/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.sofisa.recebimento._400;

import com.touchcomp.basementor.model.vo.BorderoTitulos;
import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.ItemRemessaCnabCobranca;
import com.touchcomp.basementor.model.vo.RemessaCnabCobranca;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.daycovalitau.recebimento.UtilityDaycoval;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.santander.recebimento.UtilitySantander;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RemessaRecebimentoCnabInterface;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;
import mentorcore.utilities.impl.financeiro.UtilityValidationCnab;

public class LayoutRemessaSofisaRecebimento400
implements RemessaRecebimentoCnabInterface {
    private File arquivo;
    private static Integer numeroSequencial;

    @Override
    public void createFile(File file, String extension, Long numSequencialRemessa, ConfiguracaoCnab configuracao) throws IOException {
        this.arquivo = new File(file, UtilityDaycoval.getFileName(numSequencialRemessa) + extension);
        if (this.arquivo.exists()) {
            throw new IOException("J\u00e1 existe um arquivo com o mesmo nome na pasta selecionada!");
        }
        this.arquivo.createNewFile();
    }

    @Override
    public void resetCounter() {
        numeroSequencial = 1;
    }

    @Override
    public void buildHeaderFile(RemessaCnabCobranca remessaCobranca, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        BorderoTitulos borderoTitulos = ((ItemRemessaCnabCobranca)remessaCobranca.getItemRemessaCobranca().get(0)).getItemBordero().getBorderoCobranca();
        if (ToolMethods.isEquals((Object)borderoTitulos.getCarteiraCobranca().getContaValor().getNumeroConvenio(), null) || borderoTitulos.getCarteiraCobranca().getContaValor().getNumeroConvenio().isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException("Primeiro informe o N\u00famero do Conv\u00eanio na Agencia de Valores!");
        }
        p.append("0");
        p.append("1");
        p.append("REMESSA");
        p.append("01");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("COBRANCA", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(borderoTitulos.getCarteiraCobranca().getContaValor().getNumeroConvenio(), 20));
        if (borderoTitulos.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(remessaCobranca.getEmpresa().getPessoa().getNome().substring(0, 30));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaCobranca.getEmpresa().getPessoa().getNome(), 30));
        }
        p.append("637");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("BANCO SOFISA SA", 15));
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(remessaCobranca.getDataCadastro()));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 294));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 6));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildHeaderPackage(RemessaCnabCobranca remessaCobranca, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
    }

    @Override
    public void buildDetail(RemessaCnabCobranca remessaCobranca, Short tipoNumero, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        String tipoMovimento = ToolString.refina((String)remessaCobranca.getTipoRemessa().getCodigo());
        if (tipoMovimento == null || tipoMovimento.isEmpty()) {
            throw new IOException("Nenhum codigo foi encontrado para o Tipo de Movimento selecionado. Contate o suporte tecnico!");
        }
        for (ItemRemessaCnabCobranca itemRemessaCnabCobranca : remessaCobranca.getItemRemessaCobranca()) {
            this.buildDetail(itemRemessaCnabCobranca.getItemBordero().getBorderoCobranca(), itemRemessaCnabCobranca, tipoNumero, configuracao, tipoMovimento, codificacaoArquivo);
        }
    }

    private void buildDetail(BorderoTitulos borderoTitulos, ItemRemessaCnabCobranca itemRemessaCnabCobranca, Short tipoNumero, ConfiguracaoCnab configuracao, String tipoMovimento, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Titulo titulo = itemRemessaCnabCobranca.getItemBordero().getTitulo();
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(titulo.getEmpresa().getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        String erroSacado = UtilityValidationCnab.isValidDadosBasicoPessoa(titulo.getPessoa());
        if (erroSacado != null && !erroSacado.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroSacado);
        }
        Endereco enderecoCliente = titulo.getPessoa().getEnderecoCobranca() != null ? titulo.getPessoa().getEnderecoCobranca() : titulo.getPessoa().getEndereco();
        String erro = UtilityValidationCnab.isValidAddress(enderecoCliente, titulo.getPessoa());
        if (erro != null && !erro.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erro);
        }
        p.append("1");
        p.append(UtilityArquivoCnab.getTipoInscricaoDoisDigitos(titulo.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)titulo.getEmpresa().getPessoa().getComplemento().getCnpj()), 14));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(borderoTitulos.getCarteiraCobranca().getContaValor().getNumeroConvenio(), 20));
        p.append(UtilityArquivoCnab.numeroDocumento(tipoNumero, titulo, 25));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 11));
        Object numeroBoleto = "";
        if (tipoMovimento.equals("01")) {
            numeroBoleto = itemRemessaCnabCobranca.getBoleto().getNumeroTituloInst().toString();
            numeroBoleto = (String)numeroBoleto + UtilitySantander.getDvNossoNumero((String)numeroBoleto);
        } else {
            numeroBoleto = UtilityArquivoCnab.getNossoNumeroItemRetornoCnab(titulo);
            if (numeroBoleto == null || ((String)numeroBoleto).isEmpty()) {
                p.close();
                this.getFile().delete();
                throw new IOException("O T\u00edtulo " + titulo.toString().toUpperCase() + " n\u00e3o possui Nosso Numero. Certifique se o mesmo j\u00e1 havia sido inserido anteriormente no banco!");
            }
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda((String)numeroBoleto, 13));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        p.append(UtilityArquivoCnab.getValueByKey("CODIGO_MULTA", configuracao));
        if (ToolMethods.isEquals((Object)UtilityArquivoCnab.getValueByKey("CODIGO_MULTA", configuracao), (Object)"1")) {
            Double valorMultaFixa = 0.0;
            if (ToolMethods.isWithData((Number)titulo.getPercMulta())) {
                valorMultaFixa = ToolFormatter.arrredondarNumero((Double)(titulo.getValor() * (titulo.getPercMulta() / 100.0)), (int)2);
            }
            String valorMulta = ToolFormatter.formataNumero((Number)valorMultaFixa, (int)2);
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)valorMulta), 13));
        } else if (ToolMethods.isEquals((Object)UtilityArquivoCnab.getValueByKey("CODIGO_MULTA", configuracao), (Object)"2")) {
            String percentualMulta = ToolFormatter.formataNumero((Number)titulo.getPercMulta(), (int)4);
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)percentualMulta), 13));
        } else {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 13));
        }
        p.append(UtilityArquivoCnab.getValueByKey("NUMERO_DIAS_MULTA", configuracao));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(borderoTitulos.getCarteiraCobranca().getCodigoCarteira());
        p.append(tipoMovimento);
        p.append(UtilityArquivoCnab.numeroDocumento(tipoNumero, titulo, 10));
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(titulo.getDataVencimento()));
        Double valorBoleto = ToolMethods.isWithData((Number)itemRemessaCnabCobranca.getBoleto().getValorBoleto()) ? itemRemessaCnabCobranca.getBoleto().getValorBoleto() : titulo.getValor();
        String valorCobrado = ToolFormatter.formataNumero((Number)valorBoleto, (int)2);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)valorCobrado), 13));
        p.append("033");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 4));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 1));
        p.append(UtilityArquivoCnab.getValueByKey("ESPECIE_TITULO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("ACEITE", configuracao));
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(titulo.getDataEmissao()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 2));
        String valorJurosDia = ToolFormatter.formataNumero((Number)titulo.getVrJurosDia(), (int)2);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)valorJurosDia), 13));
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(titulo.getDataLimiteDesconto()));
        String valorDesconto = ToolFormatter.formataNumero((Number)(titulo.getDescontoFinanceiro() + titulo.getValorDescontosEmbutido()), (int)2);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)valorDesconto), 13));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 13));
        String valorAbatimento = ToolFormatter.formataNumero((Number)titulo.getVrAbatimento(), (int)2);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)valorAbatimento), 13));
        p.append(UtilityArquivoCnab.getTipoInscricaoDoisDigitos(titulo.getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)titulo.getPessoa().getComplemento().getCnpj()), 14));
        if (titulo.getPessoa().getNome().length() > 30) {
            p.append(titulo.getPessoa().getNome().substring(0, 30));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getPessoa().getNome(), 30));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        String endereco = ToolString.substituiCaractereEspecial((String)(enderecoCliente.getLogradouro() + " " + enderecoCliente.getNumero() + " " + (ToolMethods.isStrWithData((String)enderecoCliente.getComplemento()) ? enderecoCliente.getComplemento() : "")));
        if (endereco.length() > 40) {
            p.append(endereco.substring(0, 40));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(endereco, 40));
        }
        String bairro = ToolString.substituiCaractereEspecial((String)enderecoCliente.getBairro());
        if (bairro.length() > 12) {
            p.append(bairro.substring(0, 12));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(bairro, 12));
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(enderecoCliente.getCep(), 8));
        String cidade = ToolString.substituiCaractereEspecial((String)enderecoCliente.getCidade().getDescricao());
        if (cidade.length() > 15) {
            p.append(cidade.substring(0, 15));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade, 15));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(enderecoCliente.getCidade().getUf().getSigla(), 2));
        if (borderoTitulos.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(borderoTitulos.getEmpresa().getPessoa().getNome().substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(borderoTitulos.getEmpresa().getPessoa().getNome(), 30));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 4));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 6));
        p.append(UtilityArquivoCnab.getValueByKey("PRAZO_PARA_PROTESTO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("MOEDA", configuracao));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 6));
        if (titulo.getInfPagamentoNfPropria() != null) {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(titulo.getInfPagamentoNfPropria().getNotaFiscalPropria().getChaveNFE(), 44));
        } else {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 44));
        }
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildTrailerPackage(ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
    }

    @Override
    public void buildTrailerFile(ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("9");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 393));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 6));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void validationBeforePrint() throws FileNotFoundException, IOException {
    }

    @Override
    public File getFile() throws IOException {
        return this.arquivo;
    }
}

