/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.sofisa.recebimento._400;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.sofisa.recebimento._400.ConstantsRetornoSofisa400;
import mentorcore.service.impl.financeiro.cnabnovo.exceptions.ExceptionCnab;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RetornoRecebimentoCnabInterface;
import mentorcore.service.impl.financeiro.cnabnovo.model.RetornoRecebimentoCnab;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;

public class LayoutRetornoSofisaRecebimento400
implements RetornoRecebimentoCnabInterface {
    private final TLogger logger = TLogger.get(LayoutRetornoSofisaRecebimento400.class);
    private BufferedReader buffer;
    private List<RetornoRecebimentoCnab> retornoSofisaRecebimento400CNAB;
    private String convenio = "";
    private final String LIQUIDACAO_NORMAL = "06";
    private final String LIQUIDACAO_CARTORIO = "08";
    private final String ENTRADA_REJEITADA = "03";

    @Override
    public void createBufferedReader(File file) throws IOException {
        FileReader fileReader = new FileReader(file);
        this.buffer = new BufferedReader(fileReader);
    }

    @Override
    public void resetVariables() {
        this.retornoSofisaRecebimento400CNAB = new ArrayList<RetornoRecebimentoCnab>();
    }

    @Override
    public Boolean isBankValid(InstituicaoValores instValor) throws IOException {
        String line = this.buffer.readLine();
        if (line.substring(0, 1).equals("0")) {
            this.analyzeHeader(line);
        }
        this.convenio = ToolString.removerZerosAEsquerda((String)line.substring(26, 38));
        String nrBanco = line.substring(76, 79);
        return nrBanco.equals(instValor.getNrBanco());
    }

    private void analyzeHeader(String line) throws IOException {
        if (line.substring(1, 2).equals("1")) {
            throw new IOException("O arquivo selecionado n\u00ef\u00bf\u00bdo \u00ef\u00bf\u00bd de Retorno e sim uma Remessa. Selecione um arquivo de Retorno. Opera\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdo cancelada!");
        }
    }

    @Override
    public void readFile(OpcoesFinanceiras opcoesFinanceiro) throws IOException, ExceptionCnab {
        try {
            while (this.buffer.ready()) {
                String line = this.buffer.readLine();
                if (!line.substring(0, 1).equals("1")) continue;
                RetornoRecebimentoCnab retornoSofisa = new RetornoRecebimentoCnab();
                this.setRetornoSofisaDetail(retornoSofisa, line, opcoesFinanceiro, this.convenio);
                this.retornoSofisaRecebimento400CNAB.add(retornoSofisa);
            }
        }
        catch (ExceptionService ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
        }
    }

    private void setRetornoSofisaDetail(RetornoRecebimentoCnab retornoSofisa, String line, OpcoesFinanceiras opcoesFinanceiro, String convenio) throws ExceptionService {
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        String codMovRetorno;
        retornoSofisa.setNrTitulo(line.substring(116, 126));
        retornoSofisa.setNrNossoNumero(line.substring(94, 107));
        retornoSofisa.setDataVencimentoString(line.substring(146, 152));
        retornoSofisa.setDataCredito(line.substring(110, 116));
        retornoSofisa.setDataOcorrencia(line.substring(110, 116));
        retornoSofisa.setDataReferenciaRetorno(line.substring(110, 116));
        retornoSofisa.setNrSequencialRegistro(line.substring(394, 400));
        Titulo titulo = null;
        ConfiguracaoCnab configuracao = null;
        if (opcoesFinanceiro.getTipoNumeroTitulo().equals(EnumConstantsMentorSimNao.SIM.getValue())) {
            if (retornoSofisa.getNrNossoNumero() != null && (b = UtilityArquivoCnab.buscarTituloNossoNumero(retornoSofisa.getNrNossoNumero(), "637", convenio)) != null) {
                titulo = b.getTitulo();
                retornoSofisa.setBoletoTitulo(b);
            }
        } else {
            titulo = UtilityArquivoCnab.buscarTituloCobranca(retornoSofisa.getNrTitulo());
            if (titulo == null && retornoSofisa.getNrNossoNumero() != null && (b = UtilityArquivoCnab.buscarTituloNossoNumero(retornoSofisa.getNrNossoNumero(), "637", convenio)) != null) {
                titulo = b.getTitulo();
                retornoSofisa.setBoletoTitulo(b);
            }
        }
        retornoSofisa.setTitulo(titulo);
        if (titulo != null) {
            configuracao = titulo.getConfiguracaoCnab();
        }
        if ((codMovRetorno = line.substring(108, 110).trim()) != null && !codMovRetorno.isEmpty()) {
            retornoSofisa.setCodMovRetorno(codMovRetorno);
            retornoSofisa.setDescMovRet(ConstantsRetornoSofisa400.getInfoMovRetornoByCodigo(codMovRetorno));
            retornoSofisa.setBaixarPeloMovRetorno(this.verificarSeTituloPodeSerBaixadoPeloCodMovRetornoRecebimento(codMovRetorno));
            retornoSofisa.setRejeitado(this.verificarSeTituloRejeitadoByCodMovRetornoRecebimento(codMovRetorno));
        } else {
            retornoSofisa.setBaixarPeloMovRetorno(Boolean.FALSE);
        }
        String codOcorrencia1 = line.substring(377, 379).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoSofisa.setCodOcorrencia1(codOcorrencia1);
            retornoSofisa.setMsgOcorrencia1(ConstantsRetornoSofisa400.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(379, 381).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoSofisa.setCodOcorrencia2(codOcorrencia2);
            retornoSofisa.setMsgOcorrencia2(ConstantsRetornoSofisa400.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(381, 383).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoSofisa.setCodOcorrencia3(codOcorrencia3);
            retornoSofisa.setMsgOcorrencia3(ConstantsRetornoSofisa400.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(383, 385).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoSofisa.setCodOcorrencia4(codOcorrencia4);
            retornoSofisa.setMsgOcorrencia4(ConstantsRetornoSofisa400.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia4));
        }
        if (configuracao != null && configuracao.getValorTarifa().shortValue() == EnumConstantsMentorSimNao.SIM.getValue()) {
            String valorTarifaInteiro = line.substring(175, 186);
            String valorTarifaDecimal = line.substring(186, 188);
            Double valorTarifa = UtilityArquivoCnab.formatarNumero(valorTarifaInteiro, valorTarifaDecimal);
            retornoSofisa.setValorTarifaCobranca(valorTarifa);
        } else {
            retornoSofisa.setValorTarifaCobranca(0.0);
        }
        if (configuracao != null && configuracao.getValorIof().shortValue() == EnumConstantsMentorSimNao.SIM.getValue()) {
            String valorIofInteiro = line.substring(214, 225);
            String valorIofDecimal = line.substring(225, 227);
            Double valorIof = UtilityArquivoCnab.formatarNumero(valorIofInteiro, valorIofDecimal);
            retornoSofisa.setValorIof(valorIof);
        } else {
            retornoSofisa.setValorIof(0.0);
        }
        retornoSofisa.setValorOutrosCreditos(0.0);
        if (configuracao != null && configuracao.getValorAbatimento().shortValue() == EnumConstantsMentorSimNao.SIM.getValue()) {
            String valorAbatimentoInteiro = line.substring(227, 238);
            String valorAbatimentoDecimal = line.substring(238, 240);
            Double valorAbatimento = UtilityArquivoCnab.formatarNumero(valorAbatimentoInteiro, valorAbatimentoDecimal);
            retornoSofisa.setValorAbatimento(valorAbatimento);
        } else {
            retornoSofisa.setValorAbatimento(0.0);
        }
        retornoSofisa.setValorDespesasBancarias(0.0);
        if (configuracao != null && configuracao.getValorJuros().shortValue() == EnumConstantsMentorSimNao.SIM.getValue()) {
            String valorJurosInteiro = line.substring(266, 277);
            String valorJurosDecimal = line.substring(277, 279);
            Double valorJuros = UtilityArquivoCnab.formatarNumero(valorJurosInteiro, valorJurosDecimal);
            retornoSofisa.setValorJuros(valorJuros);
        } else {
            retornoSofisa.setValorJuros(0.0);
        }
        if (configuracao != null && configuracao.getValorDesconto().shortValue() == EnumConstantsMentorSimNao.SIM.getValue()) {
            String valorDescontoInteiro = line.substring(240, 251);
            String valorDescontoDecimal = line.substring(251, 253);
            Double valorDesconto = UtilityArquivoCnab.formatarNumero(valorDescontoInteiro, valorDescontoDecimal);
            retornoSofisa.setValorDesconto(valorDesconto);
        } else {
            retornoSofisa.setValorDesconto(0.0);
        }
        String valorBaixaInteiro = line.substring(253, 264);
        String valorBaixaDecimal = line.substring(264, 266);
        Double valorBaixa = UtilityArquivoCnab.formatarNumero(valorBaixaInteiro, valorBaixaDecimal);
        retornoSofisa.setValorBaixa(valorBaixa);
        if (configuracao != null && configuracao.getValorMulta().shortValue() == EnumConstantsMentorSimNao.SIM.getValue()) {
            retornoSofisa.setValorMulta(0.0);
        } else {
            retornoSofisa.setValorMulta(0.0);
        }
        String valorTituloInteiro = line.substring(152, 163);
        String valorTituloDecimal = line.substring(163, 165);
        Double valorTitulo = UtilityArquivoCnab.formatarNumero(valorTituloInteiro, valorTituloDecimal);
        retornoSofisa.setValorTitulo(valorTitulo);
    }

    public Boolean verificarSeTituloPodeSerBaixadoPeloCodMovRetornoRecebimento(String codMovRetorno) {
        switch (codMovRetorno) {
            case "06": {
                return true;
            }
            case "08": {
                return true;
            }
        }
        return false;
    }

    public Short verificarSeTituloRejeitadoByCodMovRetornoRecebimento(String codMovRetorno) {
        switch (codMovRetorno) {
            case "03": {
                return EnumConstantsMentorSimNao.SIM.getValue();
            }
        }
        return EnumConstantsMentorSimNao.NAO.getValue();
    }

    @Override
    public List<RetornoRecebimentoCnab> getList() {
        return this.retornoSofisaRecebimento400CNAB;
    }
}

