/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.unicred.pagamento;

import com.touchcomp.basementor.constants.enums.cnab.pagamento.EnumConstFormaLancamentoCnabPagamento;
import com.touchcomp.basementor.model.vo.BorderoPagamento;
import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.ItemBorderoPagamento;
import com.touchcomp.basementor.model.vo.ItemRemessaCnabPagamento;
import com.touchcomp.basementor.model.vo.RemessaCnabPagamento;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import mentorcore.exceptions.ExceptionValidation;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RemessaPagamentoCnabInterface;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;
import mentorcore.utilities.impl.financeiro.UtilityValidationCnab;

public class LayoutRemessaUnicredPagamento240
implements RemessaPagamentoCnabInterface {
    private File arquivo;
    private static Integer numeroSequencial;
    private Double valorTotal;
    private static Integer numeroTotalLotes;
    private static Integer numeroRegistroArquivo;
    private static Integer qtdeRegistroLote;

    @Override
    public void dataValidationBeforeGetStarted(RemessaCnabPagamento remessaPagamento) throws ExceptionValidation {
    }

    @Override
    public void createFile(File file, String extension, Long numSequencialRemessa) throws IOException {
        this.arquivo = new File(file, "4022cnab240160720218003500005" + extension);
        if (this.arquivo.exists()) {
            throw new IOException("Ja existe um arquivo com o mesmo nome na pasta selecionada!");
        }
        this.arquivo.createNewFile();
        numeroTotalLotes = 0;
        numeroRegistroArquivo = 0;
    }

    @Override
    public void resetCounter() {
        numeroSequencial = 1;
        qtdeRegistroLote = 0;
    }

    @Override
    public void resetValorTotal() {
        this.valorTotal = 0.0;
    }

    @Override
    public void buildHeaderFile(RemessaCnabPagamento remessaPagamento, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        BorderoPagamento bordero = ((ItemRemessaCnabPagamento)remessaPagamento.getItemRemessaPagamento().get(0)).getItemBordero().getBorderoPagamento();
        p.append("136");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 4));
        p.append("0");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(remessaPagamento.getEmpresa().getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(remessaPagamento.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)remessaPagamento.getEmpresa().getPessoa().getComplemento().getCnpj()), 14));
        String convenioPagamento = bordero.getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento();
        if (convenioPagamento != null && !convenioPagamento.isEmpty()) {
            if (convenioPagamento.length() > 20) {
                p.close();
                this.getFile().delete();
                throw new IOException("O Codigo de Convenio de Pagamento excede a quantidade permitida no layout de 20 caracteres!");
            }
        } else {
            p.close();
            this.getFile().delete();
            throw new IOException("No cadastro da Agencia Valores esta faltando informar o numero do Convenio de Pagamento!");
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(bordero.getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento(), 20));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia(), 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getNrConta(), 12));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getDvConta(), 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        if (remessaPagamento.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(remessaPagamento.getEmpresa().getPessoa().getNome().substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaPagamento.getEmpresa().getPessoa().getNome(), 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("UNICRED COOPERATIVA", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        p.append("1");
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(remessaPagamento.getDataCadastro()));
        p.append(UtilityArquivoCnab.getHoraGeracao(remessaPagamento.getHoraGeracao()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaPagamento.getNumeroSequenciaArquivo().toString(), 6));
        p.append("103");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 69));
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildHeaderPackage(RemessaCnabPagamento remessaPagamento, ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        if (EnumConstFormaLancamentoCnabPagamento.isSegmentoA((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"756")) {
            this.buildHeaderPackageSegmentoA(remessaPagamento, item, codificacaoArquivo);
        } else if (EnumConstFormaLancamentoCnabPagamento.isSegmentoJ((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"756")) {
            this.buildHeaderPackageSegmentoJ(remessaPagamento, item, codificacaoArquivo);
        }
    }

    @Override
    public void buildDetail(RemessaCnabPagamento remessaPagamento, ConfiguracaoCnab configuracaoCnab, String codificacaoArquivo) throws IOException {
        String tipoMovimento = ToolString.refina((String)remessaPagamento.getTipoRemessa().getCodigo());
        if (tipoMovimento == null || tipoMovimento.isEmpty()) {
            throw new IOException("Nenhum codigo foi encontrado para o Tipo de Movimento selecionado. Contate o suporte tecnico!");
        }
        for (ItemRemessaCnabPagamento item : remessaPagamento.getItemRemessaPagamento()) {
            Titulo titulo = this.getTituloItemBordero(item.getItemBordero());
            if (EnumConstFormaLancamentoCnabPagamento.isSegmentoA((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"756")) {
                this.buildDetailSegmentoA(item, configuracaoCnab, tipoMovimento, titulo, codificacaoArquivo);
                this.buildDetailSegmentoB(item, configuracaoCnab, titulo, codificacaoArquivo);
                continue;
            }
            if (!EnumConstFormaLancamentoCnabPagamento.isSegmentoJ((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"756")) continue;
            this.buildDetailSegmentoJ(item, configuracaoCnab, tipoMovimento, titulo, codificacaoArquivo);
            this.buildDetailSegmentoJ52(item, configuracaoCnab, tipoMovimento, titulo, codificacaoArquivo);
        }
    }

    private void buildHeaderPackageSegmentoJ(RemessaCnabPagamento remessaPagamento, ItemRemessaCnabPagamento item, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Integer n = numeroTotalLotes;
        numeroTotalLotes = numeroTotalLotes + 1;
        p.append("136");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("1");
        p.append("C");
        p.append(item.getItemBordero().getFormaLancamento().getTipoServico().getCodigo());
        p.append(item.getItemBordero().getFormaLancamento().getCodigo());
        p.append("040");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(remessaPagamento.getEmpresa().getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(remessaPagamento.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)remessaPagamento.getEmpresa().getPessoa().getComplemento().getCnpj()), 14));
        String convenioPagamento = item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento();
        if (convenioPagamento != null && !convenioPagamento.isEmpty()) {
            if (convenioPagamento.length() > 20) {
                p.close();
                this.getFile().delete();
                throw new IOException("O Codigo de Convenio de Pagamento excede a quantidade permitida no layout de 20 caracteres!");
            }
        } else {
            p.close();
            this.getFile().delete();
            throw new IOException("No cadastro da Agencia Valores esta faltando informar o numero do Convenio de Pagamento!");
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(convenioPagamento, 20));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia(), 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNrConta(), 12));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getDvConta(), 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        if (remessaPagamento.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(remessaPagamento.getEmpresa().getPessoa().getNome().substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaPagamento.getEmpresa().getPessoa().getNome(), 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 40));
        Endereco enderecoEmpresa = remessaPagamento.getEmpresa().getPessoa().getEndereco();
        String erro = UtilityValidationCnab.isValidAddress(enderecoEmpresa, remessaPagamento.getEmpresa().getPessoa());
        if (erro != null && !erro.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erro);
        }
        String endereco = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getLogradouro().toUpperCase());
        if (endereco.length() > 30) {
            p.append(endereco.substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(endereco, 30).toUpperCase());
        }
        if (ToolMethods.validarFormadoDeIDsInformado((String)enderecoEmpresa.getNumero()).booleanValue()) {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(enderecoEmpresa.getNumero(), 5));
        } else {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 5));
        }
        String complemento = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getComplemento());
        if (complemento.length() > 15) {
            p.append(complemento.toUpperCase().substring(0, 15));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(complemento.toUpperCase(), 15));
        }
        String cidade = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getCidade().getDescricao());
        if (cidade.length() > 20) {
            p.append(cidade.toUpperCase().substring(0, 20));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade.toUpperCase(), 20));
        }
        p.append(UtilityArquivoCnab.getDadosCep(enderecoEmpresa.getCep(), 1, remessaPagamento.getEmpresa().getPessoa().getNome()));
        p.append(UtilityArquivoCnab.getDadosCep(enderecoEmpresa.getCep(), 2, remessaPagamento.getEmpresa().getPessoa().getNome()));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(enderecoEmpresa.getCidade().getUf().getSigla(), 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 18));
        Integer n2 = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n2 = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildHeaderPackageSegmentoA(RemessaCnabPagamento remessaPagamento, ItemRemessaCnabPagamento item, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Integer n = numeroTotalLotes;
        numeroTotalLotes = numeroTotalLotes + 1;
        p.append("136");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("1");
        p.append("C");
        p.append(item.getItemBordero().getFormaLancamento().getTipoServico().getCodigo());
        p.append(item.getItemBordero().getFormaLancamento().getCodigo());
        p.append("046");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(remessaPagamento.getEmpresa().getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(remessaPagamento.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)remessaPagamento.getEmpresa().getPessoa().getComplemento().getCnpj()), 14));
        String convenioPagamento = item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento();
        if (convenioPagamento != null && !convenioPagamento.isEmpty()) {
            if (convenioPagamento.length() > 20) {
                p.close();
                this.getFile().delete();
                throw new IOException("O Codigo de Convenio de Pagamento excede a quantidade permitida no layout de 20 caracteres!");
            }
        } else {
            p.close();
            this.getFile().delete();
            throw new IOException("No cadastro da Agencia Valores esta faltando informar o numero do Convenio de Pagamento!");
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(convenioPagamento, 20));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNrConta(), 12));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getDvConta(), 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getDvConta(), 1));
        if (remessaPagamento.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(remessaPagamento.getEmpresa().getPessoa().getNome().substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaPagamento.getEmpresa().getPessoa().getNome(), 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 40));
        Endereco enderecoEmpresa = remessaPagamento.getEmpresa().getPessoa().getEndereco();
        String erro = UtilityValidationCnab.isValidAddress(enderecoEmpresa, remessaPagamento.getEmpresa().getPessoa());
        if (erro != null && !erro.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erro);
        }
        String endereco = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getLogradouro().toUpperCase());
        if (endereco.length() > 30) {
            p.append(endereco.substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(endereco, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(enderecoEmpresa.getNumero(), 5));
        String complemento = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getComplemento());
        if (complemento.length() > 15) {
            p.append(complemento.toUpperCase().substring(0, 15));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(complemento.toUpperCase(), 15));
        }
        String cidade = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getCidade().getDescricao());
        if (cidade.length() > 20) {
            p.append(cidade.toUpperCase().substring(0, 20));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade.toUpperCase(), 20));
        }
        p.append(UtilityArquivoCnab.getDadosCep(enderecoEmpresa.getCep(), 1, remessaPagamento.getEmpresa().getPessoa().getNome()));
        p.append(UtilityArquivoCnab.getDadosCep(enderecoEmpresa.getCep(), 2, remessaPagamento.getEmpresa().getPessoa().getNome()));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(enderecoEmpresa.getCidade().getUf().getSigla(), 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("01", 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 16));
        Integer n2 = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n2 = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoJ(ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("136");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        numeroSequencial = numeroSequencial + 1;
        p.append("J");
        p.append(tipoMovimento);
        p.append(titulo.getCodigoDeBarras());
        String nomeSacado = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getNome());
        if (nomeSacado.length() > 30) {
            p.append(nomeSacado.substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeSacado, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(titulo.getDataVencimento()));
        String valorTitulo = ContatoFormatUtil.formataNumero((Number)titulo.getValor(), (int)2);
        valorTitulo = ToolString.refina((String)valorTitulo);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorTitulo, 15));
        String valorDescontoAbatimento = ContatoFormatUtil.formataNumero((Number)(titulo.getDescontoFinanceiro() + titulo.getVrAbatimento() + titulo.getValorDescontosEmbutido()), (int)2);
        valorDescontoAbatimento = ToolString.refina((String)valorDescontoAbatimento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorDescontoAbatimento, 15));
        String valorMoraMulta = ContatoFormatUtil.formataNumero((Number)(titulo.getValorJurosEmbutido() + titulo.getValorMultaEmbutida()), (int)2);
        valorMoraMulta = ToolString.refina((String)valorMoraMulta);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorMoraMulta, 15));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(item.getItemBordero().getDataPagamento()));
        String valorPagamento = ContatoFormatUtil.formataNumero((Number)item.getItemBordero().getValorPago(), (int)2);
        valorPagamento = ToolString.refina((String)valorPagamento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorPagamento, 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append("09");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        this.valorTotal = this.valorTotal + item.getItemBordero().getValorPago();
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoJ52(ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("136");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        numeroSequencial = numeroSequencial + 1;
        p.append("J");
        p.append(" ");
        p.append("01");
        p.append("52");
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(titulo.getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(item.getItemBordero().getBorderoPagamento().getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)item.getItemBordero().getBorderoPagamento().getEmpresa().getPessoa().getComplemento().getCnpj()), 15));
        String nomePagador = ToolString.substituiCaractereEspecial((String)item.getItemBordero().getBorderoPagamento().getEmpresa().getPessoa().getNome());
        if (nomePagador.length() > 40) {
            p.append(nomePagador.substring(0, 40).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomePagador, 40).toUpperCase());
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(titulo.getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)titulo.getPessoa().getComplemento().getCnpj()), 15));
        String nomeBeneficiario = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getNome());
        if (nomeBeneficiario.length() > 40) {
            p.append(nomeBeneficiario.substring(0, 40).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeBeneficiario, 40).toUpperCase());
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(titulo.getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)titulo.getPessoa().getComplemento().getCnpj()), 15));
        nomePagador = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getNome());
        if (nomePagador.length() > 40) {
            p.append(nomePagador.substring(0, 40).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomePagador, 40).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 53));
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildTrailerPackge(RemessaCnabPagamento remessaPagamento, ItemRemessaCnabPagamento item, String codificacaoArquivo) throws IOException {
        this.buildTrailerPackgePadrao(codificacaoArquivo);
    }

    @Override
    public void buildTrailerFile(String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        p.append("136");
        p.append("9999");
        p.append("9");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroRegistroArquivo.toString(), 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 211));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void validationBeforePrint() throws FileNotFoundException, IOException {
        UtilityArquivoCnab.validationBeforePrintCnab(this.getFile(), 240);
    }

    @Override
    public File getFile() throws IOException {
        return this.arquivo;
    }

    private void buildDetailSegmentoA(ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("136");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("A");
        p.append(tipoMovimento);
        p.append("018");
        String nrBancoFavorecido = item.getItemBordero().getContaBancaria().getInstituicaoValor().getNrBanco();
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(nrBancoFavorecido, 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)item.getItemBordero().getContaBancaria().getAgencia()), 5));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)item.getItemBordero().getContaBancaria().getDvAgencia()), 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)item.getItemBordero().getContaBancaria().getContaCorrente()), 12));
        String digitoConta = ToolString.refina((String)item.getItemBordero().getContaBancaria().getDvContaCorrente());
        if (digitoConta != null && !digitoConta.isEmpty() && digitoConta.length() == 2) {
            p.append(digitoConta.substring(0, 1));
        } else if (digitoConta != null && !digitoConta.isEmpty() && digitoConta.length() == 1) {
            p.append(digitoConta);
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        }
        if (digitoConta != null && !digitoConta.isEmpty() && digitoConta.length() == 2) {
            p.append(digitoConta.substring(1, 2));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        }
        String nomeColaborador = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getNome());
        if (nomeColaborador.length() <= 30) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeColaborador, 30));
        } else {
            p.append(nomeColaborador.substring(0, 30));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 20));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(item.getItemBordero().getDataPagamento()));
        p.append("BRL");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        String valorPrevistoPag = ContatoFormatUtil.formataNumero((Number)item.getItemBordero().getValorPago(), (int)2);
        valorPrevistoPag = ToolString.refina((String)valorPrevistoPag);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorPrevistoPag, 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 40));
        if (item.getItemBordero().getFormaLancamento().getCodigo().equalsIgnoreCase("03")) {
            if (item.getItemBordero().getFinalidadeDoc() == null) {
                p.close();
                this.getFile().delete();
                throw new IOException("O Titulo " + titulo.toString().toUpperCase() + " esta sem a Finalidade DOC. Favor informar!");
            }
            p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getItemBordero().getFinalidadeDoc().getCodigo(), 2));
        } else if (item.getItemBordero().getFormaLancamento().getTipoServico().getCodigo().equalsIgnoreCase("30") && item.getItemBordero().getFormaLancamento().getCodigo().equalsIgnoreCase("01")) {
            p.append("07");
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        }
        if (item.getItemBordero().getFormaLancamento().getCodigo().equalsIgnoreCase("41") || item.getItemBordero().getFormaLancamento().getCodigo().equalsIgnoreCase("43")) {
            if (item.getItemBordero().getFinalidadeTed() == null) {
                p.close();
                this.getFile().delete();
                throw new IOException("O Titulo " + titulo.toString().toUpperCase() + " esta sem a Finalidade TED. Favor informar!");
            }
            p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getItemBordero().getFinalidadeTed().getCodigo(), 5));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 5));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 5));
        p.append("0");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        this.valorTotal = this.valorTotal + item.getItemBordero().getValorPago();
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoB(ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("136");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("B");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(titulo.getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        if (item.getItemBordero().getContaBancaria() != null && item.getItemBordero().getContaBancaria().getCnpj() != null && !item.getItemBordero().getContaBancaria().getCnpj().isEmpty()) {
            p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(item.getItemBordero().getContaBancaria().getCnpj()));
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getContaBancaria().getCnpj(), 14));
        } else {
            p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(titulo.getPessoa()));
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(titulo.getPessoa().getComplemento().getCnpj(), 14));
        }
        String logradouro = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getEndereco().getLogradouro());
        if (logradouro.length() <= 30) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(logradouro, 30));
        } else {
            p.append(logradouro.substring(0, 30));
        }
        if (titulo.getPessoa().getEndereco().getNumero().length() <= 5) {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(titulo.getPessoa().getEndereco().getNumero(), 5));
        } else {
            p.append(titulo.getPessoa().getEndereco().getNumero().substring(0, 5));
        }
        String complemento = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getEndereco().getComplemento());
        if (complemento == null) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 15));
        } else if (complemento.length() <= 15) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(complemento, 15));
        } else {
            p.append(complemento.substring(0, 15));
        }
        String bairro = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getEndereco().getBairro());
        if (bairro.length() <= 15) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(bairro, 15));
        } else {
            p.append(bairro.substring(0, 15));
        }
        String cidade = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getEndereco().getCidade().getDescricao());
        if (cidade.length() <= 20) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade, 20));
        } else {
            p.append(cidade.substring(0, 20));
        }
        p.append(UtilityArquivoCnab.getDadosCep(titulo.getPessoa().getEndereco().getCep(), 1, titulo.getPessoa().getNome()));
        p.append(UtilityArquivoCnab.getDadosCep(titulo.getPessoa().getEndereco().getCep(), 2, titulo.getPessoa().getNome()));
        p.append(titulo.getPessoa().getEndereco().getCidade().getUf().getSigla());
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(titulo.getDataVencimento()));
        String valorTitulo = ContatoFormatUtil.formataNumero((Number)titulo.getValor(), (int)2);
        valorTitulo = ToolString.refina((String)valorTitulo);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorTitulo, 15));
        String valorAbatimento = ContatoFormatUtil.formataNumero((Number)titulo.getVrAbatimento(), (int)2);
        valorAbatimento = ToolString.refina((String)valorAbatimento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorAbatimento, 15));
        Double valorDesconto = titulo.getValorDescontosEmbutido() + titulo.getDescontoFinanceiro();
        String vlrDesconto = ContatoFormatUtil.formataNumero((Number)valorDesconto, (int)2);
        vlrDesconto = ToolString.refina((String)vlrDesconto);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(vlrDesconto, 15));
        String vlrMora = ContatoFormatUtil.formataNumero((Number)titulo.getValorJurosEmbutido(), (int)2);
        vlrMora = ToolString.refina((String)vlrMora);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(vlrMora, 15));
        String vlrMulta = ContatoFormatUtil.formataNumero((Number)titulo.getValorMultaEmbutida(), (int)2);
        vlrMulta = ToolString.refina((String)vlrMulta);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(vlrMulta, 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 15));
        p.append("0");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 8));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildTrailerPackgePadrao(String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Integer n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.append("136");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("5");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(qtdeRegistroLote.toString(), 6));
        String valorTotalPagtos = ContatoFormatUtil.formataNumero((Number)this.valorTotal, (int)2);
        valorTotalPagtos = ToolString.refina((String)valorTotalPagtos);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorTotalPagtos, 18));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 18));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 165));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n2 = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        p.println();
        p.flush();
        p.close();
    }

    private Titulo getTituloItemBordero(ItemBorderoPagamento itemBordero) {
        if (itemBordero.getItemLiberacao() != null) {
            return itemBordero.getItemLiberacao().getTitulo();
        }
        return itemBordero.getTitulo();
    }
}

