/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.unicred.recebimento._240;

import com.touchcomp.basementor.model.vo.BoletoTitulo;
import com.touchcomp.basementor.model.vo.BorderoTitulos;
import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.ItemRemessaCnabCobranca;
import com.touchcomp.basementor.model.vo.RemessaCnabCobranca;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RemessaRecebimentoCnabInterface;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;
import mentorcore.utilities.impl.financeiro.UtilityValidationCnab;

public class LayoutRemessaUnicredRecebimento240
implements RemessaRecebimentoCnabInterface {
    private File arquivo;
    private static Integer numeroSequencial;
    private final String codigoBancoCompensacao = "136";
    private Long quantidadeTitulos = 0L;
    private Double valorTotalTitulos = 0.0;
    private final Short NUMERICO = 0;
    private final Short ALFA = 1;

    @Override
    public void createFile(File file, String extension, Long numSequencialRemessa, ConfiguracaoCnab configuracao) throws IOException {
        this.arquivo = new File(file, "4022cnab240160720218003500005" + extension);
        if (this.arquivo.exists()) {
            throw new IOException("J\u00e1 existe um arquivo com o mesmo nome na pasta selecionada!");
        }
        this.arquivo.createNewFile();
    }

    @Override
    public void resetCounter() {
        numeroSequencial = 1;
    }

    @Override
    public void buildHeaderFile(RemessaCnabCobranca remessaCobranca, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        BorderoTitulos bordero = ((ItemRemessaCnabCobranca)remessaCobranca.getItemRemessaCobranca().get(0)).getItemBordero().getBorderoCobranca();
        p.append(this.get("136", this.NUMERICO, 3));
        p.append(this.get("", this.NUMERICO, 4));
        p.append(this.get("0", this.NUMERICO, 1));
        p.append(this.get("", this.ALFA, 9));
        p.append(this.get("2", this.NUMERICO, 1));
        p.append(this.get(ToolString.refina((String)remessaCobranca.getEmpresa().getPessoa().getComplemento().getCnpj()), this.NUMERICO, 14));
        String value = "";
        if (bordero.getCarteiraCobranca().getContaValor().getNumeroConvenio() != null && !bordero.getCarteiraCobranca().getContaValor().getNumeroConvenio().isEmpty()) {
            if (bordero.getCarteiraCobranca().getContaValor().getNumeroConvenio().length() > 20) {
                p.close();
                this.getFile().delete();
                throw new IOException(" O N\u00famero Convenio Recebimento possui mais de 20 caracteres. Favor verificar!");
            }
            value = bordero.getCarteiraCobranca().getContaValor().getNumeroConvenio();
        }
        p.append(this.get(value, this.ALFA, 20));
        p.append(this.get(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), this.NUMERICO, 5));
        value = "";
        if (!ToolMethods.isNull((Object)bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia()).booleanValue()) {
            value = bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia();
        }
        p.append(this.get(value, this.ALFA, 1));
        p.append(this.get(bordero.getCarteiraCobranca().getContaValor().getNrConta(), this.NUMERICO, 12));
        p.append(this.get(bordero.getCarteiraCobranca().getContaValor().getDvConta(), this.ALFA, 1));
        p.append(this.get("", this.ALFA, 1));
        p.append(this.get(remessaCobranca.getEmpresa().getPessoa().getNome(), this.ALFA, 30));
        p.append(this.get("UNICRED", this.ALFA, 30));
        p.append(this.get("", this.ALFA, 10));
        p.append(this.get("1", this.NUMERICO, 1));
        p.append(this.get(UtilityArquivoCnab.formatarDatas8Digitos(remessaCobranca.getDataCadastro()), this.NUMERICO, 8));
        p.append(this.get(UtilityArquivoCnab.getHoraGeracao(remessaCobranca.getHoraGeracao()), this.NUMERICO, 6));
        p.append(this.get(remessaCobranca.getNumeroSequenciaArquivo().toString(), this.NUMERICO, 6));
        p.append(this.get("103", this.NUMERICO, 3));
        p.append(this.get("", this.NUMERICO, 5));
        p.append(this.get("", this.ALFA, 20));
        p.append(this.get("", this.ALFA, 20));
        p.append(this.get("", this.ALFA, 29));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildHeaderPackage(RemessaCnabCobranca remessaCobranca, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        BorderoTitulos bordero = ((ItemRemessaCnabCobranca)remessaCobranca.getItemRemessaCobranca().get(0)).getItemBordero().getBorderoCobranca();
        p.append(this.get("136", this.NUMERICO, 3));
        p.append(this.get("", this.NUMERICO, 4));
        p.append(this.get("1", this.NUMERICO, 1));
        p.append(this.get(UtilityArquivoCnab.getValueByKey("TIPO_OPERACAO", configuracao), this.ALFA, 1));
        p.append(this.get(UtilityArquivoCnab.getValueByKey("TIPO_SERVICO", configuracao), this.NUMERICO, 2));
        p.append(this.get("", this.ALFA, 2));
        p.append(this.get("060", this.NUMERICO, 3));
        p.append(this.get("", this.ALFA, 1));
        p.append(this.get(UtilityArquivoCnab.getTipoInscricaoUmDigito(remessaCobranca.getEmpresa().getPessoa()), this.NUMERICO, 1));
        p.append(this.get(remessaCobranca.getEmpresa().getPessoa().getComplemento().getCnpj(), this.NUMERICO, 15));
        String value = "";
        if (bordero.getCarteiraCobranca().getContaValor().getNumeroConvenio() != null && !bordero.getCarteiraCobranca().getContaValor().getNumeroConvenio().isEmpty()) {
            if (bordero.getCarteiraCobranca().getContaValor().getNumeroConvenio().length() > 20) {
                p.close();
                this.getFile().delete();
                throw new IOException(" O N\u00famero Convenio Recebimento possui mais de 20 caracteres. Favor verificar!");
            }
            value = bordero.getCarteiraCobranca().getContaValor().getNumeroConvenio();
        }
        p.append(this.get(value, this.ALFA, 20));
        p.append(this.get(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), this.NUMERICO, 5));
        value = "";
        if (!ToolMethods.isNull((Object)bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia().isEmpty()).booleanValue()) {
            value = bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia();
        }
        p.append(this.get(value, this.ALFA, 1));
        p.append(this.get(bordero.getCarteiraCobranca().getContaValor().getNrConta(), this.NUMERICO, 12));
        p.append(this.get(bordero.getCarteiraCobranca().getContaValor().getDvConta(), this.ALFA, 1));
        p.append(this.get("", this.ALFA, 1));
        p.append(this.get(remessaCobranca.getEmpresa().getPessoa().getNome(), this.ALFA, 30));
        p.append(this.get(UtilityArquivoCnab.getValueByKey("MENSAGEM_1", configuracao), this.ALFA, 40));
        p.append(this.get(UtilityArquivoCnab.getValueByKey("MENSAGEM_2", configuracao), this.ALFA, 40));
        p.append(this.get(remessaCobranca.getNumeroSequenciaArquivo().toString(), this.NUMERICO, 8));
        p.append(this.get(UtilityArquivoCnab.formatarDatas8Digitos(remessaCobranca.getDataCadastro()), this.NUMERICO, 8));
        p.append(this.get("", this.ALFA, 8));
        p.append(this.get("", this.ALFA, 33));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildDetail(RemessaCnabCobranca remessa, Short tipoNumero, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        String tipoMovimento = ToolString.refina((String)remessa.getTipoRemessa().getCodigo());
        if (tipoMovimento == null || tipoMovimento.isEmpty()) {
            throw new IOException("Nenhum codigo foi encontrado para o Tipo de Movimento selecionado. Contate o suporte tecnico!");
        }
        for (ItemRemessaCnabCobranca item : remessa.getItemRemessaCobranca()) {
            this.buildDetailSegmentoP(item.getItemBordero().getBorderoCobranca(), item, tipoNumero, configuracao, tipoMovimento, codificacaoArquivo);
            this.buildDetailSegmentoQ(item, configuracao, tipoMovimento, codificacaoArquivo);
            this.buildDetailSegmentoY(item, configuracao, tipoMovimento, codificacaoArquivo);
        }
    }

    private void buildDetailSegmentoP(BorderoTitulos borderoTitulos, ItemRemessaCnabCobranca item, Short tipoNumero, ConfiguracaoCnab configuracao, String tipoMovimento, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Titulo titulo = item.getItemBordero().getTitulo();
        BoletoTitulo boleto = item.getBoleto();
        p.append(this.get("136", this.NUMERICO, 3));
        p.append(this.get("1", this.NUMERICO, 4));
        p.append(this.get("3", this.NUMERICO, 1));
        p.append(this.get(numeroSequencial.toString(), this.NUMERICO, 5));
        p.append(this.get("P", this.ALFA, 1));
        p.append(this.get("", this.ALFA, 1));
        p.append(this.get(tipoMovimento, this.NUMERICO, 2));
        p.append(this.get(borderoTitulos.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), this.NUMERICO, 5));
        String value = "";
        if (!ToolMethods.isNull((Object)borderoTitulos.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia()).booleanValue()) {
            value = borderoTitulos.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia();
        }
        p.append(this.get(value, this.ALFA, 1));
        p.append(this.get(borderoTitulos.getCarteiraCobranca().getContaValor().getNrConta(), this.NUMERICO, 12));
        p.append(this.get(borderoTitulos.getCarteiraCobranca().getContaValor().getDvConta(), this.ALFA, 1));
        p.append(this.get("", this.ALFA, 1));
        p.append(this.get("", this.ALFA, 20));
        if (borderoTitulos.getCarteiraCobranca().getCodigoCarteira() == null || borderoTitulos.getCarteiraCobranca().getCodigoCarteira().isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException("Primeiro informe o C\u00f3digo da Carteira na Carteira " + borderoTitulos.getCarteiraCobranca().toString().toUpperCase() + ". Contate o Suporte Tecnico!");
        }
        if (borderoTitulos.getCarteiraCobranca().getCodigoCarteira().length() != 1) {
            p.close();
            this.getFile().delete();
            throw new IOException("O C\u00f3digo da Carteira deve possuir apenas 1 caracter! Favor verificar.");
        }
        p.append(this.get(borderoTitulos.getCarteiraCobranca().getCodigoCarteira(), this.NUMERICO, 1));
        p.append(this.get(UtilityArquivoCnab.getValueByKey("FORMA_CAD_BANCO", configuracao), this.NUMERICO, 1));
        p.append(this.get(UtilityArquivoCnab.getValueByKey("TIPO_DOCUMENTO", configuracao), this.ALFA, 1));
        p.append(this.get(boleto.getNumeroTituloInst().toString(), this.NUMERICO, 1));
        p.append(this.get(UtilityArquivoCnab.getValueByKey("DISTRIBUICAO", configuracao), this.ALFA, 1));
        value = "";
        value = tipoNumero.equals((short)1) ? (titulo.getInfPagamentoNfPropria() != null && titulo.getInfPagamentoNfPropria().getNotaFiscalPropria() != null ? titulo.getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota().toString() : (titulo.getFaturaCte() != null ? titulo.getFaturaCte().getIdentificador().toString() : (titulo.getRps() != null ? titulo.getRps().getNumero().toString() : (titulo.getOrdemCompra() != null ? titulo.getOrdemCompra().getIdentificador().toString() : (titulo.getInfPagamentoPedido() != null && titulo.getInfPagamentoPedido().getPedido() != null ? titulo.getInfPagamentoPedido().getPedido().getIdentificador().toString() : (titulo.getPedidoComercio() != null ? titulo.getPedidoComercio().getIdentificador().toString() : (titulo.getAdiantamentoViagem() != null ? titulo.getAdiantamentoViagem().getIdentificador().toString() : (titulo.getNotaContratoLocacao() != null ? titulo.getNotaContratoLocacao().getNumero().toString() : (titulo.getContratoLocacao() != null ? titulo.getContratoLocacao().getNumeroContrato().toString() : (titulo.getApuracaoLocacaoContrato() != null ? titulo.getApuracaoLocacaoContrato().getIdentificador().toString() : (titulo.getCte() != null ? titulo.getCte().getNumero().toString() : titulo.getIdentificador().toString()))))))))))) : titulo.getIdentificador().toString();
        p.append(this.get(value, this.ALFA, 15));
        p.append(this.get(UtilityArquivoCnab.formatarDatas8Digitos(titulo.getDataVencimento()), this.NUMERICO, 8));
        Double valorBoleto = boleto.getTitulo().getValor();
        String valorCobrado = ContatoFormatUtil.formataNumero((Number)valorBoleto, (int)2);
        valorCobrado = ToolString.refina((String)valorCobrado);
        p.append(this.get(valorCobrado, this.NUMERICO, 15));
        p.append(this.get("", this.NUMERICO, 5));
        p.append(this.get("", this.ALFA, 1));
        p.append(this.get(UtilityArquivoCnab.getValueByKey("ESPECIE_TITULO", configuracao), this.NUMERICO, 2));
        p.append(this.get(UtilityArquivoCnab.getValueByKey("ACEITE", configuracao), this.ALFA, 1));
        p.append(this.get(UtilityArquivoCnab.formatarDatas8Digitos(titulo.getDataEmissao()), this.NUMERICO, 8));
        String codJurosMora = UtilityArquivoCnab.getValueByKey("COD_JUROS_MORA", configuracao);
        p.append(this.get(codJurosMora, this.NUMERICO, 8));
        value = "";
        if (!codJurosMora.equals("3")) {
            value = UtilityArquivoCnab.formatarDatas8Digitos(boleto.getTitulo().getDataInicioJuros());
        }
        p.append(this.get(value, this.NUMERICO, 8));
        value = "";
        Double valor = 0.0;
        if (codJurosMora.equals("1")) {
            valor = boleto.getTitulo().getVrJurosDia() / boleto.getTitulo().getValor() * boleto.getTitulo().getValorSaldo();
        } else if (codJurosMora.equals("2")) {
            valor = titulo.getPercJurosMes();
        } else if (codJurosMora.equals("3")) {
            valor = 0.0;
        }
        value = ContatoFormatUtil.formataNumero((Number)valor, (int)2);
        value = ToolString.refina((String)value);
        p.append(this.get(value, this.NUMERICO, 13));
        String codDesconto = UtilityArquivoCnab.getValueByKey("COD_DESCONTO_1", configuracao);
        p.append(this.get(codDesconto, this.NUMERICO, 1));
        p.append(this.get(UtilityArquivoCnab.formatarDatas8Digitos(boleto.getTitulo().getDataLimiteDesconto()), this.NUMERICO, 8));
        valor = 0.0;
        String valorPercDescpmtpConcedido = "";
        if (ToolMethods.isEquals((Object)codDesconto, (Object)"1") || ToolMethods.isEquals((Object)codDesconto, (Object)"3") || ToolMethods.isEquals((Object)codDesconto, (Object)"4")) {
            valor = boleto.getTitulo().getDescontoFinanceiro() + boleto.getTitulo().getValorDescontosEmbutido();
        } else if (ToolMethods.isEquals((Object)codDesconto, (Object)"2") || ToolMethods.isEquals((Object)codDesconto, (Object)"5") || ToolMethods.isEquals((Object)codDesconto, (Object)"6")) {
            valor = boleto.getTitulo().getPercDescontoMes();
        }
        valorPercDescpmtpConcedido = ContatoFormatUtil.formataNumero((Number)valor, (int)2);
        valorPercDescpmtpConcedido = ToolString.refina((String)valorPercDescpmtpConcedido);
        p.append(this.get(valorPercDescpmtpConcedido, this.NUMERICO, 13));
        String valorIof = ContatoFormatUtil.formataNumero((Number)titulo.getVrIofPago(), (int)2);
        valorIof = ToolString.refina((String)valorIof);
        p.append(this.get(valorIof, this.NUMERICO, 13));
        String valorAbatimento = ContatoFormatUtil.formataNumero((Number)titulo.getVrAbatimento(), (int)2);
        valorAbatimento = ToolString.refina((String)valorAbatimento);
        p.append(this.get(valorAbatimento, this.NUMERICO, 13));
        p.append(this.get(titulo.getIdentificador().toString(), this.ALFA, 25));
        p.append(this.get(UtilityArquivoCnab.getValueByKey("COD_PROTESTO", configuracao), this.NUMERICO, 1));
        p.append(this.get(UtilityArquivoCnab.getValueByKey("NUM_DIAS_PROTESTO", configuracao), this.NUMERICO, 2));
        p.append(this.get(UtilityArquivoCnab.getValueByKey("COD_BAIXA_DEVOLUCAO", configuracao), this.NUMERICO, 1));
        p.append(this.get(UtilityArquivoCnab.getValueByKey("NUM_DIAS_BAIXA_DEVOLUCAO", configuracao), this.ALFA, 3));
        p.append(this.get(UtilityArquivoCnab.getValueByKey("CODIGO_MOEDA", configuracao), this.NUMERICO, 3));
        p.append(this.get("", this.NUMERICO, 10));
        p.append(this.get("", this.ALFA, 1));
        this.valorTotalTitulos = this.valorTotalTitulos + titulo.getValor();
        Number number = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        number = this.quantidadeTitulos;
        this.quantidadeTitulos = this.quantidadeTitulos + 1L;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoQ(ItemRemessaCnabCobranca item, ConfiguracaoCnab configuracao, String tipoMovimento, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Titulo titulo = item.getItemBordero().getTitulo();
        p.append(this.get("136", this.NUMERICO, 3));
        p.append(this.get("1", this.NUMERICO, 4));
        p.append(this.get("3", this.NUMERICO, 1));
        p.append(this.get(numeroSequencial.toString(), this.NUMERICO, 5));
        p.append(this.get("Q", this.ALFA, 1));
        p.append(this.get("", this.ALFA, 1));
        p.append(this.get(tipoMovimento, this.NUMERICO, 2));
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(titulo.getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(this.get(UtilityArquivoCnab.getTipoInscricaoUmDigito(titulo.getPessoa()), this.NUMERICO, 1));
        p.append(this.get(titulo.getPessoa().getComplemento().getCnpj(), this.NUMERICO, 15));
        String nomeSacado = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getNome());
        p.append(this.get(nomeSacado, this.ALFA, 40));
        Endereco enderecoCliente = titulo.getPessoa().getEnderecoCobranca() != null ? titulo.getPessoa().getEnderecoCobranca() : titulo.getPessoa().getEndereco();
        String erro = UtilityValidationCnab.isValidAddress(enderecoCliente, titulo.getPessoa());
        if (erro != null && !erro.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erro);
        }
        String complemento = ToolMethods.isStrWithData((String)enderecoCliente.getComplemento()) ? enderecoCliente.getComplemento() : "";
        String endereco = ToolString.substituiCaractereEspecial((String)(enderecoCliente.getLogradouro().toUpperCase() + " " + enderecoCliente.getNumero() + " " + complemento.toUpperCase()));
        p.append(this.get(endereco, this.ALFA, 40));
        String bairro = ToolString.substituiCaractereEspecial((String)enderecoCliente.getBairro());
        p.append(this.get(bairro, this.ALFA, 15));
        p.append(this.get(UtilityArquivoCnab.getDadosCep(enderecoCliente.getCep(), 1, titulo.getPessoa().getNome()), this.NUMERICO, 5));
        p.append(this.get(UtilityArquivoCnab.getDadosCep(enderecoCliente.getCep(), 2, titulo.getPessoa().getNome()), this.NUMERICO, 3));
        String cidade = ToolString.substituiCaractereEspecial((String)enderecoCliente.getCidade().getDescricao());
        p.append(this.get(cidade, this.ALFA, 15));
        p.append(this.get(enderecoCliente.getCidade().getUf().getSigla(), this.ALFA, 2));
        p.append(this.get(UtilityArquivoCnab.getTipoInscricaoUmDigito(titulo.getEmpresa().getPessoa()), this.NUMERICO, 1));
        p.append(this.get(ToolString.refina((String)titulo.getEmpresa().getPessoa().getComplemento().getCnpj()), this.NUMERICO, 15));
        String nomeSacadoAvalista = ToolString.substituiCaractereEspecial((String)titulo.getEmpresa().getPessoa().getNome());
        p.append(this.get(nomeSacadoAvalista, this.ALFA, 40));
        p.append(this.get(UtilityArquivoCnab.getValueByKey("COD_BCO_CORRESPONDENTE_COMP", configuracao), this.NUMERICO, 3));
        p.append(this.get(UtilityArquivoCnab.getValueByKey("NUM_BANCO_CORRESPONDENTE", configuracao), this.ALFA, 20));
        p.append(this.get("", this.ALFA, 8));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildTrailerPackage(ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append(this.get("136", this.NUMERICO, 3));
        p.append(this.get("1", this.NUMERICO, 4));
        p.append(this.get("5", this.NUMERICO, 1));
        p.append(this.get("", this.ALFA, 9));
        Integer registros = numeroSequencial + 1;
        p.append(this.get(registros.toString(), this.NUMERICO, 6));
        p.append(this.get(this.quantidadeTitulos.toString(), this.NUMERICO, 6));
        String valorTitulosSTR = ContatoFormatUtil.formataNumero((Number)this.valorTotalTitulos, (int)2);
        valorTitulosSTR = ToolString.refina((String)valorTitulosSTR);
        p.append(this.get(valorTitulosSTR, this.NUMERICO, 17));
        p.append(this.get("", this.NUMERICO, 6));
        p.append(this.get("", this.NUMERICO, 17));
        p.append(this.get("", this.NUMERICO, 6));
        p.append(this.get("", this.NUMERICO, 17));
        p.append(this.get("", this.NUMERICO, 6));
        p.append(this.get("", this.NUMERICO, 17));
        p.append(this.get("", this.ALFA, 8));
        p.append(this.get("", this.ALFA, 117));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildTrailerFile(ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("136");
        p.append("9999");
        p.append("9");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("0", 6));
        Integer registros = numeroSequencial + 3;
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(registros.toString(), 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 205));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void validationBeforePrint() throws FileNotFoundException, IOException {
        UtilityArquivoCnab.validationBeforePrintCnab(this.getFile(), 240);
    }

    @Override
    public File getFile() throws IOException {
        return this.arquivo;
    }

    private void buildDetailSegmentoY(ItemRemessaCnabCobranca i, ConfiguracaoCnab configuracao, String tipoMovimento, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Titulo titulo = i.getItemBordero().getTitulo();
        p.append(this.get("136", this.NUMERICO, 3));
        p.append(this.get("", this.NUMERICO, 4));
        p.append(this.get("3", this.NUMERICO, 1));
        p.append(this.get(numeroSequencial.toString(), this.NUMERICO, 5));
        p.append(this.get("Y", this.ALFA, 1));
        p.append(this.get("", this.ALFA, 1));
        p.append(this.get(tipoMovimento, this.NUMERICO, 2));
        p.append(this.get(UtilityArquivoCnab.getValueByKey("REGISTROS_OPCIONAIS", configuracao), this.NUMERICO, 2));
        String value = "";
        if (titulo.getInfPagamentoNfPropria() != null && titulo.getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
            value = titulo.getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota().toString();
        }
        p.append(this.get(value, this.ALFA, 15));
        String valorCobrado = "";
        if (titulo.getInfPagamentoNfPropria() != null && titulo.getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
            Double valor = titulo.getInfPagamentoNfPropria().getNotaFiscalPropria().getValoresNfPropria().getValorTotal();
            valorCobrado = ContatoFormatUtil.formataNumero((Number)valor, (int)2);
            valorCobrado = ToolString.refina((String)valorCobrado);
        }
        p.append(this.get(valorCobrado, this.NUMERICO, 15));
        value = "";
        if (titulo.getInfPagamentoNfPropria() != null && titulo.getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
            value = UtilityArquivoCnab.formatarDatas8Digitos(titulo.getInfPagamentoNfPropria().getNotaFiscalPropria().getDataEmissaoNota());
        }
        p.append(this.get(value, this.NUMERICO, 8));
        value = "";
        if (titulo.getInfPagamentoNfPropria() != null && titulo.getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
            value = titulo.getInfPagamentoNfPropria().getNotaFiscalPropria().getChaveNFE();
        }
        p.append(this.get(value, this.NUMERICO, 44));
        p.append(this.get("", this.ALFA, 15));
        p.append(this.get("", this.NUMERICO, 15));
        p.append(this.get("", this.NUMERICO, 9));
        p.append(this.get("", this.NUMERICO, 44));
        p.append(this.get("", this.ALFA, 56));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    private String get(String value, Short tipo, int tamanho) {
        if (value.length() > tamanho) {
            return value.substring(0, tamanho).toUpperCase();
        }
        if (ToolMethods.isEquals((Object)tipo, (Object)this.NUMERICO)) {
            return UtilityArquivoCnab.completarComZeroEsquerda(value, tamanho);
        }
        return UtilityArquivoCnab.completarComBrancoDireita(value, tamanho);
    }
}

