/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.unicred.recebimento._240;

import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.unicred.recebimento._240.ConstantsRetornoUnicred240;
import mentorcore.service.impl.financeiro.cnabnovo.exceptions.ExceptionCnab;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RetornoRecebimentoCnabInterface;
import mentorcore.service.impl.financeiro.cnabnovo.model.RetornoRecebimentoCnab;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;

public class LayoutRetornoUnicredRecebimento240
implements RetornoRecebimentoCnabInterface {
    private final TLogger logger = TLogger.get(LayoutRetornoUnicredRecebimento240.class);
    private BufferedReader buffer;
    private List<RetornoRecebimentoCnab> retornoUnicredRecebimento240CNAB;
    private File arquivo;
    private String convenio = "";
    private final String LIQUIDACAO = "06";
    private final String LIQUIDACAO_APOS_BAIXA_OU_TITULO_NAO_REGISTRADO = "17";
    private final String ENTRADA_REJEITADA = "03";

    @Override
    public void createBufferedReader(File file) throws IOException {
        this.arquivo = file;
        FileReader fileReader = new FileReader(this.arquivo);
        this.buffer = new BufferedReader(fileReader);
    }

    @Override
    public void resetVariables() {
        this.retornoUnicredRecebimento240CNAB = new ArrayList<RetornoRecebimentoCnab>();
    }

    @Override
    public Boolean isBankValid(InstituicaoValores instValor) throws IOException {
        String line = this.buffer.readLine();
        if (line.substring(7, 8).equals("0")) {
            this.analyzeHeader(line);
        }
        this.convenio = ToolString.removerZerosAEsquerda((String)line.substring(32, 52));
        String nrBanco = line.substring(0, 3);
        return nrBanco.equals(instValor.getNrBanco());
    }

    private void analyzeHeader(String line) throws IOException {
        if (line.substring(142, 143).equals("1")) {
            throw new IOException("O arquivo selecionado n\u00ef\u00bf\u00bdo \u00ef\u00bf\u00bd de Retorno e sim uma Remessa. Selecione um arquivo de Retorno. Opera\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdo cancelada!");
        }
    }

    @Override
    public void readFile(OpcoesFinanceiras opcoesFinanceiras) throws IOException, ExceptionCnab {
        try {
            while (this.buffer.ready()) {
                String line = this.buffer.readLine();
                if (!line.substring(7, 8).equals("3")) continue;
                RetornoRecebimentoCnab retorno = new RetornoRecebimentoCnab();
                this.setRetornoDatailSegT(retorno, line, opcoesFinanceiras, this.convenio);
                ConfiguracaoCnab configuracao = null;
                if (retorno.getTitulo() != null) {
                    configuracao = retorno.getTitulo().getConfiguracaoCnab();
                }
                this.setRetornoUnicredDatailSegU(retorno, this.buffer.readLine(), configuracao);
                this.retornoUnicredRecebimento240CNAB.add(retorno);
            }
        }
        catch (ExceptionService ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
        }
    }

    private void setRetornoDatailSegT(RetornoRecebimentoCnab retorno, String line, OpcoesFinanceiras opcoesFinanceiras, String convenio) throws ExceptionService {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retorno.setNrTitulo(line.substring(58, 73));
        retorno.setNrNossoNumero(line.substring(37, 46));
        retorno.setDataVencimentoString(line.substring(73, 81));
        Titulo titulo = null;
        if (opcoesFinanceiras.getTipoNumeroTitulo().equals((short)1)) {
            if (retorno.getNrNossoNumero() != null && (b = UtilityArquivoCnab.buscarTituloNossoNumero(retorno.getNrNossoNumero(), "136", convenio)) != null) {
                titulo = b.getTitulo();
                retorno.setBoletoTitulo(b);
            }
        } else {
            titulo = UtilityArquivoCnab.buscarTituloCobranca(retorno.getNrTitulo());
            if (titulo == null && retorno.getNrNossoNumero() != null && (b = UtilityArquivoCnab.buscarTituloNossoNumero(retorno.getNrNossoNumero(), "136", convenio)) != null) {
                titulo = b.getTitulo();
                retorno.setBoletoTitulo(b);
            }
        }
        ConfiguracaoCnab configuracao = null;
        if (titulo != null) {
            configuracao = titulo.getConfiguracaoCnab();
        }
        retorno.setTitulo(titulo);
        String codMovRetorno = line.substring(15, 17).trim();
        if (codMovRetorno != null && !codMovRetorno.isEmpty()) {
            retorno.setCodMovRetorno(codMovRetorno);
            retorno.setDescMovRet(ConstantsRetornoUnicred240.getInfoMovRetornoByCodigo(codMovRetorno));
            retorno.setBaixarPeloMovRetorno(this.verificarSeTituloPodeSerBaixadoPeloCodMovRetornoRecebimento(codMovRetorno));
            retorno.setRejeitado(this.verificarSeTituloRejeitadoByCodMovRetornoRecebimento(codMovRetorno));
        } else {
            retorno.setBaixarPeloMovRetorno(Boolean.FALSE);
        }
        String codOcorrencia1 = line.substring(213, 215).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retorno.setCodOcorrencia1(codOcorrencia1);
            retorno.setMsgOcorrencia1(ConstantsRetornoUnicred240.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(215, 217).trim()) != null && !codOcorrencia2.isEmpty()) {
            retorno.setCodOcorrencia2(codOcorrencia2);
            retorno.setMsgOcorrencia2(ConstantsRetornoUnicred240.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(217, 219).trim()) != null && !codOcorrencia3.isEmpty()) {
            retorno.setCodOcorrencia3(codOcorrencia3);
            retorno.setMsgOcorrencia3(ConstantsRetornoUnicred240.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(219, 221).trim()) != null && !codOcorrencia4.isEmpty()) {
            retorno.setCodOcorrencia4(codOcorrencia4);
            retorno.setMsgOcorrencia4(ConstantsRetornoUnicred240.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(221, 223).trim()) != null && !codOcorrencia5.isEmpty()) {
            retorno.setCodOcorrencia5(codOcorrencia5);
            retorno.setMsgOcorrencia5(ConstantsRetornoUnicred240.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia5));
        }
        if (configuracao != null && configuracao.getValorTarifa() == 1) {
            String valorTarifaInteiro = line.substring(181, 186);
            String valorTarifaDecimal = line.substring(186, 188);
            Double valorTarifa = UtilityArquivoCnab.formatarNumero(valorTarifaInteiro, valorTarifaDecimal);
            retorno.setValorTarifaCobranca(valorTarifa);
        } else {
            retorno.setValorTarifaCobranca(0.0);
        }
        String valorTituloInteiro = line.substring(81, 94);
        String valorTituloDecimal = line.substring(94, 96);
        Double valorTitulo = UtilityArquivoCnab.formatarNumero(valorTituloInteiro, valorTituloDecimal);
        retorno.setValorTitulo(valorTitulo);
    }

    private void setRetornoUnicredDatailSegU(RetornoRecebimentoCnab retorno, String line, ConfiguracaoCnab configuracao) {
        retorno.setDataOcorrencia(line.substring(145, 153));
        retorno.setDataReferenciaRetorno(line.substring(145, 153));
        retorno.setDataCredito(line.substring(157, 165));
        retorno.setNrSequencialRegistro(line.substring(8, 13));
        if (configuracao != null && configuracao.getValorIof() == 1) {
            String valorIofInteiro = line.substring(62, 75);
            String valorIofDecimal = line.substring(75, 77);
            Double valorIof = UtilityArquivoCnab.formatarNumero(valorIofInteiro, valorIofDecimal);
            retorno.setValorIof(valorIof);
        } else {
            retorno.setValorIof(0.0);
        }
        if (configuracao != null && configuracao.getValorOutrosCreditos() == 1) {
            String valorOutrosCreditosInteira = line.substring(122, 135);
            String valorOutrosCreditosDecimal = line.substring(135, 137);
            Double valorOutrosCreditos = UtilityArquivoCnab.formatarNumero(valorOutrosCreditosInteira, valorOutrosCreditosDecimal);
            retorno.setValorOutrosCreditos(valorOutrosCreditos);
        } else {
            retorno.setValorOutrosCreditos(0.0);
        }
        if (configuracao != null && configuracao.getValorAbatimento() == 1) {
            String valorAbatimentoInteiro = line.substring(47, 60);
            String valorAbatimentoDecimal = line.substring(60, 62);
            Double valorAbatimento = UtilityArquivoCnab.formatarNumero(valorAbatimentoInteiro, valorAbatimentoDecimal);
            retorno.setValorAbatimento(valorAbatimento);
        } else {
            retorno.setValorAbatimento(0.0);
        }
        if (configuracao != null && configuracao.getValorDespesaBancaria() == 1) {
            String valorOutrasDespesasInteiro = line.substring(107, 120);
            String valorOutrasDespesasDecimal = line.substring(120, 122);
            Double valorOutrasDespesas = UtilityArquivoCnab.formatarNumero(valorOutrasDespesasInteiro, valorOutrasDespesasDecimal);
            retorno.setValorDespesasBancarias(valorOutrasDespesas);
        } else {
            retorno.setValorDespesasBancarias(0.0);
        }
        if (configuracao != null && configuracao.getValorJuros() == 1) {
            String valorJurosInteiro = line.substring(17, 30);
            String valorJurosDecimal = line.substring(30, 32);
            Double valorJuros = UtilityArquivoCnab.formatarNumero(valorJurosInteiro, valorJurosDecimal);
            retorno.setValorJuros(valorJuros);
        } else {
            retorno.setValorJuros(0.0);
        }
        if (configuracao != null && configuracao.getValorDesconto() == 1) {
            String valorDescontoInteiro = line.substring(32, 45);
            String valorDescontoDecimal = line.substring(45, 47);
            Double valorDesconto = UtilityArquivoCnab.formatarNumero(valorDescontoInteiro, valorDescontoDecimal);
            retorno.setValorDesconto(valorDesconto);
        } else {
            retorno.setValorDesconto(0.0);
        }
        String valorBaixaInteiro = line.substring(77, 90);
        String valorBaixaDecimal = line.substring(90, 92);
        Double valorBaixa = UtilityArquivoCnab.formatarNumero(valorBaixaInteiro, valorBaixaDecimal);
        retorno.setValorBaixa(valorBaixa);
        if (configuracao != null && configuracao.getValorMulta() == 1) {
            retorno.setValorMulta(0.0);
        } else {
            retorno.setValorMulta(0.0);
        }
    }

    @Override
    public List<RetornoRecebimentoCnab> getList() {
        return this.retornoUnicredRecebimento240CNAB;
    }

    public Boolean verificarSeTituloPodeSerBaixadoPeloCodMovRetornoRecebimento(String codMovRetorno) {
        switch (codMovRetorno) {
            case "06": {
                return Boolean.TRUE;
            }
            case "17": {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public Short verificarSeTituloRejeitadoByCodMovRetornoRecebimento(String codMovRetorno) {
        switch (codMovRetorno) {
            case "03": {
                return (short)1;
            }
        }
        return (short)0;
    }
}

