/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.validation;

import com.touchcomp.basementor.model.vo.BorderoPagamento;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.ContaSalarioColaborador;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.ItemBorderoPagamento;
import com.touchcomp.basementor.model.vo.ItemRemessaCnabPagamento;
import com.touchcomp.basementor.model.vo.RemessaCnabPagamento;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.HashMap;
import mentorcore.exceptions.ExceptionValidation;
import mentorcore.service.impl.financeiro.cnabfolha.UtilCnabFolha;

public class CnabPagamentoValidation {
    public static void isValidDataPagCaixa240(RemessaCnabPagamento remessaPagamento) throws ExceptionValidation {
        String numConvenioPagtoCaixa = ((ItemRemessaCnabPagamento)remessaPagamento.getItemRemessaPagamento().get(0)).getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento();
        if (numConvenioPagtoCaixa == null || numConvenioPagtoCaixa.isEmpty()) {
            throw new ExceptionValidation("A Conta da Empresa a ser debitada est\u00e1 sem o c\u00f3digo do Conv\u00eancio de Pagamento");
        }
        if (((ItemRemessaCnabPagamento)remessaPagamento.getItemRemessaPagamento().get(0)).getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getOperacao() == null) {
            throw new ExceptionValidation("A Conta da Empresa a ser debitada est\u00e1 sem Opera\u00e7\u00e3o");
        }
        String logradouroEmpresa = remessaPagamento.getEmpresa().getPessoa().getEndereco().getLogradouro();
        if (logradouroEmpresa == null || logradouroEmpresa.isEmpty()) {
            throw new ExceptionValidation("No endere\u00e7o da Empresa est\u00e1 faltando informar o Logradouro");
        }
        String numeroEmpresa = remessaPagamento.getEmpresa().getPessoa().getEndereco().getNumero();
        if (numeroEmpresa == null || numeroEmpresa.isEmpty()) {
            throw new ExceptionValidation("No endere\u00e7o da Empresa est\u00e1 faltando informar o N\u00famero");
        }
        if (remessaPagamento.getEmpresa().getPessoa().getEndereco().getCidade() == null) {
            throw new ExceptionValidation("No endere\u00e7o da Empresa est\u00e1 faltando informar a Cidade");
        }
        String cepEmpresa = remessaPagamento.getEmpresa().getPessoa().getEndereco().getCep();
        if (cepEmpresa == null || cepEmpresa.isEmpty()) {
            throw new ExceptionValidation("No endere\u00e7o da Empresa est\u00e1 faltando informar o Cep");
        }
        StringBuilder errosTitulos = new StringBuilder();
        for (ItemBorderoPagamento item : ((ItemRemessaCnabPagamento)remessaPagamento.getItemRemessaPagamento().get(0)).getItemBordero().getBorderoPagamento().getItemBordero()) {
            String cepPessoa;
            String bairroPessoa;
            String numeroPessoa;
            String logradouroPessoa;
            HashMap dadosBancariosPessoa = UtilCnabFolha.getDadosBancariosPessoa(item.getItemLiberacao().getTitulo().getPessoa());
            String infoPessoa = item.getItemLiberacao().getTitulo().getPessoa().getIdentificador().toString() + " - " + item.getItemLiberacao().getTitulo().getPessoa().getNome();
            if (dadosBancariosPessoa == null) {
                errosTitulos.append("Pessoa: ").append(infoPessoa).append(" sem dados banc\u00e1rios cadastrados \n");
            }
            if (dadosBancariosPessoa.get("AGENCIA_COL") == null) {
                errosTitulos.append("Pessoa: ").append(infoPessoa).append(" sem N\u00ba da Ag\u00eancia nos dados banc\u00e1rios \n");
            }
            if (dadosBancariosPessoa.get("DIG_AGENCIA_COL") == null) {
                errosTitulos.append("Pessoa: ").append(infoPessoa).append(" sem d\u00edgito da Ag\u00eancia nos dados banc\u00e1rios \n");
            }
            if (dadosBancariosPessoa.get("CONTA_COL") == null) {
                errosTitulos.append("Pessoa: ").append(infoPessoa).append(" sem N\u00ba da Conta nos dados banc\u00e1rios \n");
            }
            if (dadosBancariosPessoa.get("TIPO_CONTA") == null) {
                errosTitulos.append("Pessoa: ").append(infoPessoa).append(" sem a Raz\u00e3o da Conta Banc\u00e1ria nos dados banc\u00e1rios \n");
            }
            if ((logradouroPessoa = item.getItemLiberacao().getTitulo().getPessoa().getEndereco().getLogradouro()) == null || logradouroPessoa.isEmpty()) {
                errosTitulos.append("Pessoa: ").append(infoPessoa).append(" sem Logradoro no cadastro do Endere\u00e7o \n");
            }
            if ((numeroPessoa = item.getItemLiberacao().getTitulo().getPessoa().getEndereco().getNumero()) == null || numeroPessoa.isEmpty()) {
                errosTitulos.append("Pessoa: ").append(infoPessoa).append(" sem N\u00famero no cadastro do Endere\u00e7o \n");
            } else if (numeroPessoa.length() > 5) {
                errosTitulos.append("Pessoa: ").append(infoPessoa).append(" possui N\u00famero superior a 5 d\u00edgitos no cadastro do Endere\u00e7o \n");
            }
            String complementoPessoa = item.getItemLiberacao().getTitulo().getPessoa().getEndereco().getComplemento();
            if (complementoPessoa == null || complementoPessoa.isEmpty()) {
                errosTitulos.append("Pessoa: ").append(infoPessoa).append(" sem Complemento no cadastro do Endere\u00e7o \n");
            }
            if ((bairroPessoa = item.getItemLiberacao().getTitulo().getPessoa().getEndereco().getBairro()) == null || bairroPessoa.isEmpty()) {
                errosTitulos.append("Pessoa: ").append(infoPessoa).append(" sem Bairro no cadastro do Endere\u00e7o \n");
            }
            if (item.getItemLiberacao().getTitulo().getPessoa().getEndereco().getCidade() == null) {
                errosTitulos.append("Pessoa: ").append(infoPessoa).append(" sem Cidade no cadastro do Endere\u00e7o \n");
            }
            if ((cepPessoa = item.getItemLiberacao().getTitulo().getPessoa().getEndereco().getCep()) != null && !cepPessoa.isEmpty()) continue;
            errosTitulos.append("Pessoa: ").append(infoPessoa).append(" sem Cep no cadastro do Endere\u00e7o \n");
        }
        if (errosTitulos != null && errosTitulos.length() > 0) {
            throw new ExceptionValidation(errosTitulos.toString());
        }
    }

    public static void isValidDataPagCaixa150(RemessaCnabPagamento remessaPagamento) throws ExceptionValidation {
        String numConvenioPagtoCaixa = ((ItemRemessaCnabPagamento)remessaPagamento.getItemRemessaPagamento().get(0)).getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento();
        if (numConvenioPagtoCaixa == null || numConvenioPagtoCaixa.isEmpty()) {
            throw new ExceptionValidation("A Conta da Empresa a ser debitada est\u00e1 sem o c\u00f3digo do Conv\u00eancio de Pagamento");
        }
        if (((ItemRemessaCnabPagamento)remessaPagamento.getItemRemessaPagamento().get(0)).getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getOperacao() == null) {
            throw new ExceptionValidation("A Conta da Empresa a ser debitada est\u00e1 sem Opera\u00e7\u00e3o");
        }
        StringBuilder errosTitulos = new StringBuilder();
        for (ItemRemessaCnabPagamento item : remessaPagamento.getItemRemessaPagamento()) {
            HashMap dadosBancariosPessoa = UtilCnabFolha.getDadosBancariosPessoa(item.getItemBordero().getItemLiberacao().getTitulo().getPessoa());
            String infoPessoa = item.getItemBordero().getItemLiberacao().getTitulo().getPessoa().getIdentificador().toString() + " - " + item.getItemBordero().getItemLiberacao().getTitulo().getPessoa().getNome();
            if (dadosBancariosPessoa == null) {
                errosTitulos.append("Pessoa: ").append(infoPessoa).append(" sem dados banc\u00e1rios cadastrados \n");
            }
            if (dadosBancariosPessoa.get("AGENCIA_COL") == null) {
                errosTitulos.append("Pessoa: ").append(infoPessoa).append(" sem N\u00ba da Ag\u00eancia nos dados banc\u00e1rios \n");
            }
            if (dadosBancariosPessoa.get("DIG_AGENCIA_COL") == null) {
                errosTitulos.append("Pessoa: ").append(infoPessoa).append(" sem d\u00edgito da Ag\u00eancia nos dados banc\u00e1rios \n");
            }
            if (dadosBancariosPessoa.get("CONTA_COL") == null) {
                errosTitulos.append("Pessoa: ").append(infoPessoa).append(" sem N\u00ba da Conta nos dados banc\u00e1rios \n");
            }
            if (dadosBancariosPessoa.get("TIPO_CONTA") != null) continue;
            errosTitulos.append("Pessoa: ").append(infoPessoa).append(" sem a Raz\u00e3o da Conta Banc\u00e1ria nos dados banc\u00e1rios \n");
        }
        if (errosTitulos != null && errosTitulos.length() > 0) {
            throw new ExceptionValidation(errosTitulos.toString());
        }
    }

    public static void isValidDadosCnabPagamento240(BorderoPagamento borderoPagamento, ItemBorderoPagamento item) throws ExceptionValidation {
        InstituicaoValores instituicaoValor = borderoPagamento.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor();
        if (!instituicaoValor.getNrBanco().equals("399")) {
            if (instituicaoValor.getNrBanco().equals("001")) {
                CnabPagamentoValidation.isValidDadosObrigatoriosBancoBrasil240(borderoPagamento, item);
            } else if (!(instituicaoValor.getNrBanco().equals("033") || instituicaoValor.getNrBanco().equals("104") || instituicaoValor.getNrBanco().equals("756"))) {
                if (instituicaoValor.getNrBanco().equals("237")) {
                    CnabPagamentoValidation.isValidDadosObrigatoriosBradesco240(borderoPagamento, item);
                } else if (instituicaoValor.getNrBanco().equals("341")) {
                    CnabPagamentoValidation.isValidDadosObrigatoriosItau240(borderoPagamento, item);
                }
            }
        }
    }

    public static void isValidDadosObrigatoriosItau240(BorderoPagamento borderoPagamento, ItemBorderoPagamento item) throws ExceptionValidation {
        CarteiraCobranca carteiraDestino = borderoPagamento.getCarteiraCobranca();
        if (carteiraDestino.getContaValor().getAgenciaValor().getNrAgencia() == null || carteiraDestino.getContaValor().getAgenciaValor().getNrAgencia().isEmpty()) {
            throw new ExceptionValidation("A Conta da Empresa a ser debitada est\u00e1 sem o N\u00famero da Agencia. Favor Informar!");
        }
        if (carteiraDestino.getContaValor().getNrConta() == null || carteiraDestino.getContaValor().getNrConta().isEmpty()) {
            throw new ExceptionValidation("A Conta da Empresa a ser debitada est\u00e1 sem o N\u00famero da Conta. Favor Informar!");
        }
        if (carteiraDestino.getContaValor().getDvConta() == null || carteiraDestino.getContaValor().getDvConta().isEmpty()) {
            throw new ExceptionValidation("A Conta da Empresa a ser debitada est\u00e1 sem o D\u00edgito da Conta. Favor Informar!");
        }
        StringBuilder errosTitulos = new StringBuilder();
        ContaSalarioColaborador contaBancaria = item.getContaBancaria();
        String infoPessoa = item.getItemLiberacao().getTitulo().getPessoa().getIdentificador().toString() + " - " + item.getItemLiberacao().getTitulo().getPessoa().getNome();
        if (contaBancaria == null) {
            throw new ExceptionValidation("Pessoa: " + infoPessoa + " sem dados banc\u00e1rios cadastrados. Favor informar! \n");
        }
        if (contaBancaria.getAgencia() == null || contaBancaria.getAgencia().isEmpty()) {
            errosTitulos.append("Pessoa: ").append(infoPessoa).append(" est\u00e1 sem N\u00ba da Ag\u00eancia em sua Conta Banc\u00e1ria. Favor informar!\n");
        }
        if (contaBancaria.getAgencia() != null && !contaBancaria.getAgencia().isEmpty() && !ToolString.stringIsANumberInteger((String)contaBancaria.getAgencia()).booleanValue()) {
            errosTitulos.append("Pessoa: ").append(infoPessoa).append(" O N\u00ba da Ag\u00eancia da Conta Banc\u00e1ria possui caracteres inv\u00e1lidos. Favor verificar!\n");
        }
        if (contaBancaria.getContaCorrente() == null || contaBancaria.getContaCorrente().isEmpty()) {
            errosTitulos.append("Pessoa: ").append(infoPessoa).append(" est\u00e1 sem N\u00ba da Conta nos dados banc\u00e1rios. Favor informar! \n");
        }
        if (contaBancaria.getDvContaCorrente() == null || contaBancaria.getDvContaCorrente().isEmpty()) {
            errosTitulos.append("Pessoa: ").append(infoPessoa).append(" est\u00e1 sem o Digito Verificador da Conta Banc\u00e1ria. Favor informar! \n");
        }
        if (errosTitulos.length() > 0) {
            throw new ExceptionValidation(errosTitulos.toString());
        }
    }

    public static void isValidDadosObrigatoriosBancoBrasil240(BorderoPagamento borderoPagamento, ItemBorderoPagamento item) throws ExceptionValidation {
        String numConvenioPagtBancoBrasil = borderoPagamento.getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento();
        if (numConvenioPagtBancoBrasil == null || numConvenioPagtBancoBrasil.isEmpty()) {
            throw new ExceptionValidation("A Conta da Empresa a ser debitada est\u00e1 sem o c\u00f3digo do Conv\u00eancio de Pagamento!");
        }
        StringBuilder errosTitulos = new StringBuilder();
        ContaSalarioColaborador dadosBancariosPessoa = item.getContaBancaria();
        String infoPessoa = item.getItemLiberacao().getTitulo().getPessoa().getIdentificador().toString() + " - " + item.getItemLiberacao().getTitulo().getPessoa().getNome();
        if (dadosBancariosPessoa == null) {
            throw new ExceptionValidation("Pessoa: " + infoPessoa + " sem dados banc\u00e1rios cadastrados. Favor informar! \n");
        }
        if (dadosBancariosPessoa.getAgencia() == null || dadosBancariosPessoa.getAgencia().isEmpty()) {
            errosTitulos.append("Pessoa: ").append(infoPessoa).append(" sem N\u00ba da Ag\u00eancia nos dados banc\u00e1rios. Favor informar! \n");
        }
        if (dadosBancariosPessoa.getDvAgencia() == null || dadosBancariosPessoa.getDvAgencia().isEmpty()) {
            errosTitulos.append("Pessoa: ").append(infoPessoa).append(" sem d\u00edgito da Ag\u00eancia nos dados banc\u00e1rios. Favor informar! \n");
        }
        if (dadosBancariosPessoa.getContaCorrente() == null || dadosBancariosPessoa.getContaCorrente().isEmpty()) {
            errosTitulos.append("Pessoa: ").append(infoPessoa).append(" sem N\u00ba da Conta nos dados banc\u00e1rios. Favor informar! \n");
        }
        if (errosTitulos != null && errosTitulos.length() > 0) {
            throw new ExceptionValidation(errosTitulos.toString());
        }
    }

    private static void isValidDadosObrigatoriosBradesco240(BorderoPagamento borderoPagamento, ItemBorderoPagamento item) throws ExceptionValidation {
        String numConvenioPagtBancoBradesco = borderoPagamento.getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento();
        if (numConvenioPagtBancoBradesco == null || numConvenioPagtBancoBradesco.isEmpty()) {
            throw new ExceptionValidation("A Conta da Empresa a ser debitada est\u00e1 sem o c\u00f3digo do Conv\u00eancio de Pagamento. Favor informar!");
        }
        StringBuilder errosTitulos = new StringBuilder();
        ContaSalarioColaborador dadosBancariosPessoa = item.getContaBancaria();
        String infoPessoa = item.getItemLiberacao().getTitulo().getPessoa().getIdentificador().toString() + " - " + item.getItemLiberacao().getTitulo().getPessoa().getNome();
        if (dadosBancariosPessoa == null) {
            throw new ExceptionValidation("Pessoa: " + infoPessoa + " sem dados banc\u00e1rios cadastrados. Favor informar! \n");
        }
        if (dadosBancariosPessoa.getAgencia() == null || dadosBancariosPessoa.getAgencia().isEmpty()) {
            errosTitulos.append("Pessoa: ").append(infoPessoa).append(" sem N\u00ba da Ag\u00eancia nos dados banc\u00e1rios. Favor informar! \n");
        }
        if (dadosBancariosPessoa.getContaCorrente() == null || dadosBancariosPessoa.getContaCorrente().isEmpty()) {
            errosTitulos.append("Pessoa: ").append(infoPessoa).append(" sem N\u00ba da Conta nos dados banc\u00e1rios. Favor informar! \n");
        }
        if ((item.getFormaLancamento().getCodigo().equals("41") || item.getFormaLancamento().getCodigo().equals("43")) && (item.getContaBancaria().getInstituicaoValor().getCodigoIspb() == null || item.getContaBancaria().getInstituicaoValor().getCodigoIspb().isEmpty())) {
            errosTitulos.append("A Instui\u00e7\u00e3o de Valores da Pessoa: ").append(infoPessoa).append(" esta sem o C\u00f3digo ISPB. Favor informar! \n");
        }
        if (errosTitulos != null && errosTitulos.length() > 0) {
            throw new ExceptionValidation(errosTitulos.toString());
        }
    }
}

