/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.utility;

import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoaComplementar;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.BoletoTitulo;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.ContaSalarioColaborador;
import com.touchcomp.basementor.model.vo.GrupoDeBaixa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixaFormas;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.ItemConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.ItemOutrosTitulosFolha;
import com.touchcomp.basementor.model.vo.ItemRetornoCnab;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionService;
import mentorcore.finder.BaseCriteria;
import mentorcore.finder.BaseOrder;
import mentorcore.service.CoreService;
import mentorcore.util.CoreStringUtil;
import org.apache.commons.lang3.StringUtils;

public class UtilityArquivoCnab {
    private static final TLogger logger = TLogger.get(UtilityArquivoCnab.class);

    public static String completarComZeroEsquerda(String st, int tam) {
        if (st == null) {
            st = "";
        }
        if (st.length() > tam) {
            return st.substring(0, tam);
        }
        return StringUtils.leftPad((String)st, (int)tam, (String)"0");
    }

    public static String completarComBrancoDireita(String st, int tam) {
        if (st == null) {
            st = "";
        }
        if (st.length() > tam) {
            return st.substring(0, tam);
        }
        return StringUtils.rightPad((String)st, (int)tam, (String)" ");
    }

    public static String completarComBrancoEsquerda(String st, int tam) {
        return StringUtils.leftPad((String)st, (int)tam, (String)" ");
    }

    public static String completarComZeroDireita(String st, int tam) {
        return StringUtils.rightPad((String)st, (int)tam, (String)"0");
    }

    public static String formatarDatas6Digitos(Date data) {
        if (data != null) {
            SimpleDateFormat dataFormatada = new SimpleDateFormat("ddMMyy");
            String dataVenc = dataFormatada.format(data);
            return dataVenc;
        }
        return "000000";
    }

    public static String formatarDatas8Digitos(Date data) {
        if (data != null) {
            SimpleDateFormat dataFormatada = new SimpleDateFormat("ddMMyyyy");
            String dataVenc = dataFormatada.format(data);
            return dataVenc;
        }
        return "00000000";
    }

    public static Date strToDateByFormatRetorno(String dataStr) {
        if (!ToolMethods.isStrWithData((String)(dataStr = ToolString.refina((String)dataStr))) || dataStr.matches("[0]+")) {
            return null;
        }
        if (!CoreStringUtil.stringIsANumberInteger(dataStr).booleanValue()) {
            return null;
        }
        switch (dataStr.length()) {
            case 6: {
                return ToolDate.strToDate((String)dataStr, (String)"ddMMyy");
            }
            case 8: {
                return ToolDate.strToDate((String)dataStr, (String)"ddMMyyyy");
            }
        }
        return null;
    }

    public static String formatarDatas8DigitosFormatyyyyMMdd(Date data) {
        if (data != null) {
            SimpleDateFormat dataFormatada = new SimpleDateFormat("yyyyMMdd");
            String dataVenc = dataFormatada.format(data);
            return dataVenc;
        }
        return "00000000";
    }

    public static String getTipoInscricaoDoisDigitos(Pessoa pessoa) {
        if (ToolString.refina((String)pessoa.getComplemento().getCnpj().toString()).length() == 14) {
            return "02";
        }
        return "01";
    }

    public static String verificarDataDesconto(BoletoTitulo boleto) {
        if (boleto.getTitulo().getDataLimiteDesconto() != null) {
            return UtilityArquivoCnab.formatarDatas6Digitos(boleto.getTitulo().getDataLimiteDesconto());
        }
        return "000000";
    }

    public static String verificarAceite(Short tipoAceite) {
        if (tipoAceite == 1) {
            return "A";
        }
        return "N";
    }

    public static Double formatarNumero(String valorInteiro, String valorDecimal) {
        try {
            String numeroCertoS = valorInteiro + "," + valorDecimal;
            DecimalFormat dff = (DecimalFormat)DecimalFormat.getInstance();
            Number numeroCerto = dff.parse(numeroCertoS);
            return ContatoFormatUtil.arrredondarNumero((Double)numeroCerto.doubleValue(), (int)2);
        }
        catch (ParseException ex) {
            Logger.getLogger(UtilityArquivoCnab.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
            Logger.getLogger(UtilityArquivoCnab.class.getName()).log(Level.SEVERE, null, ex);
        }
        return 0.0;
    }

    public static String getTipoInscricaoUmDigito(Pessoa pessoa) {
        if (ToolMethods.isNotNull((Object)pessoa.getComplemento().getCnpj()).booleanValue() && ToolMethods.isStrWithDataLength((String)pessoa.getComplemento().getCnpj().trim(), (int)14)) {
            return "2";
        }
        if (ToolMethods.isNotNull((Object)pessoa.getComplemento().getCnpj()).booleanValue() && ToolMethods.isStrWithDataLength((String)pessoa.getComplemento().getCnpj().trim(), (int)11)) {
            return "1";
        }
        throw new RuntimeException("N\u00e3o foi encontrado o CPF/CNPJ da pessoa " + pessoa.getNome());
    }

    public static String getTipoInscricaoCNPJCEIUmDigito(Pessoa pessoa) {
        if (pessoa.getComplemento().getTipoPessoa().equals(EnumConstTipoPessoaComplementar.JURIDICA.getEnumId())) {
            return "1";
        }
        if (pessoa.getComplemento().getTipoPessoa().equals(EnumConstTipoPessoaComplementar.CEI.getEnumId())) {
            return "2";
        }
        throw new RuntimeException("N\u00e3o foi encontrado o Tipo de Pessoa como Juridica ou CEI da pessoa " + pessoa.getNome());
    }

    public static String getInscricaoCNPJCEIUmDigito(Pessoa pessoa) {
        if (pessoa.getComplemento().getTipoPessoa().equals(EnumConstTipoPessoaComplementar.JURIDICA.getEnumId())) {
            return pessoa.getComplemento().getCnpj();
        }
        if (pessoa.getComplemento().getTipoPessoa().equals(EnumConstTipoPessoaComplementar.CEI.getEnumId())) {
            return pessoa.getComplemento().getCodCei();
        }
        throw new RuntimeException("N\u00e3o foi encontrado o Tipo de Pessoa como Juridica ou CEI da pessoa " + pessoa.getNome());
    }

    public static String getTipoInscricaoUmDigito(String cnpj) {
        if (cnpj != null && !cnpj.isEmpty() && cnpj.length() == 14) {
            return "2";
        }
        if (cnpj != null && !cnpj.isEmpty() && cnpj.length() == 11) {
            return "1";
        }
        return "";
    }

    public static String getDadosCep(String cep, Integer tipo, String pessoa) throws IOException {
        if (cep == null || cep.isEmpty()) {
            throw new IOException("No cadastro de " + pessoa + " est\u00e1 faltando o CEP. Opera\u00e7\u00e3o cancelada.");
        }
        if (tipo.equals(1)) {
            return cep.substring(0, 5);
        }
        return cep.substring(5, 8);
    }

    public static Titulo buscarTituloCobranca(String idTituloS) throws ExceptionService {
        if ((idTituloS = idTituloS.trim()) != null && idTituloS.length() > 0 && ToolString.stringIsANumberInteger((String)idTituloS).booleanValue()) {
            Long idTitulo = Long.valueOf(idTituloS);
            BaseCriteria b = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOBoletoTitulo().getVOClass());
            b.and().equal("titulo.identificador", idTitulo);
            BoletoTitulo boleto = (BoletoTitulo)CoreService.executeSearchUniqueResult(b);
            if (boleto != null) {
                return boleto.getTitulo();
            }
        } else {
            return null;
        }
        return null;
    }

    public static Titulo buscarTituloPagamento(String idTituloS) throws ExceptionService {
        if ((idTituloS = idTituloS.trim()) != null && idTituloS.length() > 0 && ToolString.stringIsANumberInteger((String)idTituloS).booleanValue()) {
            Long idTitulo = Long.valueOf(idTituloS);
            return (Titulo)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOTitulo(), idTitulo);
        }
        return null;
    }

    public static BoletoTitulo buscarTituloNossoNumero(String nrNossoNumero, String nrBanco, String convenio) throws ExceptionService {
        if (!(ToolMethods.isStrWithData((String)nrNossoNumero) && ToolMethods.isStrWithData((String)nrBanco) && ToolString.stringIsANumberInteger((String)nrNossoNumero.trim()).booleanValue())) {
            return null;
        }
        BaseCriteria criteria = BaseCriteria.create(BoletoTitulo.class);
        criteria.and().equal("numeroTituloInst", String.valueOf(Long.valueOf(nrNossoNumero.trim())));
        criteria.and().equal("carteiraCobranca.contaValor.agenciaValor.instituicaoValor.nrBanco", nrBanco);
        List listBoleto = CoreService.executeSearch(criteria);
        if (!ToolMethods.isWithData((Collection)listBoleto)) {
            return null;
        }
        if (listBoleto.size() == 1) {
            return (BoletoTitulo)listBoleto.get(0);
        }
        for (BoletoTitulo b : listBoleto) {
            if (convenio.equals(b.getCarteiraCobranca().getContaValor().getNumeroConvenio())) {
                return b;
            }
            if (!convenio.equals(b.getCarteiraCobranca().getContaValor().getNrConta())) continue;
            return b;
        }
        return null;
    }

    static boolean existeBoletoDuplicado(String nrNossoNumero, InstituicaoValores instValor, Titulo titulo) throws ExceptionService {
        List boletos;
        if (!ToolMethods.isStrWithData((String)nrNossoNumero) || ToolMethods.isEquals((Object)instValor, null) || !ToolString.stringIsANumberInteger((String)nrNossoNumero.trim()).booleanValue()) {
            return false;
        }
        BaseCriteria criteria = BaseCriteria.create(BoletoTitulo.class);
        criteria.and().equal("numeroTituloInst", String.valueOf(Long.valueOf(nrNossoNumero.trim())));
        criteria.and().equal("carteiraCobranca.contaValor.agenciaValor.instituicaoValor", instValor);
        criteria.and().equal("ativo", (short)1);
        if (!ToolMethods.isEquals((Object)titulo, null)) {
            CarteiraCobranca carteira = titulo.getCartCobrancaDestino() != null ? titulo.getCartCobrancaDestino() : titulo.getCarteiraCobranca();
            criteria.and().equal("carteiraCobranca", carteira);
        }
        return ToolMethods.isWithData((Collection)(boletos = CoreService.executeSearch(criteria))) && boletos.size() > 1;
    }

    public static Double findSaldoTitulo(Titulo t) throws ExceptionService {
        return t.getValorSaldo() != null ? ContatoFormatUtil.arrredondarNumero((Double)t.getValorSaldo(), (int)2) : 0.0;
    }

    public static String getHoraGeracao(Timestamp dataEHora) {
        Timestamp horaCorrente = dataEHora;
        Integer hora = horaCorrente.getHours();
        Integer minu = horaCorrente.getMinutes();
        Integer segu = horaCorrente.getSeconds();
        return (String)(hora.toString().length() == 1 ? "0" + hora.toString() : hora.toString()) + (String)(minu.toString().length() == 1 ? "0" + minu.toString() : minu.toString()) + (String)(segu.toString().length() == 1 ? "0" + segu.toString() : segu.toString());
    }

    public static String getValueByKey(String key, ConfiguracaoCnab configuracaoCnab) {
        for (ItemConfiguracaoCnab itemConfigCnab : configuracaoCnab.getItensConfiguracaoCnab()) {
            if (!itemConfigCnab.getChave().equals(key)) continue;
            if (itemConfigCnab.getIsNumerico() == 1) {
                if (itemConfigCnab.getConteudo() != null && !itemConfigCnab.getConteudo().isEmpty()) {
                    return UtilityArquivoCnab.completarComZeroEsquerda(itemConfigCnab.getConteudo(), itemConfigCnab.getTamanho().intValue());
                }
                return UtilityArquivoCnab.completarComZeroEsquerda("", itemConfigCnab.getTamanho().intValue());
            }
            if (itemConfigCnab.getConteudo() != null && !itemConfigCnab.getConteudo().isEmpty()) {
                return UtilityArquivoCnab.completarComBrancoDireita(itemConfigCnab.getConteudo(), itemConfigCnab.getTamanho().intValue());
            }
            return UtilityArquivoCnab.completarComBrancoDireita("", itemConfigCnab.getTamanho().intValue());
        }
        throw new RuntimeException("Nenhum valor encontrado para a Key: " + key);
    }

    public static Boolean validValueByKey(String key, ConfiguracaoCnab configuracaoCnab) {
        for (ItemConfiguracaoCnab itemConfigCnab : configuracaoCnab.getItensConfiguracaoCnab()) {
            if (!itemConfigCnab.getChave().equals(key) || itemConfigCnab.getConteudo() == null || itemConfigCnab.getConteudo().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static void validationBeforePrintCnab(File arquivo, int layout) throws IOException {
        FileReader file = new FileReader(arquivo);
        BufferedReader buffer = new BufferedReader(file);
        int linha = 1;
        while (buffer.ready()) {
            String line = buffer.readLine();
            if (line.length() != layout) {
                file.close();
                throw new IOException("Foram encontradas inconsistencias na estrutura do arquivo \nArquivo com " + line.length() + " posicoes. Na linha " + linha);
            }
            ++linha;
        }
    }

    public static String getLayoutArquivoCnab(File arquivo) throws FileNotFoundException, IOException {
        FileReader file = new FileReader(arquivo);
        BufferedReader buffer = new BufferedReader(file);
        return Integer.toString(buffer.readLine().length());
    }

    public static List<ContaSalarioColaborador> getContaBancariaAtivaByPessoa(List<ContaSalarioColaborador> contasBancarias) throws ExceptionService {
        if (contasBancarias == null || contasBancarias.isEmpty()) {
            return null;
        }
        ArrayList<ContaSalarioColaborador> aux = new ArrayList<ContaSalarioColaborador>();
        for (ContaSalarioColaborador conta : contasBancarias) {
            if (!ToolMethods.isEquals((Object)conta.getAtivo(), (Object)1)) continue;
            aux.add(conta);
        }
        return aux;
    }

    public static ContaSalarioColaborador getContaBancariaAtivaAndPreferencialByPessoa(List<ContaSalarioColaborador> contasBancarias) throws ExceptionService {
        if (contasBancarias == null || contasBancarias.isEmpty()) {
            return null;
        }
        for (ContaSalarioColaborador conta : contasBancarias) {
            if (!ToolMethods.isEquals((Object)conta.getAtivo(), (Object)1) || !ToolMethods.isEquals((Object)conta.getPreferencial(), (Object)1)) continue;
            return conta;
        }
        return null;
    }

    static boolean verificarSeTituloPodeSerBaixadoPeloCodOcorrenciaRetornoPagamento(String codOcorrencia) {
        switch (codOcorrencia) {
            case "00": {
                return Boolean.TRUE;
            }
            case "03": {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public static Double findValorBaixaDevolucao(Titulo titulo) {
        try {
            Double valorBaixaDevolucao = 0.0;
            BaseCriteria b = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOGrupoDeBaixaTitulo().getVOClass());
            b.and().equal("grupoDeBaixaFormas.baixaTitulo.titulo", titulo);
            b.and().equal("grupoDeBaixaFormas.formaPagamento", (short)2);
            List baixasDevolucao = CoreService.executeSearch(b);
            if (baixasDevolucao != null && !baixasDevolucao.isEmpty()) {
                for (GrupoDeBaixa gb : baixasDevolucao) {
                    for (GrupoDeBaixaFormas gbf : gb.getGrupoDeBaixaFormas()) {
                        for (BaixaTitulo bt : gbf.getBaixaTitulo()) {
                            if (!bt.getTitulo().equals((Object)titulo)) continue;
                            valorBaixaDevolucao = valorBaixaDevolucao + bt.getValor();
                        }
                    }
                }
            }
            return ContatoFormatUtil.arrredondarNumero((Double)valorBaixaDevolucao, (int)2);
        }
        catch (ExceptionService ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return 0.0;
        }
    }

    public static Double findValorBaixaFaltaPagamento(Titulo titulo) {
        try {
            Double valorBaixaFaltaPagamento = 0.0;
            BaseCriteria b = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOGrupoDeBaixaTitulo().getVOClass());
            b.and().equal("grupoDeBaixaFormas.baixaTitulo.titulo", titulo);
            b.and().equal("grupoDeBaixaFormas.formaPagamento", (short)3);
            List baixasDevolucao = CoreService.executeSearch(b);
            if (baixasDevolucao != null && !baixasDevolucao.isEmpty()) {
                for (GrupoDeBaixa gb : baixasDevolucao) {
                    for (GrupoDeBaixaFormas gbf : gb.getGrupoDeBaixaFormas()) {
                        for (BaixaTitulo bt : gbf.getBaixaTitulo()) {
                            if (!bt.getTitulo().equals((Object)titulo)) continue;
                            valorBaixaFaltaPagamento = valorBaixaFaltaPagamento + bt.getValor();
                        }
                    }
                }
            }
            return ContatoFormatUtil.arrredondarNumero((Double)valorBaixaFaltaPagamento, (int)2);
        }
        catch (ExceptionService ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return 0.0;
        }
    }

    public static Boolean findOutrosTitulosFolha(Titulo titulo) throws ExceptionService {
        ItemOutrosTitulosFolha geracaoTitulo = titulo.getGeracaoOutrosTitulosFolha();
        if (geracaoTitulo != null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    static Double findValorBaixaTituloAntecipado(Titulo titulo) {
        try {
            Double valorBaixaAntecipada = 0.0;
            BaseCriteria b = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOGrupoDeBaixaTitulo().getVOClass());
            b.and().equal("grupoDeBaixaFormas.baixaTitulo.titulo", titulo);
            b.and().equal("grupoDeBaixaFormas.formaPagamento", (short)7);
            List baixasAntecipadas = CoreService.executeSearch(b);
            if (baixasAntecipadas != null && !baixasAntecipadas.isEmpty()) {
                for (GrupoDeBaixa gb : baixasAntecipadas) {
                    for (GrupoDeBaixaFormas gbf : gb.getGrupoDeBaixaFormas()) {
                        for (BaixaTitulo bt : gbf.getBaixaTitulo()) {
                            if (!bt.getTitulo().equals((Object)titulo)) continue;
                            valorBaixaAntecipada = valorBaixaAntecipada + bt.getValor();
                        }
                    }
                }
            }
            return ContatoFormatUtil.arrredondarNumero((Double)valorBaixaAntecipada, (int)2);
        }
        catch (ExceptionService ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return 0.0;
        }
    }

    public static void deleteFileRemessa(FileWriter fileWriter, File arquivo) throws IOException {
        boolean isDeleted = true;
        try {
            if (fileWriter != null) {
                fileWriter.close();
            }
            if (arquivo != null && !(isDeleted = arquivo.delete())) {
                throw new IOException("Erro ao deletar o Arquivo!");
            }
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new IOException("Erro ao deletar o Arquivo!");
        }
    }

    public static Short getTipoTituloTributo(Titulo titulo) {
        try {
            BaseCriteria b = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOGeracaoOutrosTitulosFolha().getVOClass());
            b.and().equal("titulos.titulo.identificador", titulo);
            b.and().setField("titulos.tipoTitulo");
            Short tipoTitulo = (Short)CoreService.executeSearchUniqueResult(b);
            return tipoTitulo;
        }
        catch (ExceptionService ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static String getNossoNumeroItemRetornoCnab(Titulo titulo) {
        try {
            BaseCriteria b = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOItemRetornoCnab().getVOClass());
            b.and().equal("titulo.identificador", titulo.getIdentificador());
            b.and().setField("nossoNumero");
            b.setOrders(Arrays.asList(new BaseOrder("dataOcorrencia")));
            List nossoNumero = CoreService.executeSearch(b);
            if (nossoNumero != null && !nossoNumero.isEmpty()) {
                return ((ItemRetornoCnab)nossoNumero.get(nossoNumero.size() - 1)).getNossoNumero();
            }
            return null;
        }
        catch (ExceptionService ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static String substituirLetrasPorZero(String str) {
        Object ret = "";
        if (str != null && !str.isEmpty()) {
            for (int i = 0; i < str.length(); ++i) {
                char carac = str.charAt(i);
                ret = ToolString.stringIsANumber((String)String.valueOf(carac)) != false ? (String)ret + String.valueOf(carac) : (String)ret + "0";
            }
        }
        return ret;
    }

    public static String codigoCMC7OrLinha1Cheque(String cmc, String c1c2c3) {
        Object ret = "";
        if (cmc != null && !cmc.isEmpty()) {
            if (c1c2c3 == null || c1c2c3.isEmpty()) {
                return ret;
            }
            cmc = cmc.replace("<", "");
            cmc = cmc.replace(">", "");
            cmc = cmc.replace("\u00c7", "");
            ret = cmc.substring(8, 11);
            ret = (String)ret + cmc.substring(0, 3);
            ret = (String)ret + cmc.substring(3, 7);
            ret = (String)ret + c1c2c3.substring(0, 1);
            ret = (String)ret + cmc.substring(19, 29);
            ret = (String)ret + c1c2c3.substring(1, 2);
            ret = (String)ret + cmc.substring(11, 17);
            ret = (String)ret + c1c2c3.substring(2, 3);
        }
        return ret;
    }

    public static Boolean isCodigoCMC7(String cmc) {
        return cmc.contains("<") && cmc.contains(">");
    }

    public static String numeroDocumento(Short tipoNumero, Titulo titulo, int tamanho) {
        if (tipoNumero == 1) {
            if (titulo.getInfPagamentoNfPropria() != null && titulo.getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
                return UtilityArquivoCnab.completarComBrancoDireita(titulo.getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota().toString(), tamanho);
            }
            if (titulo.getFaturaCte() != null) {
                return UtilityArquivoCnab.completarComBrancoDireita(titulo.getFaturaCte().getIdentificador().toString(), tamanho);
            }
            if (titulo.getRps() != null) {
                return UtilityArquivoCnab.completarComBrancoDireita(titulo.getRps().getNumero().toString(), tamanho);
            }
            if (titulo.getOrdemCompra() != null) {
                return UtilityArquivoCnab.completarComBrancoDireita(titulo.getOrdemCompra().getIdentificador().toString(), tamanho);
            }
            if (titulo.getInfPagamentoPedido() != null && titulo.getInfPagamentoPedido().getPedido() != null) {
                return UtilityArquivoCnab.completarComBrancoDireita(titulo.getInfPagamentoPedido().getPedido().getIdentificador().toString(), tamanho);
            }
            if (titulo.getPedidoComercio() != null) {
                return UtilityArquivoCnab.completarComBrancoDireita(titulo.getPedidoComercio().getIdentificador().toString(), tamanho);
            }
            if (titulo.getAdiantamentoViagem() != null) {
                return UtilityArquivoCnab.completarComBrancoDireita(titulo.getAdiantamentoViagem().getIdentificador().toString(), tamanho);
            }
            if (titulo.getNotaContratoLocacao() != null) {
                return UtilityArquivoCnab.completarComBrancoDireita(titulo.getNotaContratoLocacao().getNumero().toString(), tamanho);
            }
            if (titulo.getContratoLocacao() != null) {
                return UtilityArquivoCnab.completarComBrancoDireita(titulo.getContratoLocacao().getNumeroContrato().toString(), tamanho);
            }
            if (titulo.getApuracaoLocacaoContrato() != null) {
                return UtilityArquivoCnab.completarComBrancoDireita(titulo.getApuracaoLocacaoContrato().getIdentificador().toString(), tamanho);
            }
            if (titulo.getCte() != null) {
                return UtilityArquivoCnab.completarComBrancoDireita(titulo.getCte().getNumero().toString(), tamanho);
            }
            return UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), tamanho);
        }
        return UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), tamanho);
    }
}

