/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.utility;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumProvisionamentoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.situacaocobranca.EnumConstSituacaoCobranca;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Cheque;
import com.touchcomp.basementor.model.vo.ChequeTerceiros;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementor.model.vo.ContraPartMovimentoBancario;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixaFormas;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.LayoutCobranca;
import com.touchcomp.basementor.model.vo.MovimentoBancario;
import com.touchcomp.basementor.model.vo.OcorrenciaRetornoCnab;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorservice.service.impl.feriado.ServiceFeriadoImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.date.ToolDate;
import contatocore.util.ContatoDateUtil;
import contatocore.util.ContatoFormatUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.tools.DateUtil;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class UtilityFinanceiro {
    public static MovimentoBancario gerarMovimentoConta(GrupoDeBaixaFormas grupoFormas, Double totalOperacao, Double valor, Cheque cheque, BaixaTitulo baixa, Double valorJuros, Double valorDesconto, Double valorAtMonetariaRecebida, Double valorAtMonetariaPaga, Double valorDespBancariaPaga, Double valorDespBancariaRec, Double valorMulta, Double valorPis, Double valorConfins, Double valorContribSocial, String historicoContraPartidas, Double valorAbatimento, Double valorIofPago, Double valorIofRecebido, Empresa empresaLogada, Double valorDespesaCartorioPaga, Double valorDespesaCartorioRec, Double valorIr, Double valorTolerancia, Double valorTaxaCartao) throws ExceptionService {
        MovimentoBancario movimento = new MovimentoBancario();
        movimento.setNaoContabilizarMov(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
        movimento.setDataLancamento((Date)ContatoDateUtil.toTimestamp((Date)grupoFormas.getGrupoDeBaixa().getDataLiquidacao(), (Date)new Date()));
        if (grupoFormas.getFormaPagamento() != 0 && grupoFormas.getFormaPagamento() != 4) {
            Date data = grupoFormas.getGrupoDeBaixa().getDataLiquidacao();
            if (grupoFormas.getGrupoDeBaixa().getPagRec() == 1) {
                CarteiraCobranca cart = null;
                cart = baixa != null ? baixa.getTitulo().getCarteiraCobranca() : ((BaixaTitulo)grupoFormas.getBaixaTitulo().get(0)).getTitulo().getCarteiraCobranca();
                data = DateUtil.nextDays(data, cart.getDiasCompensacao().shortValue());
                if (cart.getContaValor().getExcluirDiasNaoUteis() != null && cart.getContaValor().getExcluirDiasNaoUteis().shortValue() == EnumConstantsMentorSimNao.SIM.getValue()) {
                    data = UtilityFinanceiro.getDataVencimentoDiasNaoUteis(data, cart.getEmpresa());
                }
            }
            movimento.setDataCompensacao(data);
        }
        if (grupoFormas.getFormaPagamento() == 4) {
            CarteiraCobranca cart = null;
            cart = baixa != null ? baixa.getTitulo().getCarteiraCobranca() : ((BaixaTitulo)grupoFormas.getBaixaTitulo().get(0)).getTitulo().getCarteiraCobranca();
            Date data = movimento.getDataLancamento();
            data = DateUtil.nextDays(movimento.getDataLancamento(), cart.getDiasCompensacao().shortValue());
            if (cart.getContaValor().getExcluirDiasNaoUteis() != null && cart.getContaValor().getExcluirDiasNaoUteis().shortValue() == EnumConstantsMentorSimNao.SIM.getValue()) {
                data = UtilityFinanceiro.getDataVencimentoDiasNaoUteis(data, cart.getEmpresa());
            }
            movimento.setDataCompensacao(data);
        }
        movimento.setContaValor(grupoFormas.getContaValor());
        if (grupoFormas.getGrupoDeBaixa().getPagRec() == 0) {
            movimento.setDebCred(Short.valueOf((short)0));
            if (grupoFormas.getContaValor().getExcluirDiasNaoUteis() != null && grupoFormas.getContaValor().getExcluirDiasNaoUteis().shortValue() == EnumConstantsMentorSimNao.SIM.getValue()) {
                movimento.setDataCompensacao(UtilityFinanceiro.getDataVencimentoDiasNaoUteis(grupoFormas.getGrupoDeBaixa().getDataLiquidacao(), grupoFormas.getGrupoDeBaixa().getEmpresa()));
            }
            if (baixa != null) {
                movimento.setHistorico("Baixa Titulos(Debito): " + historicoContraPartidas + " " + baixa.getTitulo().getPessoa().getNome());
            } else {
                movimento.setHistorico("Baixa Titulos(Debito): " + historicoContraPartidas);
            }
            if (grupoFormas.getAgrupamento().shortValue() == EnumConstantsMentorSimNao.SIM.getValue()) {
                contraPartidas = UtilityFinanceiro.gerarContraPartidas(grupoFormas, (short)0, empresaLogada);
                movimento.setContraPartMovimentoBancario(contraPartidas);
            } else {
                movimento.setContraPartMovimentoBancario(UtilityFinanceiro.gerarContraPartidaInstituicaoPagNaoAgrup(grupoFormas.getGrupoDeBaixa(), valor, valorJuros, valorDesconto, valorAtMonetariaRecebida, valorAtMonetariaPaga, valorDespBancariaPaga, valorDespBancariaRec, valorMulta, valorPis, valorConfins, valorContribSocial, grupoFormas.getContaValor(), historicoContraPartidas, baixa, valorAbatimento, valorIofPago, valorIofRecebido, valorDespesaCartorioPaga, valorDespesaCartorioRec, valorIr));
            }
        } else {
            movimento.setDebCred(Short.valueOf((short)1));
            if (baixa != null) {
                movimento.setHistorico("Baixa Titulos(Credito): " + historicoContraPartidas + " " + baixa.getTitulo().getPessoa().getNome());
            } else {
                movimento.setHistorico("Baixa Titulos(Credito): " + historicoContraPartidas);
            }
            if (grupoFormas.getAgrupamento().shortValue() == EnumConstantsMentorSimNao.SIM.getValue()) {
                contraPartidas = UtilityFinanceiro.gerarContraPartidas(grupoFormas, (short)1, empresaLogada);
                movimento.setContraPartMovimentoBancario(contraPartidas);
            } else {
                movimento.setContraPartMovimentoBancario(UtilityFinanceiro.gerarContraPartidaInstituicaoRecNaoAgrup(grupoFormas.getGrupoDeBaixa(), valor, valorJuros, valorDesconto, valorAtMonetariaRecebida, valorAtMonetariaPaga, valorDespBancariaPaga, valorDespBancariaRec, valorMulta, valorPis, valorConfins, valorContribSocial, grupoFormas.getContaValor(), historicoContraPartidas, baixa, valorAbatimento, valorIofPago, valorIofRecebido, valorDespesaCartorioPaga, valorDespesaCartorioRec, valorIr, valorTaxaCartao));
            }
        }
        movimento.setDataCadastro(new Date());
        movimento.setEmpresa(empresaLogada);
        movimento.setValor(totalOperacao);
        movimento.getContraPartMovimentoBancario().forEach(i -> i.setMovimentoBancario(movimento));
        movimento.setCheque(cheque);
        if (grupoFormas.getFormaPagamento() == 0 && cheque != null) {
            movimento.setHistorico(movimento.getHistorico() + " Ch. pr\u00f3prio nr:" + cheque.getNumero() + " para " + cheque.getFavorecido());
        }
        if (grupoFormas.getFormaPagamento() == 4) {
            List cheques;
            Object hist = "";
            List list = cheques = grupoFormas.getGrupoDeBaixa().getPagRec() == 0 ? grupoFormas.getChequeTerceirosPag() : grupoFormas.getChequeTerceirosRec();
            if (cheques != null) {
                for (Object o : cheques) {
                    ChequeTerceiros ch = (ChequeTerceiros)o;
                    hist = (String)hist + ch.getNumero() + ", " + ch.getAgencia() + ", " + ch.getBanco() + ";";
                }
            }
            movimento.setHistorico(movimento.getHistorico() + " Cheque terceiros:" + (String)hist);
        }
        if (movimento.getHistorico().length() >= 500) {
            movimento.setHistorico(movimento.getHistorico().substring(0, 500));
        }
        return movimento;
    }

    public static void gerarMovimentosBancarios(GrupoDeBaixaFormas grupo, Empresa empresaLogada, Double valorTolerancia) throws ExceptionService {
        boolean retValue = false;
        if (grupo.getContaValor() == null) {
            boolean bl = retValue = grupo.getFormaPagamento() == 1 || grupo.getFormaPagamento() == 0;
            if (retValue) {
                return;
            }
        }
        if (grupo.getAgrupamento().shortValue() == EnumConstantsMentorSimNao.SIM.getValue()) {
            UtilityFinanceiro.gerarMovimentoAgrupado(grupo, empresaLogada, valorTolerancia);
        } else {
            UtilityFinanceiro.gerarMovimentoNaoAgrupado(grupo, empresaLogada, valorTolerancia);
        }
    }

    public static void gerarMovimentoAgrupado(GrupoDeBaixaFormas grupoFormas, Empresa empresaLogada, Double valorTolerancia) throws ExceptionService {
        double valor = 0.0;
        double valorJuros = 0.0;
        double valorMulta = 0.0;
        double valorDesconto = 0.0;
        double valorAtMonetariaPaga = 0.0;
        double valorAtMonetariaRecebida = 0.0;
        double valorDespBancariaPaga = 0.0;
        double valorDespBancariaRec = 0.0;
        double valorIofPago = 0.0;
        double valorIofRecebido = 0.0;
        double valorAbatimento = 0.0;
        double valorPis = 0.0;
        double valorConfins = 0.0;
        double valorContribSocial = 0.0;
        double valorTotalOperacao = 0.0;
        double valorCartorioPag = 0.0;
        double valorCartorioRec = 0.0;
        double valorIr = 0.0;
        double valorTaxaCartao = 0.0;
        Object numTitulos = "";
        BaixaTitulo b = null;
        Double valorTotal = 0.0;
        for (Object o : grupoFormas.getBaixaTitulo()) {
            BaixaTitulo baixa = (BaixaTitulo)o;
            if (baixa == null || baixa.getTitulo().getCarteiraCobranca() != null && baixa.getTitulo().getCarteiraCobranca().getSituacaoCobranca().getTipoCobranca() == EnumConstSituacaoCobranca.DESCONTADA.getEnumId()) continue;
            valor += baixa.getValor().doubleValue();
            valorAtMonetariaRecebida += baixa.getVrAtualizacaoMonetariaRecebida().doubleValue();
            valorAtMonetariaPaga += baixa.getVrAtualizacaoMonetariaPaga().doubleValue();
            valorJuros += baixa.getVrJuros().doubleValue();
            valorMulta += baixa.getVrMulta().doubleValue();
            valorDesconto += baixa.getVrDesconto().doubleValue();
            valorDespBancariaPaga += baixa.getVrDespBancariaPaga().doubleValue();
            valorDespBancariaRec += baixa.getVrDespBancariaRecebida().doubleValue();
            valorAbatimento += baixa.getVrAbatimento().doubleValue();
            valorIofPago += baixa.getVrIOFPago().doubleValue();
            valorIofRecebido += baixa.getVrIOFRecebido().doubleValue();
            valorPis += baixa.getVrPis().doubleValue();
            valorConfins += baixa.getVrConfins().doubleValue();
            valorContribSocial += baixa.getVrContribSocial().doubleValue();
            valorTotalOperacao += baixa.getTotalOperacao().doubleValue();
            valorCartorioPag += baixa.getVrDespesaCartorioPaga().doubleValue();
            valorCartorioRec += baixa.getVrDespesaCartorioRecebida().doubleValue();
            valorIr += baixa.getVrIR().doubleValue();
            valorTaxaCartao += baixa.getVrTaxaCartao().doubleValue();
            numTitulos = (String)numTitulos + baixa.getTitulo().getIdentificador() + ", ";
        }
        if (valor > 0.0) {
            ArrayList<MovimentoBancario> mov;
            if (((String)numTitulos).length() > 3) {
                numTitulos = ((String)numTitulos).substring(0, ((String)numTitulos).length() - 2);
            }
            Cheque ch = null;
            if (grupoFormas.getFormaPagamento() == 0 && grupoFormas.getBaixaTitulo() != null && !grupoFormas.getBaixaTitulo().isEmpty()) {
                ch = ((BaixaTitulo)grupoFormas.getBaixaTitulo().get(0)).getCheque();
            }
            MovimentoBancario estorno = null;
            MovimentoBancario movimentoBancario = UtilityFinanceiro.gerarMovimentoConta(grupoFormas, valorTotalOperacao, valor, ch, b, valorJuros, valorDesconto, valorAtMonetariaRecebida, valorAtMonetariaPaga, valorDespBancariaPaga, valorDespBancariaRec, valorMulta, valorPis, valorConfins, valorContribSocial, (String)numTitulos, valorAbatimento, valorIofPago, valorIofRecebido, empresaLogada, valorCartorioPag, valorCartorioRec, valorIr, valorTolerancia, valorTaxaCartao);
            if (grupoFormas.getFormaPagamento() == 4) {
                Double valorCheques = ContatoFormatUtil.arrredondarNumero((Double)UtilityFinanceiro.getValorCheques(grupoFormas.getChequeTerceirosPag()), (int)2);
                valorCheques = valorCheques + ContatoFormatUtil.arrredondarNumero((Double)UtilityFinanceiro.getValorCheques(grupoFormas.getChequeTerceirosRec()), (int)2);
                valorTotal = grupoFormas.getGrupoDeBaixa().getPagRec() == 0 ? Double.valueOf(valor + valorCartorioPag - valorCartorioRec + valorJuros - valorDesconto - valorAbatimento + valorAtMonetariaPaga - valorAtMonetariaRecebida + valorDespBancariaPaga + valorIofPago - valorDespBancariaRec - valorIofRecebido + valorMulta - valorPis - valorConfins - valorContribSocial) : Double.valueOf(valor - valorCartorioPag + valorCartorioRec + valorJuros - valorDesconto - valorAbatimento - valorAtMonetariaPaga + valorAtMonetariaRecebida - valorDespBancariaPaga - valorIofPago + valorDespBancariaRec + valorIofRecebido + valorMulta - valorPis - valorConfins - valorContribSocial);
                valorTotal = ContatoFormatUtil.arrredondarNumero((Double)valorTotal, (int)2);
                Double valorEst = Math.abs(valorTotal - valorCheques);
                estorno = UtilityFinanceiro.criarMovimentoEstorno(grupoFormas, valorEst, empresaLogada);
                movimentoBancario.setValor(valorCheques);
            }
            if ((mov = grupoFormas.getMovimentoBancario()) == null) {
                mov = new ArrayList<MovimentoBancario>();
            } else {
                mov.clear();
            }
            movimentoBancario.setGrupoDeBaixaFormas(grupoFormas);
            mov.add(movimentoBancario);
            if (estorno != null) {
                estorno.setGrupoDeBaixaFormas(grupoFormas);
                mov.add(estorno);
            }
            grupoFormas.setMovimentoBancario(mov);
        }
    }

    public static void gerarMovimentoNaoAgrupado(GrupoDeBaixaFormas grupoFormas, Empresa empresaLogada, Double valorTolerancia) throws ExceptionService {
        ArrayList<MovimentoBancario> ret = grupoFormas.getMovimentoBancario();
        if (ret == null) {
            ret = new ArrayList<MovimentoBancario>();
        } else {
            ret.clear();
        }
        Double valorTotal = 0.0;
        Double valorCheques = 0.0;
        for (Object o : grupoFormas.getBaixaTitulo()) {
            BaixaTitulo baixa = (BaixaTitulo)o;
            valorTotal = valorTotal + baixa.getTotalOperacao();
            if (baixa.getTitulo().getCarteiraCobranca() != null && baixa.getTitulo().getCarteiraCobranca().getSituacaoCobranca().getTipoCobranca() == EnumConstSituacaoCobranca.DESCONTADA.getEnumId()) continue;
            MovimentoBancario mov = UtilityFinanceiro.gerarMovimentoConta(grupoFormas, baixa.getTotalOperacao(), baixa.getValor(), baixa.getCheque(), baixa, baixa.getVrJuros(), baixa.getVrDesconto(), baixa.getVrAtualizacaoMonetariaRecebida(), baixa.getVrAtualizacaoMonetariaPaga(), baixa.getVrDespBancariaPaga(), baixa.getVrDespBancariaRecebida(), baixa.getVrMulta(), baixa.getVrPis(), baixa.getVrConfins(), baixa.getVrContribSocial(), baixa.getTitulo().getIdentificador() != null ? baixa.getTitulo().getIdentificador().toString() : "", baixa.getVrAbatimento(), baixa.getVrIOFPago(), baixa.getVrIOFRecebido(), empresaLogada, baixa.getVrDespesaCartorioPaga(), baixa.getVrDespesaCartorioRecebida(), baixa.getVrIR(), valorTolerancia, baixa.getVrTaxaCartao());
            mov.setGrupoDeBaixaFormas(grupoFormas);
            ret.add(mov);
        }
        MovimentoBancario estorno = null;
        valorCheques = valorCheques + ContatoFormatUtil.arrredondarNumero((Double)UtilityFinanceiro.getValorCheques(grupoFormas.getChequeTerceirosRec()), (int)2);
        valorCheques = valorCheques + ContatoFormatUtil.arrredondarNumero((Double)UtilityFinanceiro.getValorCheques(grupoFormas.getChequeTerceirosPag()), (int)2);
        valorTotal = ContatoFormatUtil.arrredondarNumero((Double)valorTotal, (int)2);
        Double valorEst = Math.abs(valorTotal - valorCheques);
        if (grupoFormas.getFormaPagamento() == 4 && (estorno = UtilityFinanceiro.criarMovimentoEstorno(grupoFormas, valorEst, empresaLogada)) != null) {
            estorno.setGrupoDeBaixaFormas(grupoFormas);
            ret.add(estorno);
        }
        grupoFormas.setMovimentoBancario(ret);
    }

    public static Double getValorCheques(List cheques) {
        Double valor = 0.0;
        if (cheques == null) {
            return valor;
        }
        for (Object o : cheques) {
            ChequeTerceiros ch = (ChequeTerceiros)o;
            valor = valor + ch.getValor();
        }
        return valor;
    }

    public static MovimentoBancario criarMovimentoEstorno(GrupoDeBaixaFormas grupo, Double valor, Empresa empresaLogada) {
        if (valor <= 0.0) {
            return null;
        }
        MovimentoBancario movimento = new MovimentoBancario();
        movimento.setDataLancamento((Date)ContatoDateUtil.toTimestamp((Date)grupo.getGrupoDeBaixa().getDataLiquidacao(), (Date)new Date()));
        movimento.setContaValor(grupo.getContaValorTroco());
        movimento.setDataCompensacao(new Date());
        if (grupo.getGrupoDeBaixa().getPagRec() == 0) {
            movimento.setDebCred(Short.valueOf((short)1));
            movimento.setHistorico("Vr. estornado(troco) nesta data via baixa titulos.");
        } else {
            movimento.setDebCred(Short.valueOf((short)0));
            movimento.setHistorico("Vr. estornado(troco) nesta data via baixa titulos.");
        }
        movimento.setDataCadastro(new Date());
        movimento.setEmpresa(empresaLogada);
        movimento.setDataAtualizacao(grupo.getGrupoDeBaixa().getDataAtualizacao());
        movimento.setValor(valor);
        movimento.setGrupoDeBaixaFormas(grupo);
        return movimento;
    }

    public static List<ContraPartMovimentoBancario> gerarContraPartidaInstituicaoPagNaoAgrup(GrupoDeBaixa grupo, Double valor, Double valorJuros, Double valorDesconto, Double valorAtMonetariaRecebida, Double valorAtMonetariaPaga, Double valorDespBancariaPaga, Double valorDespBancariaRec, Double valorMulta, Double valorPis, Double ValorConfins, Double ValorContribSocial, ContaValores conta, String numTitulos, BaixaTitulo baixa, Double valorAbatimento, Double valorIofPago, Double valorIofRecebido, Double valorDespesaCartorioPag, Double valorDespesaCartorioRec, Double valorIr) {
        ContraPartMovimentoBancario contraPartidaCartorio;
        ContraPartMovimentoBancario contraPartidaIof;
        ContraPartMovimentoBancario contraPartidaDespesa;
        ContraPartMovimentoBancario contraPartidaAtualizacao;
        ArrayList<ContraPartMovimentoBancario> listaContraPartida = new ArrayList<ContraPartMovimentoBancario>();
        ContraPartMovimentoBancario contraPartida = new ContraPartMovimentoBancario();
        contraPartida.setPlanoConta(conta.getPlanoConta());
        contraPartida.setDebCred(Short.valueOf((short)0));
        contraPartida.setBuscaTitulos(Short.valueOf((short)0));
        contraPartida.setValor(valor);
        contraPartida.setHistorico("Valor. Pago Titulo " + numTitulos);
        if (contraPartida.getHistorico().length() > 500) {
            contraPartida.setHistorico(contraPartida.getHistorico().substring(0, 500));
        }
        listaContraPartida.add(contraPartida);
        if (valorJuros > 0.0) {
            ContraPartMovimentoBancario contraPartidaJuros = new ContraPartMovimentoBancario();
            contraPartidaJuros.setPlanoConta(baixa.getContasBaixa().getPlanoContaJuros());
            contraPartidaJuros.setDebCred(Short.valueOf((short)0));
            contraPartidaJuros.setBuscaTitulos(Short.valueOf((short)0));
            contraPartidaJuros.setValor(valorJuros);
            contraPartidaJuros.setHistorico("Juros sobre Titulos " + numTitulos);
            if (contraPartidaJuros.getHistorico().length() > 500) {
                contraPartidaJuros.setHistorico(contraPartidaJuros.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaJuros);
        }
        if (valorDesconto > 0.0) {
            ContraPartMovimentoBancario contraPartidaDesconto = new ContraPartMovimentoBancario();
            contraPartidaDesconto.setPlanoConta(baixa.getContasBaixa().getPlanoContaDesc());
            contraPartidaDesconto.setDebCred(Short.valueOf((short)1));
            contraPartidaDesconto.setBuscaTitulos(Short.valueOf((short)0));
            contraPartidaDesconto.setValor(valorDesconto);
            contraPartidaDesconto.setHistorico("Desconto sobre Titulos " + numTitulos);
            if (contraPartidaDesconto.getHistorico().length() > 500) {
                contraPartidaDesconto.setHistorico(contraPartidaDesconto.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaDesconto);
        }
        if (valorAbatimento > 0.0) {
            ContraPartMovimentoBancario contraPartidaAbatimento = new ContraPartMovimentoBancario();
            contraPartidaAbatimento.setPlanoConta(baixa.getContasBaixa().getPlanoContaAbatimento());
            contraPartidaAbatimento.setDebCred(Short.valueOf((short)1));
            contraPartidaAbatimento.setBuscaTitulos(Short.valueOf((short)0));
            contraPartidaAbatimento.setValor(valorAbatimento);
            contraPartidaAbatimento.setHistorico("Abatimento sobre Titulos " + numTitulos);
            if (contraPartidaAbatimento.getHistorico().length() > 500) {
                contraPartidaAbatimento.setHistorico(contraPartidaAbatimento.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaAbatimento);
        }
        if (valorAtMonetariaRecebida > 0.0) {
            contraPartidaAtualizacao = new ContraPartMovimentoBancario();
            contraPartidaAtualizacao.setPlanoConta(baixa.getContasBaixa().getPlanoContaAtualMonRecebida());
            contraPartidaAtualizacao.setDebCred(Short.valueOf((short)0));
            contraPartidaAtualizacao.setBuscaTitulos(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
            contraPartidaAtualizacao.setValor(valorAtMonetariaRecebida);
            contraPartidaAtualizacao.setHistorico("At. Monetaria Rec. sobre Titulos " + numTitulos);
            if (contraPartidaAtualizacao.getHistorico().length() > 500) {
                contraPartidaAtualizacao.setHistorico(contraPartidaAtualizacao.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaAtualizacao);
        }
        if (valorAtMonetariaPaga > 0.0) {
            contraPartidaAtualizacao = new ContraPartMovimentoBancario();
            contraPartidaAtualizacao.setPlanoConta(baixa.getContasBaixa().getPlanoContaAtualMonPaga());
            contraPartidaAtualizacao.setDebCred(Short.valueOf((short)0));
            contraPartidaAtualizacao.setBuscaTitulos(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
            contraPartidaAtualizacao.setValor(valorAtMonetariaPaga);
            contraPartidaAtualizacao.setHistorico("At. Monetaria Pag. sobre Titulos " + numTitulos);
            if (contraPartidaAtualizacao.getHistorico().length() > 500) {
                contraPartidaAtualizacao.setHistorico(contraPartidaAtualizacao.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaAtualizacao);
        }
        if (valorDespBancariaPaga > 0.0) {
            contraPartidaDespesa = new ContraPartMovimentoBancario();
            if (baixa.getGrupoDeBaixaFormas().getGrupoDeBaixa().getRetornoCnab() != null) {
                contraPartidaDespesa.setPlanoConta(baixa.getContasBaixa().getPlanoContaDespBancCnabPag());
            } else {
                contraPartidaDespesa.setPlanoConta(baixa.getContasBaixa().getPlanoContaDespBancPag());
            }
            contraPartidaDespesa.setDebCred(Short.valueOf((short)0));
            contraPartidaDespesa.setBuscaTitulos(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
            contraPartidaDespesa.setValor(valorDespBancariaPaga);
            contraPartidaDespesa.setHistorico("Desp. Bancaria sobre Titulos " + numTitulos);
            if (contraPartidaDespesa.getHistorico().length() > 500) {
                contraPartidaDespesa.setHistorico(contraPartidaDespesa.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaDespesa);
        }
        if (valorDespBancariaRec > 0.0) {
            contraPartidaDespesa = new ContraPartMovimentoBancario();
            if (baixa.getGrupoDeBaixaFormas().getGrupoDeBaixa().getRetornoCnab() != null) {
                contraPartidaDespesa.setPlanoConta(baixa.getContasBaixa().getPlanoContaDespBancCnabRec());
            } else {
                contraPartidaDespesa.setPlanoConta(baixa.getContasBaixa().getPlanoContaDespBancRec());
            }
            contraPartidaDespesa.setDebCred(Short.valueOf((short)1));
            contraPartidaDespesa.setBuscaTitulos(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
            contraPartidaDespesa.setValor(valorDespBancariaRec);
            contraPartidaDespesa.setHistorico("Desp. Bancaria sobre Titulos " + numTitulos);
            if (contraPartidaDespesa.getHistorico().length() > 500) {
                contraPartidaDespesa.setHistorico(contraPartidaDespesa.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaDespesa);
        }
        if (valorIofPago > 0.0) {
            contraPartidaIof = new ContraPartMovimentoBancario();
            contraPartidaIof.setPlanoConta(baixa.getContasBaixa().getPlanoContaIofPag());
            contraPartidaIof.setDebCred(Short.valueOf((short)0));
            contraPartidaIof.setBuscaTitulos(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
            contraPartidaIof.setValor(valorIofPago);
            contraPartidaIof.setHistorico("IOF sobre Titulos " + numTitulos);
            if (contraPartidaIof.getHistorico().length() > 500) {
                contraPartidaIof.setHistorico(contraPartidaIof.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaIof);
        }
        if (valorIofRecebido > 0.0) {
            contraPartidaIof = new ContraPartMovimentoBancario();
            contraPartidaIof.setPlanoConta(baixa.getContasBaixa().getPlanoContaIofRec());
            contraPartidaIof.setDebCred(Short.valueOf((short)1));
            contraPartidaIof.setBuscaTitulos(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
            contraPartidaIof.setValor(valorIofRecebido);
            contraPartidaIof.setHistorico("IOF sobre Titulos " + numTitulos);
            if (contraPartidaIof.getHistorico().length() > 500) {
                contraPartidaIof.setHistorico(contraPartidaIof.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaIof);
        }
        if (valorMulta > 0.0) {
            ContraPartMovimentoBancario contraPartidaMulta = new ContraPartMovimentoBancario();
            contraPartidaMulta.setPlanoConta(baixa.getContasBaixa().getPlanoContaMulta());
            contraPartidaMulta.setDebCred(Short.valueOf((short)0));
            contraPartidaMulta.setBuscaTitulos(Short.valueOf((short)0));
            contraPartidaMulta.setValor(valorMulta);
            contraPartidaMulta.setHistorico("Multa sobre Titulos " + numTitulos);
            if (contraPartidaMulta.getHistorico().length() > 500) {
                contraPartidaMulta.setHistorico(contraPartidaMulta.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaMulta);
        }
        if (valorPis > 0.0) {
            ContraPartMovimentoBancario contraPartidaPis = new ContraPartMovimentoBancario();
            contraPartidaPis.setPlanoConta(baixa.getContasBaixa().getPlanoContaPis());
            contraPartidaPis.setDebCred(Short.valueOf((short)0));
            contraPartidaPis.setBuscaTitulos(Short.valueOf((short)0));
            contraPartidaPis.setValor(valorPis);
            contraPartidaPis.setHistorico("Pis sobre Titulos " + numTitulos);
            if (contraPartidaPis.getHistorico().length() > 500) {
                contraPartidaPis.setHistorico(contraPartidaPis.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaPis);
        }
        if (ValorConfins > 0.0) {
            ContraPartMovimentoBancario contraPartidaConfins = new ContraPartMovimentoBancario();
            contraPartidaConfins.setPlanoConta(baixa.getContasBaixa().getPlanoContaCofins());
            contraPartidaConfins.setDebCred(Short.valueOf((short)0));
            contraPartidaConfins.setBuscaTitulos(Short.valueOf((short)0));
            contraPartidaConfins.setValor(ValorConfins);
            contraPartidaConfins.setHistorico("Cofins sobre Titulos " + numTitulos);
            if (contraPartidaConfins.getHistorico().length() > 500) {
                contraPartidaConfins.setHistorico(contraPartidaConfins.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaConfins);
        }
        if (ValorContribSocial > 0.0) {
            ContraPartMovimentoBancario contraPartidaContribSocial = new ContraPartMovimentoBancario();
            contraPartidaContribSocial.setPlanoConta(baixa.getContasBaixa().getPlanoContaContrSoc());
            contraPartidaContribSocial.setDebCred(Short.valueOf((short)0));
            contraPartidaContribSocial.setBuscaTitulos(Short.valueOf((short)0));
            contraPartidaContribSocial.setValor(ValorContribSocial);
            contraPartidaContribSocial.setHistorico("Cont. Social sobre Titulos " + numTitulos);
            if (contraPartidaContribSocial.getHistorico().length() > 500) {
                contraPartidaContribSocial.setHistorico(contraPartida.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaContribSocial);
        }
        if (valorDespesaCartorioPag > 0.0) {
            contraPartidaCartorio = new ContraPartMovimentoBancario();
            contraPartidaCartorio.setPlanoConta(baixa.getContasBaixa().getPlanoContaCartorioPag());
            contraPartidaCartorio.setDebCred(Short.valueOf((short)0));
            contraPartidaCartorio.setBuscaTitulos(Short.valueOf((short)0));
            contraPartidaCartorio.setValor(valorDespesaCartorioPag);
            contraPartidaCartorio.setHistorico("Despesa Cartorio Pag. sobre Titulos " + numTitulos);
            if (contraPartidaCartorio.getHistorico().length() > 500) {
                contraPartidaCartorio.setHistorico(contraPartida.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaCartorio);
        }
        if (valorDespesaCartorioRec > 0.0) {
            contraPartidaCartorio = new ContraPartMovimentoBancario();
            contraPartidaCartorio.setPlanoConta(baixa.getContasBaixa().getPlanoContaCartorioRec());
            contraPartidaCartorio.setDebCred(Short.valueOf((short)0));
            contraPartidaCartorio.setBuscaTitulos(Short.valueOf((short)0));
            contraPartidaCartorio.setValor(valorDespesaCartorioRec);
            contraPartidaCartorio.setHistorico("Despesa Cartorio Rec. sobre Titulos " + numTitulos);
            if (contraPartidaCartorio.getHistorico().length() > 500) {
                contraPartidaCartorio.setHistorico(contraPartida.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaCartorio);
        }
        if (valorIr > 0.0) {
            contraPartidaCartorio = new ContraPartMovimentoBancario();
            contraPartidaCartorio.setPlanoConta(baixa.getContasBaixa().getPlanoContaIR());
            contraPartidaCartorio.setDebCred(Short.valueOf((short)0));
            contraPartidaCartorio.setBuscaTitulos(Short.valueOf((short)0));
            contraPartidaCartorio.setValor(valorIr);
            contraPartidaCartorio.setHistorico("Valor IR sobre Titulos " + numTitulos);
            if (contraPartidaCartorio.getHistorico().length() > 500) {
                contraPartidaCartorio.setHistorico(contraPartida.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaCartorio);
        }
        return listaContraPartida;
    }

    public static List<ContraPartMovimentoBancario> gerarContraPartidaInstituicaoRecNaoAgrup(GrupoDeBaixa grupo, Double valor, Double valorJuros, Double valorDesconto, Double valorAtMonetariaRecebida, Double valorAtMonetariaPaga, Double valorDespBancariaPaga, Double valorDespBancariaRec, Double valorMulta, Double valorPis, Double valorCofins, Double valorContribSocial, ContaValores conta, String historico, BaixaTitulo baixa, Double valorAbatimento, Double valorIofPago, Double valorIofRecebido, Double valorDespesaCartorioPaga, Double valorDespesaCartorioRec, Double valorIr, Double valorTaxaCartao) {
        ContraPartMovimentoBancario contraPartidaCartorio;
        ContraPartMovimentoBancario contraPartidaPis;
        ContraPartMovimentoBancario contraPartidaIof;
        ContraPartMovimentoBancario contraPartidaDespesa;
        ContraPartMovimentoBancario contraPartidaAtualizacao;
        ArrayList<ContraPartMovimentoBancario> listaContraPartida = new ArrayList<ContraPartMovimentoBancario>();
        if (conta == null) {
            return listaContraPartida;
        }
        ContraPartMovimentoBancario contraPartida = new ContraPartMovimentoBancario();
        contraPartida.setPlanoConta(conta.getPlanoConta());
        contraPartida.setDebCred(Short.valueOf((short)1));
        contraPartida.setBuscaTitulos(Short.valueOf((short)0));
        contraPartida.setValor(valor);
        contraPartida.setHistorico("Valor recebido sobre Titulo " + historico);
        if (contraPartida.getHistorico().length() > 500) {
            contraPartida.setHistorico(contraPartida.getHistorico().substring(0, 500));
        }
        listaContraPartida.add(contraPartida);
        if (valorJuros > 0.0) {
            ContraPartMovimentoBancario contraPartidaJuros = new ContraPartMovimentoBancario();
            contraPartidaJuros.setPlanoConta(baixa.getContasBaixa().getPlanoContaJuros());
            contraPartidaJuros.setDebCred(Short.valueOf((short)1));
            contraPartidaJuros.setBuscaTitulos(Short.valueOf((short)0));
            contraPartidaJuros.setValor(valorJuros);
            contraPartidaJuros.setHistorico("Juros sobre Titulos " + historico);
            if (contraPartidaJuros.getHistorico().length() > 500) {
                contraPartidaJuros.setHistorico(contraPartidaJuros.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaJuros);
        }
        if (valorDesconto > 0.0) {
            ContraPartMovimentoBancario contraPartidaDesconto = new ContraPartMovimentoBancario();
            contraPartidaDesconto.setPlanoConta(baixa.getContasBaixa().getPlanoContaDesc());
            contraPartidaDesconto.setDebCred(Short.valueOf((short)0));
            contraPartidaDesconto.setBuscaTitulos(Short.valueOf((short)0));
            contraPartidaDesconto.setValor(valorDesconto);
            contraPartidaDesconto.setHistorico("Desconto sobre Titulos " + historico);
            if (contraPartidaDesconto.getHistorico().length() > 500) {
                contraPartidaDesconto.setHistorico(contraPartidaDesconto.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaDesconto);
        }
        if (valorAbatimento > 0.0) {
            ContraPartMovimentoBancario contraPartidaAbatimento = new ContraPartMovimentoBancario();
            contraPartidaAbatimento.setPlanoConta(baixa.getContasBaixa().getPlanoContaAbatimento());
            contraPartidaAbatimento.setDebCred(Short.valueOf((short)0));
            contraPartidaAbatimento.setBuscaTitulos(Short.valueOf((short)0));
            contraPartidaAbatimento.setValor(valorAbatimento);
            contraPartidaAbatimento.setHistorico("Abatimento sobre Titulos " + historico);
            if (contraPartidaAbatimento.getHistorico().length() > 500) {
                contraPartidaAbatimento.setHistorico(contraPartidaAbatimento.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaAbatimento);
        }
        if (valorAtMonetariaRecebida > 0.0) {
            contraPartidaAtualizacao = new ContraPartMovimentoBancario();
            contraPartidaAtualizacao.setPlanoConta(baixa.getContasBaixa().getPlanoContaAtualMonRecebida());
            contraPartidaAtualizacao.setDebCred(Short.valueOf((short)1));
            contraPartidaAtualizacao.setBuscaTitulos(Short.valueOf((short)0));
            contraPartidaAtualizacao.setValor(valorAtMonetariaRecebida);
            contraPartidaAtualizacao.setHistorico("At. Monetaria Rec. sobre Titulos " + historico);
            if (contraPartidaAtualizacao.getHistorico().length() > 500) {
                contraPartidaAtualizacao.setHistorico(contraPartidaAtualizacao.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaAtualizacao);
        }
        if (valorAtMonetariaPaga > 0.0) {
            contraPartidaAtualizacao = new ContraPartMovimentoBancario();
            contraPartidaAtualizacao.setPlanoConta(baixa.getContasBaixa().getPlanoContaAtualMonPaga());
            contraPartidaAtualizacao.setDebCred(Short.valueOf((short)1));
            contraPartidaAtualizacao.setBuscaTitulos(Short.valueOf((short)0));
            contraPartidaAtualizacao.setValor(valorAtMonetariaPaga);
            contraPartidaAtualizacao.setHistorico("At. Monetaria Pag. sobre Titulos " + historico);
            if (contraPartidaAtualizacao.getHistorico().length() > 500) {
                contraPartidaAtualizacao.setHistorico(contraPartidaAtualizacao.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaAtualizacao);
        }
        if (valorDespBancariaPaga > 0.0) {
            contraPartidaDespesa = new ContraPartMovimentoBancario();
            if (baixa.getGrupoDeBaixaFormas().getGrupoDeBaixa().getRetornoCnab() != null) {
                contraPartidaDespesa.setPlanoConta(baixa.getContasBaixa().getPlanoContaDespBancCnabPag());
            } else {
                contraPartidaDespesa.setPlanoConta(baixa.getContasBaixa().getPlanoContaDespBancPag());
            }
            contraPartidaDespesa.setDebCred(Short.valueOf((short)0));
            contraPartidaDespesa.setBuscaTitulos(Short.valueOf((short)0));
            contraPartidaDespesa.setValor(valorDespBancariaPaga);
            contraPartidaDespesa.setHistorico("Desp. Bancaria sobre Titulos " + historico);
            if (contraPartidaDespesa.getHistorico().length() > 500) {
                contraPartidaDespesa.setHistorico(contraPartidaDespesa.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaDespesa);
        }
        if (valorTaxaCartao > 0.0) {
            contraPartidaDespesa = new ContraPartMovimentoBancario();
            if (baixa.getGrupoDeBaixaFormas().getGrupoDeBaixa().getRetornoCnab() != null) {
                contraPartidaDespesa.setPlanoConta(baixa.getContasBaixa().getPlanoContaTaxaCartao());
            } else {
                contraPartidaDespesa.setPlanoConta(baixa.getContasBaixa().getPlanoContaTaxaCartao());
            }
            contraPartidaDespesa.setDebCred(Short.valueOf((short)0));
            contraPartidaDespesa.setBuscaTitulos(Short.valueOf((short)0));
            contraPartidaDespesa.setValor(valorTaxaCartao);
            contraPartidaDespesa.setHistorico("Taxa Cartao " + historico);
            if (contraPartidaDespesa.getHistorico().length() > 500) {
                contraPartidaDespesa.setHistorico(contraPartidaDespesa.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaDespesa);
        }
        if (valorDespBancariaRec > 0.0) {
            contraPartidaDespesa = new ContraPartMovimentoBancario();
            if (baixa.getGrupoDeBaixaFormas().getGrupoDeBaixa().getRetornoCnab() != null) {
                contraPartidaDespesa.setPlanoConta(baixa.getContasBaixa().getPlanoContaDespBancCnabRec());
            } else {
                contraPartidaDespesa.setPlanoConta(baixa.getContasBaixa().getPlanoContaDespBancRec());
            }
            contraPartidaDespesa.setDebCred(Short.valueOf((short)0));
            contraPartidaDespesa.setBuscaTitulos(Short.valueOf((short)0));
            contraPartidaDespesa.setValor(valorDespBancariaRec);
            contraPartidaDespesa.setHistorico("Desp. Bancaria sobre Titulos " + historico);
            if (contraPartidaDespesa.getHistorico().length() > 500) {
                contraPartidaDespesa.setHistorico(contraPartidaDespesa.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaDespesa);
        }
        if (valorIofPago > 0.0) {
            contraPartidaIof = new ContraPartMovimentoBancario();
            contraPartidaIof.setPlanoConta(baixa.getContasBaixa().getPlanoContaIofPag());
            contraPartidaIof.setDebCred(Short.valueOf((short)1));
            contraPartidaIof.setBuscaTitulos(Short.valueOf((short)0));
            contraPartidaIof.setValor(valorIofPago);
            contraPartidaIof.setHistorico("IOF sobre Titulos " + historico);
            if (contraPartidaIof.getHistorico().length() > 500) {
                contraPartidaIof.setHistorico(contraPartidaIof.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaIof);
        }
        if (valorIofRecebido > 0.0) {
            contraPartidaIof = new ContraPartMovimentoBancario();
            contraPartidaIof.setPlanoConta(baixa.getContasBaixa().getPlanoContaIofRec());
            contraPartidaIof.setDebCred(Short.valueOf((short)1));
            contraPartidaIof.setBuscaTitulos(Short.valueOf((short)0));
            contraPartidaIof.setValor(valorIofRecebido);
            contraPartidaIof.setHistorico("IOF sobre Titulos " + historico);
            if (contraPartidaIof.getHistorico().length() > 500) {
                contraPartidaIof.setHistorico(contraPartidaIof.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaIof);
        }
        if (valorMulta > 0.0) {
            ContraPartMovimentoBancario contraPartidaMulta = new ContraPartMovimentoBancario();
            contraPartidaMulta.setPlanoConta(baixa.getContasBaixa().getPlanoContaMulta());
            contraPartidaMulta.setDebCred(Short.valueOf((short)1));
            contraPartidaMulta.setBuscaTitulos(Short.valueOf((short)0));
            contraPartidaMulta.setValor(valorMulta);
            contraPartidaMulta.setHistorico("Multa sobre Titulos " + historico);
            if (contraPartidaMulta.getHistorico().length() > 500) {
                contraPartidaMulta.setHistorico(contraPartidaMulta.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaMulta);
        }
        if (valorPis > 0.0) {
            contraPartidaPis = new ContraPartMovimentoBancario();
            contraPartidaPis.setPlanoConta(baixa.getContasBaixa().getPlanoContaPis());
            contraPartidaPis.setDebCred(Short.valueOf((short)1));
            contraPartidaPis.setBuscaTitulos(Short.valueOf((short)0));
            contraPartidaPis.setValor(valorPis);
            contraPartidaPis.setHistorico("Pis sobre Titulo " + historico);
            if (contraPartidaPis.getHistorico().length() > 500) {
                contraPartidaPis.setHistorico(contraPartidaPis.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaPis);
        }
        if (valorCofins > 0.0) {
            ContraPartMovimentoBancario contraPartidaCofins = new ContraPartMovimentoBancario();
            contraPartidaCofins.setPlanoConta(baixa.getContasBaixa().getPlanoContaCofins());
            contraPartidaCofins.setDebCred(Short.valueOf((short)1));
            contraPartidaCofins.setBuscaTitulos(Short.valueOf((short)0));
            contraPartidaCofins.setValor(valorCofins);
            contraPartidaCofins.setHistorico("Cofins sobre Titulos " + historico);
            if (contraPartidaCofins.getHistorico().length() > 500) {
                contraPartidaCofins.setHistorico(contraPartidaCofins.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaCofins);
        }
        if (valorContribSocial > 0.0) {
            contraPartidaPis = new ContraPartMovimentoBancario();
            contraPartidaPis.setPlanoConta(baixa.getContasBaixa().getPlanoContaContrSoc());
            contraPartidaPis.setDebCred(Short.valueOf((short)1));
            contraPartidaPis.setBuscaTitulos(Short.valueOf((short)0));
            contraPartidaPis.setValor(valorContribSocial);
            contraPartidaPis.setHistorico("Cont. Social sobre Titulos " + historico);
            if (contraPartidaPis.getHistorico().length() > 500) {
                contraPartidaPis.setHistorico(contraPartidaPis.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaPis);
        }
        if (valorDespesaCartorioPaga > 0.0) {
            contraPartidaCartorio = new ContraPartMovimentoBancario();
            contraPartidaCartorio.setPlanoConta(baixa.getContasBaixa().getPlanoContaCartorioPag());
            contraPartidaCartorio.setDebCred(Short.valueOf((short)1));
            contraPartidaCartorio.setBuscaTitulos(Short.valueOf((short)0));
            contraPartidaCartorio.setValor(valorDespesaCartorioPaga);
            contraPartidaCartorio.setHistorico("Despesa Cartorio Pag. sobre Titulos " + historico);
            if (contraPartidaCartorio.getHistorico().length() > 500) {
                contraPartidaCartorio.setHistorico(contraPartidaCartorio.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaCartorio);
        }
        if (valorDespesaCartorioRec > 0.0) {
            contraPartidaCartorio = new ContraPartMovimentoBancario();
            contraPartidaCartorio.setPlanoConta(baixa.getContasBaixa().getPlanoContaCartorioRec());
            contraPartidaCartorio.setDebCred(Short.valueOf((short)1));
            contraPartidaCartorio.setBuscaTitulos(Short.valueOf((short)0));
            contraPartidaCartorio.setValor(valorDespesaCartorioRec);
            contraPartidaCartorio.setHistorico("Despesa Cartorio Rec. sobre Titulos " + historico);
            if (contraPartidaCartorio.getHistorico().length() > 500) {
                contraPartidaCartorio.setHistorico(contraPartidaCartorio.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaCartorio);
        }
        if (valorIr > 0.0) {
            ContraPartMovimentoBancario contraPartidaIR = new ContraPartMovimentoBancario();
            contraPartidaIR.setPlanoConta(baixa.getContasBaixa().getPlanoContaIR());
            contraPartidaIR.setDebCred(Short.valueOf((short)1));
            contraPartidaIR.setBuscaTitulos(Short.valueOf((short)0));
            contraPartidaIR.setValor(valorIr);
            contraPartidaIR.setHistorico("Valor IR sobre Titulos " + historico);
            if (contraPartidaIR.getHistorico().length() > 500) {
                contraPartidaIR.setHistorico(contraPartidaIR.getHistorico().substring(0, 500));
            }
            listaContraPartida.add(contraPartidaIR);
        }
        return listaContraPartida;
    }

    public static List gerarContraPartidas(GrupoDeBaixaFormas grupoFormas, Short pagRec, Empresa empresaLogada) {
        ArrayList<ContraPartMovimentoBancario> contraPartidas = new ArrayList<ContraPartMovimentoBancario>();
        if (pagRec == 0) {
            for (Object o : grupoFormas.getBaixaTitulo()) {
                BaixaTitulo b = (BaixaTitulo)o;
                List<ContraPartMovimentoBancario> contras = UtilityFinanceiro.gerarContraPartidaInstituicaoPagNaoAgrup(grupoFormas.getGrupoDeBaixa(), b.getValor(), b.getVrJuros(), b.getVrDesconto(), b.getVrAtualizacaoMonetariaRecebida(), b.getVrAtualizacaoMonetariaPaga(), b.getVrDespBancariaPaga(), b.getVrDespBancariaRecebida(), b.getVrMulta(), b.getVrPis(), b.getVrConfins(), b.getVrContribSocial(), grupoFormas.getContaValor(), b.getTitulo().getIdentificador().toString(), b, b.getVrAbatimento(), b.getVrIOFPago(), b.getVrIOFRecebido(), b.getVrDespesaCartorioPaga(), b.getVrDespesaCartorioRecebida(), b.getVrIR());
                if (contras == null || contras.isEmpty()) continue;
                Iterator<ContraPartMovimentoBancario> iterator = contras.iterator();
                while (iterator.hasNext()) {
                    ContraPartMovimentoBancario ob;
                    ContraPartMovimentoBancario c = ob = iterator.next();
                    contraPartidas.add(c);
                }
            }
        } else {
            for (Object o : grupoFormas.getBaixaTitulo()) {
                BaixaTitulo b = (BaixaTitulo)o;
                List<ContraPartMovimentoBancario> contras = UtilityFinanceiro.gerarContraPartidaInstituicaoRecNaoAgrup(grupoFormas.getGrupoDeBaixa(), b.getValor(), b.getVrJuros(), b.getVrDesconto(), b.getVrAtualizacaoMonetariaRecebida(), b.getVrAtualizacaoMonetariaPaga(), b.getVrDespBancariaPaga(), b.getVrDespBancariaRecebida(), b.getVrMulta(), b.getVrPis(), b.getVrConfins(), b.getVrContribSocial(), grupoFormas.getContaValor(), b.getTitulo().getIdentificador().toString(), b, b.getVrAbatimento(), b.getVrIOFPago(), b.getVrIOFRecebido(), b.getVrDespesaCartorioPaga(), b.getVrDespesaCartorioRecebida(), b.getVrIR(), b.getVrTaxaCartao());
                if (contras == null || contras.isEmpty()) continue;
                Iterator<ContraPartMovimentoBancario> iterator = contras.iterator();
                while (iterator.hasNext()) {
                    ContraPartMovimentoBancario ob;
                    ContraPartMovimentoBancario c = ob = iterator.next();
                    contraPartidas.add(c);
                }
            }
        }
        return contraPartidas;
    }

    public static LancamentoCtbGerencial getLancamentoCtbGerencial(PlanoContaGerencial planoContaGerencial, short debCred, Empresa empresa, String historico, Double valor, CentroCusto centroCusto, GrupoDeBaixa grupodeBaixa) {
        LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, grupodeBaixa.getDataLiquidacao(), grupodeBaixa.getDataLiquidacao(), Short.valueOf(debCred), empresa, Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()), historico != null && historico.length() > 200 ? historico.substring(0, 200) : historico, planoContaGerencial, Short.valueOf(EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue()), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO.getValue()), centroCusto, valor, null);
        return l;
    }

    public static Boolean habilitaNumeroDiasProtestoBancos(int codigoDaOcorrenciaCobranca, InstituicaoValores instituicaoValor) {
        if (instituicaoValor.getNrBanco().equals("001")) {
            return UtilityFinanceiro.habilitaNumeroDiasProtestoBB(codigoDaOcorrenciaCobranca);
        }
        if (instituicaoValor.getNrBanco().equals("237")) {
            return UtilityFinanceiro.habilitaNumeroDiasProtestoBradesco(codigoDaOcorrenciaCobranca);
        }
        if (instituicaoValor.getNrBanco().equals("341")) {
            return UtilityFinanceiro.habilitaNumeroDiasProtesteItau(codigoDaOcorrenciaCobranca);
        }
        if (instituicaoValor.getNrBanco().equals("756")) {
            return false;
        }
        if (instituicaoValor.getNrBanco().equals("389")) {
            return false;
        }
        if (instituicaoValor.getNrBanco().equals("999")) {
            return false;
        }
        if (instituicaoValor.getNrBanco().equals("033")) {
            return false;
        }
        if (instituicaoValor.getNrBanco().equals("104")) {
            return true;
        }
        return false;
    }

    public static boolean habilitaNumeroDiasProtesteItau(Integer codigo) {
        switch (codigo) {
            case 9: {
                return true;
            }
            case 34: {
                return true;
            }
            case 35: {
                return true;
            }
            case 81: {
                return true;
            }
            case 82: {
                return true;
            }
            case 91: {
                return true;
            }
            case 92: {
                return true;
            }
        }
        return false;
    }

    public static OcorrenciaRetornoCnab findOcorrenciaCobranca(LayoutCobranca layoutCobranca, String codigo) {
        Session s = CoreBdUtil.getInstance().getSession();
        Criteria c = s.createCriteria(OcorrenciaRetornoCnab.class);
        c.add((Criterion)Restrictions.eq((String)"codigo", (Object)codigo));
        c.add((Criterion)Restrictions.eq((String)"layoutCobranca", (Object)layoutCobranca));
        return (OcorrenciaRetornoCnab)c.uniqueResult();
    }

    private static Boolean habilitaNumeroDiasProtestoBB(Integer codigoDaOcorrenciaCobranca) {
        if (codigoDaOcorrenciaCobranca.toString().equals("6")) {
            return true;
        }
        return false;
    }

    private static Boolean habilitaNumeroDiasProtestoBradesco(Integer codigoDaOcorrenciaCobranca) {
        if (codigoDaOcorrenciaCobranca.toString().equals("6") || codigoDaOcorrenciaCobranca.toString().equals("5") || codigoDaOcorrenciaCobranca.toString().equals("18")) {
            return true;
        }
        return false;
    }

    private static Date getDataVencimentoDiasNaoUteis(Date dataConpensacao, Empresa empresa) {
        Date data = dataConpensacao;
        Integer diaSemana = ToolDate.diaDaSemana((Date)dataConpensacao);
        if (diaSemana.equals(7)) {
            data = ToolDate.nextDays((Date)data, (int)1);
            diaSemana = 1;
        }
        if (diaSemana.equals(1)) {
            data = ToolDate.nextDays((Date)data, (int)1);
        }
        if (UtilityFinanceiro.existeFeriado(data, empresa).booleanValue()) {
            diaSemana = ToolDate.diaDaSemana((Date)(data = ToolDate.nextDays((Date)data, (int)1)));
            if (diaSemana.equals(7)) {
                data = ToolDate.nextDays((Date)data, (int)1);
                diaSemana = 1;
            }
            if (diaSemana.equals(1)) {
                data = ToolDate.nextDays((Date)data, (int)1);
            }
        }
        return data;
    }

    private static Boolean existeFeriado(Date data, Empresa empresa) {
        ServiceFeriadoImpl serviceFeriado = (ServiceFeriadoImpl)ConfApplicationContext.getBean(ServiceFeriadoImpl.class);
        return serviceFeriado.isFeriado(data, empresa);
    }
}

