/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.utility;

import com.touchcomp.basementor.constants.enums.baixatitulo.EnumConstTipoBaixaTitulos;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaFinanceiro;
import com.touchcomp.basementor.model.vo.GrupoDeBaixa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixaFormas;
import com.touchcomp.basementor.model.vo.ItemRemessaCnabPagamento;
import com.touchcomp.basementor.model.vo.ItemRetornoCnab;
import com.touchcomp.basementor.model.vo.LogTituloCnab;
import com.touchcomp.basementor.model.vo.OpcoesContabeisBaixaTitulos;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementor.model.vo.RemessaCnabPagamento;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorservice.helpers.impl.baixatitulos.HelperBaixaTitulos;
import com.touchcomp.basementorservice.helpers.impl.grupodebaixa.HelperGrupoDeBaixa;
import com.touchcomp.basementorservice.service.impl.opcoescontabeisbaixatitulos.ServiceOpcoesContabeisBaixaTitulosImpl;
import com.touchcomp.basementorspringcontext.Context;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.exceptions.ExceptionValidation;
import mentorcore.service.impl.financeiro.cnabnovo.exceptions.ExceptionCnab;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RemessaPagamentoCnabInterface;
import mentorcore.service.impl.financeiro.cnabnovo.model.RetornoPagamentoCnab;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;
import mentorcore.service.impl.financeiro.utility.UtilityFinanceiro;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.CoreUtilityFactory;

public class UtilityPagamentoCnab {
    private static ServiceOpcoesContabeisBaixaTitulosImpl serviceOpcoesContabeisBaixaTitulosImpl = (ServiceOpcoesContabeisBaixaTitulosImpl)Context.get(ServiceOpcoesContabeisBaixaTitulosImpl.class);

    public static void updateRetornoPagamentoCnab(List<RetornoPagamentoCnab> listRetorno) throws ExceptionService, ExceptionCnab {
        for (RetornoPagamentoCnab retornoPagamentoCnab : listRetorno) {
            if (retornoPagamentoCnab.getTipoRegistro().equals("3")) {
                Titulo titulo = UtilityArquivoCnab.buscarTituloPagamento(retornoPagamentoCnab.getNrTitulo());
                if (titulo != null) {
                    if (UtilityPagamentoCnab.getTituloAceito(titulo, retornoPagamentoCnab) && retornoPagamentoCnab.getCodOcorrencia1().equals("00")) {
                        retornoPagamentoCnab.setStatus(1);
                        continue;
                    }
                    retornoPagamentoCnab.setStatus(0);
                    continue;
                }
                retornoPagamentoCnab.setStatus(2);
                continue;
            }
            UtilityPagamentoCnab.setStatusLote(retornoPagamentoCnab);
        }
    }

    private static boolean getTituloAceito(Titulo titulo, RetornoPagamentoCnab retornoPagamentoCnab) throws ExceptionService {
        Double saldoTitulo = UtilityArquivoCnab.findSaldoTitulo(titulo);
        if (retornoPagamentoCnab.getValorBaixa() > saldoTitulo && retornoPagamentoCnab.getCodOcorrencia1().equals("00")) {
            throw new ExceptionService("O valor pago do T\u00edtulo: " + titulo.getIdentificador().toString() + " \u00e9 superior ao seu saldo!\nValor pago : " + retornoPagamentoCnab.getValorBaixa().toString() + "\nValor Saldo: " + saldoTitulo.toString());
        }
        String codOcorrencia1 = retornoPagamentoCnab.getCodOcorrencia1();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty() && UtilityArquivoCnab.verificarSeTituloPodeSerBaixadoPeloCodOcorrenciaRetornoPagamento(codOcorrencia1)) {
            return Boolean.TRUE;
        }
        String codOcorrencia2 = retornoPagamentoCnab.getCodOcorrencia2();
        if (codOcorrencia2 != null && !codOcorrencia2.isEmpty() && UtilityArquivoCnab.verificarSeTituloPodeSerBaixadoPeloCodOcorrenciaRetornoPagamento(codOcorrencia2)) {
            return Boolean.TRUE;
        }
        String codOcorrencia3 = retornoPagamentoCnab.getCodOcorrencia3();
        if (codOcorrencia3 != null && !codOcorrencia3.isEmpty() && UtilityArquivoCnab.verificarSeTituloPodeSerBaixadoPeloCodOcorrenciaRetornoPagamento(codOcorrencia3)) {
            return Boolean.TRUE;
        }
        String codOcorrencia4 = retornoPagamentoCnab.getCodOcorrencia4();
        if (codOcorrencia4 != null && !codOcorrencia4.isEmpty() && UtilityArquivoCnab.verificarSeTituloPodeSerBaixadoPeloCodOcorrenciaRetornoPagamento(codOcorrencia4)) {
            return Boolean.TRUE;
        }
        String codOcorrencia5 = retornoPagamentoCnab.getCodOcorrencia5();
        if (codOcorrencia5 != null && !codOcorrencia5.isEmpty() && UtilityArquivoCnab.verificarSeTituloPodeSerBaixadoPeloCodOcorrenciaRetornoPagamento(codOcorrencia5)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static HashMap getRetornoPagamento(List<RetornoPagamentoCnab> listRetorno, Empresa empresa, Short agruparBaixas, Date dataBaixa, Double valorTolerancia, EmpresaFinanceiro empresaFinanceiro, OpcoesGerenciais opGer) throws ExceptionService, Exception {
        HashMap<String, Object> retornoPagamento = new HashMap<String, Object>();
        ArrayList<Titulo> naoBaixar = new ArrayList<Titulo>();
        ArrayList<CallSite> naoMentor = new ArrayList<CallSite>();
        ArrayList<BaixaTitulo> baixas = new ArrayList<BaixaTitulo>();
        GrupoDeBaixa grupoBaixa = null;
        ArrayList<ContaValores> contas = new ArrayList<ContaValores>();
        for (RetornoPagamentoCnab ret : listRetorno) {
            switch (ret.getTipoRegistro()) {
                case "1": {
                    UtilityPagamentoCnab.verificaOcorrenciasLote(ret, listRetorno);
                    break;
                }
                case "5": {
                    UtilityPagamentoCnab.verificaOcorrenciasLote(ret, listRetorno);
                }
            }
        }
        ArrayList<ItemRetornoCnab> itensRetorno = new ArrayList<ItemRetornoCnab>();
        block14: for (RetornoPagamentoCnab retornoPagamentoCnab : listRetorno) {
            if (!retornoPagamentoCnab.getTipoRegistro().equals("3")) continue;
            Titulo titulo = UtilityArquivoCnab.buscarTituloPagamento(retornoPagamentoCnab.getNrTitulo());
            retornoPagamentoCnab.setTitulo(titulo);
            if (titulo != null) {
                switch (retornoPagamentoCnab.getStatus()) {
                    case 0: {
                        naoBaixar.add(titulo);
                        itensRetorno.add(UtilityPagamentoCnab.createInfComplementaresItensRetorno(retornoPagamentoCnab, titulo));
                        continue block14;
                    }
                    case 2: {
                        naoMentor.add((CallSite)((Object)("O n\u00famero " + retornoPagamentoCnab.getNrTitulo() + " n\u00e3o corresponde a um T\u00edtulo gerado pelo Sistema Mentor ou Pagamento foi inserido no Banco de forma manual. ")));
                        continue block14;
                    }
                    case 1: {
                        baixas.add(UtilityPagamentoCnab.createBaixaTitulo(retornoPagamentoCnab, titulo, empresaFinanceiro, empresa, opGer));
                        itensRetorno.add(UtilityPagamentoCnab.createInfComplementaresItensRetorno(retornoPagamentoCnab, titulo));
                        if (contas.contains(titulo.getCarteiraCobranca().getContaValor())) continue block14;
                        contas.add(titulo.getCarteiraCobranca().getContaValor());
                        continue block14;
                    }
                }
                throw new ExceptionService("Titulo sem status. Favor entrar em contato com o suporte t\u00e9cnico.");
            }
            naoMentor.add((CallSite)((Object)("O n\u00famero " + retornoPagamentoCnab.getNrTitulo() + " n\u00e3o corresponde a um T\u00edtulo gerado pelo Sistema Mentor ou Pagamento foi inserido no Banco de forma manual. ")));
        }
        if (baixas != null && !baixas.isEmpty() && (grupoBaixa = UtilityPagamentoCnab.createGrupoDeBaixa(baixas, empresa, agruparBaixas, dataBaixa)) != null) {
            new HelperGrupoDeBaixa(grupoBaixa).setLancamentoPisCofins();
            for (GrupoDeBaixaFormas gbf : grupoBaixa.getGrupoDeBaixaFormas()) {
                UtilityFinanceiro.gerarMovimentosBancarios(gbf, empresa, valorTolerancia);
                CoreUtilityFactory.getUtilityLancamentosGerenciais().criarLancamentosCTBGerencialLiquidacao(gbf);
            }
        }
        retornoPagamento.put("GRUPO_BAIXA", grupoBaixa);
        retornoPagamento.put("NAO_MENTOR", naoMentor);
        retornoPagamento.put("NAO_BAIXAR", naoBaixar);
        retornoPagamento.put("INF_COMPLEMENTARES", itensRetorno);
        retornoPagamento.put("LIST_RETORNOS", listRetorno);
        retornoPagamento.put("CONTAS_VALORES", contas);
        return retornoPagamento;
    }

    private static void setLogsIntoTitulo(RetornoPagamentoCnab retornoPagamentoCnab, Titulo titulo) {
        LogTituloCnab logTitulo;
        ArrayList<LogTituloCnab> logs = new ArrayList<LogTituloCnab>();
        if (retornoPagamentoCnab.getCodOcorrencia1() != null && !retornoPagamentoCnab.getCodOcorrencia1().isEmpty()) {
            logTitulo = new LogTituloCnab();
            logTitulo.setCodOcorrencia(retornoPagamentoCnab.getCodOcorrencia1());
            logTitulo.setMotivoOcorrencia(retornoPagamentoCnab.getMsgOcorrencia1());
            logTitulo.setDataCadastro(new Date());
            logTitulo.setTitulo(titulo);
            logs.add(logTitulo);
        }
        if (retornoPagamentoCnab.getCodOcorrencia2() != null && !retornoPagamentoCnab.getCodOcorrencia2().isEmpty()) {
            logTitulo = new LogTituloCnab();
            logTitulo.setCodOcorrencia(retornoPagamentoCnab.getCodOcorrencia2());
            logTitulo.setMotivoOcorrencia(retornoPagamentoCnab.getMsgOcorrencia2());
            logTitulo.setDataCadastro(new Date());
            logTitulo.setTitulo(titulo);
            logs.add(logTitulo);
        }
        if (retornoPagamentoCnab.getCodOcorrencia3() != null && !retornoPagamentoCnab.getCodOcorrencia3().isEmpty()) {
            logTitulo = new LogTituloCnab();
            logTitulo.setCodOcorrencia(retornoPagamentoCnab.getCodOcorrencia3());
            logTitulo.setMotivoOcorrencia(retornoPagamentoCnab.getMsgOcorrencia3());
            logTitulo.setDataCadastro(new Date());
            logTitulo.setTitulo(titulo);
            logs.add(logTitulo);
        }
        if (retornoPagamentoCnab.getCodOcorrencia4() != null && !retornoPagamentoCnab.getCodOcorrencia4().isEmpty()) {
            logTitulo = new LogTituloCnab();
            logTitulo.setCodOcorrencia(retornoPagamentoCnab.getCodOcorrencia4());
            logTitulo.setMotivoOcorrencia(retornoPagamentoCnab.getMsgOcorrencia4());
            logTitulo.setDataCadastro(new Date());
            logTitulo.setTitulo(titulo);
            logs.add(logTitulo);
        }
        if (retornoPagamentoCnab.getCodOcorrencia5() != null && !retornoPagamentoCnab.getCodOcorrencia5().isEmpty()) {
            logTitulo = new LogTituloCnab();
            logTitulo.setCodOcorrencia(retornoPagamentoCnab.getCodOcorrencia5());
            logTitulo.setMotivoOcorrencia(retornoPagamentoCnab.getMsgOcorrencia5());
            logTitulo.setDataCadastro(new Date());
            logTitulo.setTitulo(titulo);
            logs.add(logTitulo);
        }
        if (titulo.getLogTituloCnab() == null) {
            titulo.setLogTituloCnab(logs);
        } else {
            titulo.getLogTituloCnab().addAll(logs);
        }
    }

    private static BaixaTitulo createBaixaTitulo(RetornoPagamentoCnab retornoPagamentoCnab, Titulo titulo, EmpresaFinanceiro empresaFinanceiro, Empresa empresa, OpcoesGerenciais opGer) throws Exception {
        Double valorBaixa = retornoPagamentoCnab.getValorBaixa();
        if (valorBaixa <= 0.0) {
            valorBaixa = titulo.getValor();
        }
        OpcoesContabeisBaixaTitulos opcoesContabeisBaixaTitulos = serviceOpcoesContabeisBaixaTitulosImpl.findOpcaoContabilBaixaTituloComFormaPagCache(titulo.getPagRec(), titulo.getTipoDoc(), titulo.getClassificacaoPessoa(), Short.valueOf((short)1), titulo.getEmpresa());
        HelperBaixaTitulos helper = (HelperBaixaTitulos)Context.get(HelperBaixaTitulos.class);
        BaixaTitulo baixa = helper.novaBaixaTitulosRetornoCNAB(titulo, opcoesContabeisBaixaTitulos, EnumConstTipoBaixaTitulos.BAIXA_TITULOS_ORIG_CNAB, valorBaixa, empresaFinanceiro, empresa, opGer);
        baixa.setSaldoBaixa(valorBaixa);
        return baixa;
    }

    private static GrupoDeBaixa createGrupoDeBaixa(List<BaixaTitulo> baixas, Empresa empresa, Short agruparBaixas, Date dataBaixa) {
        GrupoDeBaixa grupo = new GrupoDeBaixa();
        grupo.setPagRec(Short.valueOf((short)0));
        grupo.setDataCadastro(new Date());
        grupo.setEmpresa(empresa);
        grupo.setDataLiquidacao(dataBaixa);
        grupo.setDataAtualizacao(DateUtil.toTimestamp(new Date()));
        GrupoDeBaixaFormas grupoFormas = new GrupoDeBaixaFormas();
        grupoFormas.setFormaPagamento(Short.valueOf((short)1));
        grupoFormas.setBaixaTitulo(baixas);
        grupoFormas.setAgrupamento(agruparBaixas);
        grupoFormas.setGrupoDeBaixa(grupo);
        grupoFormas.setContaValor(null);
        UtilityPagamentoCnab.setGrupoIntoBaixas(baixas, grupoFormas);
        grupo.setGrupoDeBaixaFormas(Arrays.asList(grupoFormas));
        return grupo;
    }

    private static void setGrupoIntoBaixas(List<BaixaTitulo> baixas, GrupoDeBaixaFormas grupoFormas) {
        for (BaixaTitulo baixaTitulo : baixas) {
            baixaTitulo.setGrupoDeBaixaFormas(grupoFormas);
        }
    }

    private static void setStatusLote(RetornoPagamentoCnab retornoPagamentoCnab) throws ExceptionCnab {
        String codOcorrencia1 = retornoPagamentoCnab.getCodOcorrencia1();
        String codOcorrencia2 = retornoPagamentoCnab.getCodOcorrencia2();
        String codOcorrencia3 = retornoPagamentoCnab.getCodOcorrencia3();
        String codOcorrencia4 = retornoPagamentoCnab.getCodOcorrencia4();
        String codOcorrencia5 = retornoPagamentoCnab.getCodOcorrencia5();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty() && UtilityArquivoCnab.verificarSeTituloPodeSerBaixadoPeloCodOcorrenciaRetornoPagamento(codOcorrencia1) == Boolean.FALSE) {
            retornoPagamentoCnab.setStatus(4);
        }
        if (codOcorrencia2 != null && !codOcorrencia2.isEmpty() && UtilityArquivoCnab.verificarSeTituloPodeSerBaixadoPeloCodOcorrenciaRetornoPagamento(codOcorrencia2) == Boolean.FALSE) {
            retornoPagamentoCnab.setStatus(4);
        }
        if (codOcorrencia3 != null && !codOcorrencia3.isEmpty() && UtilityArquivoCnab.verificarSeTituloPodeSerBaixadoPeloCodOcorrenciaRetornoPagamento(codOcorrencia3) == Boolean.FALSE) {
            retornoPagamentoCnab.setStatus(4);
        }
        if (codOcorrencia4 != null && !codOcorrencia4.isEmpty() && UtilityArquivoCnab.verificarSeTituloPodeSerBaixadoPeloCodOcorrenciaRetornoPagamento(codOcorrencia4) == Boolean.FALSE) {
            retornoPagamentoCnab.setStatus(4);
        }
        if (codOcorrencia5 != null && !codOcorrencia5.isEmpty() && UtilityArquivoCnab.verificarSeTituloPodeSerBaixadoPeloCodOcorrenciaRetornoPagamento(codOcorrencia5) == Boolean.FALSE) {
            retornoPagamentoCnab.setStatus(4);
        }
    }

    public static void gerarArquivoRemessaPagamento240(File file, String numeroBanco, RemessaPagamentoCnabInterface pagamento, RemessaCnabPagamento remessaPagamento, String codificacaoArquivo) throws ExceptionService, ExceptionValidation, IOException {
        List<HashMap> listTiposServicos = UtilityPagamentoCnab.getTipoServicos(UtilityPagamentoCnab.getListOrderByTipoServico(remessaPagamento.getItemRemessaPagamento()));
        List<HashMap> list = UtilityPagamentoCnab.agruparTitulosConformeTipoServico(listTiposServicos, remessaPagamento.getItemRemessaPagamento());
        ConfiguracaoCnab configuracaoCnab = UtilityPagamentoCnab.getConfiguracaoCnab(remessaPagamento);
        if (configuracaoCnab == null) {
            throw new ExceptionService("Nenhum T\u00edtulo que comp\u00f5e a Remessa Possui Configura\u00e7\u00e3o CNAB. Contate o Suporte Tecnico!");
        }
        pagamento.dataValidationBeforeGetStarted(remessaPagamento);
        pagamento.createFile(file, ".txt", remessaPagamento.getNumeroSequenciaArquivo());
        pagamento.buildHeaderFile(remessaPagamento, configuracaoCnab, codificacaoArquivo);
        for (HashMap hs : list) {
            List listItensRemessa = (List)hs.get("LIST");
            RemessaCnabPagamento newRemessaPagamento = UtilityPagamentoCnab.cloneRemessaPagamento(remessaPagamento, listItensRemessa);
            UtilityPagamentoCnab.writeBuildLoteAndDetailArquivo(pagamento, newRemessaPagamento, listItensRemessa, configuracaoCnab, codificacaoArquivo);
        }
        pagamento.buildTrailerFile(codificacaoArquivo);
        pagamento.validationBeforePrint();
    }

    public static void gerarArquivoRemessaPagamento400(File file, String numeroBanco, RemessaPagamentoCnabInterface pagamento, RemessaCnabPagamento remessaPagamento, String codificacaoArquivo) throws ExceptionService, ExceptionValidation, IOException {
        List<HashMap> listTiposServicos = UtilityPagamentoCnab.getTipoServicos(UtilityPagamentoCnab.getListOrderByTipoServico(remessaPagamento.getItemRemessaPagamento()));
        List<HashMap> list = UtilityPagamentoCnab.agruparTitulosConformeTipoServico(listTiposServicos, remessaPagamento.getItemRemessaPagamento());
        ConfiguracaoCnab configuracaoCnab = UtilityPagamentoCnab.getConfiguracaoCnab(remessaPagamento);
        if (configuracaoCnab == null) {
            throw new ExceptionService("Nenhum T\u00edtulo que comp\u00f5e a Remessa Possui Configura\u00e7\u00e3o CNAB. Contate o Suporte Tecnico!");
        }
        pagamento.dataValidationBeforeGetStarted(remessaPagamento);
        pagamento.createFile(file, ".txt", remessaPagamento.getNumeroSequenciaArquivo());
        pagamento.resetCounter();
        pagamento.resetValorTotal();
        pagamento.buildHeaderFile(remessaPagamento, configuracaoCnab, codificacaoArquivo);
        pagamento.buildDetail(remessaPagamento, configuracaoCnab, codificacaoArquivo);
        pagamento.buildTrailerFile(codificacaoArquivo);
        pagamento.validationBeforePrint();
    }

    private static RemessaCnabPagamento cloneRemessaPagamento(RemessaCnabPagamento remessa, List<ItemRemessaCnabPagamento> itensBorderoPag) {
        RemessaCnabPagamento newRemessa = new RemessaCnabPagamento();
        newRemessa.setDataAtualizacao(remessa.getDataAtualizacao());
        newRemessa.setDataCadastro(remessa.getDataCadastro());
        newRemessa.setEmpresa(remessa.getEmpresa());
        newRemessa.setHoraGeracao(remessa.getHoraGeracao());
        newRemessa.setIdentificador(remessa.getIdentificador());
        newRemessa.setInstituicaoValores(remessa.getInstituicaoValores());
        newRemessa.setItemRemessaPagamento(itensBorderoPag);
        newRemessa.setNumeroSequenciaArquivo(remessa.getNumeroSequenciaArquivo());
        newRemessa.setTipoRemessa(remessa.getTipoRemessa());
        return newRemessa;
    }

    private static void verificaOcorrenciasLote(RetornoPagamentoCnab ret, List<RetornoPagamentoCnab> listRetorno) throws ExceptionService {
        if (ret.getStatus() != null && ret.getStatus().equals(4)) {
            for (RetornoPagamentoCnab r : listRetorno) {
                if (!r.getTipoRegistro().equals("3") || !r.getLoteServico().equals(ret.getLoteServico())) continue;
                Titulo titulo = UtilityArquivoCnab.buscarTituloPagamento(r.getNrTitulo());
                UtilityPagamentoCnab.setLogsIntoTitulo(ret, titulo);
                r.setStatus(0);
            }
        }
    }

    private static List<ItemRemessaCnabPagamento> getListOrderByTipoServico(List<ItemRemessaCnabPagamento> list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                ItemRemessaCnabPagamento item1 = (ItemRemessaCnabPagamento)o1;
                ItemRemessaCnabPagamento item2 = (ItemRemessaCnabPagamento)o2;
                if (item1.getItemBordero().getFormaLancamento().getTipoServico().getCodigo() != null && item2.getItemBordero().getFormaLancamento().getTipoServico().getCodigo() != null) {
                    String vlr1 = item1.getItemBordero().getFormaLancamento().getTipoServico().getCodigo();
                    String vlr2 = item2.getItemBordero().getFormaLancamento().getTipoServico().getCodigo();
                    return vlr1.compareTo(vlr2);
                }
                return 0;
            }
        });
        return list;
    }

    private static void writeBuildLoteAndDetailArquivo(RemessaPagamentoCnabInterface pagamento, RemessaCnabPagamento remessaPagamento, List<ItemRemessaCnabPagamento> itensRemessa, ConfiguracaoCnab configuracaoCnab, String codificacaoArquivo) throws IOException, ExceptionService {
        pagamento.resetCounter();
        pagamento.resetValorTotal();
        pagamento.buildHeaderPackage(remessaPagamento, itensRemessa.get(0), configuracaoCnab, codificacaoArquivo);
        pagamento.buildDetail(remessaPagamento, configuracaoCnab, codificacaoArquivo);
        pagamento.buildTrailerPackge(remessaPagamento, itensRemessa.get(0), codificacaoArquivo);
    }

    private static List<HashMap> getTipoServicos(List<ItemRemessaCnabPagamento> itemRemessa) {
        ArrayList<HashMap> tipoServicos = new ArrayList<HashMap>();
        for (ItemRemessaCnabPagamento it : itemRemessa) {
            HashMap<String, String> h = new HashMap<String, String>();
            h.put("FORMA_LANCAMENTO", it.getItemBordero().getFormaLancamento().getCodigo());
            h.put("TIPO_SERVICO", it.getItemBordero().getFormaLancamento().getTipoServico().getCodigo());
            if (tipoServicos.contains(h)) continue;
            tipoServicos.add(h);
        }
        return tipoServicos;
    }

    private static List<HashMap> agruparTitulosConformeTipoServico(List<HashMap> listTiposServicos, List<ItemRemessaCnabPagamento> titulosCompoeRemessa) {
        ArrayList<HashMap> aux = new ArrayList<HashMap>();
        for (HashMap hash : listTiposServicos) {
            HashMap hs = new HashMap();
            ArrayList<ItemRemessaCnabPagamento> listTitulos = new ArrayList<ItemRemessaCnabPagamento>();
            for (ItemRemessaCnabPagamento item : titulosCompoeRemessa) {
                if (!hash.get("TIPO_SERVICO").equals(item.getItemBordero().getFormaLancamento().getTipoServico().getCodigo()) || !hash.get("FORMA_LANCAMENTO").equals(item.getItemBordero().getFormaLancamento().getCodigo())) continue;
                listTitulos.add(item);
            }
            hs.put("CODIGO_TIPO_SERVICO", hash.get("TIPO_SERVICO"));
            hs.put("CODIGO_FORMA_LANCAMENTO", hash.get("FORMA_LANCAMENTO"));
            hs.put("LIST", listTitulos);
            aux.add(hs);
        }
        return aux;
    }

    private static ConfiguracaoCnab getConfiguracaoCnab(RemessaCnabPagamento remessa) {
        for (ItemRemessaCnabPagamento item : remessa.getItemRemessaPagamento()) {
            if (item.getItemBordero().getItemLiberacao().getTitulo().getConfiguracaoCnab() == null) continue;
            return item.getItemBordero().getItemLiberacao().getTitulo().getConfiguracaoCnab();
        }
        return null;
    }

    private static ItemRetornoCnab createInfComplementaresItensRetorno(RetornoPagamentoCnab r, Titulo titulo) {
        ItemRetornoCnab item = new ItemRetornoCnab();
        item.setDataOcorrencia(r.getDataOcorrencia());
        item.setDataPagamento(r.getDataPagamento());
        item.setNrSequencialRegistro(r.getNrSequencialRegistro());
        item.setNumeroCartorio(r.getNumeroCartorio());
        item.setNumeroProtocolo(r.getNumeroProtocolo());
        item.setTitulo(titulo);
        item.setValorAbatimento(Double.valueOf(0.0));
        item.setValorIOF(Double.valueOf(0.0));
        item.setNossoNumero(r.getNrNossoNumero());
        return item;
    }

    public static void setLogsIntoTituloPagamento(List<RetornoPagamentoCnab> listRetorno) {
        for (RetornoPagamentoCnab r : listRetorno) {
            LogTituloCnab logTitulo;
            Date dataOcorrencia;
            ArrayList<LogTituloCnab> logs = new ArrayList<LogTituloCnab>();
            Titulo titulo = r.getTitulo();
            Date date = dataOcorrencia = r.getDataOcorrencia() != null ? r.getDataOcorrencia() : new Date();
            if (titulo == null) continue;
            if (r.getCodOcorrencia1() != null && !r.getCodOcorrencia1().isEmpty()) {
                logTitulo = new LogTituloCnab();
                logTitulo.setCodOcorrencia(r.getCodOcorrencia1());
                logTitulo.setMotivoOcorrencia(r.getMsgOcorrencia1());
                logTitulo.setDataCadastro(dataOcorrencia);
                logTitulo.setTitulo(titulo);
                logs.add(logTitulo);
            }
            if (r.getCodOcorrencia2() != null && !r.getCodOcorrencia2().isEmpty()) {
                logTitulo = new LogTituloCnab();
                logTitulo.setCodOcorrencia(r.getCodOcorrencia2());
                logTitulo.setMotivoOcorrencia(r.getMsgOcorrencia2());
                logTitulo.setDataCadastro(dataOcorrencia);
                logTitulo.setTitulo(titulo);
                logs.add(logTitulo);
            }
            if (r.getCodOcorrencia3() != null && !r.getCodOcorrencia3().isEmpty()) {
                logTitulo = new LogTituloCnab();
                logTitulo.setCodOcorrencia(r.getCodOcorrencia3());
                logTitulo.setMotivoOcorrencia(r.getMsgOcorrencia3());
                logTitulo.setDataCadastro(dataOcorrencia);
                logTitulo.setTitulo(titulo);
                logs.add(logTitulo);
            }
            if (r.getCodOcorrencia4() != null && !r.getCodOcorrencia4().isEmpty()) {
                logTitulo = new LogTituloCnab();
                logTitulo.setCodOcorrencia(r.getCodOcorrencia4());
                logTitulo.setMotivoOcorrencia(r.getMsgOcorrencia4());
                logTitulo.setDataCadastro(dataOcorrencia);
                logTitulo.setTitulo(titulo);
                logs.add(logTitulo);
            }
            if (r.getCodOcorrencia5() != null && !r.getCodOcorrencia5().isEmpty()) {
                logTitulo = new LogTituloCnab();
                logTitulo.setCodOcorrencia(r.getCodOcorrencia5());
                logTitulo.setMotivoOcorrencia(r.getMsgOcorrencia5());
                logTitulo.setDataCadastro(dataOcorrencia);
                logTitulo.setTitulo(titulo);
                logs.add(logTitulo);
            }
            if (titulo == null) continue;
            if (titulo.getLogTituloCnab() == null || titulo.getLogTituloCnab().isEmpty()) {
                titulo.setLogTituloCnab(logs);
                continue;
            }
            ArrayList<LogTituloCnab> novosLogs = new ArrayList<LogTituloCnab>();
            for (LogTituloCnab l1 : titulo.getLogTituloCnab()) {
                for (LogTituloCnab l2 : logs) {
                    if (!l1.getCodOcorrencia().equalsIgnoreCase(l2.getCodOcorrencia()) && !l1.getDataCadastro().equals(l2.getDataCadastro())) {
                        novosLogs.add(l2);
                        continue;
                    }
                    novosLogs.remove(l2);
                }
            }
            titulo.getLogTituloCnab().addAll(novosLogs);
        }
    }
}

