/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.utility;

import com.touchcomp.basementor.constants.enums.baixatitulo.EnumConstTipoBaixaTitulos;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.EmpresaFinanceiro;
import com.touchcomp.basementor.model.vo.GrupoDeBaixa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixaFormas;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.ItemRetornoCnab;
import com.touchcomp.basementor.model.vo.LogTituloCnab;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementor.model.vo.RetornoCnabCobrancaObservacao;
import com.touchcomp.basementor.model.vo.RetornoCnabCobrancaTitulosAntNaoGerado;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorservice.helpers.impl.baixatitulos.HelperBaixaTitulos;
import com.touchcomp.basementorservice.helpers.impl.grupodebaixa.HelperGrupoDeBaixa;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import contatocore.util.ContatoDateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.financeiro.cnabnovo.model.RetornoRecebimentoCnab;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;
import mentorcore.tools.ContatoFormatUtil;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.CoreUtilityFactory;
import mentorcore.utilities.impl.titulos.UtilityTitulos;

public class UtilityRecebimentoCnab {
    public static BaixaTitulo createBaixaTitulo(RetornoRecebimentoCnab retornoRecebimentoCnab240, Titulo titulo, EmpresaFinanceiro empresaFinanceiro, Empresa empresa, OpcoesGerenciais opGer) throws Exception {
        HelperBaixaTitulos helper = (HelperBaixaTitulos)Context.get(HelperBaixaTitulos.class);
        Double valorTarifaCobranca = retornoRecebimentoCnab240.getValorTarifaCobranca();
        Double valorMulta = retornoRecebimentoCnab240.getValorMulta();
        Double valorAbatimento = retornoRecebimentoCnab240.getValorAbatimento();
        Double valorIof = retornoRecebimentoCnab240.getValorIof();
        Double valorDesconto = retornoRecebimentoCnab240.getValorDesconto();
        Double valorDespesasBancarias = retornoRecebimentoCnab240.getValorDespesasBancarias();
        Double valorJuros = retornoRecebimentoCnab240.getValorJuros();
        Double valorOutrosCreditos = retornoRecebimentoCnab240.getValorOutrosCreditos();
        Double diferencaJurosMulta = 0.0;
        BaixaTitulo baixa = new BaixaTitulo();
        if (titulo.getIdentificador() != null) {
            if (retornoRecebimentoCnab240.getValorDesconto() > 0.0) {
                valorDesconto = retornoRecebimentoCnab240.getValorDesconto();
            } else if (titulo.getDescontoFinanceiro() > 0.0) {
                valorDesconto = titulo.getDescontoFinanceiro();
            }
            baixa.setTitulo(titulo);
            baixa.setValor(UtilityRecebimentoCnab.getValorBaixa(retornoRecebimentoCnab240, titulo));
            baixa.setSaldoBaixa(titulo.getValor());
            baixa.setVrAbatimento(valorAbatimento);
            baixa.setVrDesconto(Double.valueOf(0.0));
            baixa.setVrDespBancariaPaga(Double.valueOf(valorTarifaCobranca + valorDespesasBancarias));
            baixa.setVrIOFPago(valorIof);
            baixa.setVrDespBancariaRecebida(valorOutrosCreditos);
            diferencaJurosMulta = ContatoFormatUtil.arrredondarNumero(valorMulta + valorJuros - (titulo.getValorMultaEmbutida() + titulo.getValorJurosEmbutido()), 2);
            Double valorBaixaDevolucao = UtilityArquivoCnab.findValorBaixaDevolucao(titulo);
            Double valorBaixaFaltaPagamento = UtilityArquivoCnab.findValorBaixaFaltaPagamento(titulo);
            Double valorBaixaAntecipada = UtilityArquivoCnab.findValorBaixaTituloAntecipado(titulo);
            Double vrTotalDiferenca = valorBaixaDevolucao + valorBaixaFaltaPagamento + valorBaixaAntecipada;
            if (vrTotalDiferenca.equals(ContatoFormatUtil.arrredondarNumero(retornoRecebimentoCnab240.getValorDesconto(), 2))) {
                baixa.setVrDesconto(Double.valueOf(0.0));
            } else if (valorDesconto > titulo.getValorDescontosEmbutido()) {
                baixa.setVrDesconto(ContatoFormatUtil.arrredondarNumero(valorDesconto - titulo.getValorDescontosEmbutido(), 2));
            }
            if (diferencaJurosMulta > 0.0 && (titulo.getValorMultaEmbutida() > 0.0 || titulo.getValorJurosEmbutido() > 0.0)) {
                baixa.setVrJuros(diferencaJurosMulta);
            } else if (diferencaJurosMulta > 0.0 && titulo.getValorMultaEmbutida() <= 0.0 && titulo.getValorJurosEmbutido() <= 0.0) {
                baixa.setVrMulta(valorMulta);
                baixa.setVrJuros(valorJuros);
            }
            baixa.setVrMultaEmbutido(titulo.getValorMultaEmbutida());
            baixa.setVrJurosEmbutido(titulo.getValorJurosEmbutido());
            Double valorOperacao = retornoRecebimentoCnab240.getValorBaixa() + baixa.getVrDesconto() + retornoRecebimentoCnab240.getValorAbatimento() + retornoRecebimentoCnab240.getValorOutrosCreditos() + retornoRecebimentoCnab240.getValorTarifaCobranca() - retornoRecebimentoCnab240.getValorDespesasBancarias();
            if (diferencaJurosMulta > 0.0 && titulo.getValorMultaEmbutida() <= 0.0 && titulo.getValorJurosEmbutido() <= 0.0) {
                valorOperacao = valorOperacao - valorJuros - valorMulta;
            }
            if (!(valorOperacao = ContatoFormatUtil.arrredondarNumero(valorOperacao, 2)).equals(retornoRecebimentoCnab240.getSaldoAtualTitulo())) {
                UtilityRecebimentoCnab.ajustaBaixaConformeRetorno(baixa, retornoRecebimentoCnab240);
            } else {
                baixa.setValor(valorOperacao);
            }
            helper.build(baixa).createAndSetContasBaixa(titulo, EnumConstTipoBaixaTitulos.BAIXA_TITULOS_ORIG_CNAB, empresa, opGer);
        } else {
            baixa.setTitulo(titulo);
            baixa.setValor(titulo.getValor());
            baixa.setSaldoBaixa(titulo.getValor());
            baixa.setVrAbatimento(Double.valueOf(0.0));
            baixa.setVrDesconto(Double.valueOf(0.0));
            baixa.setVrDespBancariaPaga(Double.valueOf(0.0));
            baixa.setVrIOFPago(Double.valueOf(0.0));
            baixa.setVrDespBancariaRecebida(Double.valueOf(0.0));
            baixa.setVrDesconto(Double.valueOf(0.0));
            baixa.setVrJuros(Double.valueOf(0.0));
            baixa.setVrMulta(Double.valueOf(0.0));
            baixa.setVrMultaEmbutido(Double.valueOf(0.0));
            baixa.setVrJurosEmbutido(Double.valueOf(0.0));
            helper.build(baixa).createAndSetContasBaixa(titulo, EnumConstTipoBaixaTitulos.BAIXA_TITULOS_ORIG_CNAB, empresa, opGer);
        }
        return baixa;
    }

    public static void updateRetornoRecebimentoCnab(List<RetornoRecebimentoCnab> listRetorno, InstituicaoValores instValor, Short gerarTituloAntecipado) throws ExceptionService {
        ArrayList<RetornoRecebimentoCnab> listTitulos = new ArrayList<RetornoRecebimentoCnab>();
        for (RetornoRecebimentoCnab retornoRecebimentoCnab : listRetorno) {
            boolean existeBoletosDuplicados = false;
            Titulo titulo = retornoRecebimentoCnab.getTitulo();
            if (retornoRecebimentoCnab.getNrNossoNumero() != null) {
                existeBoletosDuplicados = UtilityArquivoCnab.existeBoletoDuplicado(retornoRecebimentoCnab.getNrNossoNumero(), instValor, titulo);
            }
            if (titulo != null && !existeBoletosDuplicados) {
                Double saldoTitulo = UtilityArquivoCnab.findSaldoTitulo(titulo);
                retornoRecebimentoCnab.setSaldoAtualTitulo(saldoTitulo);
                if (retornoRecebimentoCnab.getValorBaixa() <= saldoTitulo && retornoRecebimentoCnab.getBaixarPeloMovRetorno().booleanValue()) {
                    retornoRecebimentoCnab.setStatus(1);
                    continue;
                }
                if (retornoRecebimentoCnab.getValorBaixa() > saldoTitulo && retornoRecebimentoCnab.getBaixarPeloMovRetorno().booleanValue() && !UtilityRecebimentoCnab.isValidValorPagoSemJurosMulta(retornoRecebimentoCnab).booleanValue()) {
                    retornoRecebimentoCnab.setStatus(1);
                    continue;
                }
                if (retornoRecebimentoCnab.getValorBaixa() > saldoTitulo && retornoRecebimentoCnab.getBaixarPeloMovRetorno().booleanValue() && UtilityRecebimentoCnab.isValidValorPagoSemJurosMulta(retornoRecebimentoCnab).booleanValue()) {
                    if (saldoTitulo > 0.0) {
                        listTitulos.add(UtilityRecebimentoCnab.createLiquidacaoTituloAtual(retornoRecebimentoCnab, titulo));
                    }
                    if (gerarTituloAntecipado.equals((short)1)) {
                        retornoRecebimentoCnab.setStatus(3);
                        continue;
                    }
                    retornoRecebimentoCnab.setStatus(5);
                    continue;
                }
                retornoRecebimentoCnab.setStatus(0);
                continue;
            }
            retornoRecebimentoCnab.setStatus(2);
        }
        if (!listTitulos.isEmpty()) {
            listRetorno.addAll(listTitulos);
        }
    }

    public static HashMap getRetornoCobranca(List<RetornoRecebimentoCnab> listRetorno, EmpresaFinanceiro empresaFinanceiro, Empresa empresa, Short agruparBaixas, Date dataBaixa, InstituicaoValores instValor, EmpresaContabilidade empresaContabilidade, OpcoesGerenciais opGer, OpcoesContabeis opCont) throws ExceptionService, Exception {
        HashMap<String, Object> retornoCobranca = new HashMap<String, Object>();
        ArrayList<Titulo> naoBaixar = new ArrayList<Titulo>();
        ArrayList<String> naoMentor = new ArrayList<String>();
        ArrayList<BaixaTitulo> baixas = new ArrayList<BaixaTitulo>();
        ArrayList<RetornoCnabCobrancaObservacao> observacoes = new ArrayList<RetornoCnabCobrancaObservacao>();
        ArrayList<RetornoCnabCobrancaTitulosAntNaoGerado> tituloAntecipadosNaoGerados = new ArrayList<RetornoCnabCobrancaTitulosAntNaoGerado>();
        GrupoDeBaixa grupoBaixa = null;
        ArrayList<ItemRetornoCnab> itensRetorno = new ArrayList<ItemRetornoCnab>();
        ArrayList<ContaValores> contas = new ArrayList<ContaValores>();
        Date dataReferenciaRetorno = null;
        block7: for (RetornoRecebimentoCnab retornoRecebimentoCnab : listRetorno) {
            Titulo titulo = retornoRecebimentoCnab.getTitulo();
            if (ToolMethods.isNull(dataReferenciaRetorno).booleanValue()) {
                dataReferenciaRetorno = retornoRecebimentoCnab.getDataReferenciaRetorno();
            }
            switch (retornoRecebimentoCnab.getStatus()) {
                case 0: {
                    naoBaixar.add(titulo);
                    itensRetorno.add(UtilityRecebimentoCnab.createInfComplementaresItensRetorno(retornoRecebimentoCnab));
                    continue block7;
                }
                case 2: {
                    StringBuilder sb = new StringBuilder();
                    sb.append("O titulo nr: ");
                    sb.append(retornoRecebimentoCnab.getNrTitulo());
                    sb.append("  nosso nr (boleto): ");
                    sb.append(retornoRecebimentoCnab.getNrNossoNumero());
                    sb.append("  Vr Titulo: ");
                    sb.append(ContatoFormatUtil.formataNumero(retornoRecebimentoCnab.getValorTitulo(), 2));
                    sb.append("  Vr Baixa: ");
                    sb.append(ContatoFormatUtil.formataNumero(retornoRecebimentoCnab.getValorBaixa(), 2));
                    if (retornoRecebimentoCnab.getDataVencimentoString() != null && retornoRecebimentoCnab.getDataVencimentoString().trim().length() == 6) {
                        sb.append("  Data Venc: ");
                        sb.append(retornoRecebimentoCnab.getDataVencimentoString().substring(0, 2));
                        sb.append("-");
                        sb.append(retornoRecebimentoCnab.getDataVencimentoString().substring(2, 4));
                        sb.append("-");
                        sb.append(retornoRecebimentoCnab.getDataVencimentoString().substring(4, 6));
                    }
                    sb.append(" n\u00e3o foram encontrados no Mentor.");
                    naoMentor.add(sb.toString());
                    observacoes.add(UtilityRecebimentoCnab.getObservacoesRetornoCnab(retornoRecebimentoCnab));
                    continue block7;
                }
                case 1: {
                    baixas.add(UtilityRecebimentoCnab.createBaixaTitulo(retornoRecebimentoCnab, titulo, empresaFinanceiro, empresa, opGer));
                    itensRetorno.add(UtilityRecebimentoCnab.createInfComplementaresItensRetorno(retornoRecebimentoCnab));
                    if (contas.contains(titulo.getCarteiraCobranca().getContaValor())) continue block7;
                    contas.add(titulo.getCarteiraCobranca().getContaValor());
                    continue block7;
                }
                case 3: {
                    baixas.add(UtilityRecebimentoCnab.createTituloAntecipado(retornoRecebimentoCnab, titulo, empresaContabilidade, empresaFinanceiro, empresa, opGer, opCont));
                    if (contas.contains(titulo.getCarteiraCobranca().getContaValor())) continue block7;
                    contas.add(titulo.getCarteiraCobranca().getContaValor());
                    continue block7;
                }
                case 5: {
                    tituloAntecipadosNaoGerados.add(UtilityRecebimentoCnab.getTitulosAntecipadosNaoGerados(retornoRecebimentoCnab, titulo));
                    continue block7;
                }
            }
            throw new ExceptionService("Titulo sem status. Favor entrar em contato com o suporte t\u00e9cnico.");
        }
        if (baixas != null && !baixas.isEmpty() && (grupoBaixa = UtilityRecebimentoCnab.createGrupoDeBaixa(baixas, empresa, agruparBaixas, dataBaixa)) != null) {
            new HelperGrupoDeBaixa(grupoBaixa).setLancamentoPisCofins();
            for (GrupoDeBaixaFormas gbf : grupoBaixa.getGrupoDeBaixaFormas()) {
                CoreUtilityFactory.getUtilityLancamentosGerenciais().criarLancamentosCTBGerencialLiquidacao(gbf);
            }
        }
        retornoCobranca.put("GRUPO_BAIXA", grupoBaixa);
        retornoCobranca.put("INF_COMPLEMENTARES", itensRetorno);
        retornoCobranca.put("NAO_MENTOR", naoMentor);
        retornoCobranca.put("NAO_BAIXAR", naoBaixar);
        retornoCobranca.put("OBSERVACOES", observacoes);
        retornoCobranca.put("ANTECIPADO_NAO_BAIXADO", tituloAntecipadosNaoGerados);
        retornoCobranca.put("LIST_RETORNOS", listRetorno);
        retornoCobranca.put("CONTAS_VALORES", contas);
        retornoCobranca.put("DATA_REFERENCIA_RETORNO", dataReferenciaRetorno);
        return retornoCobranca;
    }

    public static void setLogsIntoTituloCobranca(List<RetornoRecebimentoCnab> listRetorno) {
        for (RetornoRecebimentoCnab retornoRecebimentoCnab : listRetorno) {
            LogTituloCnab logTitulo;
            Date dataOcorrencia;
            ArrayList<LogTituloCnab> logs = new ArrayList<LogTituloCnab>();
            Titulo titulo = retornoRecebimentoCnab.getTitulo();
            Date date = dataOcorrencia = retornoRecebimentoCnab.getDataOcorrencia() != null ? retornoRecebimentoCnab.getDataOcorrencia() : new Date();
            if (titulo == null) continue;
            if (retornoRecebimentoCnab.getCodMovRetorno() != null && !retornoRecebimentoCnab.getCodMovRetorno().isEmpty()) {
                logTitulo = new LogTituloCnab();
                logTitulo.setRejeitado(retornoRecebimentoCnab.getRejeitado());
                logTitulo.setCodMovimentoRetorno(retornoRecebimentoCnab.getCodMovRetorno());
                logTitulo.setDescMovimentoRetorno(retornoRecebimentoCnab.getDescMovRet());
                logTitulo.setCodOcorrencia(retornoRecebimentoCnab.getCodOcorrencia1());
                logTitulo.setMotivoOcorrencia(retornoRecebimentoCnab.getMsgOcorrencia1());
                logTitulo.setDataCadastro(dataOcorrencia);
                logTitulo.setTitulo(titulo);
                logTitulo.setValorTarifa(ContatoFormatUtil.arrredondarNumero(retornoRecebimentoCnab.getValorTarifaCobranca() + retornoRecebimentoCnab.getValorDespesasBancarias(), 2));
                logs.add(logTitulo);
            }
            if (retornoRecebimentoCnab.getCodOcorrencia2() != null && !retornoRecebimentoCnab.getCodOcorrencia2().isEmpty() && !retornoRecebimentoCnab.getCodOcorrencia2().equalsIgnoreCase("00")) {
                logTitulo = new LogTituloCnab();
                logTitulo.setRejeitado(retornoRecebimentoCnab.getRejeitado());
                logTitulo.setCodMovimentoRetorno(retornoRecebimentoCnab.getCodMovRetorno());
                logTitulo.setDescMovimentoRetorno(retornoRecebimentoCnab.getDescMovRet());
                logTitulo.setCodOcorrencia(retornoRecebimentoCnab.getCodOcorrencia2());
                logTitulo.setMotivoOcorrencia(retornoRecebimentoCnab.getMsgOcorrencia2());
                logTitulo.setDataCadastro(dataOcorrencia);
                logTitulo.setTitulo(titulo);
                logTitulo.setValorTarifa(ContatoFormatUtil.arrredondarNumero(retornoRecebimentoCnab.getValorTarifaCobranca() + retornoRecebimentoCnab.getValorDespesasBancarias(), 2));
                logs.add(logTitulo);
            }
            if (retornoRecebimentoCnab.getCodOcorrencia3() != null && !retornoRecebimentoCnab.getCodOcorrencia3().isEmpty() && !retornoRecebimentoCnab.getCodOcorrencia3().equalsIgnoreCase("00")) {
                logTitulo = new LogTituloCnab();
                logTitulo.setRejeitado(retornoRecebimentoCnab.getRejeitado());
                logTitulo.setCodMovimentoRetorno(retornoRecebimentoCnab.getCodMovRetorno());
                logTitulo.setDescMovimentoRetorno(retornoRecebimentoCnab.getDescMovRet());
                logTitulo.setCodOcorrencia(retornoRecebimentoCnab.getCodOcorrencia3());
                logTitulo.setMotivoOcorrencia(retornoRecebimentoCnab.getMsgOcorrencia3());
                logTitulo.setDataCadastro(dataOcorrencia);
                logTitulo.setTitulo(titulo);
                logTitulo.setValorTarifa(ContatoFormatUtil.arrredondarNumero(retornoRecebimentoCnab.getValorTarifaCobranca() + retornoRecebimentoCnab.getValorDespesasBancarias(), 2));
                logs.add(logTitulo);
            }
            if (retornoRecebimentoCnab.getCodOcorrencia4() != null && !retornoRecebimentoCnab.getCodOcorrencia4().isEmpty() && !retornoRecebimentoCnab.getCodOcorrencia4().equalsIgnoreCase("00")) {
                logTitulo = new LogTituloCnab();
                logTitulo.setRejeitado(retornoRecebimentoCnab.getRejeitado());
                logTitulo.setCodMovimentoRetorno(retornoRecebimentoCnab.getCodMovRetorno());
                logTitulo.setDescMovimentoRetorno(retornoRecebimentoCnab.getDescMovRet());
                logTitulo.setCodOcorrencia(retornoRecebimentoCnab.getCodOcorrencia4());
                logTitulo.setMotivoOcorrencia(retornoRecebimentoCnab.getMsgOcorrencia4());
                logTitulo.setDataCadastro(dataOcorrencia);
                logTitulo.setTitulo(titulo);
                logTitulo.setValorTarifa(ContatoFormatUtil.arrredondarNumero(retornoRecebimentoCnab.getValorTarifaCobranca() + retornoRecebimentoCnab.getValorDespesasBancarias(), 2));
                logs.add(logTitulo);
            }
            if (retornoRecebimentoCnab.getCodOcorrencia5() != null && !retornoRecebimentoCnab.getCodOcorrencia5().isEmpty() && !retornoRecebimentoCnab.getCodOcorrencia5().equalsIgnoreCase("00")) {
                logTitulo = new LogTituloCnab();
                logTitulo.setRejeitado(retornoRecebimentoCnab.getRejeitado());
                logTitulo.setCodMovimentoRetorno(retornoRecebimentoCnab.getCodMovRetorno());
                logTitulo.setDescMovimentoRetorno(retornoRecebimentoCnab.getDescMovRet());
                logTitulo.setCodOcorrencia(retornoRecebimentoCnab.getCodOcorrencia5());
                logTitulo.setMotivoOcorrencia(retornoRecebimentoCnab.getMsgOcorrencia5());
                logTitulo.setDataCadastro(dataOcorrencia);
                logTitulo.setTitulo(titulo);
                logTitulo.setValorTarifa(ContatoFormatUtil.arrredondarNumero(retornoRecebimentoCnab.getValorTarifaCobranca() + retornoRecebimentoCnab.getValorDespesasBancarias(), 2));
                logs.add(logTitulo);
            }
            if (titulo == null) continue;
            if (titulo.getLogTituloCnab() == null || titulo.getLogTituloCnab().isEmpty()) {
                titulo.setLogTituloCnab(logs);
                continue;
            }
            ArrayList<LogTituloCnab> novosLogs = new ArrayList<LogTituloCnab>();
            for (LogTituloCnab l1 : titulo.getLogTituloCnab()) {
                for (LogTituloCnab l2 : logs) {
                    if (!l1.getCodMovimentoRetorno().equalsIgnoreCase(l2.getCodMovimentoRetorno()) && !l1.getDataCadastro().equals(l2.getDataCadastro())) {
                        novosLogs.add(l2);
                        continue;
                    }
                    novosLogs.remove(l2);
                }
            }
            titulo.getLogTituloCnab().addAll(novosLogs);
        }
    }

    private static GrupoDeBaixa createGrupoDeBaixa(List<BaixaTitulo> baixas, Empresa empresa, Short agruparBaixas, Date dataBaixa) {
        GrupoDeBaixa grupo = new GrupoDeBaixa();
        grupo.setPagRec(Short.valueOf((short)1));
        grupo.setDataCadastro(new Date());
        grupo.setEmpresa(empresa);
        grupo.setDataLiquidacao(dataBaixa);
        grupo.setDataAtualizacao(DateUtil.toTimestamp(new Date()));
        GrupoDeBaixaFormas grupoFormas = new GrupoDeBaixaFormas();
        grupoFormas.setBaixaTitulo(baixas);
        grupoFormas.setFormaPagamento(Short.valueOf((short)1));
        grupoFormas.setContaValor(null);
        grupoFormas.setAgrupamento(agruparBaixas);
        grupoFormas.setGrupoDeBaixa(grupo);
        UtilityRecebimentoCnab.setGrupoIntoBaixas(baixas, grupoFormas);
        grupo.setGrupoDeBaixaFormas(Arrays.asList(grupoFormas));
        return grupo;
    }

    private static void setGrupoIntoBaixas(List<BaixaTitulo> baixas, GrupoDeBaixaFormas grupo) {
        for (BaixaTitulo baixaTitulo : baixas) {
            baixaTitulo.setGrupoDeBaixaFormas(grupo);
        }
    }

    private static BaixaTitulo createTituloAntecipado(RetornoRecebimentoCnab retornoRecebimentoCnab, Titulo titulo, EmpresaContabilidade empresaContabilidade, EmpresaFinanceiro empresaFinanceiro, Empresa empresa, OpcoesGerenciais opGer, OpcoesContabeis opCont) throws ExceptionService, Exception {
        Titulo t = new UtilityTitulos().criarTitulos(retornoRecebimentoCnab, empresaFinanceiro, titulo, empresaContabilidade, opCont);
        return UtilityRecebimentoCnab.createBaixaTitulo(retornoRecebimentoCnab, t, empresaFinanceiro, empresa, opGer);
    }

    private static void ajustaBaixaConformeRetorno(BaixaTitulo baixa, RetornoRecebimentoCnab retornoRecebimentoCnab240) {
        Double diferenca = ContatoFormatUtil.arrredondarNumero(retornoRecebimentoCnab240.getValorBaixa() - retornoRecebimentoCnab240.getSaldoAtualTitulo(), 2);
        if (retornoRecebimentoCnab240.getValorBaixa() > retornoRecebimentoCnab240.getSaldoAtualTitulo()) {
            if (retornoRecebimentoCnab240.getBoletoTitulo() != null) {
                Double valorJuros = ContatoFormatUtil.arrredondarNumero(retornoRecebimentoCnab240.getBoletoTitulo().getValorJuros(), 2);
                Double valorMulta = ContatoFormatUtil.arrredondarNumero(retornoRecebimentoCnab240.getBoletoTitulo().getValorMulta(), 2);
                if (diferenca.equals(valorJuros + valorMulta)) {
                    baixa.setVrJuros(valorJuros);
                    baixa.setVrMulta(valorMulta);
                } else if (diferenca < valorJuros + valorMulta) {
                    baixa.setVrJuros(diferenca);
                } else {
                    baixa.setVrMulta(valorMulta);
                    baixa.setVrJuros(Double.valueOf(diferenca - baixa.getVrMulta()));
                }
            } else {
                Double valorJuros = ContatoFormatUtil.arrredondarNumero(retornoRecebimentoCnab240.getValorBaixa() - retornoRecebimentoCnab240.getSaldoAtualTitulo() + retornoRecebimentoCnab240.getValorTarifaCobranca() + retornoRecebimentoCnab240.getValorDespesasBancarias(), 2);
                baixa.setVrJuros(valorJuros);
            }
            baixa.setValor(Double.valueOf(baixa.getValor() + baixa.getVrDespBancariaPaga() - baixa.getVrJuros() - baixa.getVrMulta()));
        } else if (retornoRecebimentoCnab240.getValorBaixa() < retornoRecebimentoCnab240.getSaldoAtualTitulo() && ContatoFormatUtil.arrredondarNumero(baixa.getValor() + baixa.getVrIOFPago() + baixa.getVrDespBancariaPaga(), 2).equals(ContatoFormatUtil.arrredondarNumero(retornoRecebimentoCnab240.getSaldoAtualTitulo(), 2))) {
            baixa.setValor(Double.valueOf(baixa.getValor() + baixa.getVrIOFPago() + baixa.getVrDespBancariaPaga()));
        }
    }

    private static RetornoCnabCobrancaObservacao getObservacoesRetornoCnab(RetornoRecebimentoCnab retornoRecebimentoCnab) {
        RetornoCnabCobrancaObservacao r = new RetornoCnabCobrancaObservacao();
        r.setNrTitulo(retornoRecebimentoCnab.getNrTitulo());
        r.setNossoNumero(retornoRecebimentoCnab.getNrNossoNumero());
        r.setValorTitulo(retornoRecebimentoCnab.getValorTitulo());
        r.setValorBaixa(retornoRecebimentoCnab.getValorBaixa());
        if (retornoRecebimentoCnab.getDataVencimentoString() != null && retornoRecebimentoCnab.getDataVencimentoString().trim().length() == 6 && !retornoRecebimentoCnab.getDataVencimentoString().equals("000000")) {
            StringBuilder sb = new StringBuilder();
            sb.append(retornoRecebimentoCnab.getDataVencimentoString().substring(0, 2));
            sb.append("/");
            sb.append(retornoRecebimentoCnab.getDataVencimentoString().substring(2, 4));
            sb.append("/");
            sb.append("20");
            sb.append(retornoRecebimentoCnab.getDataVencimentoString().substring(4, 6));
            Date dataVencimento = ContatoDateUtil.strToDate((String)sb.toString());
            r.setDataVencimento(dataVencimento);
        }
        return r;
    }

    private static RetornoRecebimentoCnab createLiquidacaoTituloAtual(RetornoRecebimentoCnab oldRetorno, Titulo titulo) {
        RetornoRecebimentoCnab newRetorno = new RetornoRecebimentoCnab();
        newRetorno.setBoletoTitulo(oldRetorno.getBoletoTitulo());
        newRetorno.setCodMovRetorno(oldRetorno.getCodMovRetorno());
        newRetorno.setCodOcorrencia1(oldRetorno.getCodOcorrencia1());
        newRetorno.setCodOcorrencia2(oldRetorno.getCodOcorrencia2());
        newRetorno.setCodOcorrencia3(oldRetorno.getCodOcorrencia3());
        newRetorno.setCodOcorrencia4(oldRetorno.getCodOcorrencia4());
        newRetorno.setCodOcorrencia5(oldRetorno.getCodOcorrencia5());
        newRetorno.setDataVencimentoString(oldRetorno.getDataVencimentoString());
        newRetorno.setDescMovRet(oldRetorno.getDescMovRet());
        newRetorno.setMsgOcorrencia1(oldRetorno.getMsgOcorrencia1());
        newRetorno.setMsgOcorrencia2(oldRetorno.getMsgOcorrencia2());
        newRetorno.setMsgOcorrencia3(oldRetorno.getMsgOcorrencia3());
        newRetorno.setMsgOcorrencia4(oldRetorno.getMsgOcorrencia4());
        newRetorno.setMsgOcorrencia5(oldRetorno.getMsgOcorrencia5());
        newRetorno.setNrNossoNumero(oldRetorno.getNrNossoNumero());
        newRetorno.setNrTitulo(oldRetorno.getNrTitulo());
        newRetorno.setSaldoAtualTitulo(oldRetorno.getSaldoAtualTitulo());
        newRetorno.setStatus(1);
        newRetorno.setValorAbatimento(oldRetorno.getValorAbatimento());
        newRetorno.setValorBaixa(oldRetorno.getSaldoAtualTitulo());
        newRetorno.setValorDesconto(oldRetorno.getValorDesconto());
        newRetorno.setValorDespesasBancarias(oldRetorno.getValorDespesasBancarias());
        newRetorno.setValorIof(oldRetorno.getValorIof());
        newRetorno.setValorJuros(oldRetorno.getValorJuros());
        newRetorno.setValorMulta(oldRetorno.getValorMulta());
        newRetorno.setValorOutrosCreditos(oldRetorno.getValorOutrosCreditos());
        newRetorno.setValorTarifaCobranca(oldRetorno.getValorTarifaCobranca());
        newRetorno.setValorTitulo(oldRetorno.getValorTitulo());
        newRetorno.setNrSequencialRegistro(oldRetorno.getNrSequencialRegistro());
        newRetorno.setDataCredito(oldRetorno.getDataCredito());
        newRetorno.setDataDebitoTarifa(oldRetorno.getDataDebitoTarifa());
        newRetorno.setDataOcorrencia(oldRetorno.getDataOcorrencia());
        newRetorno.setNumeroCartorio(oldRetorno.getNumeroCartorio());
        newRetorno.setNumeroProtocolo(oldRetorno.getNumeroProtocolo());
        newRetorno.setTitulo(titulo);
        return newRetorno;
    }

    private static Boolean isValidValorPagoSemJurosMulta(RetornoRecebimentoCnab retorno) {
        Double diferenca = ContatoFormatUtil.arrredondarNumero(retorno.getValorBaixa() - retorno.getSaldoAtualTitulo(), 2);
        Double valorJuros = 0.0;
        Double valorMulta = 0.0;
        Double valorTarifa = 0.0;
        if (retorno.getValorBaixa() > retorno.getSaldoAtualTitulo()) {
            if (retorno.getBoletoTitulo() != null) {
                valorJuros = ContatoFormatUtil.arrredondarNumero(retorno.getBoletoTitulo().getValorJuros(), 2);
                valorMulta = ContatoFormatUtil.arrredondarNumero(retorno.getBoletoTitulo().getValorMulta(), 2);
                valorTarifa = ContatoFormatUtil.arrredondarNumero(retorno.getValorTarifaCobranca(), 2);
                if (diferenca.equals(valorJuros + valorMulta - valorTarifa)) {
                    return false;
                }
                valorJuros = ContatoFormatUtil.arrredondarNumero(retorno.getValorJuros(), 2);
                valorMulta = ContatoFormatUtil.arrredondarNumero(retorno.getValorMulta(), 2);
                valorTarifa = ContatoFormatUtil.arrredondarNumero(retorno.getValorTarifaCobranca(), 2);
                if (diferenca.equals(valorJuros + valorMulta - valorTarifa)) {
                    return false;
                }
            } else {
                valorJuros = ContatoFormatUtil.arrredondarNumero(retorno.getValorJuros(), 2);
                valorMulta = ContatoFormatUtil.arrredondarNumero(retorno.getValorMulta(), 2);
                valorTarifa = ContatoFormatUtil.arrredondarNumero(retorno.getValorTarifaCobranca(), 2);
                if (diferenca.equals(valorJuros + valorMulta - valorTarifa)) {
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    private static RetornoCnabCobrancaTitulosAntNaoGerado getTitulosAntecipadosNaoGerados(RetornoRecebimentoCnab retornoRecebimentoCnab, Titulo titulo) {
        RetornoCnabCobrancaTitulosAntNaoGerado ret = new RetornoCnabCobrancaTitulosAntNaoGerado();
        ret.setTitulo(titulo);
        ret.setValorPago(retornoRecebimentoCnab.getValorBaixa());
        ret.setSaldoTitulo(retornoRecebimentoCnab.getSaldoAtualTitulo());
        ret.setObservacao("T\u00edtulo antecipado n\u00e3o gerado.");
        return ret;
    }

    private static ItemRetornoCnab createInfComplementaresItensRetorno(RetornoRecebimentoCnab r) {
        ItemRetornoCnab item = new ItemRetornoCnab();
        item.setDataCredito(r.getDataCredito());
        item.setDataOcorrencia(r.getDataOcorrencia());
        item.setNrSequencialRegistro(r.getNrSequencialRegistro());
        item.setNumeroCartorio(r.getNumeroCartorio());
        item.setNumeroProtocolo(r.getNumeroProtocolo());
        if (r.getTitulo() != null && r.getTitulo().getAntecipado() == 1) {
            item.setTitulo(null);
        } else {
            item.setTitulo(r.getTitulo());
        }
        item.setValorAbatimento(r.getValorAbatimento());
        item.setValorIOF(r.getValorIof());
        Object nossoNumero = r.getNrNossoNumero();
        if (r.getDvNossoNumero() != null && !r.getDvNossoNumero().isEmpty()) {
            nossoNumero = (String)nossoNumero + r.getDvNossoNumero();
        }
        item.setNossoNumero((String)nossoNumero);
        item.setDataDebitoTarifa(r.getDataDebitoTarifa());
        return item;
    }

    private static Double getValorBaixa(RetornoRecebimentoCnab retornoRecebimentoCnab240, Titulo titulo) {
        String COD_DESCONTO = "47";
        for (LogTituloCnab logTituloCnab : titulo.getLogTituloCnab()) {
            if (logTituloCnab.getCodMovimentoRetorno() == null || !logTituloCnab.getCodMovimentoRetorno().equals(COD_DESCONTO)) continue;
            return titulo.getValor();
        }
        return retornoRecebimentoCnab240.getValorBaixa();
    }
}

