/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.folhaleite;

import com.touchcomp.basementor.model.vo.CentroResultadoContFin;
import com.touchcomp.basementor.model.vo.LancamentoEventoCooperado;
import com.touchcomp.basementor.model.vo.LoteLancamentoEventoCooperado;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.folhaleite.extratoleite.LayoutQ01Leite;
import mentorcore.utilities.impl.titulos.AuxTitulosFolhaLeite;

public class CoreServiceFolhaLeite
extends CoreService {
    public static final String SALVAR_LANCAMENTO_COOPERADO = "salvarLancamentoCooperado";
    public static final String SALVAR_LOTE_LANCAMENTO_COOPERADO = "salvarLoteLancamentoCooperado";
    public static final String LEITURA_ARQUIVO_Q01 = "leituraArquivoQ01";

    public Object salvarLancamentoCooperado(CoreRequestContext request) throws ExceptionDatabase, ExceptionGeracaoTitulos, ExceptionInvalidData {
        LancamentoEventoCooperado vo = (LancamentoEventoCooperado)request.getAttribute("vo");
        OpcoesFinanceiras opcoes = (OpcoesFinanceiras)request.getAttribute("opcoes");
        OpcoesContabeis opCont = (OpcoesContabeis)request.getAttribute("opcoesContabeis");
        CentroResultadoContFin centroResultadoContFin = (CentroResultadoContFin)request.getAttribute("centroResultadoContFin");
        vo = new AuxTitulosFolhaLeite().createTitulo(vo, opcoes, opCont, centroResultadoContFin);
        return CoreDAOFactory.getInstance().getDAOLancamentoEventoCooperado().saveOrUpdate(vo);
    }

    public Object salvarLoteLancamentoCooperado(CoreRequestContext request) throws ExceptionDatabase, ExceptionGeracaoTitulos, ExceptionInvalidData {
        LoteLancamentoEventoCooperado vo = (LoteLancamentoEventoCooperado)request.getAttribute("vo");
        OpcoesFinanceiras opcoes = (OpcoesFinanceiras)request.getAttribute("opcoes");
        OpcoesContabeis opCont = (OpcoesContabeis)request.getAttribute("opcoesContabeis");
        vo = new AuxTitulosFolhaLeite().createTituloLote(vo, opcoes, opCont);
        return CoreDAOFactory.getInstance().getDAOLoteLancamentoEventoCooperado().saveOrUpdate(vo);
    }

    public HashMap leituraArquivoQ01(CoreRequestContext r) throws IOException, FileNotFoundException, ExceptionService {
        Date periodo = (Date)r.getAttribute("periodo");
        File file = (File)r.getAttribute("arquivo");
        String nomeArquivo = (String)r.getAttribute("nomeArquivo");
        this.getArquivoImportado(periodo, nomeArquivo);
        return new LayoutQ01Leite().leituraArquivoQ01(periodo, file);
    }

    private void getArquivoImportado(Date periodo, String nomeArquivo) throws ExceptionService {
        String hql = " select coalesce(count(e.identificador),0)  from ExtratoFornecimentoLeite e  where  e.periodo = :periodo  and  e.nomeArquivo = :nomeArquivo ";
        Long retorno = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("periodo", (Object)periodo).setParameter("nomeArquivo", (Object)nomeArquivo).uniqueResult();
        if (retorno > 0L) {
            throw new ExceptionService("J\u00e1 foi importado este arquivo neste Periodo");
        }
    }
}

