/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.geracaoarquivoperdcomp.versao001;

import com.touchcomp.basementor.model.vo.AjusteApuracaoIpi;
import com.touchcomp.basementor.model.vo.ApuracaoIPI;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemAPIpiDoc;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.impl.geracaoarquivoperdcomp.versao001.model.RegistroR11;
import mentorcore.service.impl.geracaoarquivoperdcomp.versao001.model.RegistroR12;
import mentorcore.service.impl.geracaoarquivoperdcomp.versao001.model.RegistroR13;
import mentorcore.service.impl.geracaoarquivoperdcomp.versao001.model.RegistroR15;
import mentorcore.service.impl.geracaoarquivoperdcomp.versao001.model.RegistroR21;
import mentorcore.tools.DateUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class PerdCompBDConsult {
    public static final short AJUSTE_DEBITO = 0;
    public static final short AJUSTE_CREDITO = 1;

    public List<RegistroR11> getDadosRegistroR11(ApuracaoIPI apuracaoIPI, Short periodoNotasFiscais, Date dataInicial, Date dataFinal, Empresa empresa) {
        ArrayList<RegistroR11> registrosR11 = new ArrayList<RegistroR11>();
        this.getNotaTerceirosRegistroR11(apuracaoIPI, periodoNotasFiscais, dataInicial, dataFinal, empresa, registrosR11);
        this.getNotaPropriaRegistroR11(apuracaoIPI, periodoNotasFiscais, dataInicial, dataFinal, empresa, registrosR11);
        return registrosR11;
    }

    public List<RegistroR12> getDadosRegistroR12(ApuracaoIPI apuracaoIPI, Short periodoNotasFiscais, Date dataInicial, Date dataFinal, Empresa empresa) {
        ArrayList<RegistroR12> registrosR12 = new ArrayList<RegistroR12>();
        registrosR12.addAll(this.getNotaPropriaRegistrosR12(apuracaoIPI, periodoNotasFiscais, dataInicial, dataFinal, empresa));
        return registrosR12;
    }

    public List<RegistroR13> getDadosRegistroR13(Date dataInicial, Date dataFinal, Empresa empresa) {
        ArrayList<RegistroR13> registrosR13 = new ArrayList<RegistroR13>();
        registrosR13.addAll(this.getNotaTerceirosRegistroR13(dataInicial, dataFinal, empresa));
        registrosR13.addAll(this.getNotaPropriaRegistroR13(dataInicial, dataFinal, empresa));
        return registrosR13;
    }

    private Short getTipoApuracao(ApuracaoIPI apuracaoIpi, Short periodo) {
        if (periodo.equals((short)1)) {
            return Short.valueOf("0");
        }
        if (apuracaoIpi.getTipoApuracao() == 0) {
            return Short.valueOf("1");
        }
        if (apuracaoIpi.getTipoApuracao() == 1) {
            return Short.valueOf("2");
        }
        if (apuracaoIpi.getTipoApuracao() == 2) {
            return Short.valueOf("3");
        }
        return Short.valueOf("0");
    }

    private Short getTipoApuracao(Short tipoApuracao) {
        if (tipoApuracao == 0) {
            return Short.valueOf("1");
        }
        if (tipoApuracao == 1) {
            return Short.valueOf("2");
        }
        if (tipoApuracao == 2) {
            return Short.valueOf("3");
        }
        return Short.valueOf("0");
    }

    private void getNotaTerceirosRegistroR11(ApuracaoIPI apuracaoIPI, Short periodoNotasFiscais, Date dataInicial, Date dataFinal, Empresa empresa, List<RegistroR11> registrosR11) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select sum(l.valorIpiTributado) as BASE_CALCULO,  sum(l.valorIpiComercio + l.valorIpiIndustria) as VALOR_IPI,  sum(l.valorIpiIsento) as VALOR_IPI_ISENTO,  sum(l.valorIpiOutros) as VALOR_IPI_OUTROS,  l.cfop.codigo as CFOP, l.dataLivro as DATA_LIVRO FROM NotaFiscalTerceiros n inner join n.livrosFiscais l  WHERE n.dataEntrada between :dataInicial and :dataFinal and n.empresa = :empresa and l.entradaSaidaNaturezaOp = :entrada group by l.cfop.codigo, l.dataLivro");
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("entrada", (short)0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (HashMap h : lista) {
            String cfop = (String)h.get("CFOP");
            Date dataLivro = (Date)h.get("DATA_LIVRO");
            Integer ano = DateUtil.yearFromDate(dataLivro);
            Integer mes = DateUtil.monthFromDate(dataLivro);
            Boolean achou = false;
            for (RegistroR11 rr : registrosR11) {
                if (!rr.getCfop().equals(cfop) || !rr.getAno().equals(ano) || !rr.getMes().equals(mes)) continue;
                rr.setValorIpiCreditado(rr.getValorIpiCreditado() + (Double)h.get("VALOR_IPI"));
                rr.setValorIpiIsento(rr.getValorIpiIsento() + (Double)h.get("VALOR_IPI_ISENTO"));
                rr.setValorIpiOutros(rr.getValorIpiOutros() + (Double)h.get("VALOR_IPI_OUTROS"));
                rr.setBaseCalculo(rr.getBaseCalculo() + (Double)h.get("BASE_CALCULO"));
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            RegistroR11 r = new RegistroR11();
            r.setCnpjDeclarante(empresa.getPessoa().getComplemento().getCnpj());
            r.setCnpjEstabDetentorCred(empresa.getPessoa().getComplemento().getCnpj());
            r.setAno(ano);
            r.setMes(mes);
            r.setCfop(cfop);
            r.setPeriodoApuracao(this.getTipoApuracao(apuracaoIPI, periodoNotasFiscais));
            r.setValorIpiCreditado((Double)h.get("VALOR_IPI"));
            r.setValorIpiIsento((Double)h.get("VALOR_IPI_ISENTO"));
            r.setValorIpiOutros((Double)h.get("VALOR_IPI_OUTROS"));
            r.setBaseCalculo((Double)h.get("BASE_CALCULO"));
            registrosR11.add(r);
        }
    }

    private void getNotaPropriaRegistroR11(ApuracaoIPI apuracaoIPI, Short periodoNotasFiscais, Date dataInicial, Date dataFinal, Empresa empresa, List<RegistroR11> registrosR11) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select sum(l.valorIpiTributado) as BASE_CALCULO,  sum(l.valorIpiComercio + l.valorIpiIndustria) as VALOR_IPI,  sum(l.valorIpiIsento) as VALOR_IPI_ISENTO,  sum(l.valorIpiOutros) as VALOR_IPI_OUTROS,  l.cfop.codigo as CFOP, l.dataLivro as DATA_LIVRO FROM NotaFiscalPropria n inner join n.livrosFiscais l  WHERE n.dataEmissaoNota between :dataInicial and :dataFinal and n.empresa = :empresa and n.status = 100 and l.entradaSaidaNaturezaOp = :faturamentoEntrada group by l.cfop.codigo, l.dataLivro");
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("faturamentoEntrada", (short)2);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (HashMap h : lista) {
            String cfop = (String)h.get("CFOP");
            Date dataLivro = (Date)h.get("DATA_LIVRO");
            Integer ano = DateUtil.yearFromDate(dataLivro);
            Integer mes = DateUtil.monthFromDate(dataLivro);
            Boolean achou = false;
            for (RegistroR11 rr : registrosR11) {
                if (!rr.getCfop().equals(cfop) || !rr.getAno().equals(ano) || !rr.getMes().equals(mes)) continue;
                rr.setValorIpiCreditado(rr.getValorIpiCreditado() + (Double)h.get("VALOR_IPI"));
                rr.setValorIpiIsento(rr.getValorIpiIsento() + (Double)h.get("VALOR_IPI_ISENTO"));
                rr.setValorIpiOutros(rr.getValorIpiOutros() + (Double)h.get("VALOR_IPI_OUTROS"));
                rr.setBaseCalculo(rr.getBaseCalculo() + (Double)h.get("BASE_CALCULO"));
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            RegistroR11 r = new RegistroR11();
            r.setCnpjDeclarante(empresa.getPessoa().getComplemento().getCnpj());
            r.setCnpjEstabDetentorCred(empresa.getPessoa().getComplemento().getCnpj());
            r.setAno(ano);
            r.setMes(mes);
            r.setCfop(cfop);
            r.setPeriodoApuracao(this.getTipoApuracao(apuracaoIPI, periodoNotasFiscais));
            r.setValorIpiCreditado((Double)h.get("VALOR_IPI"));
            r.setValorIpiIsento((Double)h.get("VALOR_IPI_ISENTO"));
            r.setValorIpiOutros((Double)h.get("VALOR_IPI_OUTROS"));
            r.setBaseCalculo((Double)h.get("BASE_CALCULO"));
            registrosR11.add(r);
        }
    }

    private Collection<RegistroR12> getNotaPropriaRegistrosR12(ApuracaoIPI apuracaoIPI, Short periodoNotasFiscais, Date dataInicial, Date dataFinal, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select sum(l.valorIpiTributado) as BASE_CALCULO,  sum(l.valorIpiComercio + l.valorIpiIndustria) as VALOR_IPI,  sum(l.valorIpiIsento) as VALOR_IPI_ISENTO,  sum(l.valorIpiOutros) as VALOR_IPI_OUTROS,  l.cfop.codigo as CFOP, l.dataLivro as DATA_LIVRO FROM NotaFiscalPropria n inner join n.livrosFiscais l  WHERE n.dataEmissaoNota between :dataInicial and :dataFinal and n.empresa = :empresa and n.status = 100 and l.entradaSaidaNaturezaOp = :faturamentoSaida group by l.cfop.codigo, l.dataLivro");
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("faturamentoSaida", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        ArrayList<RegistroR12> registros = new ArrayList<RegistroR12>();
        for (HashMap h : lista) {
            String cfop = (String)h.get("CFOP");
            Date dataLivro = (Date)h.get("DATA_LIVRO");
            Integer ano = DateUtil.yearFromDate(dataLivro);
            Integer mes = DateUtil.monthFromDate(dataLivro);
            Boolean achou = false;
            for (RegistroR12 rr : registros) {
                if (!rr.getCfop().equals(cfop) || !rr.getAno().equals(ano) || !rr.getMes().equals(mes)) continue;
                rr.setValorIpiCreditado(rr.getValorIpiCreditado() + (Double)h.get("VALOR_IPI"));
                rr.setValorIpiIsento(rr.getValorIpiIsento() + (Double)h.get("VALOR_IPI_ISENTO"));
                rr.setValorIpiOutros(rr.getValorIpiOutros() + (Double)h.get("VALOR_IPI_OUTROS"));
                rr.setBaseCalculo(rr.getBaseCalculo() + (Double)h.get("BASE_CALCULO"));
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            RegistroR12 r = new RegistroR12();
            r.setCnpjDeclarante(empresa.getPessoa().getComplemento().getCnpj());
            r.setCnpjEstabDetentorCred(empresa.getPessoa().getComplemento().getCnpj());
            r.setAno(ano);
            r.setMes(mes);
            r.setCfop(cfop);
            r.setPeriodoApuracao(this.getTipoApuracao(apuracaoIPI, periodoNotasFiscais));
            r.setValorIpiCreditado((Double)h.get("VALOR_IPI"));
            r.setValorIpiIsento((Double)h.get("VALOR_IPI_ISENTO"));
            r.setValorIpiOutros((Double)h.get("VALOR_IPI_OUTROS"));
            r.setBaseCalculo((Double)h.get("BASE_CALCULO"));
            registros.add(r);
        }
        return registros;
    }

    private List<RegistroR13> getNotaTerceirosRegistroR13(Date dataInicial, Date dataFinal, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select sum(l.valorTotal) as VALOR_TOTAL,  sum(l.valorIpiComercio + l.valorIpiIndustria) as VALOR_IPI,  l.cfop.codigo as CFOP, n.numeroNota as NUMERO_NOTA, n.serie as SERIE, n.dataEmissao as DATA_EMISSAO, n.dataEntrada as DATA_ENTRADA, n.unidadeFatFornecedor.fornecedor.pessoa.complemento.cnpj as CNPJ_EMITENTE FROM NotaFiscalTerceiros n inner join n.livrosFiscais l  WHERE n.dataEntrada between :dataInicial and :dataFinal and n.empresa = :empresa and l.entradaSaidaNaturezaOp = :entrada group by l.cfop.codigo, n.numeroNota, n.serie, n.dataEmissao, n.dataEntrada, n.unidadeFatFornecedor.fornecedor.pessoa.complemento.cnpj having sum(l.valorIpiComercio + l.valorIpiIndustria) > 0");
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("entrada", (short)0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        ArrayList<RegistroR13> registrosR13 = new ArrayList<RegistroR13>();
        for (HashMap h : lista) {
            RegistroR13 r = new RegistroR13();
            r.setCnpjDeclarante(empresa.getPessoa().getComplemento().getCnpj());
            r.setCnpjEstabDetentorCred(empresa.getPessoa().getComplemento().getCnpj());
            r.setValorIpiCreditado((Double)h.get("VALOR_IPI"));
            r.setValorIpiDestacado((Double)h.get("VALOR_IPI"));
            r.setValorTotal((Double)h.get("VALOR_TOTAL"));
            r.setNrNota((Integer)h.get("NUMERO_NOTA"));
            r.setSerie((String)h.get("SERIE"));
            r.setDataEmissao((Date)h.get("DATA_EMISSAO"));
            r.setDataEntrada((Date)h.get("DATA_ENTRADA"));
            r.setCfop((String)h.get("CFOP"));
            r.setCnpjEmitente((String)h.get("CNPJ_EMITENTE"));
            registrosR13.add(r);
        }
        return registrosR13;
    }

    private List<RegistroR13> getNotaPropriaRegistroR13(Date dataInicial, Date dataFinal, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select sum(l.valorTotal) as VALOR_TOTAL,  sum(l.valorIpiComercio + l.valorIpiIndustria) as VALOR_IPI,  l.cfop.codigo as CFOP, n.numeroNota as NUMERO_NOTA, n.serie as SERIE, n.dataEmissaoNota as DATA_EMISSAO, n.dataEntradaSaida as DATA_ENTRADA, n.empresa.pessoa.complemento.cnpj as CNPJ_EMITENTE FROM NotaFiscalPropria n inner join n.livrosFiscais l  WHERE n.dataEmissaoNota between :dataInicial and :dataFinal and n.empresa = :empresa and l.entradaSaidaNaturezaOp = :entradaSaida group by l.cfop.codigo, n.numeroNota, n.serie, n.dataEmissaoNota, n.dataEntradaSaida, n.empresa.pessoa.complemento.cnpj having sum(l.valorIpiComercio + l.valorIpiIndustria) > 0");
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("entradaSaida", (short)2);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        ArrayList<RegistroR13> registrosR13 = new ArrayList<RegistroR13>();
        for (HashMap h : lista) {
            RegistroR13 r = new RegistroR13();
            r.setCnpjDeclarante(empresa.getPessoa().getComplemento().getCnpj());
            r.setCnpjEstabDetentorCred(empresa.getPessoa().getComplemento().getCnpj());
            r.setValorIpiCreditado((Double)h.get("VALOR_IPI"));
            r.setValorIpiDestacado((Double)h.get("VALOR_IPI"));
            r.setValorTotal((Double)h.get("VALOR_TOTAL"));
            r.setNrNota((Integer)h.get("NUMERO_NOTA"));
            r.setSerie((String)h.get("SERIE"));
            r.setDataEmissao((Date)h.get("DATA_EMISSAO"));
            r.setDataEntrada((Date)h.get("DATA_ENTRADA"));
            r.setCfop((String)h.get("CFOP"));
            r.setCnpjEmitente((String)h.get("CNPJ_EMITENTE"));
            registrosR13.add(r);
        }
        return registrosR13;
    }

    public List<RegistroR21> getDadosRegistroR21(Date dataFinal, Date dataGeracaoArquivo, Empresa empresa) {
        Date dataInicialApuracao = DateUtil.nextDays(dataFinal, 1);
        Date dataFinalApuracao = this.getDataFinalApuracao(dataGeracaoArquivo);
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select  a.anoMes as ANO_MES, a.tipoApuracao as TIPO_APURACAO, a.vrCredito as CREDITOS_ENTRADA_NACIONAL, a.vrOutroCredito as CREDITOS_DEMAIS_CREDITOS, a.vrEstornoDebito as CREDITOS_ESTORNO_DEBITOS, a.vrDebito as DEBITOS_SAIDA_NACIONAL, a.vrOutroDebito as DEBITOS_OUTROS_DEBITOS, a.vrEstornoCredito as DEBITOS_ESTORNO_CREDITOS from ApuracaoIPI a where  a.dataInicial between :dataInicial and :dataFinal and a.empresa = :empresa");
        q.setDate("dataInicial", dataInicialApuracao);
        q.setDate("dataFinal", dataFinalApuracao);
        q.setEntity("empresa", (Object)empresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        ArrayList<RegistroR21> registrosR21 = new ArrayList<RegistroR21>();
        for (HashMap h : lista) {
            RegistroR21 r = new RegistroR21();
            r.setAno(DateUtil.yearFromDate((Date)h.get("ANO_MES")));
            r.setMes(DateUtil.monthFromDate((Date)h.get("ANO_MES")));
            r.setPeriodoApuracao(this.getTipoApuracao((Short)h.get("TIPO_APURACAO")));
            r.setCnpjDeclarante(empresa.getPessoa().getComplemento().getCnpj());
            r.setCnpjEstabDetentorCred(empresa.getPessoa().getComplemento().getCnpj());
            r.setCreditosEntradaMercadoNacional((Double)h.get("CREDITOS_ENTRADA_NACIONAL"));
            r.setCreditosDemaisCreditos((Double)h.get("CREDITOS_DEMAIS_CREDITOS"));
            r.setCreditosEstornoDebitos((Double)h.get("CREDITOS_ESTORNO_DEBITOS"));
            r.setDebitosSaidaMercadoNacional((Double)h.get("DEBITOS_SAIDA_NACIONAL"));
            r.setDebitosOutrosDebitos((Double)h.get("DEBITOS_OUTROS_DEBITOS"));
            r.setDebitosEstornoCreditos((Double)h.get("DEBITOS_ESTORNO_CREDITOS"));
            r.setMovimentoPeriodo(this.existeMovimentoPeriodo(r));
            registrosR21.add(r);
        }
        return registrosR21;
    }

    private Date getDataFinalApuracao(Date dataGeracaoArquivo) {
        Date data = DateUtil.nextMonth(dataGeracaoArquivo, -1);
        return DateUtil.getLastDateOnMonth(data);
    }

    private Short existeMovimentoPeriodo(RegistroR21 r) {
        if (r.getCreditosCreditosExtemporaneos() > 0.0 || r.getCreditosCreditosPresumidos() > 0.0 || r.getCreditosDemaisCreditos() > 0.0 || r.getCreditosEntradaMercadoExterno() > 0.0 || r.getCreditosEntradaMercadoNacional() > 0.0 || r.getCreditosEstornoDebitos() > 0.0 || r.getDebitosEstornoCreditos() > 0.0 || r.getDebitosOutrosDebitos() > 0.0 || r.getDebitosRessarcimentoCreditos() > 0.0 || r.getDebitosSaidaMercadoNacional() > 0.0) {
            return Short.valueOf("2");
        }
        return Short.valueOf("1");
    }

    public List<RegistroR15> getDadosRegistroR15(ApuracaoIPI apuracaoIPI, Date dataInicial, Date dataFinal, Empresa empresa) {
        ArrayList<RegistroR15> lista = new ArrayList<RegistroR15>();
        List<ApuracaoIPI> apuracoes = this.getApuracoesPeriodo(apuracaoIPI, dataInicial, dataFinal, empresa);
        for (ApuracaoIPI ap : apuracoes) {
            for (AjusteApuracaoIpi ajuste : ap.getAjustesApuracaoIpi()) {
                if (!ToolMethods.isEquals((Object)ajuste.getTipoAjuste(), (Object)1)) continue;
                for (ItemAPIpiDoc nf : ajuste.getItemApIpiDoc()) {
                    RegistroR15 r = new RegistroR15();
                    r.setCnpjDeclarante(empresa.getPessoa().getComplemento().getCnpj());
                    r.setCnpjEstabDetentorCred(empresa.getPessoa().getComplemento().getCnpj());
                    r.setValorIpiCreditado(nf.getValorAjuste());
                    r.setValorIpiDestacado(0.0);
                    if (nf.getItemNotaTerceiros() != null) {
                        r.setValorTotal(nf.getItemNotaTerceiros().getNotaFiscalTerceiros().getValoresNfTerceiros().getValorTotal());
                        r.setNrNota(nf.getItemNotaTerceiros().getNotaFiscalTerceiros().getNumeroNota());
                        r.setSerie(nf.getItemNotaTerceiros().getNotaFiscalTerceiros().getSerie());
                        r.setDataEmissao(nf.getItemNotaTerceiros().getNotaFiscalTerceiros().getDataEmissao());
                        r.setDataEntrada(nf.getItemNotaTerceiros().getNotaFiscalTerceiros().getDataEntrada());
                        r.setCfop(nf.getItemNotaTerceiros().getItemNotaLivroFiscal().getCfop().getCodigo());
                        r.setCnpjEmitente(nf.getItemNotaTerceiros().getNotaFiscalTerceiros().getUnidadeFatFornecedor().getPessoa().getComplemento().getCnpj());
                    } else if (nf.getItemNotaPropria() != null) {
                        r.setValorTotal(nf.getItemNotaPropria().getNotaFiscalPropria().getValoresNfPropria().getValorTotal());
                        r.setNrNota(nf.getItemNotaPropria().getNotaFiscalPropria().getNumeroNota());
                        r.setSerie(nf.getItemNotaPropria().getNotaFiscalPropria().getSerie());
                        r.setDataEmissao(nf.getItemNotaPropria().getNotaFiscalPropria().getDataEmissaoNota());
                        r.setDataEntrada(nf.getItemNotaPropria().getNotaFiscalPropria().getDataEntradaSaida());
                        r.setCfop(nf.getItemNotaPropria().getItemNotaLivroFiscal().getCfop().getCodigo());
                        r.setCnpjEmitente(nf.getItemNotaPropria().getNotaFiscalPropria().getUnidadeFatCliente().getPessoa().getComplemento().getCnpj());
                    }
                    r.setEspecieCredito(Short.valueOf("2"));
                    r.setPeriodoApuracao(Short.valueOf("0"));
                    r.setMes(ToolDate.getMonthFromDate((Date)nf.getAjusteApuracaoIpi().getApuracaoIpi().getAnoMes()) + 1);
                    r.setAno(ToolDate.getYearFromDate((Date)nf.getAjusteApuracaoIpi().getApuracaoIpi().getAnoMes()));
                    lista.add(r);
                }
            }
        }
        return lista;
    }

    private List<ApuracaoIPI> getApuracoesPeriodo(ApuracaoIPI apuracaoIPI, Date dataInicial, Date dataFinal, Empresa empresa) {
        ArrayList<ApuracaoIPI> apuracoes = new ArrayList<ApuracaoIPI>();
        if (apuracaoIPI != null) {
            apuracoes.add(apuracaoIPI);
        } else {
            Session s = CoreBdUtil.getInstance().getSession();
            Query q = s.createQuery("select distinct a from ApuracaoIPI a where  a.anoMes between :dataInicial and :dataFinal and a.empresa = :empresa");
            q.setDate("dataInicial", dataInicial);
            q.setDate("dataFinal", dataFinal);
            q.setEntity("empresa", (Object)empresa);
            List list = q.list();
            for (ApuracaoIPI ap : list) {
                apuracoes.add(ap);
            }
        }
        return apuracoes;
    }
}

