/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.geracaoarquivoperdcomp.versao001;

import com.touchcomp.basementor.model.vo.ApuracaoIPI;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.impl.geracaoarquivoperdcomp.versao001.PerdCompBDConsult;
import mentorcore.service.impl.geracaoarquivoperdcomp.versao001.PerdCompFormat;
import mentorcore.service.impl.geracaoarquivoperdcomp.versao001.model.RegistroR11;
import mentorcore.service.impl.geracaoarquivoperdcomp.versao001.model.RegistroR12;
import mentorcore.service.impl.geracaoarquivoperdcomp.versao001.model.RegistroR13;
import mentorcore.service.impl.geracaoarquivoperdcomp.versao001.model.RegistroR15;
import mentorcore.service.impl.geracaoarquivoperdcomp.versao001.model.RegistroR21;

public class PerdCompWritter {
    private PerdCompFormat form = new PerdCompFormat();
    private String endOfRegister = "\r\n";
    private char separator = (char)59;

    public void gerarArquivoPerdComp(CoreRequestContext r) throws IOException {
        ApuracaoIPI apuracaoIpi = (ApuracaoIPI)r.getAttribute("apuracaoIpi");
        Date dataInicial = (Date)r.getAttribute("dataInicial");
        Date dataFinal = (Date)r.getAttribute("dataFinal");
        Date dataGeracaoArquivo = (Date)r.getAttribute("dataGeracaoArquivo");
        File f = (File)r.getAttribute("file");
        Short periodoNotasFiscais = (Short)r.getAttribute("periodoNotasFiscais");
        Short informarCnpjSucedida = (Short)r.getAttribute("informarCnpjSucedida");
        String cnpjSucedida = (String)r.getAttribute("cnpjSucedida");
        Short gerarRegistroR11 = (Short)r.getAttribute("gerarRegistroR11");
        Short gerarRegistroR12 = (Short)r.getAttribute("gerarRegistroR12");
        Short gerarRegistroR13 = (Short)r.getAttribute("gerarRegistroR13");
        Short gerarRegistroR15 = (Short)r.getAttribute("gerarRegistroR15");
        Short gerarRegistroR21 = (Short)r.getAttribute("gerarRegistroR21");
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        File r11 = this.createFileRegistroR11(apuracaoIpi, informarCnpjSucedida, cnpjSucedida, gerarRegistroR11, periodoNotasFiscais, dataInicial, dataFinal, empresa);
        File r12 = this.createFileRegistroR12(apuracaoIpi, informarCnpjSucedida, cnpjSucedida, gerarRegistroR12, periodoNotasFiscais, dataInicial, dataFinal, empresa);
        File r13 = this.createFileRegistroR13(dataInicial, dataFinal, informarCnpjSucedida, cnpjSucedida, gerarRegistroR13, empresa);
        File r15 = this.createFileRegistroR15(apuracaoIpi, informarCnpjSucedida, cnpjSucedida, gerarRegistroR15, empresa, dataInicial, dataFinal);
        File r21 = this.createFileRegistroR21(dataGeracaoArquivo, dataFinal, informarCnpjSucedida, cnpjSucedida, gerarRegistroR21, empresa);
        this.apendToSomeFile(f, r11, r12, r13, r15, r21);
    }

    private File createFileRegistroR11(ApuracaoIPI apuracaoIpi, Short informarCnpjSucedida, String cnpjSucedida, Short gerarRegistroR11, Short periodoNotasFiscais, Date dataInicial, Date dataFinal, Empresa empresa) throws IOException {
        File f = File.createTempFile("perdcomp_r11", ".txt");
        if (gerarRegistroR11.equals((short)1)) {
            PrintWriter p = new PrintWriter(f);
            List<RegistroR11> registros = new PerdCompBDConsult().getDadosRegistroR11(apuracaoIpi, periodoNotasFiscais, dataInicial, dataFinal, empresa);
            for (RegistroR11 r : registros) {
                p.append("R11");
                p.append(this.form.formatString(this.form.clearString(r.getCnpjDeclarante()), 14));
                if (informarCnpjSucedida.equals((short)1)) {
                    p.append(this.form.formatString(this.form.clearString(cnpjSucedida), 14));
                } else {
                    p.append(this.form.formatStringComEspacosEmBranco("", 14));
                }
                p.append(this.form.formatString(this.form.clearString(r.getCnpjEstabDetentorCred()), 14));
                p.append(this.form.formatClearStringComp0Esquerda(r.getAno().toString(), 4));
                p.append(this.form.formatClearStringComp0Esquerda(r.getMes().toString(), 2));
                p.append(this.form.formatNumber(r.getPeriodoApuracao(), 0, 1));
                p.append(this.form.formatString(this.form.clearString(r.getCfop()), 4));
                p.append(this.form.formatNumber(r.getBaseCalculo(), 2, 12));
                p.append(this.form.formatNumber(r.getValorIpiCreditado(), 2, 12));
                p.append(this.form.formatNumber(r.getValorIpiIsento(), 2, 12));
                p.append(this.form.formatNumber(r.getValorIpiOutros(), 2, 12));
                p.append(this.endOfRegister);
            }
            p.flush();
            p.close();
        }
        return f;
    }

    private File createFileRegistroR12(ApuracaoIPI apuracaoIpi, Short informarCnpjSucedida, String cnpjSucedida, Short gerarRegistroR12, Short periodoNotasFiscais, Date dataInicial, Date dataFinal, Empresa empresa) throws IOException {
        File f = File.createTempFile("perdcomp_r12", ".txt");
        if (gerarRegistroR12.equals((short)1)) {
            PrintWriter p = new PrintWriter(f);
            List<RegistroR12> registros = new PerdCompBDConsult().getDadosRegistroR12(apuracaoIpi, periodoNotasFiscais, dataInicial, dataFinal, empresa);
            for (RegistroR12 r : registros) {
                p.append("R12");
                p.append(this.form.formatString(this.form.clearString(r.getCnpjDeclarante()), 14));
                if (informarCnpjSucedida.equals((short)1)) {
                    p.append(this.form.formatString(this.form.clearString(cnpjSucedida), 14));
                } else {
                    p.append(this.form.formatStringComEspacosEmBranco("", 14));
                }
                p.append(this.form.formatString(this.form.clearString(r.getCnpjEstabDetentorCred()), 14));
                p.append(this.form.formatClearStringComp0Esquerda(r.getAno().toString(), 4));
                p.append(this.form.formatClearStringComp0Esquerda(r.getMes().toString(), 2));
                p.append(this.form.formatNumber(r.getPeriodoApuracao(), 0, 1));
                p.append(this.form.formatString(this.form.clearString(r.getCfop()), 4));
                p.append(this.form.formatNumber(r.getBaseCalculo(), 2, 12));
                p.append(this.form.formatNumber(r.getValorIpiCreditado(), 2, 12));
                p.append(this.form.formatNumber(r.getValorIpiIsento(), 2, 12));
                p.append(this.form.formatNumber(r.getValorIpiOutros(), 2, 12));
                p.append(this.endOfRegister);
            }
            p.flush();
            p.close();
        }
        return f;
    }

    private File createFileRegistroR13(Date dataInicial, Date dataFinal, Short informarCnpjSucedida, String cnpjSucedida, Short gerarRegistroR13, Empresa empresa) throws IOException {
        File f = File.createTempFile("perdcomp_r13", ".txt");
        if (gerarRegistroR13.equals((short)1)) {
            PrintWriter p = new PrintWriter(f);
            List<RegistroR13> registros = new PerdCompBDConsult().getDadosRegistroR13(dataInicial, dataFinal, empresa);
            for (RegistroR13 r : registros) {
                p.append("R13");
                p.append(this.form.formatString(this.form.clearString(r.getCnpjDeclarante()), 14));
                if (informarCnpjSucedida.equals((short)1)) {
                    p.append(this.form.formatString(this.form.clearString(cnpjSucedida), 14));
                } else {
                    p.append(this.form.formatStringComEspacosEmBranco("", 14));
                }
                p.append(this.form.formatString(this.form.clearString(r.getCnpjEstabDetentorCred()), 14));
                p.append(this.form.formatString(this.form.clearString(r.getCnpjEmitente()), 14));
                p.append(this.form.formatClearStringComp0Esquerda(r.getNrNota().toString(), 9));
                p.append(this.form.formatStringComEspacosEmBranco(r.getSerie().toString(), 3));
                p.append(this.form.formatDate(r.getDataEmissao()));
                p.append(this.form.formatDate(r.getDataEntrada()));
                p.append(this.form.formatString(this.form.clearString(r.getCfop()), 4));
                p.append(this.form.formatNumber(r.getValorTotal(), 2, 12));
                p.append(this.form.formatNumber(r.getValorIpiDestacado(), 2, 12));
                p.append(this.form.formatNumber(r.getValorIpiCreditado(), 2, 12));
                p.append(this.endOfRegister);
            }
            p.flush();
            p.close();
        }
        return f;
    }

    private File apendToSomeFile(File file, File blocoR11, File blocoR12, File blocoR13, File blocoR15, File blocoR21) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(file);
        this.copy(blocoR11, out);
        this.copy(blocoR12, out);
        this.copy(blocoR13, out);
        this.copy(blocoR15, out);
        this.copy(blocoR21, out);
        blocoR11.delete();
        blocoR12.delete();
        blocoR13.delete();
        blocoR15.delete();
        blocoR21.delete();
        ((OutputStream)out).close();
        return file;
    }

    void copy(File src, OutputStream out) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        ((InputStream)in).close();
    }

    private File createFileRegistroR21(Date dataGeracaoArquivo, Date dataFinal, Short informarCnpjSucedida, String cnpjSucedida, Short gerarRegistroR21, Empresa empresa) throws IOException {
        File f = File.createTempFile("perdcomp_r21", ".txt");
        if (gerarRegistroR21.equals((short)1)) {
            PrintWriter p = new PrintWriter(f);
            List<RegistroR21> registros = new PerdCompBDConsult().getDadosRegistroR21(dataFinal, dataGeracaoArquivo, empresa);
            for (RegistroR21 r : registros) {
                p.append("R21");
                p.append(this.form.formatString(this.form.clearString(r.getCnpjDeclarante()), 14));
                if (informarCnpjSucedida.equals((short)1)) {
                    p.append(this.form.formatString(this.form.clearString(cnpjSucedida), 14));
                } else {
                    p.append(this.form.formatStringComEspacosEmBranco("", 14));
                }
                p.append(this.form.formatString(this.form.clearString(r.getCnpjEstabDetentorCred()), 14));
                p.append(this.form.formatClearStringComp0Esquerda(r.getAno().toString(), 4));
                p.append(this.form.formatClearStringComp0Esquerda(r.getMes().toString(), 2));
                p.append(this.form.formatNumber(r.getPeriodoApuracao(), 0, 1));
                p.append(this.form.formatNumber(r.getMovimentoPeriodo(), 0, 1));
                p.append(this.form.formatNumber(r.getCreditosEntradaMercadoNacional(), 2, 12));
                p.append(this.form.formatNumber(r.getCreditosEntradaMercadoExterno(), 2, 12));
                p.append(this.form.formatNumber(r.getCreditosEstornoDebitos(), 2, 12));
                p.append(this.form.formatNumber(r.getCreditosCreditosPresumidos(), 2, 12));
                p.append(this.form.formatNumber(r.getCreditosCreditosExtemporaneos(), 2, 12));
                p.append(this.form.formatNumber(r.getCreditosDemaisCreditos(), 2, 12));
                p.append(this.form.formatNumber(r.getDebitosSaidaMercadoNacional(), 2, 12));
                p.append(this.form.formatNumber(r.getDebitosEstornoCreditos(), 2, 12));
                p.append(this.form.formatNumber(r.getDebitosRessarcimentoCreditos(), 2, 12));
                p.append(this.form.formatNumber(r.getDebitosOutrosDebitos(), 2, 12));
                p.append(this.endOfRegister);
            }
            p.flush();
            p.close();
        }
        return f;
    }

    private File createFileRegistroR15(ApuracaoIPI apuracaoIpi, Short informarCnpjSucedida, String cnpjSucedida, Short gerarRegistroR15, Empresa empresa, Date dataInicial, Date dataFinal) throws IOException {
        File f = File.createTempFile("perdcomp_r13", ".txt");
        if (ToolMethods.isEquals((Object)gerarRegistroR15, (Object)1)) {
            PrintWriter p = new PrintWriter(f);
            List<RegistroR15> registros = new PerdCompBDConsult().getDadosRegistroR15(apuracaoIpi, dataInicial, dataFinal, empresa);
            for (RegistroR15 r : registros) {
                p.append("R15");
                p.append(this.form.formatString(this.form.clearString(r.getCnpjDeclarante()), 14));
                if (informarCnpjSucedida.equals((short)1)) {
                    p.append(this.form.formatString(this.form.clearString(cnpjSucedida), 14));
                } else {
                    p.append(this.form.formatStringComEspacosEmBranco("", 14));
                }
                p.append(this.form.formatString(this.form.clearString(r.getCnpjEstabDetentorCred()), 14));
                p.append(this.form.formatString(this.form.clearString(r.getCnpjEmitente()), 14));
                p.append(this.form.formatClearStringComp0Esquerda(r.getNrNota().toString(), 9));
                p.append(this.form.formatStringComEspacosEmBranco(r.getSerie(), 3));
                p.append(this.form.formatDate(r.getDataEmissao()));
                p.append(this.form.formatDate(r.getDataEntrada()));
                p.append(this.form.formatString(this.form.clearString(r.getCfop()), 4));
                p.append(this.form.formatNumber(r.getValorTotal(), 2, 12));
                p.append(this.form.formatNumber(r.getValorIpiDestacado(), 2, 12));
                p.append(this.form.formatNumber(r.getValorIpiCreditado(), 2, 12));
                p.append(this.form.formatString(r.getEspecieCredito().toString()));
                p.append(this.form.formatString(r.getPeriodoApuracao().toString()));
                p.append(this.form.formatClearStringComp0Esquerda(r.getMes().toString(), 2));
                p.append(this.form.formatClearStringComp0Esquerda(r.getAno().toString(), 4));
                p.append(this.endOfRegister);
            }
            p.flush();
            p.close();
        }
        return f;
    }
}

