/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.geracaodapi.util;

import com.touchcomp.basementor.model.vo.ApuracaoICMS;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GeracaoDapi;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.geracaodapi.util.LinhaTipo10;
import mentorcore.tools.DateUtil;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilGeracaoArquivoDAPI {
    Integer mesReferencia;
    Integer anoReferencia;
    Integer diaInicialReferencia;
    Integer diaFinalReferencia;
    Double tLinha1 = 0.0;
    Double tLinha2 = 0.0;
    Double tLinha3 = 0.0;
    Double tLinha4 = 0.0;
    Double tLinha5 = 0.0;
    Double tLinha6 = 0.0;
    Double tLinha7 = 0.0;
    Double tLinha8 = 0.0;
    Double tLinha9 = 0.0;
    Double tLinha10 = 0.0;
    Double tLinha11 = 0.0;
    Double geral1 = 0.0;
    Double geral2 = 0.0;
    Double geral3 = 0.0;
    Double geral4 = 0.0;
    Double geral5 = 0.0;
    Double geral6 = 0.0;
    Double geral7 = 0.0;
    Double geral8 = 0.0;
    Double geral9 = 0.0;
    Double geral10 = 0.0;
    Double geral11 = 0.0;
    Double campo100 = 0.0;
    Double campo93 = 0.0;
    Double campo87 = 0.0;
    Double campo89 = 0.0;
    Double campo90 = 0.0;
    Double campo94 = 0.0;
    Double campo95 = 0.0;
    Double campo91 = 0.0;
    Double campo96 = 0.0;
    Double campo92 = 0.0;
    Double campo97 = 0.0;

    public void geracaoArquivoDAPI(GeracaoDapi vo, File arquivo) throws IOException, FileNotFoundException, ExceptionService {
        ApuracaoICMS apuracao;
        if (arquivo.exists()) {
            arquivo.delete();
        }
        if ((apuracao = this.getApuracaoICMS(vo.getDataInicial(), vo.getEmpresa())) == null) {
            throw new ExceptionService("Primeiro, crie uma apura\u00e7\u00e3o de ICMS.");
        }
        arquivo.createNewFile();
        this.mesReferencia = DateUtil.monthFromDate(vo.getDataInicial());
        this.anoReferencia = DateUtil.yearFromDate(vo.getDataInicial());
        this.diaInicialReferencia = DateUtil.dayFromDate(vo.getDataInicial());
        this.diaFinalReferencia = DateUtil.dayFromDate(vo.getDataFinal());
        this.createBloco0(vo, arquivo);
        this.createBloco10(vo, arquivo, apuracao);
        this.createBloco99(vo, arquivo);
    }

    private void createBloco0(GeracaoDapi vo, File file) throws IOException {
        FileWriter fileWriter = new FileWriter(file, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco00(p, vo);
        p.flush();
        p.close();
    }

    private void createBloco99(GeracaoDapi vo, File file) throws IOException {
        FileWriter fileWriter = new FileWriter(file, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco99(p, vo);
        p.flush();
        p.close();
    }

    private void writterBloco99(PrintWriter p, GeracaoDapi vo) {
        p.append("99");
        p.append(this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13));
        p.append(this.getFormatedNumero(this.anoReferencia, 0, 4));
        p.append(this.getFormatedNumero(this.mesReferencia, 0, 2));
        p.append(this.getFormatedNumero(this.diaFinalReferencia, 0, 2));
        p.append(this.getFormatedNumero(this.diaInicialReferencia, 0, 2));
        p.append("0583");
    }

    private void writterBloco00(PrintWriter p, GeracaoDapi vo) {
        Empresa empresa = vo.getEmpresa();
        p.append("00");
        p.append(this.getFormatedStringZeros(this.getClearString(empresa.getPessoa().getComplemento().getInscEst()), 13));
        p.append(this.getFormatedNumero(this.anoReferencia, 0, 4));
        p.append(this.getFormatedNumero(this.mesReferencia, 0, 2));
        p.append(this.getFormatedNumero(this.diaFinalReferencia, 0, 2));
        p.append(this.getFormatedNumero(this.diaInicialReferencia, 0, 2));
        p.append("D1");
        p.append(this.getSimOrNao(vo.getTipoArquivo()));
        p.append(this.getFormatedStringZeros("0", 7));
        p.append(this.getFormatedStringZeros("0", 2));
        p.append(this.getFormatedStringZeros(vo.getRegimeRecolhimento().getCodigo(), 2));
        p.append(this.getSimOrNao(vo.getRegimeEspecialFiscalizacao()));
        if (vo.getDataPagamento() == null) {
            p.append("00000000");
        } else {
            p.append(this.getFormatedDate(vo.getDataPagamento()));
        }
        p.append(this.getSimOrNao(vo.getOptanteFundese()));
        p.append(this.getSimOrNao(vo.getDapiMovimento()));
        p.append("N");
        p.append(this.getFormatedStringZeros(vo.getEmpresa().getEmpresaDados().getCnae().getCodigo(), 7));
        p.append("00");
        p.append(this.getFinalLine());
    }

    public String getFormatedStringZeros(String st, int numeroCasas) {
        if (st == null) {
            st = "";
        }
        if (st.length() > numeroCasas) {
            return st.substring(0, numeroCasas);
        }
        return ToolString.completaZeros((String)st, (int)numeroCasas, (boolean)true);
    }

    private String getClearString(String st) {
        return ToolString.refina((String)st);
    }

    public String getFormatedNumero(Number numero, int numCasasDecimais, int numCasasInteiras) {
        return ToolString.refina((String)ContatoFormatUtil.formataNumero((Number)numero, (int)numCasasDecimais, (int)numCasasInteiras));
    }

    private String getFinalLine() {
        return "\r\n";
    }

    private String getSimOrNao(Short simNao) {
        if (simNao.equals((short)1)) {
            return "S";
        }
        return "N";
    }

    public String getFormatedDate(Date data) {
        return DateUtil.dateToStr(data, "ddMMyyyy");
    }

    private void createBloco10(GeracaoDapi vo, File file, ApuracaoICMS apuracao) throws FileNotFoundException, IOException, ExceptionService {
        FileWriter fileWriter = new FileWriter(file, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.createBlocoEntradaEstadual(vo, p);
        this.createBlocoEntradaInterEstadual(vo, p);
        this.createBlocoEntradaExterior(vo, p);
        this.createBlocoSaidasEstaduais(vo, p);
        this.createBlocoSaidasInterEstaduais(vo, p);
        this.createBlocoSaidaExterior(vo, p);
        this.createOutrosBlocos(vo, p, apuracao);
        p.flush();
        p.close();
    }

    private void createOutrosBlocos(GeracaoDapi vo, PrintWriter p, ApuracaoICMS a) {
        this.createBloco66(vo, p);
        this.createBloco67(vo, p);
        this.createBloco68(vo, p);
        this.createBloco69(vo, p);
        this.createBloco70(vo, p);
        this.createBloco71(vo, p, a.getVrOutroCredito());
        this.createBloco72(vo, p, a.getVrOutroCredito());
        this.createBloco73(vo, p);
        this.createBloco74(vo, p);
        this.createBloco75(vo, p);
        this.createBloco76(vo, p);
        this.createBloco77(vo, p);
        this.createBloco78(vo, p);
        this.createBloco79(vo, p);
        this.createBloco80(vo, p);
        this.createBloco81(vo, p);
        this.createBloco82(vo, p);
        this.createBloco83(vo, p);
        this.createBloco84(vo, p);
        this.createBloco85(vo, p);
        this.createBloco86(vo, p);
        this.createBloco87(vo, p, a.getSaldoCredorAnterior());
        this.createBloco88(vo, p, a.getVrCredito());
        this.createBloco89(vo, p, a.getVrOutroCredito());
        this.createBloco90(vo, p);
        this.createBloco91(vo, p, a.getSaldoCredorAnterior() + a.getVrCredito() + a.getVrOutroCredito());
        this.createBloco92(vo, p);
        this.createBloco93(vo, p, a.getVrDebito());
        this.createBloco94(vo, p);
        this.createBloco95(vo, p);
        this.createBloco96(vo, p, a.getVrDebito());
        this.createBloco97(vo, p, a.getSaldoDevedor());
        this.createBloco98(vo, p);
        this.createBloco99(vo, p, a.getSaldoDevedor());
        this.createBloco100(vo, p);
        this.createBloco101(vo, p);
        this.createBloco102(vo, p);
        this.createBloco103(vo, p);
        this.createBloco104(vo, p);
        this.createBloco105(vo, p, a.getSaldoDevedor() + this.campo100);
        this.createBloco106(vo, p);
        this.createBloco107(vo, p);
        this.createBloco108(vo, p);
        this.createBloco109(vo, p);
        this.createBloco110(vo, p);
        this.createBloco111(vo, p);
        this.createBloco112(vo, p);
        this.createBloco113(vo, p);
        this.createBloco114(vo, p);
        this.createBloco115(vo, p);
        this.createBloco116(vo, p);
        this.createBloco117(vo, p);
        this.createBloco118(vo, p);
    }

    private void createBlocoEntradaExterior(GeracaoDapi vo, PrintWriter p) {
        List hash = this.getValoresLinhaDAPIExterior(vo.getDataInicial(), vo.getDataFinal(), vo.getEmpresa());
        List<LinhaTipo10> linhasEntradasExterior = this.separarValoresEntradaExterior(hash, vo);
        linhasEntradasExterior = this.ordernarLista(linhasEntradasExterior);
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        linhasEntradasExterior = this.completarLinhas(linhasEntradasExterior, 36, 41, 1, 11, inscricao);
        this.createLinhaTotalizador(inscricao, "042", linhasEntradasExterior);
        this.totalizarGeral();
        this.zerarTotalizador();
        this.createLinhaTotalizadorGeral(inscricao, "043", linhasEntradasExterior);
        linhasEntradasExterior = this.ordernarLista(linhasEntradasExterior);
        this.escreverArquivo(linhasEntradasExterior, p);
        this.zerarCamposGeral();
    }

    private void createBlocoEntradaInterEstadual(GeracaoDapi vo, PrintWriter p) {
        List hash = this.getValoresLinhasDAPIEntradaInterEstadual(vo.getDataInicial(), vo.getDataFinal(), vo.getEmpresa());
        List<LinhaTipo10> linhasEntradasInterEstaduais = this.separarValoresEntradaInterEstadual(hash, vo);
        linhasEntradasInterEstaduais = this.ordernarLista(linhasEntradasInterEstaduais);
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        linhasEntradasInterEstaduais = this.completarLinhas(linhasEntradasInterEstaduais, 26, 34, 1, 11, inscricao);
        this.createLinhaTotalizador(inscricao, "035", linhasEntradasInterEstaduais);
        this.totalizarGeral();
        this.zerarTotalizador();
        linhasEntradasInterEstaduais = this.ordernarLista(linhasEntradasInterEstaduais);
        this.escreverArquivo(linhasEntradasInterEstaduais, p);
    }

    private void createBlocoEntradaEstadual(GeracaoDapi vo, PrintWriter p) {
        List hash = this.getValoresLinhasDAPIEntradaEstadual(vo.getDataInicial(), vo.getDataFinal(), vo.getEmpresa());
        List<LinhaTipo10> linhasEntradasEstaduais = this.separarValoresEntradaEstadual(hash, vo);
        linhasEntradasEstaduais = this.ordernarLista(linhasEntradasEstaduais);
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        linhasEntradasEstaduais = this.completarLinhas(linhasEntradasEstaduais, 16, 24, 1, 11, inscricao);
        this.createLinhaTotalizador(inscricao, "025", linhasEntradasEstaduais);
        this.totalizarGeral();
        this.zerarTotalizador();
        linhasEntradasEstaduais = this.ordernarLista(linhasEntradasEstaduais);
        this.escreverArquivo(linhasEntradasEstaduais, p);
    }

    private void createBlocoSaidaExterior(GeracaoDapi vo, PrintWriter p) throws ExceptionService {
        List hash = this.getValoresLinhasDAPISaidasExterior(vo.getDataInicial(), vo.getDataFinal(), vo.getEmpresa());
        List<LinhaTipo10> linhasSaidaExterior = this.separarValoresSaidaEstaduais(hash, vo);
        linhasSaidaExterior = this.ordernarLista(linhasSaidaExterior);
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        linhasSaidaExterior = this.completarLinhas(linhasSaidaExterior, 60, 63, 1, 10, inscricao);
        this.createTotalizadorSaida(inscricao, "064", linhasSaidaExterior);
        this.campo93 = this.geral3;
        this.createLinhaTotalizadorGeralSaida(inscricao, "065", linhasSaidaExterior);
        linhasSaidaExterior = this.ordernarLista(linhasSaidaExterior);
        this.escreverArquivo(linhasSaidaExterior, p);
    }

    private void createBlocoSaidasEstaduais(GeracaoDapi vo, PrintWriter p) throws ExceptionService {
        List hash = this.getValoresLinhasDAPISaidaEstaduais(vo.getDataInicial(), vo.getDataFinal(), vo.getEmpresa());
        List<LinhaTipo10> linhasSaidasEstaduais = this.separarValoresSaidaEstaduais(hash, vo);
        linhasSaidasEstaduais = this.ordernarLista(linhasSaidasEstaduais);
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        linhasSaidasEstaduais = this.completarLinhas(linhasSaidasEstaduais, 44, 50, 1, 10, inscricao);
        this.createTotalizadorSaida(inscricao, "051", linhasSaidasEstaduais);
        this.totalizarGeral();
        this.zerarTotalizador();
        linhasSaidasEstaduais = this.ordernarLista(linhasSaidasEstaduais);
        this.escreverArquivo(linhasSaidasEstaduais, p);
    }

    private void createBlocoSaidasInterEstaduais(GeracaoDapi vo, PrintWriter p) throws ExceptionService {
        List hash = this.getValoresLinhasDAPISaidaInterEstaduais(vo.getDataInicial(), vo.getDataFinal(), vo.getEmpresa());
        List<LinhaTipo10> linhasSaidas = this.separarValoresSaidaInterEstadual(hash, vo);
        linhasSaidas = this.ordernarLista(linhasSaidas);
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        linhasSaidas = this.completarLinhas(linhasSaidas, 52, 58, 1, 10, inscricao);
        this.createTotalizadorSaida(inscricao, "059", linhasSaidas);
        this.totalizarGeral();
        this.zerarTotalizador();
        linhasSaidas = this.ordernarLista(linhasSaidas);
        this.escreverArquivo(linhasSaidas, p);
    }

    private List getValoresLinhasDAPISaidaInterEstaduais(Date dataInicial, Date dataFinal, Empresa empresa) {
        String hql = " select       coalesce( SUM(l.valorTotal),0) AS VALOR_CONTABIL,     coalesce( SUM(l.valorIcmsTributado),0)  AS BASE_CALCULO,    coalesce( SUM(l.valorIcmsSemAprov),0) AS ICMS_SEM_APROVEITAMENTO,     coalesce( SUM(l.valorIcmsIsento),0) AS ICMS_ISENTO,     coalesce( SUM(l.valorIcmsOutros),0) AS ICMS_OUTROS,     coalesce( SUM(l.valorBCIcmsSt),0) AS BC_ICMS_ST,     coalesce( SUM(l.valorIcmsSt),0) AS ICMS_ST,     coalesce( SUM(l.valorIcms),0) AS VALOR_ICMS ,     coalesce( SUM(l.valorPis),0) AS VALOR_PIS,     coalesce( SUM(l.valorCofins),0) AS VALOR_COFINS,     l.incidenciaIcms.codigo as CST  ,     l.cfop.tipoMovimentoDAPI.linhaDapi as LINHA_DAPI  from LivroFiscal l   where   l.empresa = :empresa  and  l.entradaSaidaNaturezaOp = 1  and  (l.cancelado = 0 OR l.cancelado is null) and  (l.cfop.tipoMovimentoDAPI.linhaDapi = '052'  or  l.cfop.tipoMovimentoDAPI.linhaDapi = '053'  or  l.cfop.tipoMovimentoDAPI.linhaDapi = '054'  or  l.cfop.tipoMovimentoDAPI.linhaDapi = '055'  or l.cfop.tipoMovimentoDAPI.linhaDapi = '056'  or  l.cfop.tipoMovimentoDAPI.linhaDapi = '057'  or  l.cfop.tipoMovimentoDAPI.linhaDapi = '058' )  and   l.dataLivro between :dataInicial and :dataFinal  group by   l.incidenciaIcms.codigo ,  l.cfop.tipoMovimentoDAPI.linhaDapi  order by l.cfop.tipoMovimentoDAPI.linhaDapi ";
        List hashs = CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("dataInicial", dataInicial).setDate("dataFinal", dataFinal).setEntity("empresa", (Object)empresa).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        return hashs;
    }

    private List<LinhaTipo10> separarValoresSaidaInterEstadual(List hash, GeracaoDapi vo) throws ExceptionService {
        ArrayList<LinhaTipo10> linhasDapi = new ArrayList<LinhaTipo10>();
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        for (Object obj : hash) {
            HashMap h = (HashMap)obj;
            String linhaDap = (String)h.get("LINHA_DAPI");
            if (linhaDap.equals("052")) {
                this.createLinhaSaidaInterEstadual(h, vo, linhaDap, linhasDapi);
                continue;
            }
            if (linhaDap.equals("053")) {
                this.createLinhaSaidaInterEstadual(h, vo, linhaDap, linhasDapi);
                continue;
            }
            if (linhaDap.equals("054")) {
                this.createLinhaSaidaInterEstadual(h, vo, linhaDap, linhasDapi);
                continue;
            }
            if (linhaDap.equals("055")) {
                this.createLinhaSaidaInterEstadual(h, vo, linhaDap, linhasDapi);
                continue;
            }
            if (linhaDap.equals("056")) {
                this.createLinhaSaidaInterEstadual(h, vo, linhaDap, linhasDapi);
                continue;
            }
            if (linhaDap.equals("057")) {
                this.createLinhaSaidaInterEstadual(h, vo, linhaDap, linhasDapi);
                continue;
            }
            if (!linhaDap.equals("058")) continue;
            this.createLinhaSaidaInterEstadual(h, vo, linhaDap, linhasDapi);
        }
        return linhasDapi;
    }

    private String formatarValor(Double valorDeclarado) {
        Object numero = "";
        Double valor = ContatoFormatUtil.arrredondarNumero((Double)valorDeclarado, (int)2);
        Integer inteira = valor.intValue();
        Integer decimal = (int)Math.round((valor - (double)valor.intValue()) * 100.0);
        numero = decimal.toString().length() == 1 ? inteira.toString() + "0" + decimal.toString() : inteira.toString() + decimal.toString();
        return ToolString.completaZeros((String)numero, (int)15, (boolean)true);
    }

    private void createLinhaEntradaEstadual(HashMap h, GeracaoDapi vo, String linha, List linhasDapi) {
        LinhaTipo10 l;
        String cst = (String)h.get("CST");
        Double baseCalculo = (Double)h.get("BASE_CALCULO");
        Double icmsIsento = (Double)h.get("ICMS_ISENTO");
        Double icmsOutros = (Double)h.get("ICMS_OUTROS");
        Double valorIcms = (Double)h.get("VALOR_ICMS");
        Double valorContabil = (Double)h.get("VALOR_CONTABIL");
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        if (cst.equals("000") || cst.equals("020")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "02", this.formatarValor(baseCalculo));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "03", this.formatarValor(valorIcms));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(valorContabil));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha1 = this.tLinha1 + valorContabil;
            this.tLinha2 = this.tLinha2 + baseCalculo;
            this.tLinha3 = this.tLinha3 + valorIcms;
        }
        if (cst.equals("020") || cst.equals("090")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "06", this.formatarValor(icmsIsento));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsIsento));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha6 = this.tLinha6 + icmsIsento;
            this.tLinha1 = this.tLinha1 + icmsIsento;
        }
        if (cst.equals("040")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "05", this.formatarValor(icmsIsento));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsIsento));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha5 = this.tLinha5 + icmsIsento;
            this.tLinha1 = this.tLinha1 + icmsIsento;
        }
        if (cst.equals("041")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "11", this.formatarValor(icmsOutros));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            if (!this.existeLinhaTabela(l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(valorContabil)), linhasDapi)) {
                linhasDapi.add(l);
            }
            if (!this.existeLinhaTabela(l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "06", this.formatarValor(icmsIsento)), linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha1 = this.tLinha1 + valorContabil;
            this.tLinha6 = this.tLinha6 + icmsIsento;
            this.tLinha11 = this.tLinha11 + icmsOutros;
        }
        if (cst.equals("050")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "09", this.formatarValor(icmsOutros));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsOutros));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha1 = this.tLinha1 + icmsOutros;
            this.tLinha9 = this.tLinha9 + icmsOutros;
        }
        if (cst.equals("051")) {
            // empty if block
        }
        if (cst.equals("060")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "10", this.formatarValor(icmsOutros));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            if (!this.existeLinhaTabela(l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsOutros)), linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha10 = this.tLinha10 + icmsOutros;
            this.tLinha1 = this.tLinha1 + icmsOutros;
        }
        if (cst.equals("090") || cst.equals("000")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "11", this.formatarValor(icmsOutros));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            if (!this.existeLinhaTabela(l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsOutros)), linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha11 = this.tLinha11 + icmsOutros;
            this.tLinha1 = this.tLinha1 + icmsOutros;
        }
    }

    private void createLinhaSaidaInterEstadual(HashMap h, GeracaoDapi vo, String linha, List linhasDapi) throws ExceptionService {
        String cst = (String)h.get("CST");
        Double baseCalculo = (Double)h.get("BASE_CALCULO");
        Double icmsIsento = (Double)h.get("ICMS_ISENTO");
        Double icmsOutros = (Double)h.get("ICMS_OUTROS");
        Double valorIcms = (Double)h.get("VALOR_ICMS");
        Double valorContabil = (Double)h.get("VALOR_CONTABIL");
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        if (cst.equals("000")) {
            LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "02", this.formatarValor(baseCalculo));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "03", this.formatarValor(valorIcms));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(valorContabil));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            if (!this.existeLinhaTabela(l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "10", this.formatarValor(icmsOutros)), linhasDapi)) {
                linhasDapi.add(l);
            }
            if (!this.existeLinhaTabela(l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsOutros)), linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha1 = this.tLinha1 + valorContabil;
            this.tLinha1 = this.tLinha1 + icmsOutros;
            this.tLinha10 = this.tLinha10 + icmsOutros;
            this.tLinha2 = this.tLinha2 + baseCalculo;
            this.tLinha3 = this.tLinha3 + valorIcms;
        } else if (cst.equals("020")) {
            LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "05", this.formatarValor(icmsIsento));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsIsento));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha1 = this.tLinha1 + icmsIsento;
            this.tLinha5 = this.tLinha5 + icmsIsento;
        } else if (cst.equals("040")) {
            LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "04", this.formatarValor(icmsIsento));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsIsento));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha1 = this.tLinha1 + icmsIsento;
            this.tLinha4 = this.tLinha4 + icmsIsento;
        } else if (cst.equals("040")) {
            LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "05", this.formatarValor(icmsIsento));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsIsento));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha1 = this.tLinha1 + icmsIsento;
            this.tLinha5 = this.tLinha5 + icmsIsento;
        } else if (cst.equals("050")) {
            LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "08", this.formatarValor(icmsOutros));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsOutros));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha1 = this.tLinha1 + icmsOutros;
            this.tLinha8 = this.tLinha8 + icmsOutros;
        } else if (cst.equals("051")) {
            LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "07", this.formatarValor(icmsOutros));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsOutros));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha1 = this.tLinha1 + icmsOutros;
            this.tLinha7 = this.tLinha7 + icmsOutros;
        } else if (cst.equals("060")) {
            LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "09", this.formatarValor(icmsOutros));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsOutros));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha1 = this.tLinha1 + icmsOutros;
            this.tLinha9 = this.tLinha9 + icmsOutros;
        } else if (cst.equals("090")) {
            LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "10", this.formatarValor(icmsOutros));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsOutros));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha1 = this.tLinha1 + icmsOutros;
            this.tLinha10 = this.tLinha10 + icmsOutros;
        } else if (cst.equals("041")) {
            LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "06", this.formatarValor(icmsIsento));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsIsento));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha6 = this.tLinha6 + icmsIsento;
            this.tLinha1 = this.tLinha1 + icmsIsento;
        }
    }

    private List<LinhaTipo10> ordernarLista(List<LinhaTipo10> linhasSaidas) {
        if (linhasSaidas != null) {
            Collections.sort(linhasSaidas, new Comparator(this){

                public int compare(Object o1, Object o2) {
                    LinhaTipo10 item1 = (LinhaTipo10)o1;
                    LinhaTipo10 item2 = (LinhaTipo10)o2;
                    if (!item1.getIdentificacaoLinha().equals(item2.getIdentificacaoLinha())) {
                        Double vlr1 = new Double(item1.getIdentificacaoLinha());
                        Double vlr2 = new Double(item2.getIdentificacaoLinha());
                        return vlr1.compareTo(vlr2);
                    }
                    return new Double(item1.getIdentificacaoColuna()).compareTo(new Double(item2.getIdentificacaoColuna()));
                }
            });
            return linhasSaidas;
        }
        return null;
    }

    private void escreverArquivo(List<LinhaTipo10> linhasSaidas, PrintWriter p) {
        for (LinhaTipo10 linha10 : linhasSaidas) {
            p.append("10");
            p.append(linha10.getInscricaoEstadualContribuinte());
            p.append(linha10.getAnoReferencia());
            p.append(linha10.getMesReferencia());
            p.append(linha10.getDiaFinalReferencia());
            p.append(linha10.getDiaInicialReferencia());
            p.append(linha10.getIdentificacaoLinha());
            p.append(linha10.getIdentificacaoColuna());
            p.append(linha10.getValorDeclarado());
            p.append(this.getFinalLine());
        }
    }

    private List completarLinhas(List<LinhaTipo10> linhasSaidas, Integer linhaInicial, Integer linhaFinal, Integer colunaInicial, Integer colunaFinal, String inscricao) {
        ArrayList<LinhaTipo10> aux = new ArrayList<LinhaTipo10>();
        boolean sair = false;
        boolean achou = false;
        Object colunaParametro = colunaInicial.toString().length() == 1 ? "0" + colunaInicial : colunaInicial.toString();
        String linhaParametro = "0" + linhaInicial;
        do {
            for (LinhaTipo10 linhaDec : linhasSaidas) {
                achou = false;
                String linhaLista = linhaDec.getIdentificacaoLinha();
                String colunaLista = linhaDec.getIdentificacaoColuna();
                colunaParametro = colunaInicial.toString().length() == 1 ? "0" + colunaInicial : colunaInicial.toString();
                linhaParametro = "0" + linhaInicial;
                System.err.println("LISTA = " + linhaLista + "-" + colunaLista);
                System.err.println("PARAMETRO = " + linhaParametro + " - " + (String)colunaParametro);
                if (linhaLista.equals(linhaParametro) && colunaLista.equals(colunaParametro)) {
                    achou = true;
                    aux.add(linhaDec);
                    if (linhaInicial <= linhaFinal) break;
                    sair = true;
                    break;
                }
                if (linhaInicial <= linhaFinal) continue;
                sair = true;
                break;
            }
            if (!achou && !sair) {
                LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linhaParametro, (String)colunaParametro, this.formatarValor(0.0));
                System.err.println(l.getIdentificacaoLinha() + "-" + l.getIdentificacaoColuna());
                aux.add(l);
                linhasSaidas.add(l);
                if (colunaInicial.equals(colunaFinal)) {
                    linhaInicial = linhaInicial + 1;
                    colunaInicial = 1;
                    continue;
                }
                colunaInicial = colunaInicial + 1;
                continue;
            }
            if (colunaInicial.equals(colunaFinal)) {
                linhaInicial = linhaInicial + 1;
                colunaInicial = 1;
                continue;
            }
            colunaInicial = colunaInicial + 1;
        } while (!sair);
        return aux;
    }

    private List getValoresLinhaDAPIExterior(Date dataInicial, Date dataFinal, Empresa empresa) {
        String hql = " select       coalesce( SUM(l.valorTotal),0) AS VALOR_CONTABIL,     coalesce( SUM(l.valorIcmsTributado),0)  AS BASE_CALCULO,    coalesce( SUM(l.valorIcmsSemAprov),0) AS ICMS_SEM_APROVEITAMENTO,     coalesce( SUM(l.valorIcmsIsento),0) AS ICMS_ISENTO,     coalesce( SUM(l.valorIcmsOutros),0) AS ICMS_OUTROS,     coalesce( SUM(l.valorBCIcmsSt),0) AS BC_ICMS_ST,     coalesce( SUM(l.valorIcmsSt),0) AS ICMS_ST,     coalesce( SUM(l.valorIcms),0) AS VALOR_ICMS ,     coalesce( SUM(l.valorPis),0) AS VALOR_PIS,     coalesce( SUM(l.valorCofins),0) AS VALOR_COFINS,     l.incidenciaIcms.codigo as CST  ,     l.cfop.tipoMovimentoDAPI.linhaDapi as LINHA_DAPI  from LivroFiscal l   where   l.empresa = :empresa  and  (l.entradaSaidaNaturezaOp = 0 or l.entradaSaidaNaturezaOp = 2 ) and  (l.cancelado is null OR l.cancelado != 1 )  and  (l.cfop.tipoMovimentoDAPI.linhaDapi = '036'  or  l.cfop.tipoMovimentoDAPI.linhaDapi = '037'  or  l.cfop.tipoMovimentoDAPI.linhaDapi = '038'  or  l.cfop.tipoMovimentoDAPI.linhaDapi = '039'  or l.cfop.tipoMovimentoDAPI.linhaDapi = '040'  or  l.cfop.tipoMovimentoDAPI.linhaDapi = '041' ) and   l.dataLivro between :dataInicial and :dataFinal  group by   l.incidenciaIcms.codigo ,  l.cfop.tipoMovimentoDAPI.linhaDapi  order by l.cfop.tipoMovimentoDAPI.linhaDapi ";
        List hashs = CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("dataInicial", dataInicial).setDate("dataFinal", dataFinal).setEntity("empresa", (Object)empresa).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        return hashs;
    }

    private List getValoresLinhasDAPIEntradaInterEstadual(Date dataInicial, Date dataFinal, Empresa empresa) {
        String hql = " select       coalesce( SUM(l.valorTotal),0) AS VALOR_CONTABIL,     coalesce( SUM(l.valorIcmsTributado),0)  AS BASE_CALCULO,    coalesce( SUM(l.valorIcmsSemAprov),0) AS ICMS_SEM_APROVEITAMENTO,     coalesce( SUM(l.valorIcmsIsento),0) AS ICMS_ISENTO,     coalesce( SUM(l.valorIcmsOutros),0) AS ICMS_OUTROS,     coalesce( SUM(l.valorBCIcmsSt),0) AS BC_ICMS_ST,     coalesce( SUM(l.valorIcmsSt),0) AS ICMS_ST,     coalesce( SUM(l.valorIcms),0) AS VALOR_ICMS ,     coalesce( SUM(l.valorPis),0) AS VALOR_PIS,     coalesce( SUM(l.valorCofins),0) AS VALOR_COFINS,     l.incidenciaIcms.codigo as CST  ,     l.cfop.tipoMovimentoDAPI.linhaDapi as LINHA_DAPI  from LivroFiscal l   where   l.empresa = :empresa   and  (l.entradaSaidaNaturezaOp = 0 or l.entradaSaidaNaturezaOp = 2 ) and  (l.cancelado is null OR l.cancelado != 1 )  and  (l.cfop.tipoMovimentoDAPI.linhaDapi = '026'  or  l.cfop.tipoMovimentoDAPI.linhaDapi = '027'  or  l.cfop.tipoMovimentoDAPI.linhaDapi = '028'  or  l.cfop.tipoMovimentoDAPI.linhaDapi = '029'  or l.cfop.tipoMovimentoDAPI.linhaDapi = '030'  or  l.cfop.tipoMovimentoDAPI.linhaDapi = '031'  or  l.cfop.tipoMovimentoDAPI.linhaDapi = '032'  or  l.cfop.tipoMovimentoDAPI.linhaDapi = '033'  or  l.cfop.tipoMovimentoDAPI.linhaDapi = '034')  and   l.dataLivro between :dataInicial and :dataFinal  group by   l.incidenciaIcms.codigo ,  l.cfop.tipoMovimentoDAPI.linhaDapi  order by l.cfop.tipoMovimentoDAPI.linhaDapi ";
        List hashs = CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("dataInicial", dataInicial).setDate("dataFinal", dataFinal).setEntity("empresa", (Object)empresa).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        return hashs;
    }

    private List getValoresLinhasDAPIEntradaEstadual(Date dataInicial, Date dataFinal, Empresa empresa) {
        String hql = " select       coalesce( SUM(l.valorTotal),0) AS VALOR_CONTABIL,     coalesce( SUM(l.valorIcmsTributado),0)  AS BASE_CALCULO,    coalesce( SUM(l.valorIcmsSemAprov),0) AS ICMS_SEM_APROVEITAMENTO,     coalesce( SUM(l.valorIcmsIsento),0) AS ICMS_ISENTO,     coalesce( SUM(l.valorIcmsOutros),0) AS ICMS_OUTROS,     coalesce( SUM(l.valorBCIcmsSt),0) AS BC_ICMS_ST,     coalesce( SUM(l.valorIcmsSt),0) AS ICMS_ST,     coalesce( SUM(l.valorIcms),0) AS VALOR_ICMS ,     coalesce( SUM(l.valorPis),0) AS VALOR_PIS,     coalesce( SUM(l.valorCofins),0) AS VALOR_COFINS,     l.incidenciaIcms.codigo as CST  ,     l.cfop.tipoMovimentoDAPI.linhaDapi as LINHA_DAPI  from LivroFiscal l   where   (l.cfop.tipoMovimentoDAPI.linhaDapi = '016'  or  l.cfop.tipoMovimentoDAPI.linhaDapi = '017'  or  l.cfop.tipoMovimentoDAPI.linhaDapi = '018'  or  l.cfop.tipoMovimentoDAPI.linhaDapi = '019'  or l.cfop.tipoMovimentoDAPI.linhaDapi = '020'  or  l.cfop.tipoMovimentoDAPI.linhaDapi = '021'  or  l.cfop.tipoMovimentoDAPI.linhaDapi = '022'  or  l.cfop.tipoMovimentoDAPI.linhaDapi = '023'  or  l.cfop.tipoMovimentoDAPI.linhaDapi = '024')  and  l.empresa = :empresa  and  (l.entradaSaidaNaturezaOp = 0 or l.entradaSaidaNaturezaOp = 2 ) and  (l.cancelado is null OR l.cancelado != 1 )  and   l.dataLivro between :dataInicial and :dataFinal  group by   l.incidenciaIcms.codigo ,  l.cfop.tipoMovimentoDAPI.linhaDapi  order by l.cfop.tipoMovimentoDAPI.linhaDapi ";
        List hashs = CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("dataInicial", dataInicial).setDate("dataFinal", dataFinal).setEntity("empresa", (Object)empresa).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        return hashs;
    }

    private List getValoresLinhasDAPISaidasExterior(Date dataInicial, Date dataFinal, Empresa empresa) {
        String hql = " select       coalesce( SUM(l.valorTotal),0) AS VALOR_CONTABIL,     coalesce( SUM(l.valorIcmsTributado),0)  AS BASE_CALCULO,    coalesce( SUM(l.valorIcmsSemAprov),0) AS ICMS_SEM_APROVEITAMENTO,     coalesce( SUM(l.valorIcmsIsento),0) AS ICMS_ISENTO,     coalesce( SUM(l.valorIcmsOutros),0) AS ICMS_OUTROS,     coalesce( SUM(l.valorBCIcmsSt),0) AS BC_ICMS_ST,     coalesce( SUM(l.valorIcmsSt),0) AS ICMS_ST,     coalesce( SUM(l.valorIcms),0) AS VALOR_ICMS ,     coalesce( SUM(l.valorPis),0) AS VALOR_PIS,     coalesce( SUM(l.valorCofins),0) AS VALOR_COFINS,     l.incidenciaIcms.codigo as CST  ,     l.cfop.tipoMovimentoDAPI.linhaDapi as LINHA_DAPI  from LivroFiscal l   where   l.empresa = :empresa  and  l.entradaSaidaNaturezaOp = 1  and  (l.cancelado = 0 OR l.cancelado is null) and  (l.cfop.tipoMovimentoDAPI.linhaDapi = '060'  or  l.cfop.tipoMovimentoDAPI.linhaDapi = '061'  or  l.cfop.tipoMovimentoDAPI.linhaDapi = '062'  or  l.cfop.tipoMovimentoDAPI.linhaDapi = '063')  and   l.dataLivro between :dataInicial and :dataFinal  group by   l.incidenciaIcms.codigo ,  l.cfop.tipoMovimentoDAPI.linhaDapi  order by l.cfop.tipoMovimentoDAPI.linhaDapi ";
        List hashs = CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("dataInicial", dataInicial).setDate("dataFinal", dataFinal).setEntity("empresa", (Object)empresa).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        return hashs;
    }

    private List getValoresLinhasDAPISaidaEstaduais(Date dataInicial, Date dataFinal, Empresa empresa) {
        String hql = " select       coalesce( SUM(l.valorTotal),0) AS VALOR_CONTABIL,     coalesce( SUM(l.valorIcmsTributado),0)  AS BASE_CALCULO,    coalesce( SUM(l.valorIcmsSemAprov),0) AS ICMS_SEM_APROVEITAMENTO,     coalesce( SUM(l.valorIcmsIsento),0) AS ICMS_ISENTO,     coalesce( SUM(l.valorIcmsOutros),0) AS ICMS_OUTROS,     coalesce( SUM(l.valorBCIcmsSt),0) AS BC_ICMS_ST,     coalesce( SUM(l.valorIcmsSt),0) AS ICMS_ST,     coalesce( SUM(l.valorIcms),0) AS VALOR_ICMS ,     coalesce( SUM(l.valorPis),0) AS VALOR_PIS,     coalesce( SUM(l.valorCofins),0) AS VALOR_COFINS,     l.incidenciaIcms.codigo as CST  ,     l.cfop.tipoMovimentoDAPI.linhaDapi as LINHA_DAPI  from LivroFiscal l   where   l.empresa = :empresa  and  l.entradaSaidaNaturezaOp = 1  and  (l.cancelado = 0 OR l.cancelado is null) and  (l.cfop.tipoMovimentoDAPI.linhaDapi = '044'  or  l.cfop.tipoMovimentoDAPI.linhaDapi = '045'  or  l.cfop.tipoMovimentoDAPI.linhaDapi = '046'  or  l.cfop.tipoMovimentoDAPI.linhaDapi = '047'  or l.cfop.tipoMovimentoDAPI.linhaDapi = '048'  or  l.cfop.tipoMovimentoDAPI.linhaDapi = '049'  or  l.cfop.tipoMovimentoDAPI.linhaDapi = '050' )  and   l.dataLivro between :dataInicial and :dataFinal  group by   l.incidenciaIcms.codigo ,  l.cfop.tipoMovimentoDAPI.linhaDapi  order by l.cfop.tipoMovimentoDAPI.linhaDapi ";
        List hashs = CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("dataInicial", dataInicial).setDate("dataFinal", dataFinal).setEntity("empresa", (Object)empresa).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        return hashs;
    }

    private List<LinhaTipo10> separarValoresEntradaEstadual(List hash, GeracaoDapi vo) {
        ArrayList<LinhaTipo10> linhasDapi = new ArrayList<LinhaTipo10>();
        for (Object obj : hash) {
            HashMap h = (HashMap)obj;
            String linhaDap = (String)h.get("LINHA_DAPI");
            if (linhaDap.equals("016")) {
                this.createLinhaEntradaEstadual16(h, vo, linhaDap, linhasDapi);
                continue;
            }
            if (linhaDap.equals("017")) {
                this.createLinhaEntradaEstadual(h, vo, linhaDap, linhasDapi);
                continue;
            }
            if (linhaDap.equals("018")) {
                this.createLinhaEntradaEstadual(h, vo, linhaDap, linhasDapi);
                continue;
            }
            if (linhaDap.equals("019")) {
                this.createLinhaEntradaEstadual(h, vo, linhaDap, linhasDapi);
                continue;
            }
            if (linhaDap.equals("020")) {
                this.createLinhaEntradaEstadual(h, vo, linhaDap, linhasDapi);
                continue;
            }
            if (linhaDap.equals("021")) {
                this.createLinhaEntradaEstadual(h, vo, linhaDap, linhasDapi);
                continue;
            }
            if (linhaDap.equals("022")) {
                this.createLinhaEntradaEstadual(h, vo, linhaDap, linhasDapi);
                continue;
            }
            if (linhaDap.equals("023")) {
                this.createLinhaEntradaEstadual23(h, vo, linhaDap, linhasDapi);
                continue;
            }
            if (!linhaDap.equals("024")) continue;
            this.createLinhaEntradaEstadual24(h, vo, linhaDap, linhasDapi);
        }
        return linhasDapi;
    }

    private List<LinhaTipo10> separarValoresSaidaEstaduais(List hash, GeracaoDapi vo) throws ExceptionService {
        ArrayList<LinhaTipo10> linhasDapi = new ArrayList<LinhaTipo10>();
        for (Object obj : hash) {
            HashMap h = (HashMap)obj;
            String linhaDap = (String)h.get("LINHA_DAPI");
            if (linhaDap.equals("044")) {
                this.createLinhaSaidaInterEstadual(h, vo, linhaDap, linhasDapi);
                continue;
            }
            if (linhaDap.equals("045")) {
                this.createLinhaSaidaInterEstadual(h, vo, linhaDap, linhasDapi);
                continue;
            }
            if (linhaDap.equals("046")) {
                this.createLinhaSaidaInterEstadual(h, vo, linhaDap, linhasDapi);
                continue;
            }
            if (linhaDap.equals("047")) {
                this.createLinhaSaidaInterEstadual(h, vo, linhaDap, linhasDapi);
                continue;
            }
            if (linhaDap.equals("048")) {
                this.createLinhaSaidaInterEstadual(h, vo, linhaDap, linhasDapi);
                continue;
            }
            if (linhaDap.equals("049")) {
                this.createLinhaSaidaInterEstadual(h, vo, linhaDap, linhasDapi);
                continue;
            }
            if (!linhaDap.equals("050")) continue;
            this.createLinhaSaidaInterEstadual(h, vo, linhaDap, linhasDapi);
        }
        return linhasDapi;
    }

    private List<LinhaTipo10> separarValoresEntradaInterEstadual(List hash, GeracaoDapi vo) {
        ArrayList<LinhaTipo10> linhasDapi = new ArrayList<LinhaTipo10>();
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        Double linha26Coluna3 = 0.0;
        Double linha26Coluna1 = 0.0;
        Double linha27Coluna3 = 0.0;
        Double linha27Coluna1 = 0.0;
        Double linha28Coluna3 = 0.0;
        Double linha28Coluna1 = 0.0;
        Double linha29Coluna3 = 0.0;
        Double linha29Coluna1 = 0.0;
        Double linha30Coluna3 = 0.0;
        Double linha30Coluna1 = 0.0;
        Double linha31Coluna3 = 0.0;
        Double linha31Coluna1 = 0.0;
        Double linha32Coluna3 = 0.0;
        Double linha32Coluna1 = 0.0;
        Double linha33Coluna3 = 0.0;
        Double linha33Coluna1 = 0.0;
        Double linha34Coluna3 = 0.0;
        Double linha34Coluna1 = 0.0;
        LinhaTipo10 linha = null;
        for (Object obj : hash) {
            HashMap h = (HashMap)obj;
            String linhaDap = (String)h.get("LINHA_DAPI");
            String cst = (String)h.get("CST");
            Double valorIcms = (Double)h.get("VALOR_ICMS");
            Double valorContabil = (Double)h.get("VALOR_CONTABIL");
            Double baseCalculo = (Double)h.get("BASE_CALCULO");
            if (linhaDap.equals("026")) {
                this.createLinhaEntradaEstadualLinha26(h, vo, linhaDap, linhasDapi);
                if (linha == null) continue;
                linhasDapi.add(linha);
                linha26Coluna1 = linha26Coluna1 + valorContabil;
                linha26Coluna3 = linha26Coluna3 + valorIcms;
                continue;
            }
            if (linhaDap.equals("027")) {
                this.createLinhaEntradaEstadual(h, vo, linhaDap, linhasDapi);
                if (linha == null) continue;
                linhasDapi.add(linha);
                linha27Coluna1 = linha27Coluna1 + valorContabil;
                linha27Coluna3 = linha27Coluna3 + valorIcms;
                continue;
            }
            if (linhaDap.equals("028")) {
                this.createLinhaEntradaEstadual(h, vo, linhaDap, linhasDapi);
                if (linha == null) continue;
                linhasDapi.add(linha);
                linha28Coluna1 = linha28Coluna1 + valorContabil;
                linha28Coluna3 = linha28Coluna3 + valorIcms;
                continue;
            }
            if (linhaDap.equals("029")) {
                this.createLinhaEntradaEstadual(h, vo, linhaDap, linhasDapi);
                if (linha == null) continue;
                linhasDapi.add(linha);
                linha29Coluna1 = linha29Coluna1 + valorContabil;
                linha29Coluna3 = linha29Coluna3 + valorIcms;
                continue;
            }
            if (linhaDap.equals("030")) {
                this.createLinhaEntradaEstadual(h, vo, linhaDap, linhasDapi);
                if (linha == null) continue;
                linhasDapi.add(linha);
                linha30Coluna1 = linha30Coluna1 + valorContabil;
                linha30Coluna3 = linha30Coluna3 + valorIcms;
                continue;
            }
            if (linhaDap.equals("031")) {
                this.createLinhaEntradaEstadual(h, vo, linhaDap, linhasDapi);
                if (linha == null) continue;
                linhasDapi.add(linha);
                linha31Coluna1 = linha31Coluna1 + valorContabil;
                linha31Coluna3 = linha31Coluna3 + valorIcms;
                continue;
            }
            if (linhaDap.equals("032")) {
                this.createLinhaEntradaEstadual(h, vo, linhaDap, linhasDapi);
                if (linha == null) continue;
                linhasDapi.add(linha);
                linha32Coluna1 = linha32Coluna1 + valorContabil;
                linha32Coluna3 = linha32Coluna3 + valorIcms;
                continue;
            }
            if (linhaDap.equals("033")) {
                this.createLinhaEntradaEstadual(h, vo, linhaDap, linhasDapi);
                if (linha == null) continue;
                linhasDapi.add(linha);
                linha33Coluna1 = linha33Coluna1 + valorContabil;
                linha33Coluna3 = linha33Coluna3 + valorIcms;
                continue;
            }
            if (!linhaDap.equals("034")) continue;
            this.createLinhaEntradaEstadual34(h, vo, linhaDap, linhasDapi);
            if (linha == null) continue;
            linhasDapi.add(linha);
            linha34Coluna1 = linha34Coluna1 + valorContabil;
            linha34Coluna3 = linha34Coluna3 + valorIcms;
        }
        linha = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "026", "01", this.formatarValor(linha26Coluna1));
        linhasDapi.add(linha);
        linha = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "026", "03", this.formatarValor(linha26Coluna3));
        linhasDapi.add(linha);
        linha = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "027", "01", this.formatarValor(linha27Coluna1));
        linhasDapi.add(linha);
        linha = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "027", "03", this.formatarValor(linha27Coluna3));
        linhasDapi.add(linha);
        linha = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "028", "01", this.formatarValor(linha28Coluna1));
        linhasDapi.add(linha);
        linha = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "028", "03", this.formatarValor(linha28Coluna3));
        linhasDapi.add(linha);
        linha = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "029", "01", this.formatarValor(linha29Coluna1));
        linhasDapi.add(linha);
        linha = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "029", "03", this.formatarValor(linha29Coluna3));
        linhasDapi.add(linha);
        linha = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "030", "01", this.formatarValor(linha30Coluna1));
        linhasDapi.add(linha);
        linha = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "030", "03", this.formatarValor(linha30Coluna3));
        linhasDapi.add(linha);
        linha = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "031", "01", this.formatarValor(linha31Coluna1));
        linhasDapi.add(linha);
        linha = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "031", "03", this.formatarValor(linha31Coluna3));
        linhasDapi.add(linha);
        linha = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "032", "01", this.formatarValor(linha32Coluna1));
        linhasDapi.add(linha);
        linha = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "032", "03", this.formatarValor(linha32Coluna3));
        linhasDapi.add(linha);
        linha = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "033", "01", this.formatarValor(linha33Coluna1));
        linhasDapi.add(linha);
        linha = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "033", "03", this.formatarValor(linha33Coluna3));
        linhasDapi.add(linha);
        linha = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "034", "01", this.formatarValor(linha34Coluna1));
        linhasDapi.add(linha);
        linha = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "034", "03", this.formatarValor(linha34Coluna3));
        linhasDapi.add(linha);
        return linhasDapi;
    }

    private List<LinhaTipo10> separarValoresEntradaExterior(List hash, GeracaoDapi vo) {
        ArrayList<LinhaTipo10> linhasDapi = new ArrayList<LinhaTipo10>();
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        Double linha36Coluna3 = 0.0;
        Double linha36Coluna1 = 0.0;
        Double linha37Coluna3 = 0.0;
        Double linha37Coluna1 = 0.0;
        Double linha38Coluna3 = 0.0;
        Double linha38Coluna1 = 0.0;
        Double linha39Coluna3 = 0.0;
        Double linha39Coluna1 = 0.0;
        Double linha40Coluna3 = 0.0;
        Double linha40Coluna1 = 0.0;
        Double linha41Coluna3 = 0.0;
        Double linha41Coluna1 = 0.0;
        LinhaTipo10 linha = null;
        for (Object obj : hash) {
            HashMap h = (HashMap)obj;
            String linhaDap = (String)h.get("LINHA_DAPI");
            String cst = (String)h.get("CST");
            Double valorIcms = (Double)h.get("VALOR_ICMS");
            Double valorContabil = (Double)h.get("VALOR_CONTABIL");
            Double baseCalculo = (Double)h.get("BASE_CALCULO");
            if (linhaDap.equals("036")) {
                this.createLinhaEntradaEstadual(h, vo, linhaDap, linhasDapi);
                if (linha == null) continue;
                linhasDapi.add(linha);
                linha36Coluna1 = linha36Coluna1 + valorContabil;
                linha36Coluna3 = linha36Coluna3 + valorIcms;
                continue;
            }
            if (linhaDap.equals("037")) {
                this.createLinhaEntradaEstadual(h, vo, linhaDap, linhasDapi);
                if (linha == null) continue;
                linhasDapi.add(linha);
                linha37Coluna1 = linha37Coluna1 + valorContabil;
                linha37Coluna3 = linha37Coluna3 + valorIcms;
                continue;
            }
            if (linhaDap.equals("038")) {
                this.createLinhaEntradaEstadual(h, vo, linhaDap, linhasDapi);
                if (linha == null) continue;
                linhasDapi.add(linha);
                linha38Coluna1 = linha38Coluna1 + valorContabil;
                linha38Coluna3 = linha38Coluna3 + valorIcms;
                continue;
            }
            if (linhaDap.equals("039")) {
                this.createLinhaEntradaEstadual(h, vo, linhaDap, linhasDapi);
                if (linha == null) continue;
                linhasDapi.add(linha);
                linha39Coluna1 = linha39Coluna1 + valorContabil;
                linha39Coluna3 = linha39Coluna3 + valorIcms;
                continue;
            }
            if (linhaDap.equals("040")) {
                this.createLinhaEntradaEstadual(h, vo, linhaDap, linhasDapi);
                if (linha == null) continue;
                linhasDapi.add(linha);
                linha40Coluna1 = linha40Coluna1 + valorContabil;
                linha40Coluna3 = linha40Coluna3 + valorIcms;
                continue;
            }
            if (!linhaDap.equals("041")) continue;
            this.createLinhaEntradaEstadual(h, vo, linhaDap, linhasDapi);
            if (linha == null) continue;
            linhasDapi.add(linha);
            linha41Coluna1 = linha41Coluna1 + valorContabil;
            linha41Coluna3 = linha41Coluna3 + valorIcms;
        }
        linha = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "036", "01", this.formatarValor(linha36Coluna1));
        this.tLinha1 = this.tLinha1 + linha36Coluna1;
        linhasDapi.add(linha);
        linha = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "036", "03", this.formatarValor(linha36Coluna3));
        this.tLinha3 = this.tLinha3 + linha36Coluna3;
        linhasDapi.add(linha);
        linha = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "037", "01", this.formatarValor(linha37Coluna1));
        this.tLinha1 = this.tLinha1 + linha37Coluna1;
        linhasDapi.add(linha);
        linha = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "037", "03", this.formatarValor(linha37Coluna3));
        this.tLinha3 = this.tLinha3 + linha37Coluna3;
        linhasDapi.add(linha);
        linha = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "038", "01", this.formatarValor(linha38Coluna1));
        this.tLinha1 = this.tLinha1 + linha38Coluna1;
        linhasDapi.add(linha);
        linha = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "038", "03", this.formatarValor(linha38Coluna3));
        this.tLinha3 = this.tLinha3 + linha38Coluna3;
        linhasDapi.add(linha);
        linha = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "039", "01", this.formatarValor(linha39Coluna1));
        this.tLinha1 = this.tLinha1 + linha39Coluna1;
        linhasDapi.add(linha);
        linha = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "039", "03", this.formatarValor(linha39Coluna3));
        this.tLinha3 = this.tLinha3 + linha39Coluna3;
        linhasDapi.add(linha);
        linha = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "040", "01", this.formatarValor(linha40Coluna1));
        this.tLinha1 = this.tLinha1 + linha40Coluna1;
        linhasDapi.add(linha);
        linha = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "040", "03", this.formatarValor(linha40Coluna3));
        this.tLinha3 = this.tLinha3 + linha40Coluna3;
        linhasDapi.add(linha);
        linha = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "041", "01", this.formatarValor(linha41Coluna1));
        this.tLinha1 = this.tLinha1 + linha41Coluna1;
        linhasDapi.add(linha);
        linha = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "041", "03", this.formatarValor(linha41Coluna3));
        this.tLinha3 = this.tLinha3 + linha41Coluna3;
        linhasDapi.add(linha);
        return linhasDapi;
    }

    private void createBloco66(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "066", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void escreverLinha(LinhaTipo10 linha10, PrintWriter p) {
        p.append("10");
        p.append(linha10.getInscricaoEstadualContribuinte());
        p.append(linha10.getAnoReferencia());
        p.append(linha10.getMesReferencia());
        p.append(linha10.getDiaFinalReferencia());
        p.append(linha10.getDiaInicialReferencia());
        p.append(linha10.getIdentificacaoLinha());
        p.append(linha10.getIdentificacaoColuna());
        p.append(linha10.getValorDeclarado());
        p.append(this.getFinalLine());
    }

    private void createBloco67(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "067", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco68(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "068", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco69(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "069", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco70(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "070", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco71(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "071", "00", this.formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco72(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "072", "00", this.formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco73(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "073", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco74(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "074", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco75(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "075", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco76(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "076", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco77(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "077", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco78(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "078", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco79(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "079", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco80(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "080", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco81(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "081", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco82(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "082", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco83(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "083", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco84(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "084", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco85(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "085", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco86(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "086", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco87(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "087", "00", this.formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco88(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "088", "00", this.formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco89(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "089", "00", this.formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco90(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "090", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco91(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "091", "00", this.formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco92(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        Double campo92 = this.campo91 - (this.campo93 + this.campo94 + this.campo95);
        if (campo92 <= 0.0) {
            campo92 = 0.0;
        }
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "092", "00", this.formatarValor(campo92));
        this.escreverLinha(l, p);
    }

    private void createBloco93(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "093", "00", this.formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco94(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "094", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco95(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "095", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco96(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "096", "00", this.formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco97(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "097", "00", this.formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco98(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "098", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco99(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "099", "00", this.formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco100(GeracaoDapi vo, PrintWriter p) {
        Double retorno;
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " select coalesce(sum(i.vrDifAliquota),0)  from ItemNotaLivroFiscal i  where  i.itemNotaTerceiros.notaFiscalTerceiros.dataEntrada between :dataInicial and :dataFinal ";
        this.campo100 = retorno = (Double)CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("dataInicial", vo.getDataInicial()).setDate("dataFinal", vo.getDataFinal()).uniqueResult();
        if (this.campo100 == null) {
            this.campo100 = 0.0;
        }
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "100", "00", this.formatarValor(retorno));
        this.escreverLinha(l, p);
    }

    private void createBloco101(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "101", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco102(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "102", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco103(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "103", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco104(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "104", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco105(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "105", "00", this.formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco106(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "106", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco107(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "107", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco108(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "108", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco109(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "109", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco110(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "110", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco111(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "111", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco112(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "112", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco113(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "113", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco114(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "114", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco115(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "115", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco116(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "116", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco117(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "117", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco118(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "118", "00", this.formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createLinhaTotalizador(String inscricao, String linha, List<LinhaTipo10> linhas) {
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(this.tLinha1));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "02", this.formatarValor(this.tLinha2));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "03", this.formatarValor(this.tLinha3));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "04", this.formatarValor(this.tLinha4));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "05", this.formatarValor(this.tLinha5));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "06", this.formatarValor(this.tLinha6));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "07", this.formatarValor(this.tLinha7));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "08", this.formatarValor(this.tLinha8));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "09", this.formatarValor(this.tLinha9));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "10", this.formatarValor(this.tLinha10));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "11", this.formatarValor(this.tLinha11));
        linhas.add(l);
    }

    private void zerarTotalizador() {
        this.tLinha1 = 0.0;
        this.tLinha2 = 0.0;
        this.tLinha3 = 0.0;
        this.tLinha4 = 0.0;
        this.tLinha5 = 0.0;
        this.tLinha6 = 0.0;
        this.tLinha7 = 0.0;
        this.tLinha8 = 0.0;
        this.tLinha9 = 0.0;
        this.tLinha10 = 0.0;
        this.tLinha11 = 0.0;
    }

    private void totalizarGeral() {
        this.geral1 = this.geral1 + this.tLinha1;
        this.geral2 = this.geral2 + this.tLinha2;
        this.geral3 = this.geral3 + this.tLinha3;
        this.geral4 = this.geral4 + this.tLinha4;
        this.geral5 = this.geral5 + this.tLinha5;
        this.geral6 = this.geral6 + this.tLinha6;
        this.geral7 = this.geral7 + this.tLinha7;
        this.geral8 = this.geral8 + this.tLinha8;
        this.geral9 = this.geral9 + this.tLinha9;
        this.geral10 = this.geral10 + this.tLinha10;
        this.geral11 = this.geral11 + this.tLinha11;
    }

    private void createLinhaTotalizadorGeral(String inscricao, String linha, List<LinhaTipo10> linhas) {
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(this.geral1));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "02", this.formatarValor(this.geral2));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "03", this.formatarValor(this.geral3));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "04", this.formatarValor(this.geral4));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "05", this.formatarValor(this.geral5));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "06", this.formatarValor(this.geral6));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "07", this.formatarValor(this.geral7));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "08", this.formatarValor(this.geral8));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "09", this.formatarValor(this.geral9));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "10", this.formatarValor(this.geral10));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "11", this.formatarValor(this.geral11));
        linhas.add(l);
    }

    private void createTotalizadorSaida(String inscricao, String linha, List<LinhaTipo10> linhas) {
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(this.tLinha1));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "02", this.formatarValor(this.tLinha2));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "03", this.formatarValor(this.tLinha3));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "04", this.formatarValor(this.tLinha4));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "05", this.formatarValor(this.tLinha5));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "06", this.formatarValor(this.tLinha6));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "07", this.formatarValor(this.tLinha7));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "08", this.formatarValor(this.tLinha8));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "09", this.formatarValor(this.tLinha9));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "10", this.formatarValor(this.tLinha10));
        linhas.add(l);
    }

    private void createLinhaTotalizadorGeralSaida(String inscricao, String linha, List<LinhaTipo10> linhas) {
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(this.geral1));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "02", this.formatarValor(this.geral2));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "03", this.formatarValor(this.geral3));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "04", this.formatarValor(this.geral4));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "05", this.formatarValor(this.geral5));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "06", this.formatarValor(this.geral6));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "07", this.formatarValor(this.geral7));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "08", this.formatarValor(this.geral8));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "09", this.formatarValor(this.geral9));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "10", this.formatarValor(this.geral10));
        linhas.add(l);
    }

    private void zerarCamposGeral() {
        this.geral1 = 0.0;
        this.geral2 = 0.0;
        this.geral3 = 0.0;
        this.geral4 = 0.0;
        this.geral5 = 0.0;
        this.geral6 = 0.0;
        this.geral7 = 0.0;
        this.geral8 = 0.0;
        this.geral9 = 0.0;
        this.geral10 = 0.0;
        this.geral11 = 0.0;
    }

    private boolean existeLinhaTabela(LinhaTipo10 l, List<LinhaTipo10> linhasDapi) {
        for (LinhaTipo10 linhaTabela : linhasDapi) {
            if (!linhaTabela.getIdentificacaoColuna().equals(l.getIdentificacaoColuna()) || !linhaTabela.getIdentificacaoLinha().equals(l.getIdentificacaoLinha())) continue;
            Double valor = this.getValorString(l.getValorDeclarado().substring(0, 13), l.getValorDeclarado().substring(13, 15)) + this.getValorString(linhaTabela.getValorDeclarado().substring(0, 13), linhaTabela.getValorDeclarado().substring(13, 15));
            linhaTabela.setValorDeclarado(this.formatarValor(valor));
            return true;
        }
        return false;
    }

    private Double getValorString(String valorInteiro, String valorDecimal) {
        return new Double(valorInteiro + "." + valorDecimal);
    }

    private ApuracaoICMS getApuracaoICMS(Date dataInicial, Empresa empresa) {
        String hql = " from ApuracaoICMS apuracao  where  apuracao.anoMes = :dataInicial  and  apuracao.empresa = :empresa ";
        return (ApuracaoICMS)CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("dataInicial", dataInicial).setEntity("empresa", (Object)empresa).uniqueResult();
    }

    private void createLinhaEntradaEstadualLinha26(HashMap h, GeracaoDapi vo, String linha, List<LinhaTipo10> linhasDapi) {
        LinhaTipo10 l;
        String cst = (String)h.get("CST");
        Double baseCalculo = (Double)h.get("BASE_CALCULO");
        Double icmsIsento = (Double)h.get("ICMS_ISENTO");
        Double icmsOutros = (Double)h.get("ICMS_OUTROS");
        Double valorIcms = (Double)h.get("VALOR_ICMS");
        Double valorContabil = (Double)h.get("VALOR_CONTABIL");
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        if (cst.equals("000") || cst.equals("020")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "02", this.formatarValor(baseCalculo));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "03", this.formatarValor(valorIcms));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(valorContabil));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            if (!this.existeLinhaTabela(l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "11", this.formatarValor(icmsOutros)), linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha1 = this.tLinha1 + valorContabil;
            this.tLinha2 = this.tLinha2 + baseCalculo;
            this.tLinha3 = this.tLinha3 + valorIcms;
            this.tLinha11 = this.tLinha11 + icmsOutros;
        }
        if (cst.equals("020") || cst.equals("090")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "06", this.formatarValor(icmsIsento));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsIsento));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha6 = this.tLinha6 + icmsIsento;
            this.tLinha1 = this.tLinha1 + icmsIsento;
        }
        if (cst.equals("040")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "05", this.formatarValor(icmsIsento));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsIsento));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha5 = this.tLinha5 + icmsIsento;
            this.tLinha1 = this.tLinha1 + icmsIsento;
        }
        if (cst.equals("041")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "11", this.formatarValor(icmsOutros));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            if (!this.existeLinhaTabela(l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(valorContabil)), linhasDapi)) {
                linhasDapi.add(l);
            }
            if (!this.existeLinhaTabela(l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "06", this.formatarValor(icmsIsento)), linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha1 = this.tLinha1 + valorContabil;
            this.tLinha6 = this.tLinha6 + icmsIsento;
            this.tLinha11 = this.tLinha11 + icmsOutros;
        }
        if (cst.equals("050")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "09", this.formatarValor(icmsOutros));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsOutros));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha1 = this.tLinha1 + icmsOutros;
            this.tLinha9 = this.tLinha9 + icmsOutros;
        }
        if (cst.equals("051")) {
            // empty if block
        }
        if (cst.equals("060")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "10", this.formatarValor(icmsOutros));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsOutros));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha10 = this.tLinha10 + icmsOutros;
            this.tLinha1 = this.tLinha1 + icmsOutros;
        }
        if (cst.equals("090")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "11", this.formatarValor(icmsOutros));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            if (!this.existeLinhaTabela(l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(valorContabil)), linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha11 = this.tLinha11 + icmsOutros;
            this.tLinha1 = this.tLinha1 + valorContabil;
        }
    }

    private void createLinhaEntradaEstadual16(HashMap h, GeracaoDapi vo, String linha, List<LinhaTipo10> linhasDapi) {
        LinhaTipo10 l;
        String cst = (String)h.get("CST");
        Double baseCalculo = (Double)h.get("BASE_CALCULO");
        Double icmsIsento = (Double)h.get("ICMS_ISENTO");
        Double icmsOutros = (Double)h.get("ICMS_OUTROS");
        Double valorIcms = (Double)h.get("VALOR_ICMS");
        Double valorContabil = (Double)h.get("VALOR_CONTABIL");
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        if (cst.equals("000") || cst.equals("020")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "02", this.formatarValor(baseCalculo));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "03", this.formatarValor(valorIcms));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(valorContabil));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            if (!this.existeLinhaTabela(l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "11", this.formatarValor(icmsOutros)), linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha1 = this.tLinha1 + valorContabil;
            this.tLinha2 = this.tLinha2 + baseCalculo;
            this.tLinha3 = this.tLinha3 + valorIcms;
            this.tLinha11 = this.tLinha11 + icmsOutros;
        }
        if (cst.equals("020") || cst.equals("090")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "06", this.formatarValor(icmsIsento));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(valorContabil));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha6 = this.tLinha6 + icmsIsento;
            this.tLinha1 = this.tLinha1 + icmsIsento;
        }
        if (cst.equals("040")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "05", this.formatarValor(icmsIsento));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsIsento));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha5 = this.tLinha5 + icmsIsento;
            this.tLinha1 = this.tLinha1 + icmsIsento;
        }
        if (cst.equals("041")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "11", this.formatarValor(icmsOutros));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            if (!this.existeLinhaTabela(l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(valorContabil)), linhasDapi)) {
                linhasDapi.add(l);
            }
            if (!this.existeLinhaTabela(l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "06", this.formatarValor(icmsIsento)), linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha1 = this.tLinha1 + valorContabil;
            this.tLinha6 = this.tLinha6 + icmsIsento;
            this.tLinha11 = this.tLinha11 + icmsOutros;
        }
        if (cst.equals("050")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "09", this.formatarValor(icmsOutros));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsOutros));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha1 = this.tLinha1 + icmsOutros;
            this.tLinha9 = this.tLinha9 + icmsOutros;
        }
        if (cst.equals("051")) {
            // empty if block
        }
        if (cst.equals("060")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "10", this.formatarValor(icmsOutros));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsOutros));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha10 = this.tLinha10 + icmsOutros;
            this.tLinha1 = this.tLinha1 + icmsOutros;
        }
        if (cst.equals("090")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "11", this.formatarValor(icmsOutros));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            if (!this.existeLinhaTabela(l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsOutros)), linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha11 = this.tLinha11 + icmsOutros;
            this.tLinha1 = this.tLinha1 + icmsOutros;
        }
    }

    private void createLinhaEntradaEstadual34(HashMap h, GeracaoDapi vo, String linha, List<LinhaTipo10> linhasDapi) {
        LinhaTipo10 l;
        String cst = (String)h.get("CST");
        Double baseCalculo = (Double)h.get("BASE_CALCULO");
        Double icmsIsento = (Double)h.get("ICMS_ISENTO");
        Double icmsOutros = (Double)h.get("ICMS_OUTROS");
        Double valorIcms = (Double)h.get("VALOR_ICMS");
        Double valorContabil = (Double)h.get("VALOR_CONTABIL");
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        if (cst.equals("000") || cst.equals("020")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "02", this.formatarValor(baseCalculo));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "03", this.formatarValor(valorIcms));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(valorContabil));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            if (!this.existeLinhaTabela(l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "11", this.formatarValor(icmsOutros)), linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha1 = this.tLinha1 + valorContabil;
            this.tLinha2 = this.tLinha2 + baseCalculo;
            this.tLinha3 = this.tLinha3 + valorIcms;
            this.tLinha11 = this.tLinha11 + icmsOutros;
        }
        if (cst.equals("020") || cst.equals("090")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "06", this.formatarValor(icmsIsento));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(valorContabil));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha6 = this.tLinha6 + icmsIsento;
            this.tLinha1 = this.tLinha1 + icmsIsento;
        }
        if (cst.equals("040")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "05", this.formatarValor(icmsIsento));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsIsento));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha5 = this.tLinha5 + icmsIsento;
            this.tLinha1 = this.tLinha1 + icmsIsento;
        }
        if (cst.equals("041")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "11", this.formatarValor(icmsOutros));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            if (!this.existeLinhaTabela(l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(valorContabil)), linhasDapi)) {
                linhasDapi.add(l);
            }
            if (!this.existeLinhaTabela(l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "06", this.formatarValor(icmsIsento)), linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha1 = this.tLinha1 + valorContabil;
            this.tLinha6 = this.tLinha6 + icmsIsento;
            this.tLinha11 = this.tLinha11 + icmsOutros;
        }
        if (cst.equals("050")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "09", this.formatarValor(icmsOutros));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsOutros));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha1 = this.tLinha1 + icmsOutros;
            this.tLinha9 = this.tLinha9 + icmsOutros;
        }
        if (cst.equals("051")) {
            // empty if block
        }
        if (cst.equals("060")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "10", this.formatarValor(icmsOutros));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsOutros));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha10 = this.tLinha10 + icmsOutros;
            this.tLinha1 = this.tLinha1 + icmsOutros;
        }
        if (cst.equals("090")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "11", this.formatarValor(icmsOutros));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            if (!this.existeLinhaTabela(l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(valorContabil)), linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha11 = this.tLinha11 + icmsOutros;
            this.tLinha1 = this.tLinha1 + icmsOutros;
        }
    }

    private void createLinhaEntradaEstadual23(HashMap h, GeracaoDapi vo, String linha, List<LinhaTipo10> linhasDapi) {
        LinhaTipo10 l;
        String cst = (String)h.get("CST");
        Double baseCalculo = (Double)h.get("BASE_CALCULO");
        Double icmsIsento = (Double)h.get("ICMS_ISENTO");
        Double icmsOutros = (Double)h.get("ICMS_OUTROS");
        Double valorIcms = (Double)h.get("VALOR_ICMS");
        Double valorContabil = (Double)h.get("VALOR_CONTABIL");
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        if (cst.equals("000") || cst.equals("020")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "02", this.formatarValor(baseCalculo));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "03", this.formatarValor(valorIcms));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(valorContabil));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha1 = this.tLinha1 + valorContabil;
            this.tLinha2 = this.tLinha2 + baseCalculo;
            this.tLinha3 = this.tLinha3 + valorIcms;
        }
        if (cst.equals("020") || cst.equals("090")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "06", this.formatarValor(icmsIsento));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsIsento));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha6 = this.tLinha6 + icmsIsento;
            this.tLinha1 = this.tLinha1 + icmsIsento;
        }
        if (cst.equals("040")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "05", this.formatarValor(icmsIsento));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsIsento));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha5 = this.tLinha5 + icmsIsento;
            this.tLinha1 = this.tLinha1 + icmsIsento;
        }
        if (cst.equals("041")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "11", this.formatarValor(icmsOutros));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            if (!this.existeLinhaTabela(l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(valorContabil)), linhasDapi)) {
                linhasDapi.add(l);
            }
            if (!this.existeLinhaTabela(l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "06", this.formatarValor(icmsIsento)), linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha1 = this.tLinha1 + valorContabil;
            this.tLinha6 = this.tLinha6 + icmsIsento;
            this.tLinha11 = this.tLinha11 + icmsOutros;
        }
        if (cst.equals("050")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "09", this.formatarValor(icmsOutros));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsOutros));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha1 = this.tLinha1 + icmsOutros;
            this.tLinha9 = this.tLinha9 + icmsOutros;
        }
        if (cst.equals("051")) {
            // empty if block
        }
        if (cst.equals("060")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "11", this.formatarValor(icmsOutros));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            if (!this.existeLinhaTabela(l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsOutros)), linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha11 = this.tLinha11 + icmsOutros;
            this.tLinha1 = this.tLinha1 + icmsOutros;
        }
        if (cst.equals("090") || cst.equals("000")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "11", this.formatarValor(icmsOutros));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            if (!this.existeLinhaTabela(l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsOutros)), linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha11 = this.tLinha11 + icmsOutros;
            this.tLinha1 = this.tLinha1 + icmsOutros;
        }
    }

    private void createLinhaEntradaEstadual24(HashMap h, GeracaoDapi vo, String linha, List<LinhaTipo10> linhasDapi) {
        LinhaTipo10 l;
        String cst = (String)h.get("CST");
        Double baseCalculo = (Double)h.get("BASE_CALCULO");
        Double icmsIsento = (Double)h.get("ICMS_ISENTO");
        Double icmsOutros = (Double)h.get("ICMS_OUTROS");
        Double valorIcms = (Double)h.get("VALOR_ICMS");
        Double valorContabil = (Double)h.get("VALOR_CONTABIL");
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        if (cst.equals("000") || cst.equals("020")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "02", this.formatarValor(baseCalculo));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "03", this.formatarValor(valorIcms));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(valorContabil));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha1 = this.tLinha1 + valorContabil;
            this.tLinha2 = this.tLinha2 + baseCalculo;
            this.tLinha3 = this.tLinha3 + valorIcms;
        }
        if (cst.equals("020") || cst.equals("090")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "06", this.formatarValor(icmsIsento));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha6 = this.tLinha6 + icmsIsento;
        }
        if (cst.equals("040")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "05", this.formatarValor(icmsIsento));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            if (!this.existeLinhaTabela(l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsIsento)), linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha5 = this.tLinha5 + icmsIsento;
            this.tLinha1 = this.tLinha1 + icmsIsento;
        }
        if (cst.equals("041")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "11", this.formatarValor(icmsOutros));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            if (!this.existeLinhaTabela(l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(valorContabil)), linhasDapi)) {
                linhasDapi.add(l);
            }
            if (!this.existeLinhaTabela(l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "06", this.formatarValor(icmsIsento)), linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha1 = this.tLinha1 + valorContabil;
            this.tLinha6 = this.tLinha6 + icmsIsento;
            this.tLinha11 = this.tLinha11 + icmsOutros;
        }
        if (cst.equals("050")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "09", this.formatarValor(icmsOutros));
            linhasDapi.add(l);
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsOutros));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha1 = this.tLinha1 + icmsOutros;
            this.tLinha9 = this.tLinha9 + icmsOutros;
        }
        if (cst.equals("051")) {
            // empty if block
        }
        if (cst.equals("060")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "10", this.formatarValor(icmsOutros));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            if (!this.existeLinhaTabela(l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(icmsOutros)), linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha10 = this.tLinha10 + icmsOutros;
            this.tLinha1 = this.tLinha1 + icmsOutros;
        }
        if (cst.equals("090") || cst.equals("000")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "11", this.formatarValor(icmsOutros));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha11 = this.tLinha11 + icmsOutros;
        }
        if (cst.equals("090")) {
            l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", this.formatarValor(valorContabil));
            if (!this.existeLinhaTabela(l, linhasDapi)) {
                linhasDapi.add(l);
            }
            this.tLinha1 = this.tLinha1 + valorContabil;
        }
    }
}

