/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.geracaodapi.utility;

import com.touchcomp.basementor.model.vo.AjusteApuracaoIcms;
import com.touchcomp.basementor.model.vo.ApuracaoICMS;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.GeracaoDapi;
import com.touchcomp.basementor.model.vo.SubApuracaoICMS;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.geracaodapi.model.TempAjusteApuracaoIcms;
import mentorcore.service.impl.geracaodapi.model.TempApuracaoIcms;
import mentorcore.service.impl.geracaodapi.model.TempSubApuracaoICMS;
import mentorcore.service.impl.geracaodapi.util.LinhaTipo10;
import mentorcore.service.impl.geracaodapi.utility.UtilityEntradaEstadualDapi;
import mentorcore.service.impl.geracaodapi.utility.UtilityEntradaExterior;
import mentorcore.service.impl.geracaodapi.utility.UtilityEntradaInterEstadual;
import mentorcore.service.impl.geracaodapi.utility.UtilityMetodosPadroes;
import mentorcore.service.impl.geracaodapi.utility.UtilitySaidaEstadual;
import mentorcore.service.impl.geracaodapi.utility.UtilitySaidaExterior;
import mentorcore.service.impl.geracaodapi.utility.UtilitySaidaInterEstadual;
import mentorcore.tools.DateUtil;
import utilities.StringUtil;

public class UtilityGeracaoArquivoDapi {
    HashMap valores = null;
    Integer mesReferencia = null;
    Integer anoReferencia = null;
    Integer diaFinalReferencia = null;
    Integer diaInicialReferencia = null;
    Double geral1 = 0.0;
    Double geral2 = 0.0;
    Double geral3 = 0.0;
    Double geral4 = 0.0;
    Double geral5 = 0.0;
    Double geral6 = 0.0;
    Double geral7 = 0.0;
    Double geral8 = 0.0;
    Double geral9 = 0.0;
    Double geral10 = 0.0;
    Double geral11 = 0.0;
    Double campo100 = 0.0;
    Double campo111 = 0.0;
    Long contadorLinhas = 1L;

    public void geracaoArquivoDAPI(GeracaoDapi vo, File arquivo) throws ExceptionService, IOException {
        ApuracaoICMS apuracao;
        if (arquivo.exists()) {
            arquivo.delete();
        }
        if ((apuracao = this.getApuracaoICMS(vo.getDataInicial(), vo.getEmpresa())) == null) {
            throw new ExceptionService("Primeiro, crie uma apura\u00e7\u00e3o de ICMS.");
        }
        TempApuracaoIcms tempApuracao = this.convertApuracaoIcms(apuracao);
        this.valores = new HashMap();
        this.valores.put("mesReferencia", DateUtil.monthFromDate(vo.getDataInicial()));
        this.valores.put("anoReferencia", DateUtil.yearFromDate(vo.getDataInicial()));
        this.valores.put("diaInicial", DateUtil.dayFromDate(vo.getDataInicial()));
        this.valores.put("diaFinal", DateUtil.dayFromDate(vo.getDataFinal()));
        this.mesReferencia = DateUtil.monthFromDate(vo.getDataInicial());
        this.anoReferencia = DateUtil.yearFromDate(vo.getDataInicial());
        this.diaFinalReferencia = DateUtil.dayFromDate(vo.getDataFinal());
        this.diaInicialReferencia = DateUtil.dayFromDate(vo.getDataInicial());
        this.createBloco0(vo, arquivo);
        this.createBloco10(vo, arquivo, tempApuracao);
        this.createBloco22(vo, arquivo, tempApuracao);
        this.createBloco23(vo, arquivo, tempApuracao);
        this.createBloco27(vo, arquivo);
        this.createBloco29(vo, arquivo, tempApuracao);
        this.createBloco99(vo, arquivo);
    }

    private ApuracaoICMS getApuracaoICMS(Date dataInicial, Empresa empresa) {
        String hql = " from ApuracaoICMS apuracao  where  apuracao.anoMes = :dataInicial  and  apuracao.empresa = :empresa  and  apuracao.tipoApuracao = :icmsNormal";
        return (ApuracaoICMS)CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("dataInicial", dataInicial).setShort("icmsNormal", (short)0).setEntity("empresa", (Object)empresa).uniqueResult();
    }

    private void createBloco0(GeracaoDapi vo, File file) throws IOException {
        FileWriter fileWriter = new FileWriter(file, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco00(p, vo);
        p.flush();
        p.close();
    }

    private void createBloco99(GeracaoDapi vo, File file) throws IOException {
        FileWriter fileWriter = new FileWriter(file, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco99(p, vo);
        p.flush();
        p.close();
    }

    private void writterBloco99(PrintWriter p, GeracaoDapi vo) {
        p.append("99");
        p.append(this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13));
        p.append(this.getFormatedNumero(this.valores.get("anoReferencia"), 0, 4));
        p.append(this.getFormatedNumero(this.valores.get("mesReferencia"), 0, 2));
        p.append(this.getFormatedNumero(this.valores.get("diaFinal"), 0, 2));
        p.append(this.getFormatedNumero(this.valores.get("diaInicial"), 0, 2));
        p.append(this.getFormatedStringZeros(this.contadorLinhas.toString(), 4));
    }

    private void writterBloco00(PrintWriter p, GeracaoDapi vo) {
        Empresa empresa = vo.getEmpresa();
        p.append("00");
        p.append(this.getFormatedStringZeros(this.getClearString(empresa.getPessoa().getComplemento().getInscEst()), 13));
        p.append(this.getFormatedNumero(this.valores.get("anoReferencia"), 0, 4));
        p.append(this.getFormatedNumero(this.valores.get("mesReferencia"), 0, 2));
        p.append(this.getFormatedNumero(this.valores.get("diaFinal"), 0, 2));
        p.append(this.getFormatedNumero(this.valores.get("diaInicial"), 0, 2));
        p.append("D1");
        p.append(this.getSimOrNao(vo.getTipoArquivo()));
        p.append(this.getFormatedStringZeros("0", 7));
        p.append(this.getFormatedStringZeros("0", 2));
        p.append(this.getFormatedStringZeros(vo.getRegimeRecolhimento().getCodigo(), 2));
        p.append(this.getSimOrNao(vo.getRegimeEspecialFiscalizacao()));
        if (vo.getDataPagamento() == null) {
            p.append("00000000");
        } else {
            p.append(this.getFormatedDate(vo.getDataPagamento()));
        }
        p.append(this.getSimOrNao(vo.getOptanteFundese()));
        p.append(this.getSimOrNao(vo.getDapiMovimento()));
        p.append("N");
        p.append(this.getFormatedStringZeros(vo.getEmpresa().getEmpresaDados().getCnae().getCodigo(), 7));
        if (vo.getEmpresa().getEmpresaDados().getCnae().getDesmembramento() != null && vo.getEmpresa().getEmpresaDados().getCnae().getDesmembramento().length() > 0) {
            p.append(this.getFormatedStringZeros(vo.getEmpresa().getEmpresaDados().getCnae().getDesmembramento(), 2));
        } else {
            p.append("00");
        }
        p.append(this.getSimOrNao(vo.getTermoAceite()));
        p.append(this.getFinalLine());
    }

    public String getFormatedStringZeros(String st, int numeroCasas) {
        if (st == null) {
            st = "";
        }
        if (st.length() > numeroCasas) {
            return st.substring(0, numeroCasas);
        }
        return ToolString.completaZeros((String)st, (int)numeroCasas, (boolean)true);
    }

    public String getFormatedStringVazia(String st, int numeroCasas) {
        if (st == null) {
            st = "";
        }
        if (st.length() > numeroCasas) {
            return st.substring(0, numeroCasas);
        }
        return ToolString.completaEspacos((String)st, (int)numeroCasas, (boolean)false);
    }

    private String getClearString(String st) {
        return ToolString.refina((String)st);
    }

    public String getFormatedNumero(Object obj, int numCasasDecimais, int numCasasInteiras) {
        Number numero = (Number)obj;
        return ToolString.refina((String)ContatoFormatUtil.formataNumero((Number)numero, (int)numCasasDecimais, (int)numCasasInteiras));
    }

    private String getFinalLine() {
        Long l = this.contadorLinhas;
        this.contadorLinhas = this.contadorLinhas + 1L;
        return "\r\n";
    }

    private String getSimOrNao(Short simNao) {
        if (simNao != null && simNao.equals((short)1)) {
            return "S";
        }
        return "N";
    }

    public String getFormatedDate(Date data) {
        return DateUtil.dateToStr(data, "ddMMyyyy");
    }

    private void createBloco10(GeracaoDapi vo, File arquivo, TempApuracaoIcms apuracao) throws IOException, ExceptionService {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.valores = new UtilityEntradaEstadualDapi().createBlocoEntradaEstadual(vo, p, this.valores);
        List<LinhaTipo10> linhasEntradasEstaduais = (List<LinhaTipo10>)this.valores.get("linhasEntradasEstaduais");
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        linhasEntradasEstaduais = this.completarLinhas(linhasEntradasEstaduais, 16, 24, 1, 11, inscricao);
        this.createLinhaTotalizador(inscricao, "025", linhasEntradasEstaduais);
        this.totalizarGeral();
        linhasEntradasEstaduais = new UtilityMetodosPadroes().ordernarLista(linhasEntradasEstaduais);
        this.escreverArquivo(linhasEntradasEstaduais, p);
        this.valores = new UtilityEntradaInterEstadual().createBlocoEntradaInterEstadual(vo, p, this.valores);
        List<LinhaTipo10> linhasEntradasInterEstaduais = (List<LinhaTipo10>)this.valores.get("linhasEntradasInterEstaduais");
        linhasEntradasInterEstaduais = this.completarLinhas(linhasEntradasInterEstaduais, 26, 34, 1, 11, inscricao);
        this.createLinhaTotalizador(inscricao, "035", linhasEntradasInterEstaduais);
        this.totalizarGeral();
        linhasEntradasInterEstaduais = new UtilityMetodosPadroes().ordernarLista(linhasEntradasInterEstaduais);
        this.escreverArquivo(linhasEntradasInterEstaduais, p);
        this.valores = new UtilityEntradaExterior().createBlocoEntradaExterior(vo, p, this.valores);
        List<LinhaTipo10> linhasEntradasExterior = (List<LinhaTipo10>)this.valores.get("linhasEntradasExterior");
        linhasEntradasExterior = this.completarLinhas(linhasEntradasExterior, 36, 41, 1, 11, inscricao);
        this.createLinhaTotalizador(inscricao, "042", linhasEntradasExterior);
        this.totalizarGeral();
        this.createLinhaTotalizadorGeral(inscricao, "043", linhasEntradasExterior);
        linhasEntradasExterior = new UtilityMetodosPadroes().ordernarLista(linhasEntradasExterior);
        this.escreverArquivo(linhasEntradasExterior, p);
        this.zerarCamposGeral();
        this.valores = new UtilitySaidaEstadual().createBlocoSaidaEstadual(vo, p, this.valores);
        List<LinhaTipo10> linhasSaidasEstaduais = (List<LinhaTipo10>)this.valores.get("linhasSaidasEstaduais");
        linhasSaidasEstaduais = this.completarLinhas(linhasSaidasEstaduais, 44, 50, 1, 10, inscricao);
        this.createTotalizadorSaida(inscricao, "051", linhasSaidasEstaduais);
        this.totalizarGeral();
        linhasSaidasEstaduais = new UtilityMetodosPadroes().ordernarLista(linhasSaidasEstaduais);
        this.escreverArquivo(linhasSaidasEstaduais, p);
        this.valores = new UtilitySaidaInterEstadual().createBlocoSaidaInterEstadual(vo, p, this.valores);
        List<LinhaTipo10> linhasSaidas = (List<LinhaTipo10>)this.valores.get("linhasSaidas");
        linhasSaidas = this.completarLinhas(linhasSaidas, 52, 58, 1, 10, inscricao);
        this.createTotalizadorSaida(inscricao, "059", linhasSaidas);
        this.totalizarGeral();
        linhasSaidas = new UtilityMetodosPadroes().ordernarLista(linhasSaidas);
        this.escreverArquivo(linhasSaidas, p);
        this.valores = new UtilitySaidaExterior().createBlocoSaidaExterior(vo, p, this.valores);
        List<LinhaTipo10> linhasSaidaExterior = (List<LinhaTipo10>)this.valores.get("linhasSaidaExterior");
        linhasSaidaExterior = this.completarLinhas(linhasSaidaExterior, 60, 63, 1, 10, inscricao);
        this.createTotalizadorSaida(inscricao, "064", linhasSaidaExterior);
        this.totalizarGeral();
        this.createLinhaTotalizadorGeralSaida(inscricao, "065", linhasSaidaExterior);
        linhasSaidaExterior = new UtilityMetodosPadroes().ordernarLista(linhasSaidaExterior);
        this.escreverArquivo(linhasSaidaExterior, p);
        this.recalcularValoresCreditosDescartadosApuracao(apuracao, vo);
        this.outrosBlocos(vo, p, apuracao);
        p.flush();
        p.close();
    }

    private void createLinhaTotalizador(String inscricao, String linha, List<LinhaTipo10> linhas) {
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", new UtilityMetodosPadroes().formatarValor((Double)this.valores.get("tLinha1")));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "02", new UtilityMetodosPadroes().formatarValor((Double)this.valores.get("tLinha2")));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "03", new UtilityMetodosPadroes().formatarValor((Double)this.valores.get("tLinha3")));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "04", new UtilityMetodosPadroes().formatarValor((Double)this.valores.get("tLinha4")));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "05", new UtilityMetodosPadroes().formatarValor((Double)this.valores.get("tLinha5")));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "06", new UtilityMetodosPadroes().formatarValor((Double)this.valores.get("tLinha6")));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "07", new UtilityMetodosPadroes().formatarValor((Double)this.valores.get("tLinha7")));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "08", new UtilityMetodosPadroes().formatarValor((Double)this.valores.get("tLinha8")));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "09", new UtilityMetodosPadroes().formatarValor((Double)this.valores.get("tLinha9")));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "10", new UtilityMetodosPadroes().formatarValor((Double)this.valores.get("tLinha10")));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "11", new UtilityMetodosPadroes().formatarValor((Double)this.valores.get("tLinha11")));
        linhas.add(l);
    }

    private void totalizarGeral() {
        this.geral1 = this.geral1 + (Double)this.valores.get("tLinha1");
        this.geral2 = this.geral2 + (Double)this.valores.get("tLinha2");
        this.geral3 = this.geral3 + (Double)this.valores.get("tLinha3");
        this.geral4 = this.geral4 + (Double)this.valores.get("tLinha4");
        this.geral5 = this.geral5 + (Double)this.valores.get("tLinha5");
        this.geral6 = this.geral6 + (Double)this.valores.get("tLinha6");
        this.geral7 = this.geral7 + (Double)this.valores.get("tLinha7");
        this.geral8 = this.geral8 + (Double)this.valores.get("tLinha8");
        this.geral9 = this.geral9 + (Double)this.valores.get("tLinha9");
        this.geral10 = this.geral10 + (Double)this.valores.get("tLinha10");
        this.geral11 = this.geral11 + (Double)this.valores.get("tLinha11");
    }

    public List completarLinhas(List<LinhaTipo10> linhasSaidas, Integer linhaInicial, Integer linhaFinal, Integer colunaInicial, Integer colunaFinal, String inscricao) {
        ArrayList<LinhaTipo10> aux = new ArrayList<LinhaTipo10>();
        boolean sair = false;
        boolean achou = false;
        Object colunaParametro = colunaInicial.toString().length() == 1 ? "0" + colunaInicial : colunaInicial.toString();
        String linhaParametro = "0" + linhaInicial;
        do {
            for (LinhaTipo10 linhaDec : linhasSaidas) {
                achou = false;
                String linhaLista = linhaDec.getIdentificacaoLinha();
                String colunaLista = linhaDec.getIdentificacaoColuna();
                colunaParametro = colunaInicial.toString().length() == 1 ? "0" + colunaInicial : colunaInicial.toString();
                linhaParametro = "0" + linhaInicial;
                System.err.println("LISTA = " + linhaLista + "-" + colunaLista);
                System.err.println("PARAMETRO = " + linhaParametro + " - " + (String)colunaParametro);
                if (linhaLista.equals(linhaParametro) && colunaLista.equals(colunaParametro)) {
                    achou = true;
                    aux.add(linhaDec);
                    if (linhaInicial <= linhaFinal) break;
                    sair = true;
                    break;
                }
                if (linhaInicial <= linhaFinal) continue;
                sair = true;
                break;
            }
            if (!achou && !sair) {
                LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linhaParametro, (String)colunaParametro, new UtilityMetodosPadroes().formatarValor(0.0));
                System.err.println(l.getIdentificacaoLinha() + "-" + l.getIdentificacaoColuna());
                aux.add(l);
                linhasSaidas.add(l);
                if (colunaInicial.equals(colunaFinal)) {
                    linhaInicial = linhaInicial + 1;
                    colunaInicial = 1;
                    continue;
                }
                colunaInicial = colunaInicial + 1;
                continue;
            }
            if (colunaInicial.equals(colunaFinal)) {
                linhaInicial = linhaInicial + 1;
                colunaInicial = 1;
                continue;
            }
            colunaInicial = colunaInicial + 1;
        } while (!sair);
        return aux;
    }

    private void escreverArquivo(List<LinhaTipo10> linhasSaidas, PrintWriter p) {
        for (LinhaTipo10 linha10 : linhasSaidas) {
            p.append("10");
            p.append(linha10.getInscricaoEstadualContribuinte());
            p.append(linha10.getAnoReferencia());
            p.append(linha10.getMesReferencia());
            p.append(linha10.getDiaFinalReferencia());
            p.append(linha10.getDiaInicialReferencia());
            p.append(linha10.getIdentificacaoLinha());
            p.append(linha10.getIdentificacaoColuna());
            p.append(linha10.getValorDeclarado());
            p.append(this.getFinalLine());
        }
    }

    private void createLinhaTotalizadorGeral(String inscricao, String linha, List<LinhaTipo10> linhas) {
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", new UtilityMetodosPadroes().formatarValor(this.geral1));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "02", new UtilityMetodosPadroes().formatarValor(this.geral2));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "03", new UtilityMetodosPadroes().formatarValor(this.geral3));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "04", new UtilityMetodosPadroes().formatarValor(this.geral4));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "05", new UtilityMetodosPadroes().formatarValor(this.geral5));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "06", new UtilityMetodosPadroes().formatarValor(this.geral6));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "07", new UtilityMetodosPadroes().formatarValor(this.geral7));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "08", new UtilityMetodosPadroes().formatarValor(this.geral8));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "09", new UtilityMetodosPadroes().formatarValor(this.geral9));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "10", new UtilityMetodosPadroes().formatarValor(this.geral10));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "11", new UtilityMetodosPadroes().formatarValor(this.geral11));
        linhas.add(l);
    }

    private void zerarCamposGeral() {
        this.geral1 = 0.0;
        this.geral2 = 0.0;
        this.geral3 = 0.0;
        this.geral4 = 0.0;
        this.geral5 = 0.0;
        this.geral6 = 0.0;
        this.geral7 = 0.0;
        this.geral8 = 0.0;
        this.geral9 = 0.0;
        this.geral10 = 0.0;
        this.geral11 = 0.0;
    }

    private void createTotalizadorSaida(String inscricao, String linha, List<LinhaTipo10> linhas) {
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", new UtilityMetodosPadroes().formatarValor((Double)this.valores.get("tLinha1")));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "02", new UtilityMetodosPadroes().formatarValor((Double)this.valores.get("tLinha2")));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "03", new UtilityMetodosPadroes().formatarValor((Double)this.valores.get("tLinha3")));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "04", new UtilityMetodosPadroes().formatarValor((Double)this.valores.get("tLinha4")));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "05", new UtilityMetodosPadroes().formatarValor((Double)this.valores.get("tLinha5")));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "06", new UtilityMetodosPadroes().formatarValor((Double)this.valores.get("tLinha6")));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "07", new UtilityMetodosPadroes().formatarValor((Double)this.valores.get("tLinha7")));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "08", new UtilityMetodosPadroes().formatarValor((Double)this.valores.get("tLinha8")));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "09", new UtilityMetodosPadroes().formatarValor((Double)this.valores.get("tLinha9")));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "10", new UtilityMetodosPadroes().formatarValor((Double)this.valores.get("tLinha10")));
        linhas.add(l);
    }

    private void createLinhaTotalizadorGeralSaida(String inscricao, String linha, List<LinhaTipo10> linhas) {
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "01", new UtilityMetodosPadroes().formatarValor(this.geral1));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "02", new UtilityMetodosPadroes().formatarValor(this.geral2));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "03", new UtilityMetodosPadroes().formatarValor(this.geral3));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "04", new UtilityMetodosPadroes().formatarValor(this.geral4));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "05", new UtilityMetodosPadroes().formatarValor(this.geral5));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "06", new UtilityMetodosPadroes().formatarValor(this.geral6));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "07", new UtilityMetodosPadroes().formatarValor(this.geral7));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "08", new UtilityMetodosPadroes().formatarValor(this.geral8));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "09", new UtilityMetodosPadroes().formatarValor(this.geral9));
        linhas.add(l);
        l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), linha, "10", new UtilityMetodosPadroes().formatarValor(this.geral10));
        linhas.add(l);
    }

    private void outrosBlocos(GeracaoDapi vo, PrintWriter p, TempApuracaoIcms a) {
        this.createBloco66(vo, p);
        this.createBloco67(vo, p, a);
        this.createBloco68(vo, p);
        this.createBloco69(vo, p);
        this.createBloco70(vo, p);
        Double valorOutrosCreditos = a.getVrOutroCredito();
        if (vo.getLinhaOutrosCreditos().equals((short)1)) {
            valorOutrosCreditos = 0.0;
        }
        if (vo.getLinhaAjusteCredito().equals((short)0)) {
            this.createBloco71(vo, p, valorOutrosCreditos, a.getValorAjusteCredito());
            this.createBloco72(vo, p, a.getVrOutroCredito() + a.getValorAjusteCredito());
        } else {
            this.createBloco71(vo, p, valorOutrosCreditos, 0.0);
            this.createBloco72(vo, p, a.getVrOutroCredito());
        }
        this.createBloco73(vo, p, 0.0);
        if (vo.getLinhaAjusteDebito().equals((short)0)) {
            this.createBloco74(vo, p, a.getVrOutroDebito(), a.getValorAjusteDebito());
            this.createBloco75(vo, p, a.getVrOutroDebito() + a.getValorAjusteDebito());
        } else {
            this.createBloco74(vo, p, a.getVrOutroDebito(), 0.0);
            this.createBloco75(vo, p, a.getVrOutroDebito());
        }
        this.createBloco76(vo, p);
        this.createBloco77(vo, p);
        this.createBloco78(vo, p);
        this.createBloco79(vo, p);
        this.createBloco80(vo, p);
        this.createBloco81(vo, p);
        this.createBloco82(vo, p);
        this.createBloco83(vo, p);
        this.createBloco84(vo, p);
        this.createBloco85(vo, p);
        this.createBloco86(vo, p);
        this.createBloco87(vo, p, a.getSaldoCredorAnterior());
        this.createBloco88(vo, p, a.getVrCredito());
        if (vo.getLinhaAjusteCredito().equals((short)0)) {
            this.createBloco89(vo, p, a.getVrOutroCredito() + a.getValorAjusteCredito());
            this.createBloco90(vo, p, a.getVrEstornoDebito());
        } else {
            this.createBloco89(vo, p, a.getVrOutroCredito());
            this.createBloco90(vo, p, a.getValorAjusteCredito() + a.getVrEstornoDebito());
        }
        this.createBloco91(vo, p, a.getSaldoCredorAnterior() + a.getVrCredito() + a.getVrOutroCredito() + a.getValorAjusteCredito() + a.getVrEstornoDebito());
        this.createBloco92(vo, p, a);
        this.createBloco93(vo, p, a.getVrDebito());
        if (vo.getLinhaAjusteDebito().equals((short)0)) {
            this.createBloco94(vo, p, a.getVrOutroDebito() + a.getValorAjusteDebito());
            this.createBloco95(vo, p, a.getVrEstornoCredito());
        } else {
            this.createBloco94(vo, p, a.getVrOutroDebito());
            this.createBloco95(vo, p, a.getValorAjusteDebito() + a.getVrEstornoCredito());
        }
        this.createBloco96(vo, p, a.getVrDebito() + a.getValorAjusteDebito() + a.getVrOutroDebito() + a.getVrEstornoCredito());
        this.createBloco97(vo, p, a.getSaldoDevedor());
        this.createBloco98(vo, p);
        this.createBloco99(vo, p, a.getSaldoDevedor());
        this.createBloco100(vo, p, a);
        this.createBloco101(vo, p);
        this.createBloco102(vo, p);
        this.createBloco103(vo, p);
        this.createBloco105(vo, p, a.getSaldoDevedor() + this.campo100 + this.getValorSubObrigacoes(vo, a));
        this.createBloco106(vo, p);
        this.createBloco107(vo, p);
        this.createBloco108(vo, p);
        this.createBloco109(vo, p);
        this.createBloco110(vo, p);
        this.createBloco111(vo, p, (Double)this.valores.get("linha111"));
        this.createBloco112(vo, p);
        this.createBloco113(vo, p);
        this.createBloco114(vo, p);
        this.createBloco115(vo, p);
        this.createBloco116(vo, p);
        this.createBloco117(vo, p);
        this.createBloco118(vo, p);
        this.createBloco123(vo, p, this.getValorSubObrigacoes(vo, a));
        this.createBloco124(vo, p, a.getVrOutroCredito());
        this.createBloco125(vo, p, a.getVrOutroDebito());
        this.createBloco131(vo, p, a.getSaldoDevedor());
        this.createBloco133(vo, p, this.getValorSubObrigacoes(vo, a));
    }

    private void escreverLinha(LinhaTipo10 linha10, PrintWriter p) {
        p.append("10");
        p.append(linha10.getInscricaoEstadualContribuinte());
        p.append(linha10.getAnoReferencia());
        p.append(linha10.getMesReferencia());
        p.append(linha10.getDiaFinalReferencia());
        p.append(linha10.getDiaInicialReferencia());
        p.append(linha10.getIdentificacaoLinha());
        p.append(linha10.getIdentificacaoColuna());
        p.append(linha10.getValorDeclarado());
        p.append(this.getFinalLine());
    }

    private void createBloco66(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "066", "00", new UtilityMetodosPadroes().formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco67(GeracaoDapi vo, PrintWriter p, TempApuracaoIcms ap) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        Double valor = 0.0;
        if (vo.getLinhaOutrosCreditos().equals((short)1)) {
            valor = ap.getVrOutroCredito();
        }
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "067", "00", new UtilityMetodosPadroes().formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco68(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "068", "00", new UtilityMetodosPadroes().formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco69(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "069", "00", new UtilityMetodosPadroes().formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco70(GeracaoDapi vo, PrintWriter p) {
        Double valorRessarcimentoST = this.getValorRessarcimentoST(vo);
        valorRessarcimentoST = 0.0;
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "070", "00", new UtilityMetodosPadroes().formatarValor(valorRessarcimentoST));
        this.escreverLinha(l, p);
    }

    private void createBloco71(GeracaoDapi vo, PrintWriter p, Double valorOutrosCreditos, Double valorAjuste) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        Double valor = valorOutrosCreditos + valorAjuste;
        if (vo.getOutrosCreditosLinha71() != null && vo.getOutrosCreditosLinha71().equals((short)1)) {
            valor = valor - valorOutrosCreditos;
        }
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "071", "00", new UtilityMetodosPadroes().formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco72(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "072", "00", new UtilityMetodosPadroes().formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco73(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "073", "00", new UtilityMetodosPadroes().formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco74(GeracaoDapi vo, PrintWriter p, Double valorOutrosDebitos, Double valorAjuste) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        Double valor = valorOutrosDebitos + valorAjuste;
        if (vo.getOutrosDebitosLinha74() != null && vo.getOutrosDebitosLinha74().equals((short)1)) {
            valor = valor - valorOutrosDebitos;
        }
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "074", "00", new UtilityMetodosPadroes().formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco75(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "075", "00", new UtilityMetodosPadroes().formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco76(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "076", "00", new UtilityMetodosPadroes().formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco77(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "077", "00", new UtilityMetodosPadroes().formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco78(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "078", "00", new UtilityMetodosPadroes().formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco79(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "079", "00", new UtilityMetodosPadroes().formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco80(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "080", "00", new UtilityMetodosPadroes().formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco81(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "081", "00", new UtilityMetodosPadroes().formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco82(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "082", "00", new UtilityMetodosPadroes().formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco83(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "083", "00", new UtilityMetodosPadroes().formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco84(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "084", "00", new UtilityMetodosPadroes().formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco85(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "085", "00", new UtilityMetodosPadroes().formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco86(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "086", "00", new UtilityMetodosPadroes().formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco87(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "087", "00", new UtilityMetodosPadroes().formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco88(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "088", "00", new UtilityMetodosPadroes().formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco89(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "089", "00", new UtilityMetodosPadroes().formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco90(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "090", "00", new UtilityMetodosPadroes().formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco91(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "091", "00", new UtilityMetodosPadroes().formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco92(GeracaoDapi vo, PrintWriter p, TempApuracaoIcms a) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        Double campo92 = a.getSaldoCredorAnterior() + a.getVrCredito() + a.getVrOutroCredito() + a.getValorAjusteCredito() + a.getVrEstornoDebito() - (a.getVrDebito() + a.getValorAjusteDebito() + a.getVrOutroDebito() + a.getVrEstornoCredito());
        if (campo92 <= 0.0) {
            campo92 = 0.0;
        }
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "092", "00", new UtilityMetodosPadroes().formatarValor(campo92));
        this.escreverLinha(l, p);
    }

    private void createBloco93(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "093", "00", new UtilityMetodosPadroes().formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco94(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "094", "00", new UtilityMetodosPadroes().formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco95(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "095", "00", new UtilityMetodosPadroes().formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco96(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "096", "00", new UtilityMetodosPadroes().formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco97(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "097", "00", new UtilityMetodosPadroes().formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco98(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "098", "00", new UtilityMetodosPadroes().formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco99(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "099", "00", new UtilityMetodosPadroes().formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco100(GeracaoDapi vo, PrintWriter p, TempApuracaoIcms a) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " select coalesce(sum(i.vrDifAliquota),0)  from ItemNotaLivroFiscal i  where  i.itemNotaTerceiros.notaFiscalTerceiros.empresa = :empresa  and  i.itemNotaTerceiros.notaFiscalTerceiros.dataEntrada between :dataInicial and :dataFinal ";
        Double retorno = (Double)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("empresa", (Object)vo.getEmpresa()).setDate("dataInicial", vo.getDataInicial()).setDate("dataFinal", vo.getDataFinal()).uniqueResult();
        for (TempAjusteApuracaoIcms ajusteApuracaoIcms : a.getAjustesApuracao()) {
            if (!ajusteApuracaoIcms.getCodigoTipoAjusteApIcms().equals("MG050099")) continue;
            retorno = retorno + ajusteApuracaoIcms.getValorAjuste();
        }
        this.campo100 = retorno;
        if (this.campo100 == null) {
            this.campo100 = 0.0;
        }
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "100", "00", new UtilityMetodosPadroes().formatarValor(retorno));
        this.escreverLinha(l, p);
    }

    private void createBloco101(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "101", "00", new UtilityMetodosPadroes().formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco102(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "102", "00", new UtilityMetodosPadroes().formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco103(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "103", "00", new UtilityMetodosPadroes().formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco104(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "104", "00", new UtilityMetodosPadroes().formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco105(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "105", "00", new UtilityMetodosPadroes().formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco106(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "106", "00", new UtilityMetodosPadroes().formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco107(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "107", "00", new UtilityMetodosPadroes().formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco108(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "108", "00", new UtilityMetodosPadroes().formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco109(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "109", "00", new UtilityMetodosPadroes().formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco110(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "110", "00", new UtilityMetodosPadroes().formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco111(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "111", "00", new UtilityMetodosPadroes().formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco112(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "112", "00", new UtilityMetodosPadroes().formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco113(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "113", "00", new UtilityMetodosPadroes().formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco114(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "114", "00", new UtilityMetodosPadroes().formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco115(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "115", "00", new UtilityMetodosPadroes().formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco116(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "116", "00", new UtilityMetodosPadroes().formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco117(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "117", "00", new UtilityMetodosPadroes().formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco118(GeracaoDapi vo, PrintWriter p) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "118", "00", new UtilityMetodosPadroes().formatarValor(0.0));
        this.escreverLinha(l, p);
    }

    private void createBloco22(GeracaoDapi vo, File file, TempApuracaoIcms ap) throws IOException {
        Double valor = ap.getVrEstornoDebito();
        if (vo.getLinhaAjusteCredito().equals((short)1)) {
            valor = valor + ap.getValorAjusteCredito();
        }
        if (valor > 0.0) {
            FileWriter fileWriter = new FileWriter(file, true);
            PrintWriter p = new PrintWriter(fileWriter);
            this.writterBloco22(p, vo, valor);
            p.flush();
            p.close();
        }
    }

    private void writterBloco22(PrintWriter p, GeracaoDapi vo, Double valor) {
        p.append("22");
        p.append(this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13));
        p.append(this.getFormatedNumero(this.valores.get("anoReferencia"), 0, 4));
        p.append(this.getFormatedNumero(this.valores.get("mesReferencia"), 0, 2));
        p.append(this.getFormatedNumero(this.valores.get("diaFinal"), 0, 2));
        p.append(this.getFormatedNumero(this.valores.get("diaInicial"), 0, 2));
        p.append(this.getFormatedStringZeros("0", 9));
        p.append(this.getFormatedStringZeros("0", 3));
        p.append(this.getFormatedStringZeros("0", 8));
        p.append(new UtilityMetodosPadroes().formatarValor(valor));
        p.append(this.getFormatedStringZeros("0", 60));
        p.append("6");
        p.append(this.getFinalLine());
    }

    private void createBloco29(GeracaoDapi vo, File file, TempApuracaoIcms ap) throws IOException {
        Double valor = ap.getVrEstornoCredito();
        if (vo.getLinhaAjusteDebito().equals((short)1)) {
            valor = valor + ap.getValorAjusteDebito();
        }
        if (valor > 0.0) {
            FileWriter fileWriter = new FileWriter(file, true);
            PrintWriter p = new PrintWriter(fileWriter);
            this.writterBloco29(p, vo, valor);
            p.flush();
            p.close();
        }
    }

    private void writterBloco29(PrintWriter p, GeracaoDapi vo, Double valor) {
        p.append("29");
        p.append(this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13));
        p.append(this.getFormatedNumero(this.valores.get("anoReferencia"), 0, 4));
        p.append(this.getFormatedNumero(this.valores.get("mesReferencia"), 0, 2));
        p.append(this.getFormatedNumero(this.valores.get("diaFinal"), 0, 2));
        p.append(this.getFormatedNumero(this.valores.get("diaInicial"), 0, 2));
        p.append("04");
        p.append(this.getFormatedStringVazia("", 13));
        p.append(new UtilityMetodosPadroes().formatarValor(valor));
        p.append(this.getFormatedStringVazia("", 9));
        p.append(this.getFormatedStringVazia("", 3));
        p.append(this.getFormatedStringVazia("", 8));
        p.append(this.getFinalLine());
    }

    private void createBloco123(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "123", "00", new UtilityMetodosPadroes().formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco124(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        if (vo.getOutrosCreditosLinha71() != null && vo.getOutrosCreditosLinha71().equals((short)1)) {
            LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "124", "00", new UtilityMetodosPadroes().formatarValor(valor));
            this.escreverLinha(l, p);
        }
    }

    private void createBloco125(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        String hql = " ";
        if (vo.getOutrosDebitosLinha74() != null && vo.getOutrosDebitosLinha74().equals((short)1)) {
            LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "125", "00", new UtilityMetodosPadroes().formatarValor(valor));
            this.escreverLinha(l, p);
        }
    }

    private void createBloco131(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "131", "00", new UtilityMetodosPadroes().formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco133(GeracaoDapi vo, PrintWriter p, Double valor) {
        String inscricao = this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13);
        LinhaTipo10 l = new LinhaTipo10(inscricao, this.anoReferencia.toString(), this.mesReferencia.toString(), this.diaFinalReferencia.toString(), this.diaInicialReferencia.toString(), "133", "00", new UtilityMetodosPadroes().formatarValor(valor));
        this.escreverLinha(l, p);
    }

    private void createBloco23(GeracaoDapi vo, File arquivo, TempApuracaoIcms apuracao) throws IOException {
        if (vo.getSaldoIncentivoCultura() > 0.0 || vo.getSaldoIncentivoEsporte() > 0.0) {
            FileWriter fileWriter = new FileWriter(arquivo, true);
            PrintWriter p = new PrintWriter(fileWriter);
            this.writterBloco23(p, vo);
            p.flush();
            p.close();
        }
    }

    private void writterBloco23(PrintWriter p, GeracaoDapi vo) {
        Double saldoCultura = vo.getSaldoIncentivoCultura();
        Double saldoEsporte = vo.getSaldoIncentivoEsporte();
        p.append("23");
        p.append(this.getFormatedStringZeros(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 13));
        p.append(this.getFormatedNumero(this.valores.get("anoReferencia"), 0, 4));
        p.append(this.getFormatedNumero(this.valores.get("mesReferencia"), 0, 2));
        p.append(this.getFormatedNumero(this.valores.get("diaFinal"), 0, 2));
        p.append(this.getFormatedNumero(this.valores.get("diaInicial"), 0, 2));
        p.append(new UtilityMetodosPadroes().formatarValor(saldoCultura));
        p.append(new UtilityMetodosPadroes().formatarValor(0.0));
        p.append(new UtilityMetodosPadroes().formatarValor(saldoCultura));
        p.append(new UtilityMetodosPadroes().formatarValor(0.0));
        p.append(new UtilityMetodosPadroes().formatarValor(saldoCultura));
        p.append(new UtilityMetodosPadroes().formatarValor(0.0));
        p.append(new UtilityMetodosPadroes().formatarValor(0.0));
        p.append(new UtilityMetodosPadroes().formatarValor(0.0));
        p.append(new UtilityMetodosPadroes().formatarValor(0.0));
        p.append(new UtilityMetodosPadroes().formatarValor(0.0));
        p.append(new UtilityMetodosPadroes().formatarValor(saldoEsporte));
        p.append(new UtilityMetodosPadroes().formatarValor(0.0));
        p.append(new UtilityMetodosPadroes().formatarValor(saldoEsporte));
        p.append(new UtilityMetodosPadroes().formatarValor(0.0));
        p.append(new UtilityMetodosPadroes().formatarValor(saldoEsporte));
        p.append(new UtilityMetodosPadroes().formatarValor(0.0));
        p.append(new UtilityMetodosPadroes().formatarValor(0.0));
        p.append(this.getFinalLine());
    }

    private Double getValorSubObrigacoes(GeracaoDapi vo, TempApuracaoIcms a) {
        Double valor = 0.0;
        if (vo.getSomarIcmsRecolherSubApuracao().equals((short)1)) {
            for (TempSubApuracaoICMS s : a.getSubApuracao()) {
                valor = valor + s.getValorIcmsRecolher();
            }
        }
        return valor;
    }

    private Double getValorRessarcimentoST(GeracaoDapi vo) {
        String hql = " select coalesce(sum(vrRessarcimentoST),0) from ApuracaoICMS apuracao  where  apuracao.anoMes = :dataInicial  and  apuracao.empresa = :empresa  and  apuracao.tipoApuracao = :icmsST";
        return (Double)CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("dataInicial", vo.getDataInicial()).setShort("icmsST", (short)0).setEntity("empresa", (Object)vo.getEmpresa()).uniqueResult();
    }

    private void createBloco27(GeracaoDapi vo, File arquivo) throws IOException {
        if (vo.getRessarcimentoST() != null && !vo.getRessarcimentoST().isEmpty()) {
            FileWriter fileWriter = new FileWriter(arquivo, true);
            PrintWriter p = new PrintWriter(fileWriter);
            this.writterBloco27(p, vo);
            p.flush();
            p.close();
        }
    }

    private void writterBloco27(PrintWriter p, GeracaoDapi vo) {
    }

    private String getMotivoRessarcimentoST(Short motivoRessarcimento) {
        if (motivoRessarcimento.equals(new Short("1"))) {
            return "01";
        }
        if (motivoRessarcimento.equals(new Short("2"))) {
            return "02";
        }
        if (motivoRessarcimento.equals(new Short("3"))) {
            return "03";
        }
        return "04";
    }

    private void recalcularValoresCreditosDescartadosApuracao(TempApuracaoIcms apuracao, GeracaoDapi vo) {
        Double valorIcmsDescartado = this.getValorIcmsDescartaDapi(vo);
        apuracao.setVrCredito(apuracao.getVrCredito() - valorIcmsDescartado);
        apuracao.setVrOutroCredito(apuracao.getVrOutroCredito() + valorIcmsDescartado);
    }

    private Double getValorIcmsDescartaDapi(GeracaoDapi vo) {
        String hql = " select coalesce(sum(lv.valorIcms),0) from LivroFiscal lv  where  lv.dataLivro between :dataInicial and :dataFinal  and  lv.empresa = :empresa  and  lv.cancelado = :nao and  lv.descartarDapi = :sim and  (lv.entradaSaidaNaturezaOp = :entrada or lv.entradaSaidaNaturezaOp = :faturamentoEntrada)";
        return (Double)CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("dataInicial", vo.getDataInicial()).setDate("dataFinal", vo.getDataFinal()).setEntity("empresa", (Object)vo.getEmpresa()).setShort("sim", (short)1).setShort("nao", (short)0).setShort("entrada", (short)0).setShort("faturamentoEntrada", (short)2).uniqueResult();
    }

    private TempApuracaoIcms convertApuracaoIcms(ApuracaoICMS ap) {
        TempApuracaoIcms t = new TempApuracaoIcms();
        t.setSaldoCredor(ap.getSaldoCredor());
        t.setSaldoCredorAnterior(ap.getSaldoCredorAnterior());
        t.setSaldoDevedor(ap.getSaldoDevedor());
        t.setValorAjusteCredito(ap.getValorAjusteCredito());
        t.setValorAjusteDebito(ap.getValorAjusteDebito());
        t.setVrCredito(ap.getVrCredito());
        t.setVrDebito(ap.getVrDebito());
        t.setVrEstornoCredito(ap.getVrEstornoCredito());
        t.setVrEstornoDebito(ap.getVrEstornoDebito());
        t.setVrOutroCredito(ap.getVrOutroCredito());
        t.setVrOutroDebito(ap.getVrOutroDebito());
        for (AjusteApuracaoIcms aj : ap.getAjustesApuracao()) {
            TempAjusteApuracaoIcms taj = new TempAjusteApuracaoIcms();
            taj.setCodigoTipoAjusteApIcms(aj.getTipoAjusteApIcms().getCodigo());
            taj.setValorAjuste(aj.getValorAjuste());
            t.getAjustesApuracao().add(taj);
        }
        for (SubApuracaoICMS sub : ap.getSubApuracao()) {
            TempSubApuracaoICMS tsub = new TempSubApuracaoICMS();
            tsub.setValorIcmsRecolher(sub.getValorIcmsRecolher());
            t.getSubApuracao().add(tsub);
        }
        return t;
    }

    public void geracaoArquivoDMA(GeracaoDapi vo, File f, EmpresaContabilidade empCont) throws ExceptionService, IOException {
        ApuracaoICMS apuracao = this.getApuracaoICMS(vo.getDataInicial(), vo.getEmpresa());
        if (apuracao == null) {
            throw new ExceptionService("Primeiro, crie uma apura\u00e7\u00e3o de ICMS.");
        }
        TempApuracaoIcms tempApuracao = this.convertApuracaoIcms(apuracao);
        this.createBloco00DMA(vo, f, empCont);
        this.createBloco01DMA(vo, f, empCont);
        this.createBloco08DMA(vo, f, empCont);
        this.createBloco09DMA(vo, f, empCont);
        this.createBloco10DMA(vo, f, empCont);
        this.createBloco11DMA(vo, f, empCont);
        this.createBloco13DMA(vo, f, empCont);
        this.createBloco14DMA(vo, f, empCont);
        this.createBloco15DMA(vo, f, empCont);
        this.createBloco16DMA(vo, f, empCont);
        this.createBloco17DMA(vo, f, empCont);
        this.createBloco18DMA(vo, f, empCont);
        this.createBloco19DMA(vo, f, empCont);
        this.createBloco20DMA(vo, f, empCont);
        this.createBloco21DMA(vo, f, empCont);
        this.createBloco22DMA(vo, f, empCont);
        this.createBloco99DMA(vo, f, empCont);
    }

    private void createBloco00DMA(GeracaoDapi vo, File file, EmpresaContabilidade empCont) throws IOException {
        FileWriter fileWriter = new FileWriter(file, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco00DMA(p, vo, empCont);
        p.flush();
        p.close();
    }

    private void writterBloco00DMA(PrintWriter p, GeracaoDapi vo, EmpresaContabilidade empresaContabilidade) {
        Empresa empresa = vo.getEmpresa();
        p.append("00");
        p.append("DMA  ");
        p.append("O");
        p.append(this.getFormatedStringZeros(empresaContabilidade.getPessoa().getComplemento().getCnpj(), 11));
        p.append(this.getFormatedStringVazia(empresaContabilidade.getPessoa().getNome().toUpperCase(), 35));
        p.append("2010");
        p.append(this.getFinalLine());
    }

    private void writterBloco01DMA(PrintWriter p, GeracaoDapi vo, EmpresaContabilidade empCont) {
        p.append("01");
        p.append(this.getFormatedNumero(ToolDate.yearFromDate((Object)vo.getDataInicial()), 0, 4));
        p.append(this.getFormatedNumero(ToolDate.monthFromDate((Date)vo.getDataInicial()), 0, 2));
        p.append(this.getFormatedStringZeros(ToolString.refina((String)vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 9));
        p.append(this.getSimOrNao(vo.getArquivoRetificacao()));
        p.append(this.getSimOrNao(vo.getDeclaracaoBaixaEmpresa()));
        p.append("N");
        p.append("N");
        p.append(this.getFormatedDate(vo.getDataFechamentoBalanco()));
        p.append(this.getFormatedStringVazia(vo.getEmpresa().getPessoa().getNome().toUpperCase(), 50));
        p.append(this.getFormatedStringZeros("29307", 5));
        p.append(this.getFormatedStringZeros(vo.getEmpresa().getEmpresaDados().getCnae().getCodigo(), 7));
        p.append("00");
        p.append("N");
        p.append(this.getFinalLine());
    }

    private void createBloco01DMA(GeracaoDapi vo, File f, EmpresaContabilidade empCont) throws IOException {
        FileWriter fileWriter = new FileWriter(f, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco01DMA(p, vo, empCont);
        p.flush();
        p.close();
    }

    private void createBloco08DMA(GeracaoDapi vo, File f, EmpresaContabilidade empCont) throws IOException {
        FileWriter fileWriter = new FileWriter(f, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco08DMA(p, vo, empCont);
        p.flush();
        p.close();
    }

    private void writterBloco08DMA(PrintWriter p, GeracaoDapi vo, EmpresaContabilidade empCont) {
        List hashs = new UtilityEntradaEstadualDapi().valoresEntradaPorUfDMA(vo);
        Double totalContabil = 0.0;
        Double totalBcCalculo = 0.0;
        Double totalOutras = 0.0;
        Double totalIsentos = 0.0;
        Double totalIcmsSt = 0.0;
        for (HashMap hash : hashs) {
            if (hash.get("SIGLA") == null || hash.get("SIGLA").equals("BA")) continue;
            Double vlrContabil = (Double)hash.get("VALOR_CONTABIL");
            Double bcCalculo = (Double)hash.get("BASE_CALCULO");
            Double vlrOutras = (Double)hash.get("ICMS_OUTROS");
            Double vlrIsentas = (Double)hash.get("ICMS_ISENTO") + (Double)hash.get("VR_NAO_TRIB_ICMS");
            Double icmsSt = (Double)hash.get("ICMS_ST");
            totalContabil = totalContabil + vlrContabil;
            totalBcCalculo = totalBcCalculo + bcCalculo;
            totalOutras = totalOutras + vlrOutras;
            totalIsentos = totalIsentos + vlrIsentas;
            totalIcmsSt = totalIcmsSt + icmsSt;
            p.append("08");
            p.append(this.getFormatedNumero(ToolDate.yearFromDate((Object)vo.getDataInicial()), 0, 4));
            p.append(this.getFormatedNumero(ToolDate.monthFromDate((Date)vo.getDataInicial()), 0, 2));
            p.append(this.getFormatedStringZeros(ToolString.refina((String)vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 9));
            p.append((CharSequence)hash.get("SIGLA"));
            p.append(new UtilityMetodosPadroes().formatarValorDMA(vlrContabil));
            p.append(new UtilityMetodosPadroes().formatarValorDMA(bcCalculo));
            p.append(new UtilityMetodosPadroes().formatarValorDMA(vlrIsentas + vlrOutras));
            p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
            p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
            p.append(this.getFinalLine());
        }
        p.append("08");
        p.append(this.getFormatedNumero(ToolDate.yearFromDate((Object)vo.getDataInicial()), 0, 4));
        p.append(this.getFormatedNumero(ToolDate.monthFromDate((Date)vo.getDataInicial()), 0, 2));
        p.append(this.getFormatedStringZeros(ToolString.refina((String)vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 9));
        p.append("ZZ");
        p.append(new UtilityMetodosPadroes().formatarValorDMA(totalContabil));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(totalBcCalculo));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(totalIsentos + totalOutras));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(this.getFinalLine());
    }

    private void createBloco09DMA(GeracaoDapi vo, File f, EmpresaContabilidade empCont) throws IOException {
        FileWriter fileWriter = new FileWriter(f, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco09DMA(p, vo, empCont);
        p.flush();
        p.close();
    }

    private void writterBloco09DMA(PrintWriter p, GeracaoDapi vo, EmpresaContabilidade empCont) {
        List hashsNaoContribuintes = new UtilityEntradaEstadualDapi().valoresSaidaPorUfDMANaoContribuinte(vo);
        List hashsContribuinte = new UtilityEntradaEstadualDapi().valoresSaidaPorUfDMAContribuinte(vo);
        ArrayList aux = new ArrayList();
        for (HashMap c : hashsContribuinte) {
            if (c.get("SIGLA") == null || c.get("SIGLA").equals("BA")) continue;
            boolean achou = false;
            for (HashMap nc : hashsNaoContribuintes) {
                if (!nc.get("SIGLA").equals(c.get("SIGLA"))) continue;
                achou = true;
                nc.put("NAO_VALOR_CONTRIBUINTE", c.get("VALOR_CONTABIL"));
                nc.put("NAO_BASE_CALCULO", c.get("BASE_CALCULO"));
                nc.put("ICMS_ISENTO", (Double)c.get("ICMS_ISENTO") + (Double)nc.get("ICMS_ISENTO"));
                nc.put("ICMS_ISENTO", (Double)c.get("ICMS_ISENTO") + (Double)nc.get("ICMS_ISENTO"));
                nc.put("ICMS_OUTROS", (Double)c.get("ICMS_OUTROS") + (Double)nc.get("ICMS_OUTROS"));
            }
            if (achou) continue;
            hashsNaoContribuintes.add(c);
        }
        Double totalContabil = 0.0;
        Double totalBcCalculo = 0.0;
        Double totalOutras = 0.0;
        Double totalContabilNC = 0.0;
        Double totalBaseNC = 0.0;
        Double totalIsentas = 0.0;
        for (HashMap hash : hashsNaoContribuintes) {
            if (hash.get("SIGLA") == null || hash.get("SIGLA").equals("BA") || hash.get("SIGLA").equals("EX")) continue;
            Double vlrContabil = (Double)hash.get("VALOR_CONTABIL");
            Double bcCalculo = (Double)hash.get("BASE_CALCULO");
            Double vlrOutras = (Double)hash.get("ICMS_OUTROS");
            Double bcCalculoNc = (Double)hash.get("NAO_BASE_CALCULO") != null ? (Double)hash.get("NAO_BASE_CALCULO") : 0.0;
            Double vlrContabilNC = hash.get("NAO_VALOR_CONTRIBUINTE") != null ? (Double)hash.get("NAO_VALOR_CONTRIBUINTE") : 0.0;
            Double vlrIsentas = (Double)hash.get("ICMS_ISENTO") + (Double)hash.get("VR_NAO_TRIB_ICMS");
            totalContabil = totalContabil + vlrContabil;
            totalBcCalculo = totalBcCalculo + bcCalculo;
            totalContabilNC = totalContabilNC + vlrContabilNC;
            totalBaseNC = totalBaseNC + bcCalculoNc;
            totalOutras = totalOutras + vlrOutras;
            totalIsentas = totalIsentas + vlrIsentas;
            p.append("09");
            p.append(this.getFormatedNumero(ToolDate.yearFromDate((Object)vo.getDataInicial()), 0, 4));
            p.append(this.getFormatedNumero(ToolDate.monthFromDate((Date)vo.getDataInicial()), 0, 2));
            p.append(this.getFormatedStringZeros(ToolString.refina((String)vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 9));
            p.append((CharSequence)hash.get("SIGLA"));
            p.append(new UtilityMetodosPadroes().formatarValorDMA(vlrContabilNC));
            p.append(new UtilityMetodosPadroes().formatarValorDMA(vlrContabil));
            p.append(new UtilityMetodosPadroes().formatarValorDMA(bcCalculoNc));
            p.append(new UtilityMetodosPadroes().formatarValorDMA(bcCalculo));
            p.append(new UtilityMetodosPadroes().formatarValorDMA(vlrIsentas));
            p.append(new UtilityMetodosPadroes().formatarValorDMA(vlrOutras));
            p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
            p.append(this.getFinalLine());
        }
        p.append("09");
        p.append(this.getFormatedNumero(ToolDate.yearFromDate((Object)vo.getDataInicial()), 0, 4));
        p.append(this.getFormatedNumero(ToolDate.monthFromDate((Date)vo.getDataInicial()), 0, 2));
        p.append(this.getFormatedStringZeros(ToolString.refina((String)vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 9));
        p.append("ZZ");
        p.append(new UtilityMetodosPadroes().formatarValorDMA(totalContabilNC));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(totalContabil));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(totalBaseNC));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(totalBcCalculo));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(totalIsentas));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(totalOutras));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(this.getFinalLine());
    }

    private void createBloco10DMA(GeracaoDapi vo, File f, EmpresaContabilidade empCont) throws IOException {
        FileWriter fileWriter = new FileWriter(f, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco10DMA(p, vo, empCont);
        p.flush();
        p.close();
    }

    private void writterBloco10DMA(PrintWriter p, GeracaoDapi vo, EmpresaContabilidade empCont) {
        List hashs = new UtilityEntradaEstadualDapi().valoresEntradaPorCodigoDMA(vo);
        Double totalContabil = 0.0;
        Double totalBcCalculo = 0.0;
        Double totalOutras = 0.0;
        Double totalIsentas = 0.0;
        for (HashMap hash : hashs) {
            Double vlrContabil = (Double)hash.get("VALOR_CONTABIL");
            Double bcCalculo = (Double)hash.get("BASE_CALCULO");
            Double vlrOutras = (Double)hash.get("ICMS_OUTROS");
            Double vlrIcmsSt = (Double)hash.get("ICMS_ST");
            Double isentas = (Double)hash.get("ICMS_ISENTO") + (Double)hash.get("VR_NAO_TRIB_ICMS");
            totalContabil = totalContabil + vlrContabil;
            totalBcCalculo = totalBcCalculo + bcCalculo;
            totalOutras = totalOutras + vlrOutras;
            totalIsentas = totalIsentas + isentas;
            p.append("10");
            p.append(this.getFormatedNumero(ToolDate.yearFromDate((Object)vo.getDataInicial()), 0, 4));
            p.append(this.getFormatedNumero(ToolDate.monthFromDate((Date)vo.getDataInicial()), 0, 2));
            p.append(this.getFormatedStringZeros(ToolString.refina((String)vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 9));
            p.append("E");
            p.append(hash.get("CODIGO_DMA").toString().substring(0, 1));
            p.append("0" + hash.get("CODIGO_DMA").toString().substring(1, 2));
            p.append(new UtilityMetodosPadroes().formatarValorDMA(vlrContabil));
            p.append(new UtilityMetodosPadroes().formatarValorDMA(bcCalculo));
            p.append(new UtilityMetodosPadroes().formatarValorDMA(isentas));
            p.append(new UtilityMetodosPadroes().formatarValorDMA(vlrOutras));
            p.append(this.getFinalLine());
        }
        p.append("10");
        p.append(this.getFormatedNumero(ToolDate.yearFromDate((Object)vo.getDataInicial()), 0, 4));
        p.append(this.getFormatedNumero(ToolDate.monthFromDate((Date)vo.getDataInicial()), 0, 2));
        p.append(this.getFormatedStringZeros(ToolString.refina((String)vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 9));
        p.append("E");
        p.append("9");
        p.append("99");
        p.append(new UtilityMetodosPadroes().formatarValorDMA(totalContabil));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(totalBcCalculo));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(totalIsentas));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(totalOutras));
        p.append(this.getFinalLine());
    }

    private void createBloco11DMA(GeracaoDapi vo, File f, EmpresaContabilidade empCont) throws IOException {
        FileWriter fileWriter = new FileWriter(f, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco11DMA(p, vo, empCont);
        p.flush();
        p.close();
    }

    private void writterBloco11DMA(PrintWriter p, GeracaoDapi vo, EmpresaContabilidade empCont) {
        List hashs = new UtilityEntradaEstadualDapi().valoresSaidaPorCodigoDMA(vo);
        Double totalContabil = 0.0;
        Double totalBcCalculo = 0.0;
        Double totalOutras = 0.0;
        Double totalIsentas = 0.0;
        for (HashMap hash : hashs) {
            Double vlrContabil = (Double)hash.get("VALOR_CONTABIL");
            Double bcCalculo = (Double)hash.get("BASE_CALCULO");
            Double vlrOutras = (Double)hash.get("ICMS_OUTROS");
            Double vlrIcmsSt = (Double)hash.get("ICMS_ST");
            Double isentas = (Double)hash.get("ICMS_ISENTO") + (Double)hash.get("VR_NAO_TRIB_ICMS");
            totalContabil = totalContabil + vlrContabil;
            totalBcCalculo = totalBcCalculo + bcCalculo;
            totalOutras = totalOutras + vlrOutras;
            totalIsentas = totalIsentas + isentas;
            p.append("11");
            p.append(this.getFormatedNumero(ToolDate.yearFromDate((Object)vo.getDataInicial()), 0, 4));
            p.append(this.getFormatedNumero(ToolDate.monthFromDate((Date)vo.getDataInicial()), 0, 2));
            p.append(this.getFormatedStringZeros(ToolString.refina((String)vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 9));
            p.append("S");
            p.append(hash.get("CODIGO_DMA").toString().substring(0, 1));
            p.append("0" + hash.get("CODIGO_DMA").toString().substring(1, 2));
            p.append(new UtilityMetodosPadroes().formatarValorDMA(vlrContabil));
            p.append(new UtilityMetodosPadroes().formatarValorDMA(bcCalculo));
            p.append(new UtilityMetodosPadroes().formatarValorDMA(isentas));
            p.append(new UtilityMetodosPadroes().formatarValorDMA(vlrOutras));
            p.append(this.getFinalLine());
        }
        p.append("11");
        p.append(this.getFormatedNumero(ToolDate.yearFromDate((Object)vo.getDataInicial()), 0, 4));
        p.append(this.getFormatedNumero(ToolDate.monthFromDate((Date)vo.getDataInicial()), 0, 2));
        p.append(this.getFormatedStringZeros(ToolString.refina((String)vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 9));
        p.append("S");
        p.append("9");
        p.append("99");
        p.append(new UtilityMetodosPadroes().formatarValorDMA(totalContabil));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(totalBcCalculo));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(totalIsentas));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(totalOutras));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(this.getFinalLine());
    }

    private void createBloco13DMA(GeracaoDapi vo, File f, EmpresaContabilidade empCont) throws IOException {
        FileWriter fileWriter = new FileWriter(f, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco13DMA(p, vo, empCont);
        p.flush();
        p.close();
    }

    private void writterBloco13DMA(PrintWriter p, GeracaoDapi vo, EmpresaContabilidade empCont) {
        HashMap entrada = new UtilityEntradaEstadualDapi().linha13EntradaDMA(vo);
        HashMap saida = new UtilityEntradaEstadualDapi().linha13SaidaDMA(vo);
        p.append("13");
        p.append(this.getFormatedNumero(ToolDate.yearFromDate((Object)vo.getDataInicial()), 0, 4));
        p.append(this.getFormatedNumero(ToolDate.monthFromDate((Date)vo.getDataInicial()), 0, 2));
        p.append(this.getFormatedStringZeros(ToolString.refina((String)vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 9));
        Double comprasAtivo = (Double)entrada.get("COMPRA_ATIVO");
        Double comprasUso = (Double)entrada.get("USU_CONSUMO");
        Double transferenciaAtivo = (Double)entrada.get("TRANS_ATIVO");
        Double transferenciaUso = (Double)entrada.get("TRANS_USO");
        Double retorno = (Double)entrada.get("RETORNO");
        Double outros = (Double)entrada.get("OUTRAS_ENTRADA");
        p.append("E");
        p.append(new UtilityMetodosPadroes().formatarValorDMA(comprasAtivo));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(comprasUso));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(transferenciaAtivo));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(transferenciaUso));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(retorno));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(outros));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(comprasAtivo + comprasUso + transferenciaAtivo + transferenciaUso + retorno + outros));
        p.append(this.getFinalLine());
        p.append("13");
        p.append(this.getFormatedNumero(ToolDate.yearFromDate((Object)vo.getDataInicial()), 0, 4));
        p.append(this.getFormatedNumero(ToolDate.monthFromDate((Date)vo.getDataInicial()), 0, 2));
        p.append(this.getFormatedStringZeros(ToolString.refina((String)vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 9));
        Double industrializacao = (Double)saida.get("INDUSTRIALIZACAO");
        Double outras = (Double)saida.get("OUTRAS_SAIDAS");
        p.append("S");
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(industrializacao));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(outras));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(industrializacao + outras));
        p.append(this.getFinalLine());
    }

    private void createBloco14DMA(GeracaoDapi vo, File f, EmpresaContabilidade empCont) throws IOException {
        ApuracaoICMS apuracao = this.getApuracaoICMS(vo.getDataInicial(), vo.getEmpresa());
        FileWriter fileWriter = new FileWriter(f, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco14DMA(p, vo, empCont, apuracao);
        p.flush();
        p.close();
    }

    private void writterBloco14DMA(PrintWriter p, GeracaoDapi vo, EmpresaContabilidade empCont, ApuracaoICMS apuracao) {
        p.append("14");
        p.append(this.getFormatedNumero(ToolDate.yearFromDate((Object)vo.getDataInicial()), 0, 4));
        p.append(this.getFormatedNumero(ToolDate.monthFromDate((Date)vo.getDataInicial()), 0, 2));
        p.append(this.getFormatedStringZeros(ToolString.refina((String)vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 9));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(apuracao.getVrDebito()));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(apuracao.getVrOutroDebito()));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(apuracao.getVrEstornoCredito()));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(apuracao.getVrCredito()));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(apuracao.getVrOutroCredito()));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(apuracao.getVrEstornoDebito()));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(apuracao.getSaldoCredorAnterior()));
        p.append(this.getFinalLine());
    }

    private void createBloco15DMA(GeracaoDapi vo, File f, EmpresaContabilidade empCont) throws IOException {
        ApuracaoICMS apuracao = this.getApuracaoICMS(vo.getDataInicial(), vo.getEmpresa());
        FileWriter fileWriter = new FileWriter(f, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco15DMA(p, vo, empCont, apuracao);
        p.flush();
        p.close();
    }

    private void writterBloco15DMA(PrintWriter p, GeracaoDapi vo, EmpresaContabilidade empCont, ApuracaoICMS apuracao) {
        p.append("15");
        p.append(this.getFormatedNumero(ToolDate.yearFromDate((Object)vo.getDataInicial()), 0, 4));
        p.append(this.getFormatedNumero(ToolDate.monthFromDate((Date)vo.getDataInicial()), 0, 2));
        p.append(this.getFormatedStringZeros(ToolString.refina((String)vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 9));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(apuracao.getVrDebito() + apuracao.getVrOutroDebito() + apuracao.getVrEstornoCredito()));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(apuracao.getVrOutroCredito() + apuracao.getVrEstornoDebito() + apuracao.getVrCredito()));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(apuracao.getSaldoCredor()));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(apuracao.getSaldoDevedor()));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(this.getFinalLine());
    }

    private void createBloco16DMA(GeracaoDapi vo, File f, EmpresaContabilidade empCont) throws IOException {
        FileWriter fileWriter = new FileWriter(f, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco16DMA(p, vo, empCont);
        p.flush();
        p.close();
    }

    private void writterBloco16DMA(PrintWriter p, GeracaoDapi vo, EmpresaContabilidade empCont) {
        p.append("16");
        p.append(this.getFormatedNumero(ToolDate.yearFromDate((Object)vo.getDataInicial()), 0, 4));
        p.append(this.getFormatedNumero(ToolDate.monthFromDate((Date)vo.getDataInicial()), 0, 2));
        p.append(this.getFormatedStringZeros(ToolString.refina((String)vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 9));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(this.getFinalLine());
    }

    private void createBloco17DMA(GeracaoDapi vo, File f, EmpresaContabilidade empCont) throws IOException {
        FileWriter fileWriter = new FileWriter(f, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco17DMA(p, vo, empCont);
        p.flush();
        p.close();
    }

    private void writterBloco17DMA(PrintWriter p, GeracaoDapi vo, EmpresaContabilidade empCont) {
        p.append("17");
        p.append(this.getFormatedNumero(ToolDate.yearFromDate((Object)vo.getDataInicial()), 0, 4));
        p.append(this.getFormatedNumero(ToolDate.monthFromDate((Date)vo.getDataInicial()), 0, 2));
        p.append(this.getFormatedStringZeros(ToolString.refina((String)vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 9));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(this.getFinalLine());
    }

    private void createBloco18DMA(GeracaoDapi vo, File f, EmpresaContabilidade empCont) throws IOException {
        FileWriter fileWriter = new FileWriter(f, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco18DMA(p, vo, empCont);
        p.flush();
        p.close();
    }

    private void createBloco19DMA(GeracaoDapi vo, File f, EmpresaContabilidade empCont) throws IOException {
        FileWriter fileWriter = new FileWriter(f, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco19DMA(p, vo, empCont);
        p.flush();
        p.close();
    }

    private void createBloco20DMA(GeracaoDapi vo, File f, EmpresaContabilidade empCont) throws IOException {
        FileWriter fileWriter = new FileWriter(f, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco20DMA(p, vo, empCont);
        p.flush();
        p.close();
    }

    private void writterBloco18DMA(PrintWriter p, GeracaoDapi vo, EmpresaContabilidade empCont) {
        p.append("18");
        p.append(this.getFormatedNumero(ToolDate.yearFromDate((Object)vo.getDataInicial()), 0, 4));
        p.append(this.getFormatedNumero(ToolDate.monthFromDate((Date)vo.getDataInicial()), 0, 2));
        p.append(this.getFormatedStringZeros(ToolString.refina((String)vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 9));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(this.getFinalLine());
    }

    private void writterBloco19DMA(PrintWriter p, GeracaoDapi vo, EmpresaContabilidade empCont) {
        p.append("19");
        p.append(this.getFormatedNumero(ToolDate.yearFromDate((Object)vo.getDataInicial()), 0, 4));
        p.append(this.getFormatedNumero(ToolDate.monthFromDate((Date)vo.getDataInicial()), 0, 2));
        p.append(this.getFormatedStringZeros(ToolString.refina((String)vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 9));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(this.getFinalLine());
    }

    private void writterBloco20DMA(PrintWriter p, GeracaoDapi vo, EmpresaContabilidade empCont) {
        p.append("20");
        p.append(this.getFormatedNumero(ToolDate.yearFromDate((Object)vo.getDataInicial()), 0, 4));
        p.append(this.getFormatedNumero(ToolDate.monthFromDate((Date)vo.getDataInicial()), 0, 2));
        p.append(this.getFormatedStringZeros(ToolString.refina((String)vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 9));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(new UtilityMetodosPadroes().formatarValorDMA(0.0));
        p.append(this.getFinalLine());
    }

    private void createBloco21DMA(GeracaoDapi vo, File f, EmpresaContabilidade empCont) throws IOException {
        FileWriter fileWriter = new FileWriter(f, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco21DMA(p, vo, empCont);
        p.flush();
        p.close();
    }

    private void writterBloco21DMA(PrintWriter p, GeracaoDapi vo, EmpresaContabilidade empCont) {
        p.append("21");
        p.append(this.getFormatedNumero(ToolDate.yearFromDate((Object)vo.getDataInicial()), 0, 4));
        p.append(this.getFormatedNumero(ToolDate.monthFromDate((Date)vo.getDataInicial()), 0, 2));
        p.append(this.getFormatedStringZeros(ToolString.refina((String)vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 9));
        p.append(this.getFormatedStringVazia(empCont.getCrc(), 7));
        p.append("BA");
        p.append(this.getFormatedStringVazia(empCont.getPessoa().getNome(), 35));
        p.append("AV ");
        p.append(this.getFormatedStringVazia(empCont.getPessoa().getEndereco().getLogradouro(), 30));
        p.append("BA");
        p.append(this.getFinalLine());
    }

    private void createBloco22DMA(GeracaoDapi vo, File f, EmpresaContabilidade empCont) throws IOException {
        FileWriter fileWriter = new FileWriter(f, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco22DMA(p, vo, empCont);
        p.flush();
        p.close();
    }

    private void writterBloco22DMA(PrintWriter p, GeracaoDapi vo, EmpresaContabilidade empCont) {
        p.append("22");
        p.append(this.getFormatedNumero(ToolDate.yearFromDate((Object)vo.getDataInicial()), 0, 4));
        p.append(this.getFormatedNumero(ToolDate.monthFromDate((Date)vo.getDataInicial()), 0, 2));
        p.append(this.getFormatedStringZeros(ToolString.refina((String)vo.getEmpresa().getPessoa().getComplemento().getInscEst()), 9));
        p.append(this.getFormatedStringVazia(empCont.getPessoa().getEndereco().getBairro(), 16));
        p.append(this.getFormatedStringVazia(empCont.getPessoa().getEndereco().getNumero(), 9));
        p.append("7135942215      ");
        p.append(this.getFormatedStringVazia(StringUtil.refina((String)empCont.getPessoa().getEndereco().getCep()), 8));
        p.append("27400");
        p.append(this.getFormatedStringVazia(empCont.getPessoa().getEndereco().getCidade().getDescricao(), 30));
        p.append(this.getFinalLine());
    }

    private void createBloco99DMA(GeracaoDapi vo, File f, EmpresaContabilidade empCont) throws IOException {
        FileWriter fileWriter = new FileWriter(f, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco99DMA(p, vo, empCont);
        p.flush();
        p.close();
    }

    private void writterBloco99DMA(PrintWriter p, GeracaoDapi vo, EmpresaContabilidade empCont) {
        p.append("9900001 ");
        p.append(this.getFinalLine());
    }
}

