/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.geracaodapi.utility;

import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import mentorcore.service.impl.geracaodapi.util.LinhaTipo10;
import mentorcore.tools.DateUtil;

public class UtilityMetodosPadroes {
    public Double getValorString(String valorInteiro, String valorDecimal) {
        return new Double(valorInteiro + "." + valorDecimal);
    }

    public String formatarValorDMA(Double valorDeclarado) {
        if (valorDeclarado == 0.0) {
            return ToolString.completaEspacos((String)"0", (int)12, (boolean)true);
        }
        Object numero = "";
        Double valor = ContatoFormatUtil.arrredondarNumero((Double)valorDeclarado, (int)2);
        Integer inteira = valor.intValue();
        Integer decimal = (int)Math.round((valor - (double)valor.intValue()) * 100.0);
        numero = decimal.toString().length() == 1 ? inteira.toString() + "0" + decimal.toString() : inteira.toString() + decimal.toString();
        return ToolString.completaEspacos((String)numero, (int)12, (boolean)true);
    }

    public String formatarValor(Double valorDeclarado) {
        Object numero = "";
        Double valor = ContatoFormatUtil.arrredondarNumero((Double)valorDeclarado, (int)2);
        Integer inteira = valor.intValue();
        Integer decimal = (int)Math.round((valor - (double)valor.intValue()) * 100.0);
        numero = decimal.toString().length() == 1 ? inteira.toString() + "0" + decimal.toString() : inteira.toString() + decimal.toString();
        return ToolString.completaZeros((String)numero, (int)15, (boolean)true);
    }

    public String getFormatedDate(Date data) {
        return DateUtil.dateToStr(data, "ddMMyyyy");
    }

    public boolean existeLinhaTabela(LinhaTipo10 l, List<LinhaTipo10> linhasDapi) {
        for (LinhaTipo10 linhaTabela : linhasDapi) {
            if (!linhaTabela.getIdentificacaoColuna().equals(l.getIdentificacaoColuna()) || !linhaTabela.getIdentificacaoLinha().equals(l.getIdentificacaoLinha())) continue;
            Double valor = this.getValorString(l.getValorDeclarado().substring(0, 13), l.getValorDeclarado().substring(13, 15)) + this.getValorString(linhaTabela.getValorDeclarado().substring(0, 13), linhaTabela.getValorDeclarado().substring(13, 15));
            linhaTabela.setValorDeclarado(this.formatarValor(valor));
            return true;
        }
        return false;
    }

    public String getFormatedStringZeros(String st, int numeroCasas) {
        if (st == null) {
            st = "";
        }
        if (st.length() > numeroCasas) {
            return st.substring(0, numeroCasas);
        }
        return ToolString.completaZeros((String)st, (int)numeroCasas, (boolean)true);
    }

    public String getClearString(String st) {
        return ToolString.refina((String)st);
    }

    public String getFormatedNumero(Object obj, int numCasasDecimais, int numCasasInteiras) {
        Number numero = (Number)obj;
        return ToolString.refina((String)ContatoFormatUtil.formataNumero((Number)numero, (int)numCasasDecimais, (int)numCasasInteiras));
    }

    public String getFinalLine() {
        return "\r\n";
    }

    public String getSimOrNao(Short simNao) {
        if (simNao.equals((short)1)) {
            return "S";
        }
        return "N";
    }

    public List<LinhaTipo10> ordernarLista(List<LinhaTipo10> linhasSaidas) {
        if (linhasSaidas != null) {
            Collections.sort(linhasSaidas, new Comparator(this){

                public int compare(Object o1, Object o2) {
                    LinhaTipo10 item1 = (LinhaTipo10)o1;
                    LinhaTipo10 item2 = (LinhaTipo10)o2;
                    if (!item1.getIdentificacaoLinha().equals(item2.getIdentificacaoLinha())) {
                        Double vlr1 = new Double(item1.getIdentificacaoLinha());
                        Double vlr2 = new Double(item2.getIdentificacaoLinha());
                        return vlr1.compareTo(vlr2);
                    }
                    return new Double(item1.getIdentificacaoColuna()).compareTo(new Double(item2.getIdentificacaoColuna()));
                }
            });
            return linhasSaidas;
        }
        return null;
    }
}

