/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.geracaoordemservicoplanomanutencao;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.GeracaoOrdemServicoPlanoManutencao;
import com.touchcomp.basementor.model.vo.LocalizacaoAtivo;
import com.touchcomp.basementor.model.vo.OpcoesManutencEquip;
import com.touchcomp.basementor.model.vo.OrdemServicoAlteracaoDataProgramacao;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoManutencaoAtivo;
import com.touchcomp.basementor.model.vo.PlanoManutencaoAtivoAtivo;
import com.touchcomp.basementor.model.vo.SetorExecutante;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.DateUtil;

public class UtilityGeracaoOrdemServicoPlanoManutencao {
    public static List<PlanoManutencaoAtivoAtivo> getPlanoManutencaoAtivoTodos(Date dataInicial, Date dataFinal, SetorExecutante setorExecutante, LocalizacaoAtivo localizacaoAtivo, Empresa empresaLogada, Short opcaoPesquisa, Short gerarOSAtivoNaoExisteOS) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("dataInicial", dataInicial);
        request.setAttribute("dataFinal", dataFinal);
        request.setAttribute("setorExecutante", setorExecutante);
        request.setAttribute("localizacaoAtivo", localizacaoAtivo);
        request.setAttribute("empresaLogada", empresaLogada);
        request.setAttribute("opcaoPesquisa", opcaoPesquisa);
        request.setAttribute("gerarOSAtivoNaoExisteOS", gerarOSAtivoNaoExisteOS);
        return (List)CoreServiceFactory.getServicePlanoManutencaoAtivo().execute(request, "findPlanoManutencaoExcedido");
    }

    public static List<OrdemServicoAlteracaoDataProgramacao> gerarOrdemServicoPlanoManutencao(List<PlanoManutencaoAtivoAtivo> planoManutencaoAtivoAtivo, Short opcaoPesquisa, Date dataInicial, Date dataFinal, OpcoesManutencEquip opcoes, Pessoa solicitante, Pessoa responsavel) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("planoManutencaoAtivoAtivo", planoManutencaoAtivoAtivo);
        request.setAttribute("opcaoPesquisa", opcaoPesquisa);
        request.setAttribute("opcoesManutencao", opcoes);
        request.setAttribute("dataInicial", dataInicial);
        request.setAttribute("dataFinal", dataFinal);
        request.setAttribute("solicitante", solicitante);
        request.setAttribute("responsavel", responsavel);
        return (List)CoreServiceFactory.getServicePlanoManutencaoAtivo().execute(request, "gerarOrdemServicoPorPlano");
    }

    public static GeracaoOrdemServicoPlanoManutencao salvarGeracao(CoreRequestContext request) throws ExceptionService {
        return (GeracaoOrdemServicoPlanoManutencao)CoreServiceFactory.getServicePlanoManutencaoAtivo().execute(request, "salvarGeracao");
    }

    public static Timestamp getDataUltimaManutencao(PlanoManutencaoAtivo planoManutencaoAtivo, Equipamento ativo, Short opcaoPesquisa) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("planoManutencaoAtivo", planoManutencaoAtivo);
        request.setAttribute("ativo", ativo);
        request.setAttribute("opcaoPesquisa", opcaoPesquisa);
        return (Timestamp)CoreServiceFactory.getServicePlanoManutencaoAtivo().execute(request, "getUltimaDataManutencao");
    }

    public static void deleteGeracao(GeracaoOrdemServicoPlanoManutencao geracaoOrdemServicoPlanoManutencao) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("geracaoOrdemServicoPlanoManutencao", geracaoOrdemServicoPlanoManutencao);
        CoreServiceFactory.getServicePlanoManutencaoAtivo().execute(request, "deleteGeracao");
    }

    public static List<PlanoManutencaoAtivoAtivo> buildPlanosManutencaoAtivoAtivos(List<PlanoManutencaoAtivo> planosAcumulativos, List<PlanoManutencaoAtivo> planosPeriodicos, List<PlanoManutencaoAtivo> planosSobDemanda, Empresa empresaLogada, Boolean validar, Short opcaoPesquisa, Short gerarOSAtivoNaoExisteOS) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("planosAcumulativos", planosAcumulativos);
        request.setAttribute("planosPeriodicos", planosPeriodicos);
        request.setAttribute("planosSobDemanda", planosSobDemanda);
        request.setAttribute("empresaLogada", empresaLogada);
        request.setAttribute("validar", validar);
        request.setAttribute("opcaoPesquisa", opcaoPesquisa);
        request.setAttribute("gerarOSAtivoNaoExisteOS", gerarOSAtivoNaoExisteOS);
        return (List)CoreServiceFactory.getServicePlanoManutencaoAtivo().execute(request, "buildPlanoManutencaoAtivoAtivo");
    }

    protected static void gerarOsAutomaticamentePeloPlano(Integer diasAntecedencia) throws ExceptionService {
        List opcoes = (List)CoreServiceFactory.getServiceOpcoesManutencaoEquipamento().execute(new CoreRequestContext(), "findAllOpcoesManutencaoEquipamento");
        for (OpcoesManutencEquip opcao : opcoes) {
            Date dataInicial = null;
            Date dataFinal = null;
            if (diasAntecedencia != null && diasAntecedencia != 0) {
                dataFinal = new Date();
                dataInicial = DateUtil.previousDays(dataFinal, diasAntecedencia);
            }
            List<PlanoManutencaoAtivoAtivo> planosExcedidos = UtilityGeracaoOrdemServicoPlanoManutencao.getPlanoManutencaoAtivoTodos(dataInicial, dataFinal, null, null, opcao.getEmpresa(), opcao.getTipoDataUltimaManutencao(), EnumConstantsMentorSimNao.NAO.getValue());
            List<OrdemServicoAlteracaoDataProgramacao> ordensGeradas = UtilityGeracaoOrdemServicoPlanoManutencao.gerarOrdemServicoPlanoManutencao(planosExcedidos, opcao.getTipoDataUltimaManutencao(), dataInicial, dataFinal, opcao, null, null);
            if (planosExcedidos == null || planosExcedidos.isEmpty() || ordensGeradas == null || ordensGeradas.isEmpty()) continue;
            GeracaoOrdemServicoPlanoManutencao g = new GeracaoOrdemServicoPlanoManutencao();
            g.setDataCadastro(new Date());
            g.setDataFinal(dataFinal);
            g.setDataInicial(dataInicial);
            g.setEmpresa(opcao.getEmpresa());
            for (PlanoManutencaoAtivoAtivo plano : planosExcedidos) {
                plano.setGeracaoOrdemServicoPlanoManutencao(g);
            }
            g.setOrdemServicoAlteracaoDataProgramacao(ordensGeradas);
            g.setPlanoManutencaoAtivoAtivo(planosExcedidos);
            g.setGeradoAutomaticamente(Short.valueOf((short)1));
            CoreRequestContext request = new CoreRequestContext();
            request.setAttribute("centroEstoqueReserva", opcao.getCentroEstoqueReserva());
            request.setAttribute("gerarNecessidadeCompra", opcao.getReservarEstoque());
            request.setAttribute("geracaoOrdemServicoPlanoManutencao", g);
            UtilityGeracaoOrdemServicoPlanoManutencao.salvarGeracao(request);
        }
    }
}

