/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.geracaotitulo;

import com.touchcomp.basementor.model.vo.BoletoTitulo;
import com.touchcomp.basementor.model.vo.GeracaoTitulos;
import com.touchcomp.basementor.model.vo.LancamentoEventoCooperado;
import com.touchcomp.basementor.model.vo.Titulo;
import java.util.ArrayList;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.geracaotitulo.UtilGeracaoTitulo;

public class ServiceGeracaoTitulo
extends CoreService {
    public static final String VERIFICA_BAIXA_TITULO = "verificaBaixaTitulo";
    public static final String ATUALIZAR_DADOS = "atualizarDados";
    public static final String DELETE_GERACAO_TITULO = "deleteGeracaoTitulo";

    public Short verificaBaixaTitulo(CoreRequestContext r) throws ExceptionService {
        Long idTitulo = (Long)r.getAttribute("idTitulo");
        return new UtilGeracaoTitulo().verificarBaixasEmTitulos(idTitulo);
    }

    public Object atualizarDados(CoreRequestContext r) throws ExceptionService {
        GeracaoTitulos geracaoTitulo = (GeracaoTitulos)r.getAttribute("geracaoTitulo");
        geracaoTitulo = (GeracaoTitulos)CoreService.simpleSave(CoreDAOFactory.getInstance().getDAOGeracaoTitulos(), geracaoTitulo);
        return geracaoTitulo;
    }

    public void deleteGeracaoTitulo(CoreRequestContext r) throws ExceptionService, ExceptionDatabase {
        GeracaoTitulos geracaoTitulo = (GeracaoTitulos)r.getAttribute("geracaoTitulo");
        ArrayList<Titulo> titulos = new ArrayList<Titulo>();
        ArrayList<LancamentoEventoCooperado> eventos = new ArrayList<LancamentoEventoCooperado>();
        for (Titulo t : geracaoTitulo.getTitulos()) {
            t.setGeracaoTitulos(null);
            t.setLancamentoCooperado(null);
            if (t.getBoletoTitulo() != null && !t.getBoletoTitulo().isEmpty()) {
                for (BoletoTitulo b : t.getBoletoTitulo()) {
                    b.setTitulo(null);
                    b.setAtivo(Short.valueOf((short)0));
                }
            }
            titulos.add((Titulo)CoreDAOFactory.getInstance().getDAOTitulo().saveOrUpdate(t));
            CoreBdUtil.getInstance().getSession().flush();
        }
        CoreService.simpleDeleteCollection(CoreDAOFactory.getInstance().getDAOTitulo(), titulos);
        for (LancamentoEventoCooperado l : geracaoTitulo.getLancamentosEventos()) {
            l.setGeracaoTitulo(null);
            eventos.add((LancamentoEventoCooperado)CoreDAOFactory.getInstance().getDAOLancamentoEventoCooperado().saveOrUpdate(l));
            CoreBdUtil.getInstance().getSession().flush();
        }
        CoreService.simpleDeleteCollection(CoreDAOFactory.getInstance().getDAOLancamentoEventoCooperado(), eventos);
        CoreBdUtil.getInstance().getSession().flush();
        geracaoTitulo = (GeracaoTitulos)CoreDAOFactory.getInstance().getDAOGeracaoTitulos().findByPrimaryKey(geracaoTitulo.getIdentificador());
        CoreDAOFactory.getInstance().getDAOGeracaoTitulos().delete(geracaoTitulo);
    }
}

