/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.gradecorservice;

import com.touchcomp.basementor.model.vo.Cor;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.ProdutoGrade;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;

public class ServiceGradeCor
extends CoreService {
    public static final String FIND_PRIMEIRA_GRADE_COR = "findPrimeiraGradeCor";
    public static final String FIND_GRADE_COR = "findGradeCor";
    public static final String FIND_FIRST_GRADE_COR_POR_COD_BARRAS_PRODUTO = "findfirstGradeCorCodBarrasProduto";
    public static final String FIND_GRADE_COR_POR_COD_BARRAS = "findGradeCorCodigoBarras";
    public static final String CRIAR_SALVAR_GRADE_UNICA_PRODUTO = "criaESalvaGradeUnica";

    public Object findPrimeiraGradeCor(CoreRequestContext r) {
        Produto prod = (Produto)r.getAttribute("produto");
        return CoreDAOFactory.getInstance().getDAOGradeCor().findPrimeiraGradeCor(prod);
    }

    public List findGradeCor(CoreRequestContext r) {
        Long idProduto = (Long)r.getAttribute("idProduto");
        return CoreDAOFactory.getInstance().getDAOGradeCor().findGradeCor(idProduto);
    }

    public Object findfirstGradeCorCodBarrasProduto(CoreRequestContext r) {
        String codBarras = (String)r.getAttribute("codBarras");
        return CoreDAOFactory.getInstance().getDAOGradeCor().findfirstGradeCorCodBarrasProduto(codBarras);
    }

    public Object findGradeCorCodigoBarras(CoreRequestContext r) {
        String codBarras = (String)r.getAttribute("codBarras");
        return CoreDAOFactory.getInstance().getDAOGradeCor().findGradeCorCodigoBarras(codBarras);
    }

    public GradeCor criaESalvaGradeUnica(CoreRequestContext cq) throws ExceptionDatabase {
        Produto prod = (Produto)cq.getAttribute("produto");
        Cor cor = (Cor)cq.getAttribute("cor");
        GradeCor found = (GradeCor)CoreDAOFactory.getInstance().getDAOGradeCor().existeGradeCorAtivaInativa(prod);
        if (found == null) {
            ProdutoGrade pg = new ProdutoGrade();
            pg.setDataCadastro(new Date());
            pg.setEmpresa(prod.getEmpresa());
            pg.setProduto(prod);
            pg.setDataUltModificacao(new Date());
            GradeCor g = new GradeCor();
            g.setCor(cor);
            g.setGradePrincipal(Short.valueOf((short)0));
            g.setAtivo(Short.valueOf((short)1));
            g.setProdutoGrade(pg);
            ArrayList<GradeCor> a = new ArrayList<GradeCor>();
            a.add(g);
            pg.setGradesCores(a);
            ProdutoGrade prodGrade = (ProdutoGrade)CoreDAOFactory.getInstance().getDAOProduto().saveOrUpdate(pg);
            found = (GradeCor)prodGrade.getGradesCores().get(0);
        }
        return found;
    }
}

