/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.gradeformulaproduto;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeFormulaProduto;
import com.touchcomp.basementor.model.vo.ItemGradeFormulaProduto;
import com.touchcomp.basementor.model.vo.ItemPlanejProdLinProdPrevConsProd;
import com.touchcomp.basementor.model.vo.NecessidadeProducao;
import com.touchcomp.basementor.model.vo.OpcoesPCP;
import com.touchcomp.basementor.model.vo.OrdemServicoProdLinhaProd;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanejProdLinProdPrevConsProd;
import com.touchcomp.basementor.model.vo.PlanejamentoProdLinhaProd;
import com.touchcomp.basementor.model.vo.SubdivisaoOSProdLinhaProd;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import org.nfunk.jep.function.Abs;
import org.nfunk.jep.function.Ceil;
import org.nfunk.jep.function.Floor;
import org.nfunk.jep.function.PostfixMathCommandI;
import org.nfunk.jep.function.Round;

public class AuxCalculaFormulacaoProdutos {
    private TLogger logger = TLogger.get(this.getClass());
    private short CALCULO_PREV_PROD_OS = 0;

    Object calcularMaterialNecessarioSubOsAbertas(Short filtraProduto, Long prodInicial, Long prodFinal, Short filtraData, Date dataInicial, Date dataFinal, Short tipoRel, Date dataPosicao, Empresa empresa, Short filtraEspecie, Long especieInicial, Long especieFinal, Short filtraSubEspecie, Long subEspecieInicial, Long subEspecieFinal, Short filtraFabricante, Long fabricanteInicial, Long fabricanteFinal, Short filtrarLocalizacao, Long localizacaoInicial, Long localizacaoFinal, Short exibirUltCompra, Long periodoProducao, List osNaoSalva, Short tipoAnaliseCompra, OpcoesPCP opcoesPCP, Short calcularApenasPlanej, PlanejamentoProdLinhaProd pl) throws ExceptionDatabase, ExceptionService {
        List<HashMap> formProd = new LinkedList<HashMap>();
        List<HashMap> qtdPrevProd = new LinkedList<HashMap>();
        List<Object> qtdPrevProdNecProd = new LinkedList();
        tipoRel = 1;
        if (calcularApenasPlanej == null || calcularApenasPlanej == 0) {
            if (tipoRel == 0) {
                formProd = this.getFormProdPOSLinha(filtraProduto, prodInicial, prodFinal, filtraData, dataInicial, dataFinal, filtraEspecie, especieInicial, especieFinal, filtraSubEspecie, subEspecieInicial, subEspecieFinal, filtraFabricante, fabricanteInicial, fabricanteFinal, periodoProducao);
                qtdPrevProd = this.getPrevQtdProdFormProdPOSLinha(filtraProduto, prodInicial, prodFinal, filtraData, dataInicial, dataFinal, filtraEspecie, especieInicial, especieFinal, filtraSubEspecie, subEspecieInicial, subEspecieFinal, filtraFabricante, fabricanteInicial, fabricanteFinal, periodoProducao);
            } else {
                formProd = this.getFormProdPSubOS(filtraProduto, prodInicial, prodFinal, filtraData, dataInicial, dataFinal, filtraEspecie, especieInicial, especieFinal, filtraSubEspecie, subEspecieInicial, subEspecieFinal, filtraFabricante, fabricanteInicial, fabricanteFinal, periodoProducao, pl);
                qtdPrevProd = this.getPrevQtdProdFormProdPSubOS(filtraProduto, prodInicial, prodFinal, filtraData, dataInicial, dataFinal, filtraEspecie, especieInicial, especieFinal, filtraSubEspecie, subEspecieInicial, subEspecieFinal, filtraFabricante, fabricanteInicial, fabricanteFinal, periodoProducao);
                qtdPrevProdNecProd = this.getPrevQtdProdNecProducao(filtraProduto, prodInicial, prodFinal, filtraData, dataInicial, dataFinal, filtraEspecie, especieInicial, especieFinal, filtraSubEspecie, subEspecieInicial, subEspecieFinal, filtraFabricante, fabricanteInicial, fabricanteFinal, periodoProducao);
            }
        }
        this.putOsNaoSalvas(osNaoSalva, formProd, tipoRel, calcularApenasPlanej);
        this.putQtdPrev(formProd, qtdPrevProd);
        this.putSaldosEstoque(formProd, dataPosicao, empresa, filtraProduto, prodInicial, prodFinal, filtraEspecie, especieInicial, especieFinal, filtraSubEspecie, subEspecieInicial, subEspecieFinal, filtraFabricante, fabricanteInicial, fabricanteFinal, filtrarLocalizacao, localizacaoInicial, localizacaoFinal);
        if (exibirUltCompra != null && exibirUltCompra == 1) {
            Iterator<HashMap> iterator = formProd.iterator();
            while (iterator.hasNext()) {
                HashMap o;
                HashMap h = o = iterator.next();
                this.putDadosUltCompraProduto(h);
                h.put("QUANTIDADE_COMPRADA", CoreDAOFactory.getInstance().getDAOOrdemCompra().putDadosOrdemCompra((Number)h.get("ID_GRADE_COR")));
            }
        }
        this.processarQtdNecessaria(formProd, tipoAnaliseCompra, opcoesPCP);
        return this.convertHashToObject(formProd, empresa);
    }

    private List<HashMap> getFormProdPSubOS(Short filtraProduto, Long prodInicial, Long prodFinal, Short filtraData, Date dataInicial, Date dataFinal, Short filtraEspecie, Long especieInicial, Long especieFinal, Short filtraSubEspecie, Long subEspecieInicial, Long subEspecieFinal, Short filtraFabricante, Long fabricanteInicial, Long fabricanteFinal, Long periodoProducao, PlanejamentoProdLinhaProd pl) {
        Object st = "select pr.identificador as ID_PRODUTO, pr.codigoAuxiliar as CODIGO_AUXILIAR, pr.nome as PRODUTO, cor.nome as GRADE, gc.identificador as ID_GRADE_COR, sum(((cast(itForm.percAdicional as double)/100 * cast(itForm.quantidade as double)) +itForm.quantidade) * s.quantidadeRefPrevProd) as QUANTIDADE, pr.qtdMin as QTD_MIN, pr.qtdMax as QTD_MAX, esp.nome as ESPECIE, sub.nome as SUB_ESPECIE, unid.sigla as UNIDADE_MEDIDA, pr.pontoRessupEstoque as PTO_RESSUPRIMENTO, parc.identificador as PARCEIRO  from SubdivisaoOSProdLinhaProd s inner join s.gradeFormulaProduto form inner join form.itemGradeFormulaProduto itForm inner join itForm.gradeCor gc inner join gc.cor cor inner join gc.produtoGrade pg inner join pg.produto pr inner join pr.unidadeMedida unid inner join pr.especie esp inner join pr.subEspecie sub inner join pr.fabricante fab inner join s.ordemServicoProdLinhaProd o inner join o.periodoProducao periodo left join o.pessoaParceiro parc left join o.itemPlanProducaoOSLinProd i left join i.itemPlanejamentoProducao ip left join ip.planejamentoProdLinProd p where s.dataFechamento is null and periodo.identificador = :periodo ";
        if (filtraData != null && filtraData == 1) {
            st = (String)st + " and s.dataPrevisao between :dataInicial and :dataFinal";
        }
        if (filtraProduto != null && filtraProduto == 1) {
            st = (String)st + " and pr.identificador between :idInicial and :idFinal";
        }
        if (filtraEspecie != null && filtraEspecie == 1) {
            st = (String)st + " and esp.identificador between :idEspecieInicial and :idEspecieFinal";
        }
        if (filtraSubEspecie != null && filtraSubEspecie == 1) {
            st = (String)st + " and sub.identificador between :idSubEspecieInicial and :idSubEspecieFinal";
        }
        if (filtraFabricante != null && filtraFabricante == 1) {
            st = (String)st + " and fab.identificador between :idFabricanteInicial and :idFabricanteFinal";
        }
        if (pl != null && pl.getIdentificador() > 0L) {
            st = (String)st + " and p.identificador<>:planejamento";
        }
        st = (String)st + " group by pr.identificador, pr.codigoAuxiliar, pr.nome, cor.nome, gc.identificador, pr.qtdMin, pr.qtdMax, pr.pontoRessupEstoque, esp.nome, unid.sigla, sub.nome, parc.identificador";
        st = (String)st + " order by pr.nome";
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)st);
        q.setLong("periodo", periodoProducao.longValue());
        if (filtraData != null && filtraData == 1) {
            q.setDate("dataInicial", dataInicial);
            q.setDate("dataFinal", dataFinal);
        }
        if (filtraProduto != null && filtraProduto == 1) {
            q.setLong("idInicial", prodInicial.longValue());
            q.setLong("idFinal", prodFinal.longValue());
        }
        if (filtraEspecie != null && filtraEspecie == 1) {
            q.setLong("idEspecieInicial", especieInicial.longValue());
            q.setLong("idEspecieFinal", especieFinal.longValue());
        }
        if (filtraSubEspecie != null && filtraSubEspecie == 1) {
            q.setLong("idSubEspecieInicial", subEspecieInicial.longValue());
            q.setLong("idSubEspecieFinal", subEspecieFinal.longValue());
        }
        if (filtraFabricante != null && filtraFabricante == 1) {
            q.setLong("idFabricanteInicial", fabricanteInicial.longValue());
            q.setLong("idFabricanteFinal", fabricanteFinal.longValue());
        }
        if (pl != null && pl.getIdentificador() > 0L) {
            q.setLong("planejamento", pl.getIdentificador().longValue());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List<HashMap> getFormProdPOSLinha(Short filtraProduto, Long prodInicial, Long prodFinal, Short filtraData, Date dataInicial, Date dataFinal, Short filtraEspecie, Long especieInicial, Long especieFinal, Short filtraSubEspecie, Long subEspecieInicial, Long subEspecieFinal, Short filtraFabricante, Long fabricanteInicial, Long fabricanteFinal, Long periodoProducao) {
        Object st = "select itemForm.gradeCor.produtoGrade.produto.identificador as ID_PRODUTO, itemForm.gradeCor.produtoGrade.produto.codigoAuxiliar as CODIGO_AUXILIAR, itemForm.gradeCor.produtoGrade.produto.nome as PRODUTO, itemForm.gradeCor.cor.nome as GRADE, itemForm.gradeCor.identificador as ID_GRADE_COR, itemForm.gradeCor.produtoGrade.produto.especie.nome as ESPECIE, itemForm.gradeCor.produtoGrade.produto.subEspecie.nome as SUB_ESPECIE, sum(((itemForm.percAdicional/100 * itemForm.quantidade)+itemForm.quantidade) *  s.quantidadeRefPrevProd) as QUANTIDADE, itemForm.gradeCor.produtoGrade.produto.qtdMin as QTD_MIN, itemForm.gradeCor.produtoGrade.produto.qtdMax as QTD_MAX, itemForm.gradeCor.produtoGrade.produto.pontoRessupEstoque as PTO_RESSUPRIMENTO, itemForm.gradeCor.produtoGrade.produto.unidadeMedida.sigla as UNIDADE_MEDIDA, s.pessoaParceiro.identificador as PARCEIRO from OrdemServicoProdLinhaProd s inner join s.gradeFormulaProduto form inner join form.itemGradeFormulaProduto itemForm where  s.periodoProducao.identificador = :periodo";
        if (filtraData != null && filtraData == 1) {
            st = (String)st + " and s.dataPrevisao between :dataInicial and :dataFinal";
        }
        if (filtraProduto != null && filtraProduto == 1) {
            st = (String)st + " and itemForm.gradeCor.produtoGrade.produto.identificador between :idInicial and :idFinal";
        }
        if (filtraEspecie != null && filtraEspecie == 1) {
            st = (String)st + " and itemForm.gradeCor.produtoGrade.produto.especie.identificador between :idEspecieInicial and :idEspecieFinal";
        }
        if (filtraSubEspecie != null && filtraSubEspecie == 1) {
            st = (String)st + " and itemForm.gradeCor.produtoGrade.produto.subEspecie.identificador between :idSubEspecieInicial and :idSubEspecieFinal";
        }
        if (filtraFabricante != null && filtraFabricante == 1) {
            st = (String)st + " and s.gradeCor.produtoGrade.produto.fabricante.identificador between :idFabricanteInicial and :idFabricanteFinal";
        }
        st = (String)st + " group by itemForm.gradeCor.produtoGrade.produto.identificador, itemForm.gradeCor.produtoGrade.produto.codigoAuxiliar, itemForm.gradeCor.produtoGrade.produto.nome, itemForm.gradeCor.cor.nome, itemForm.gradeCor.identificador, itemForm.gradeCor.produtoGrade.produto.qtdMin, itemForm.gradeCor.produtoGrade.produto.qtdMax, itemForm.gradeCor.produtoGrade.produto.pontoRessupEstoque, itemForm.gradeCor.produtoGrade.produto.especie.nome, itemForm.gradeCor.produtoGrade.produto.subEspecie.nome, itemForm.gradeCor.produtoGrade.produto.unidadeMedida.sigla, s.pessoaParceiro.identificador";
        st = (String)st + " order by itemForm.gradeCor.produtoGrade.produto.nome ";
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)st);
        q.setLong("periodo", periodoProducao.longValue());
        if (filtraData != null && filtraData == 1) {
            q.setDate("dataInicial", dataInicial);
            q.setDate("dataFinal", dataFinal);
        }
        if (filtraProduto != null && filtraProduto == 1) {
            q.setLong("idInicial", prodInicial.longValue());
            q.setLong("idFinal", prodFinal.longValue());
        }
        if (filtraEspecie != null && filtraEspecie == 1) {
            q.setLong("idEspecieInicial", especieInicial.longValue());
            q.setLong("idEspecieFinal", especieFinal.longValue());
        }
        if (filtraSubEspecie != null && filtraSubEspecie == 1) {
            q.setLong("idSubEspecieInicial", subEspecieInicial.longValue());
            q.setLong("idSubEspecieFinal", subEspecieFinal.longValue());
        }
        if (filtraFabricante != null && filtraFabricante == 1) {
            q.setLong("idFabricanteInicial", fabricanteInicial.longValue());
            q.setLong("idFabricanteFinal", fabricanteFinal.longValue());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private void putSaldosEstoque(List<HashMap> formProd, Date dataPosicao, Empresa empresa, Short filtraProduto, Long prodInicial, Long prodFinal, Short filtraEspecie, Long especieInicial, Long especieFinal, Short filtraSubEspecie, Long subEspecieInicial, Long subEspecieFinal, Short filtraFabricante, Long fabricanteInicial, Long fabricanteFinal, Short filtrarLocalizacao, Long localizacaoInicial, Long localizacaoFinal) {
        Object idCentro = null;
        if (filtraEspecie == null || filtraEspecie != 1) {
            especieFinal = null;
            especieInicial = null;
        }
        if (filtraSubEspecie == null || filtraSubEspecie != 1) {
            subEspecieFinal = null;
            subEspecieInicial = null;
        }
        if (filtraFabricante == null || filtraFabricante != 1) {
            fabricanteFinal = null;
            fabricanteInicial = null;
        }
        if (filtraProduto == null || filtraProduto != 1) {
            prodFinal = null;
            prodInicial = null;
        }
        if (filtrarLocalizacao == null || filtrarLocalizacao != 1) {
            localizacaoFinal = null;
            localizacaoInicial = null;
        }
        this.setarParceiros(formProd, empresa);
        Iterator<HashMap> iterator = formProd.iterator();
        while (iterator.hasNext()) {
            HashMap o;
            HashMap itemFormulacao = o = iterator.next();
            Long idParceiro = (Long)itemFormulacao.get("PARCEIRO");
            Long idProduto = (Long)itemFormulacao.get("ID_PRODUTO");
            Long idGradeCor = (Long)itemFormulacao.get("ID_GRADE_COR");
            List<Map> hashProdutos = idParceiro == null || idParceiro.equals(empresa.getPessoa().getIdentificador()) ? this.getSaldoProduto(dataPosicao, idProduto, idGradeCor, null, empresa, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue()) : this.getSaldoProduto(dataPosicao, idProduto, idGradeCor, idParceiro, empresa, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_TERCEIROS.getValue());
            if (hashProdutos != null && hashProdutos.size() > 0) {
                Map saldo = hashProdutos.get(0);
                itemFormulacao.putAll(saldo);
            }
            if (itemFormulacao.get("SALDO_QTD") != null) continue;
            itemFormulacao.put("SALDO_QTD", 0.0);
        }
    }

    private List<Map> getSaldoProduto(Date dataPosicao, Long idProduto, Long idGradeCor, Long idParceiro, Empresa empresa, Short tipoCentroEstoqueParc) {
        return CoreDAOFactory.getInstance().getDAOSaldoEstProprio().getSaldoProdutoEstoqueDisponivelOrNaoDisponivielProprioOrTerceiros(dataPosicao, idProduto, idProduto, 0L, 999999999L, 0L, 999999999L, 0L, 999999999L, 0L, 999999999L, 0L, 999999999L, idGradeCor, idGradeCor, 0, 99, (short)2, empresa.getIdentificador(), EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_DISPONIVEL.getValue(), tipoCentroEstoqueParc, idParceiro);
    }

    private void putDadosUltCompraProduto(HashMap h) {
        Number idGradeCor = (Number)h.get("ID_GRADE_COR");
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select  n.dataEntrada as DATA_ENTRADA, n.unidadeFatFornecedor.fornecedor.pessoa.nome as FORNECEDOR, n.unidadeFatFornecedor.fornecedor.pessoa.complemento.cnpj as CNPJ, i.valorUnitario as VALOR_UNITARIO, n.numeroNota as NUMERO_NOTA, n.unidadeFatFornecedor.fornecedor.pessoa.complemento.fone1 as FONE from ItemNotaTerceiros i  inner join i.grade g inner join i.notaFiscalTerceiros n where n.dataEntrada = (select max(nn.dataEntrada) from ItemNotaTerceiros ii inner join ii.grade gg  inner join ii.notaFiscalTerceiros nn  where gg.gradeCor.identificador=:id_grade) and g.gradeCor.identificador=:id_grade");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        q.setLong("id_grade", idGradeCor.longValue());
        List notas = q.list();
        h.put("NOTAS_FISCAIS", notas);
        double vlr = 0.0;
        double contador = 0.0;
        for (Object o : notas) {
            HashMap hash = (HashMap)o;
            double vlrUnitario = (Double)hash.get("VALOR_UNITARIO");
            vlr += vlrUnitario;
            contador += 1.0;
        }
        if (contador <= 0.0) {
            contador = 1.0;
        }
        h.put("VALOR_MEDIO", vlr / contador);
    }

    private void putOsNaoSalvas(List osNaoSalva, List<HashMap> formProd, Short tipoRel, Short processarPlanejamento) throws ExceptionDatabase {
        if (osNaoSalva == null) {
            return;
        }
        for (Object o : osNaoSalva) {
            OrdemServicoProdLinhaProd os = (OrdemServicoProdLinhaProd)o;
            if (tipoRel == this.CALCULO_PREV_PROD_OS) {
                this.putGradesTemporarias(os.getGradeFormulaProduto(), os.getQuantidadeRefPrevProd(), formProd, os);
                this.putProducaoProdutosTemporario(os.getGradeCor(), os.getQuantidadeRefPrevProd(), formProd);
                continue;
            }
            this.definirModeoFormProduto(os, formProd);
            for (SubdivisaoOSProdLinhaProd s : os.getSubDivisoesOS()) {
                this.putGradesTemporarias(s.getGradeFormulaProduto(), s.getQuantidadeRefPrevProd(), formProd, s.getOrdemServicoProdLinhaProd());
                this.putProducaoProdutosTemporario(s.getGradeCor(), s.getQuantidadeRefPrevProd(), formProd);
                for (NecessidadeProducao nec : s.getNecessidadesProducao()) {
                    this.putProducaoProdutosTemporario(nec.getGradeCor(), nec.getQuantidade(), formProd);
                }
            }
        }
    }

    private void definirModeoFormProduto(OrdemServicoProdLinhaProd os, List<HashMap> formProd) {
        for (SubdivisaoOSProdLinhaProd subOs : os.getSubDivisoesOS()) {
            GradeFormulaProduto gf = subOs.getGradeFormulaProduto();
            for (ItemGradeFormulaProduto it : gf.getItemGradeFormulaProduto()) {
                Long idParceiro = 0L;
                Long idGradeCor = it.getGradeCor().getIdentificador();
                if (os.getPessoaParceiro() != null) {
                    idParceiro = os.getPessoaParceiro().getIdentificador();
                }
                Long idParceiroF = idParceiro;
                Optional<HashMap> found = formProd.stream().filter(i -> ToolMethods.isEqualsNumber((Number)idGradeCor, (Number)((Number)i.get("ID_GRADE_COR"))) && ToolMethods.isEqualsNumber((Number)idParceiroF, (Number)((Number)i.get("PARCEIRO")))).findFirst();
                if (found.isPresent()) continue;
                HashMap hash = this.getDadosBaseGradeCor(it.getGradeCor());
                if (os.getPessoaParceiro() != null) {
                    hash.put("PARCEIRO", idParceiro);
                }
                hash.put("QUANTIDADE", 0.0);
                hash.put("DESCRICAO_CALC", "");
                hash.put("LIST_PRODUTOS", new ArrayList());
                if (formProd.contains(hash)) continue;
                formProd.add(hash);
            }
        }
    }

    private void putGradesTemporarias(GradeFormulaProduto gf, Double qtd, List<HashMap> formProd, OrdemServicoProdLinhaProd os) throws ExceptionDatabase {
        if (gf == null) {
            return;
        }
        for (ItemGradeFormulaProduto it : gf.getItemGradeFormulaProduto()) {
            HashMap found = null;
            GradeCor gc = it.getGradeCor();
            for (HashMap h : formProd) {
                Long idParceiro = (Long)h.get("PARCEIRO");
                if (!h.get("ID_GRADE_COR").equals(gc.getIdentificador()) || idParceiro == null || os.getPessoaParceiro() == null || !idParceiro.equals(os.getPessoaParceiro().getIdentificador())) continue;
                found = h;
                break;
            }
            if (found == null) {
                found = this.getDadosBaseGradeCor(gc);
                if (os.getPessoaParceiro() != null) {
                    found.put("PARCEIRO", os.getPessoaParceiro().getIdentificador());
                }
                found.put("QUANTIDADE", 0.0);
                found.put("DESCRICAO_CALC", "");
                found.put("LIST_PRODUTOS", new ArrayList());
                formProd.add(found);
            }
            Double calc = 0.0;
            try {
                calc = (it.getPercAdicional() / 100.0 * it.getQuantidade() + it.getQuantidade()) * qtd;
            }
            catch (Exception ex) {
                throw new ExceptionDatabase("Verifique os campos da formula\u00e7\u00e3o/item, onde devem estar nulos ou preenchidos incorretamente: " + String.valueOf(it.getGradeCor().getProdutoGrade().getProduto()) + "/" + String.valueOf(it.getGradeFormulaProduto()));
            }
            found.put("QUANTIDADE", (Double)found.get("QUANTIDADE") + calc);
            List listProdutos = (List)found.get("LIST_PRODUTOS");
            this.criarItemProdutosGradesTemporarias(listProdutos, it, calc, qtd);
            Object desc = (String)found.get("DESCRICAO_CALC");
            desc = (String)desc + "\n ";
            desc = (String)desc + " Prod: " + os.getGradeCor().getProdutoGrade().getProduto().getIdentificador();
            desc = (String)desc + " Form: " + gf.getIdentificador();
            desc = (String)desc + " Fator: " + ContatoFormatUtil.formataNumero((Number)gf.getQuantidadeReferenciaProd(), (int)10);
            desc = (String)desc + " Qtd Form: " + ContatoFormatUtil.formataNumero((Number)it.getQuantidade(), (int)6);
            desc = (String)desc + " % Adic: " + ContatoFormatUtil.formataNumero((Number)it.getPercAdicional(), (int)6);
            desc = (String)desc + " Qtd OS: " + ContatoFormatUtil.formataNumero((Number)qtd, (int)6);
            desc = (String)desc + " Calc: " + ContatoFormatUtil.formataNumero((Number)calc, (int)6);
            found.put("DESCRICAO_CALC", desc);
        }
    }

    private void criarItemProdutosGradesTemporarias(List<HashMap> listProdutos, ItemGradeFormulaProduto it, Double calc, Double qtd) {
        Boolean b = true;
        for (HashMap h : listProdutos) {
            Double comprimento = (Double)h.get("COMPRIMENTO");
            Double altura = (Double)h.get("ALTURA");
            Double largura = (Double)h.get("LARGURA");
            if (!comprimento.equals(it.getComprimento()) || !altura.equals(it.getAltura()) || !largura.equals(it.getLargura())) continue;
            h.put("QUANTIDADE", (Double)h.get("QUANTIDADE") + calc);
            h.put("QTD_REFERENCIA", (Double)h.get("QTD_REFERENCIA") + qtd);
            b = false;
            break;
        }
        if (b.booleanValue()) {
            HashMap<String, Double> ha = new HashMap<String, Double>();
            ha.put("QUANTIDADE", calc);
            ha.put("QTD_REFERENCIA", qtd);
            ha.put("COMPRIMENTO", it.getComprimento());
            ha.put("ALTURA", it.getAltura());
            ha.put("LARGURA", it.getLargura());
            ha.put("VOLUME", it.getVolume());
            listProdutos.add(ha);
        }
    }

    private HashMap getDadosBaseGradeCor(GradeCor gc) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select  gc.produtoGrade.produto.identificador as ID_PRODUTO, gc.produtoGrade.produto.codigoAuxiliar as CODIGO_AUXILIAR, gc.produtoGrade.produto.nome as PRODUTO, gc.cor.nome as GRADE, gc.identificador as ID_GRADE_COR, gc.produtoGrade.produto.qtdMin as QTD_MIN, gc.produtoGrade.produto.qtdMax as QTD_MAX, gc.produtoGrade.produto.especie.nome as ESPECIE, gc.produtoGrade.produto.subEspecie.nome as SUB_ESPECIE, gc.produtoGrade.produto.unidadeMedida.sigla as UNIDADE_MEDIDA, gc.produtoGrade.produto.pontoRessupEstoque as PTO_RESSUPRIMENTO from GradeCor gc where gc=:gc");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        q.setEntity("gc", (Object)gc);
        return (HashMap)q.uniqueResult();
    }

    private void putProducaoProdutosTemporario(GradeCor gradeCor, Double quantidadePrevProd, List<HashMap> formProd) {
        for (HashMap o : formProd) {
            HashMap h = o;
            Long idGradeCor = (Long)h.get("ID_GRADE_COR");
            if (!idGradeCor.equals(gradeCor.getIdentificador())) continue;
            if (h.get("QTD_PREV_PRODUCAO") == null) {
                h.put("QTD_PREV_PRODUCAO", 0.0);
            }
            h.put("QTD_PREV_PRODUCAO", (Double)h.get("QTD_PREV_PRODUCAO") + quantidadePrevProd);
        }
    }

    private List<HashMap> getPrevQtdProdFormProdPSubOS(Short filtraProduto, Long prodInicial, Long prodFinal, Short filtraData, Date dataInicial, Date dataFinal, Short filtraEspecie, Long especieInicial, Long especieFinal, Short filtraSubEspecie, Long subEspecieInicial, Long subEspecieFinal, Short filtraFabricante, Long fabricanteInicial, Long fabricanteFinal, Long periodoProducao) {
        Object st = "select p.identificador as ID_PRODUTO, p.codigoAuxiliar as CODIGO_AUXILIAR, p.nome as PRODUTO, c.nome as GRADE, gc.identificador as ID_GRADE_COR, sum(s.quantidadeRefPrevProd) as QTD_PREV_PRODUCAO, p.qtdMin as QTD_MIN, p.qtdMax as QTD_MAX, e.nome as ESPECIE, su.nome as SUB_ESPECIE, un.sigla as UNIDADE_MEDIDA, p.pontoRessupEstoque as PTO_RESSUPRIMENTO from SubdivisaoOSProdLinhaProd s inner join s.gradeFormulaProduto form inner join s.gradeCor gc inner join gc.cor c inner join gc.produtoGrade pg inner join pg.produto p inner join p.especie e inner join p.subEspecie su inner join p.fabricante f inner join p.unidadeMedida un inner join s.ordemServicoProdLinhaProd os inner join os.periodoProducao pp where s.dataFechamento is null and pp.identificador = :periodo ";
        if (filtraData != null && filtraData == 1) {
            st = (String)st + " and s.dataPrevisao between :dataInicial and :dataFinal";
        }
        if (filtraProduto != null && filtraProduto == 1) {
            st = (String)st + " and p.identificador between :idInicial and :idFinal";
        }
        if (filtraEspecie != null && filtraEspecie == 1) {
            st = (String)st + " and e.identificador between :idEspecieInicial and :idEspecieFinal";
        }
        if (filtraSubEspecie != null && filtraSubEspecie == 1) {
            st = (String)st + " and su.identificador between :idSubEspecieInicial and :idSubEspecieFinal";
        }
        if (filtraFabricante != null && filtraFabricante == 1) {
            st = (String)st + " and f.identificador between :idFabricanteInicial and :idFabricanteFinal";
        }
        st = (String)st + " group by p.identificador, p.codigoAuxiliar, p.nome, c.nome, gc.identificador, p.qtdMin, p.qtdMax, p.pontoRessupEstoque, e.nome, un.sigla, su.nome";
        st = (String)st + " order by gc.identificador";
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)st);
        q.setLong("periodo", periodoProducao.longValue());
        if (filtraData != null && filtraData == 1) {
            q.setDate("dataInicial", dataInicial);
            q.setDate("dataFinal", dataFinal);
        }
        if (filtraProduto != null && filtraProduto == 1) {
            q.setLong("idInicial", prodInicial.longValue());
            q.setLong("idFinal", prodFinal.longValue());
        }
        if (filtraEspecie != null && filtraEspecie == 1) {
            q.setLong("idEspecieInicial", especieInicial.longValue());
            q.setLong("idEspecieFinal", especieFinal.longValue());
        }
        if (filtraSubEspecie != null && filtraSubEspecie == 1) {
            q.setLong("idSubEspecieInicial", subEspecieInicial.longValue());
            q.setLong("idSubEspecieFinal", subEspecieFinal.longValue());
        }
        if (filtraFabricante != null && filtraFabricante == 1) {
            q.setLong("idFabricanteInicial", fabricanteInicial.longValue());
            q.setLong("idFabricanteFinal", fabricanteFinal.longValue());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List<HashMap> getPrevQtdProdFormProdPOSLinha(Short filtraProduto, Long prodInicial, Long prodFinal, Short filtraData, Date dataInicial, Date dataFinal, Short filtraEspecie, Long especieInicial, Long especieFinal, Short filtraSubEspecie, Long subEspecieInicial, Long subEspecieFinal, Short filtraFabricante, Long fabricanteInicial, Long fabricanteFinal, Long periodoProducao) {
        Object st = "select s.gradeCor.produtoGrade.produto.identificador as ID_PRODUTO, s.gradeCor.produtoGrade.produto.codigoAuxiliar as CODIGO_AUXILIAR, s.gradeCor.produtoGrade.produto.nome as PRODUTO, s.gradeCor.cor.nome as GRADE, s.gradeCor.identificador as ID_GRADE_COR, s.gradeCor.produtoGrade.produto.especie.nome as ESPECIE, s.gradeCor.produtoGrade.produto.subEspecie.nome as SUB_ESPECIE, sum(s.quantidadeRefPrevProd) as QTD_PREV_PRODUCAO, s.gradeCor.produtoGrade.produto.qtdMin as QTD_MIN, s.gradeCor.produtoGrade.produto.qtdMax as QTD_MAX, s.gradeCor.produtoGrade.produto.pontoRessupEstoque as PTO_RESSUPRIMENTO, s.gradeCor.produtoGrade.produto.unidadeMedida.sigla as UNIDADE_MEDIDA from OrdemServicoProdLinhaProd s where  s.periodoProducao.identificador = :periodo";
        if (filtraData != null && filtraData == 1) {
            st = (String)st + " and s.dataPrevisao between :dataInicial and :dataFinal";
        }
        if (filtraProduto != null && filtraProduto == 1) {
            st = (String)st + " and s.gradeCor.produtoGrade.produto.identificador between :idInicial and :idFinal";
        }
        if (filtraEspecie != null && filtraEspecie == 1) {
            st = (String)st + " and s.gradeCor.produtoGrade.produto.especie.identificador between :idEspecieInicial and :idEspecieFinal";
        }
        if (filtraSubEspecie != null && filtraSubEspecie == 1) {
            st = (String)st + " and s.gradeCor.produtoGrade.produto.subEspecie.identificador between :idSubEspecieInicial and :idSubEspecieFinal";
        }
        if (filtraFabricante != null && filtraFabricante == 1) {
            st = (String)st + " and s.gradeCor.produtoGrade.produto.fabricante.identificador between :idFabricanteInicial and :idFabricanteFinal";
        }
        st = (String)st + " group by s.gradeCor.produtoGrade.produto.identificador, s.gradeCor.produtoGrade.produto.codigoAuxiliar, s.gradeCor.produtoGrade.produto.nome, s.gradeCor.cor.nome, s.gradeCor.identificador, s.gradeCor.produtoGrade.produto.qtdMin, s.gradeCor.produtoGrade.produto.qtdMax, s.gradeCor.produtoGrade.produto.pontoRessupEstoque, s.gradeCor.produtoGrade.produto.especie.nome, s.gradeCor.produtoGrade.produto.subEspecie.nome, s.gradeCor.produtoGrade.produto.unidadeMedida.sigla";
        st = (String)st + " order by s.gradeCor.identificador";
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)st);
        q.setLong("periodo", periodoProducao.longValue());
        if (filtraData != null && filtraData == 1) {
            q.setDate("dataInicial", dataInicial);
            q.setDate("dataFinal", dataFinal);
        }
        if (filtraProduto != null && filtraProduto == 1) {
            q.setLong("idInicial", prodInicial.longValue());
            q.setLong("idFinal", prodFinal.longValue());
        }
        if (filtraEspecie != null && filtraEspecie == 1) {
            q.setLong("idEspecieInicial", especieInicial.longValue());
            q.setLong("idEspecieFinal", especieFinal.longValue());
        }
        if (filtraSubEspecie != null && filtraSubEspecie == 1) {
            q.setLong("idSubEspecieInicial", subEspecieInicial.longValue());
            q.setLong("idSubEspecieFinal", subEspecieFinal.longValue());
        }
        if (filtraFabricante != null && filtraFabricante == 1) {
            q.setLong("idFabricanteInicial", fabricanteInicial.longValue());
            q.setLong("idFabricanteFinal", fabricanteFinal.longValue());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List<HashMap> getPrevQtdProdNecProducao(Short filtraProduto, Long prodInicial, Long prodFinal, Short filtraData, Date dataInicial, Date dataFinal, Short filtraEspecie, Long especieInicial, Long especieFinal, Short filtraSubEspecie, Long subEspecieInicial, Long subEspecieFinal, Short filtraFabricante, Long fabricanteInicial, Long fabricanteFinal, Long periodoProducao) {
        Object st = "select s.gradeCor.produtoGrade.produto.identificador as ID_PRODUTO, s.gradeCor.produtoGrade.produto.codigoAuxiliar as CODIGO_AUXILIAR, s.gradeCor.produtoGrade.produto.nome as PRODUTO, s.gradeCor.cor.nome as GRADE, s.gradeCor.identificador as ID_GRADE_COR, s.gradeCor.produtoGrade.produto.especie.nome as ESPECIE, s.gradeCor.produtoGrade.produto.subEspecie.nome as SUB_ESPECIE, sum(s.quantidade) as QTD_PREV_PRODUCAO, s.gradeCor.produtoGrade.produto.qtdMin as QTD_MIN, s.gradeCor.produtoGrade.produto.qtdMax as QTD_MAX, s.gradeCor.produtoGrade.produto.pontoRessupEstoque as PTO_RESSUPRIMENTO, s.gradeCor.produtoGrade.produto.unidadeMedida.sigla as UNIDADE_MEDIDA from NecessidadeProducao s left join s.subdivisaoOSLinhaProd sub left join sub.ordemServicoProdLinhaProd o where  o.periodoProducao.identificador = :periodo";
        if (filtraData != null && filtraData == 1) {
            st = (String)st + " and o.dataPrevisao between :dataInicial and :dataFinal";
        }
        if (filtraProduto != null && filtraProduto == 1) {
            st = (String)st + " and s.gradeCor.produtoGrade.produto.identificador between :idInicial and :idFinal";
        }
        if (filtraEspecie != null && filtraEspecie == 1) {
            st = (String)st + " and s.gradeCor.produtoGrade.produto.especie.identificador between :idEspecieInicial and :idEspecieFinal";
        }
        if (filtraSubEspecie != null && filtraSubEspecie == 1) {
            st = (String)st + " and s.gradeCor.produtoGrade.produto.subEspecie.identificador between :idSubEspecieInicial and :idSubEspecieFinal";
        }
        if (filtraFabricante != null && filtraFabricante == 1) {
            st = (String)st + " and s.gradeCor.produtoGrade.produto.fabricante.identificador between :idFabricanteInicial and :idFabricanteFinal";
        }
        st = (String)st + " group by s.gradeCor.produtoGrade.produto.identificador, s.gradeCor.produtoGrade.produto.codigoAuxiliar, s.gradeCor.produtoGrade.produto.nome, s.gradeCor.cor.nome, s.gradeCor.identificador, s.gradeCor.produtoGrade.produto.qtdMin, s.gradeCor.produtoGrade.produto.qtdMax, s.gradeCor.produtoGrade.produto.pontoRessupEstoque, s.gradeCor.produtoGrade.produto.especie.nome, s.gradeCor.produtoGrade.produto.subEspecie.nome, s.gradeCor.produtoGrade.produto.unidadeMedida.sigla";
        st = (String)st + " order by s.gradeCor.identificador";
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)st);
        q.setLong("periodo", periodoProducao.longValue());
        if (filtraData != null && filtraData == 1) {
            q.setDate("dataInicial", dataInicial);
            q.setDate("dataFinal", dataFinal);
        }
        if (filtraProduto != null && filtraProduto == 1) {
            q.setLong("idInicial", prodInicial.longValue());
            q.setLong("idFinal", prodFinal.longValue());
        }
        if (filtraEspecie != null && filtraEspecie == 1) {
            q.setLong("idEspecieInicial", especieInicial.longValue());
            q.setLong("idEspecieFinal", especieFinal.longValue());
        }
        if (filtraSubEspecie != null && filtraSubEspecie == 1) {
            q.setLong("idSubEspecieInicial", subEspecieInicial.longValue());
            q.setLong("idSubEspecieFinal", subEspecieFinal.longValue());
        }
        if (filtraFabricante != null && filtraFabricante == 1) {
            q.setLong("idFabricanteInicial", fabricanteInicial.longValue());
            q.setLong("idFabricanteFinal", fabricanteFinal.longValue());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private void putQtdPrev(List<HashMap> formProd, List<HashMap> qtdPrevProd) {
        Iterator<HashMap> iterator = formProd.iterator();
        while (iterator.hasNext()) {
            HashMap ob;
            Long idGradeEst;
            HashMap o;
            HashMap h = o = iterator.next();
            Long idGrade = (Long)h.get("ID_GRADE_COR");
            HashMap hEst = null;
            Iterator<HashMap> iterator2 = qtdPrevProd.iterator();
            while (iterator2.hasNext() && !idGrade.equals((long)(idGradeEst = (Long)(hEst = (ob = iterator2.next())).get("ID_GRADE_COR")))) {
                hEst = null;
            }
            if (hEst == null) continue;
            qtdPrevProd.remove(hEst);
            h.putAll(hEst);
        }
    }

    private void processarQtdNecessaria(List<HashMap> formProd, Short tipoAnaliseCompra, OpcoesPCP opcoesPCP) throws ExceptionService {
        Iterator<HashMap> iterator = formProd.iterator();
        while (iterator.hasNext()) {
            HashMap o;
            HashMap h = o = iterator.next();
            Number qtdMax = (Number)h.get("QTD_MAX");
            Number qtdMin = (Number)h.get("QTD_MIN");
            Number qtdPtoSup = (Number)h.get("PTO_RESSUPRIMENTO");
            Number qtdComprada = (Number)h.get("QUANTIDADE_COMPRADA");
            Number qtd = (Number)h.get("QUANTIDADE");
            Number saldoQtd = (Number)h.get("SALDO_QTD");
            Number qtdPrevProd = (Number)h.get("QTD_PREV_PRODUCAO");
            qtdMax = qtdMax == null ? (Number)0.0 : (Number)qtdMax;
            qtdMin = qtdMin == null ? (Number)0.0 : (Number)qtdMin;
            qtdPtoSup = qtdPtoSup == null ? (Number)0.0 : (Number)qtdPtoSup;
            saldoQtd = saldoQtd == null ? (Number)0.0 : (Number)saldoQtd;
            qtdComprada = qtdComprada == null ? (Number)0.0 : (Number)qtdComprada;
            qtd = qtd == null ? (Number)0.0 : (Number)qtd;
            qtdPrevProd = qtdPrevProd == null ? (Number)0.0 : (Number)qtdPrevProd;
            double qtdAnalCompra = 0.0;
            qtdAnalCompra = tipoAnaliseCompra != null && tipoAnaliseCompra == 2 ? qtdMax.doubleValue() : (tipoAnaliseCompra != null && tipoAnaliseCompra == 0 ? qtdMin.doubleValue() : qtdPtoSup.doubleValue());
            String formula = opcoesPCP.getFormulaCalculoPrevisaoConsumo();
            double aux = 0.0;
            if (formula != null && !formula.isEmpty()) {
                aux = this.getTotalFormulaCalculoQtdeProduzida(formula, qtdMin, qtdMax, qtdPtoSup, saldoQtd, qtd, qtdPrevProd);
                aux = aux < 0.0 ? (aux *= -1.0) : 0.0;
            } else {
                throw new ExceptionService("Primeiro, informe a f\u00f3rmula de c\u00e1lculo de previs\u00e3o de consumo de materiais em Op\u00e7\u00f5es de PCP!");
            }
            h.put("PONTO_ESTOQUE", qtdAnalCompra);
            h.put("QUANTIDADE_FALTA", aux);
        }
    }

    private void setarParceiros(List<HashMap> formProd, Empresa empresa) {
        for (HashMap h : formProd) {
            Long idParceiro = (Long)h.get("PARCEIRO");
            if (idParceiro != null) continue;
            h.put("PARCEIRO", empresa.getPessoa().getIdentificador());
        }
    }

    private List<PlanejProdLinProdPrevConsProd> convertHashToObject(List<HashMap> formProd, Empresa emp) throws ExceptionDatabase {
        LinkedList<PlanejProdLinProdPrevConsProd> ret = new LinkedList<PlanejProdLinProdPrevConsProd>();
        for (HashMap h : formProd) {
            PlanejProdLinProdPrevConsProd p = new PlanejProdLinProdPrevConsProd();
            Double qtd = (Double)h.get("QUANTIDADE");
            String descCalc = (String)h.get("DESCRICAO_CALC");
            Number pontoEstoque = (Number)h.get("PONTO_ESTOQUE");
            Number qtdPrevProd = (Number)h.get("QTD_PREV_PRODUCAO");
            Number saldoQtd = (Number)h.get("SALDO_QTD");
            Number qtdFalta = (Number)h.get("QUANTIDADE_FALTA");
            Number qtdMin = (Number)h.get("QTD_MIN");
            Number qtdRessuprimento = (Number)h.get("PTO_RESSUPRIMENTO");
            Number qtdMax = (Number)h.get("QTD_MAX");
            Number vlrPrecoMedio = (Number)h.get("VLR_PRECO_MEDIO");
            Number idGradeCor = (Number)h.get("ID_GRADE_COR");
            Number idParceiro = (Number)h.get("PARCEIRO");
            List notasFiscais = (List)h.get("NOTAS_FISCAIS");
            List listProdutos = (List)h.get("LIST_PRODUTOS");
            GradeCor gc = (GradeCor)CoreDAOFactory.getInstance().getDAOGradeCor().findByPrimaryKey(idGradeCor.longValue());
            p.setGradeCor(gc);
            if (idParceiro != null) {
                Pessoa par = (Pessoa)CoreDAOFactory.getInstance().getDAOPessoa().findByPrimaryKey(idParceiro.longValue());
                p.setParceiro(par);
            }
            p.setQuantidade(qtd);
            p.setPontoEstoque(Double.valueOf(pontoEstoque != null ? pontoEstoque.doubleValue() : 0.0));
            p.setQtdePrevProducao(Double.valueOf(qtdPrevProd != null ? qtdPrevProd.doubleValue() : 0.0));
            p.setQtdeSaldo(Double.valueOf(saldoQtd != null ? saldoQtd.doubleValue() : 0.0));
            p.setQtdeFalta(Double.valueOf(qtdFalta != null ? qtdFalta.doubleValue() : 0.0));
            p.setQtdeMin(Double.valueOf(qtdMin != null ? qtdMin.doubleValue() : 0.0));
            p.setQtdeMax(Double.valueOf(qtdMax != null ? qtdMax.doubleValue() : 0.0));
            p.setQtdeRessuprimento(Double.valueOf(qtdRessuprimento != null ? qtdRessuprimento.doubleValue() : 0.0));
            p.setVlrPrecoMedio(Double.valueOf(vlrPrecoMedio != null ? vlrPrecoMedio.doubleValue() : 0.0));
            p.setObservacao(descCalc);
            if (qtdFalta != null && qtdFalta.doubleValue() > 0.0 && (p.getParceiro() == null || p.getParceiro().equals((Object)emp.getPessoa()))) {
                p.setQtdCompra(Double.valueOf(qtdFalta.doubleValue()));
                p.setEnviarParaCompras(Short.valueOf((short)1));
            }
            if (saldoQtd != null && saldoQtd.doubleValue() > 0.0 && qtd != null && qtd > 0.0) {
                Double aux = saldoQtd.doubleValue() > qtd ? qtd.doubleValue() : saldoQtd.doubleValue();
                p.setQtdReserva(aux);
                p.setEnviarParaReserva(Short.valueOf((short)1));
            }
            p.setNotasFiscais(notasFiscais);
            if (listProdutos != null) {
                for (HashMap ha : listProdutos) {
                    Double quantidade = (Double)ha.get("QUANTIDADE");
                    Double qtdReferencia = (Double)ha.get("QTD_REFERENCIA");
                    Double comprimento = (Double)ha.get("COMPRIMENTO");
                    Double altura = (Double)ha.get("ALTURA");
                    Double largura = (Double)ha.get("LARGURA");
                    Double volume = (Double)ha.get("VOLUME");
                    ItemPlanejProdLinProdPrevConsProd i = new ItemPlanejProdLinProdPrevConsProd();
                    i.setQuantidade(quantidade);
                    i.setQtdReferencia(qtdReferencia);
                    i.setComprimento(comprimento);
                    i.setAltura(altura);
                    i.setLargura(largura);
                    i.setVolume(volume);
                    i.setPlanejProdLinProdPrevConsProd(p);
                    p.getItemPlanejProdLinProdPrevConsProd().add(i);
                }
            }
            ret.add(p);
        }
        return ret;
    }

    private Double getTotalFormulaCalculoQtdeProduzida(String expressao, Number estoqueMinimo, Number estoqueMaximo, Number pontoRessuprimento, Number qtdeEstoque, Number qtdeFormulacao, Number qtdePrevistaProducao) throws ExceptionService {
        List token = ToolString.getReplaceTokens((String)expressao);
        HashMap<String, String> m = new HashMap<String, String>();
        for (Object o : token) {
            StringToken sk = (StringToken)o;
            String chave = sk.getChave();
            String valor = "0";
            if (chave.equals("estoque")) {
                valor = qtdeEstoque.toString();
            } else if (chave.equals("estoque_maximo")) {
                valor = estoqueMaximo.toString();
            } else if (chave.equals("estoque_minimo")) {
                valor = estoqueMinimo.toString();
            } else if (chave.equals("ponto_ressuprimento")) {
                valor = pontoRessuprimento.toString();
            } else if (chave.equals("qtde_formulacao")) {
                valor = qtdeFormulacao.toString();
            } else if (chave.equals("qtde_prevista_producao")) {
                valor = qtdePrevistaProducao.toString();
            }
            m.put(chave, valor);
        }
        expressao = ToolString.build((String)expressao, m);
        JEP myParser = new JEP();
        myParser.addFunction("arredondar", (PostfixMathCommandI)new Round());
        myParser.addFunction("teto", (PostfixMathCommandI)new Ceil());
        myParser.addFunction("piso", (PostfixMathCommandI)new Floor());
        myParser.addFunction("abs", (PostfixMathCommandI)new Abs());
        try {
            Node node = myParser.parse(expressao);
            Double b = (Double)myParser.evaluate(node);
            return b;
        }
        catch (Throwable ex) {
            this.logger.error(ex.getClass(), ex);
            throw new ExceptionService("Erro ao avaliar a expressao: " + expressao);
        }
    }
}

