/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.gradeformulaproduto;

import com.touchcomp.basementor.model.vo.AlteracaoFormulacaoProduto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeFormulaProduto;
import com.touchcomp.basementor.model.vo.OpcoesPCP;
import com.touchcomp.basementor.model.vo.PlanejamentoProdLinhaProd;
import com.touchcomp.basementor.model.vo.Produto;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.gradeformulaproduto.AuxCalculaFormulacaoProdutos;

public class ServiceGradeFormulaProduto
extends CoreService {
    public static final String SALVAR_IMPORTAR_FORMULACOES = "salvarImportarFormulacoes";
    public static final String FIND_GRADE_FORMULA_PRODUTO_BY_PRODUTO = "findGradeFormulaProdutoByProduto";
    public static final String FIND_GRADE_FORMULA_ATIVOS = "findGradeFormulaAtivos";
    public static final String FIND_GRADE_FORMULA_PRODUTO_ATIVOS = "findGradeFormulaProdutoAtivos";
    public static final String CALCULAR_MATERIAL_NECESSARIO_SUB_OS_ABERTAS = "calcularMaterialNecessarioSubOsAbertas";
    public static final String PESQUISAR_FORM_CONTEM_PRODUTO = "pesquisarFormContemProduto";
    public static final String EXISTE_FORMULACAO_PRODUTO_GRADE = "existeFormulacaoProdutoGrade";
    public static final String SALVAR_ALTERACAO_GRADE_FORMULA_PRODUTO = "salvarAlteracaoGradeFormulaProduto";

    public void salvarImportarFormulacoes(CoreRequestContext request) throws ExceptionDatabase {
        List formulacoes = (List)request.getAttribute("formulacoes");
        Short criarForm = (Short)request.getAttribute("criarForm");
        for (GradeFormulaProduto formulacoe : formulacoes) {
            if (criarForm != null && criarForm == 1) {
                CoreDAOFactory.getInstance().getDAOGradeFormulaProduto().inativarFormulacoes(formulacoe.getGradeCor());
            }
            CoreDAOFactory.getInstance().getDAOGradeFormulaProduto().saveOrUpdate(formulacoe);
        }
    }

    public Object findGradeFormulaProdutoByProduto(CoreRequestContext request) {
        return CoreDAOFactory.getInstance().getDAOGradeFormulaProduto().findGradeFormulaProdutoByProduto(request);
    }

    public Object findGradeFormulaAtivos(CoreRequestContext request) {
        GradeCor gc = (GradeCor)request.getAttribute("gradeCor");
        List found = CoreDAOFactory.getInstance().getDAOGradeFormulaProduto().findGradeFormulaAtivos(gc);
        return found;
    }

    public Object findGradeFormulaProdutoAtivos(CoreRequestContext request) {
        Produto gc = (Produto)request.getAttribute("produto");
        return CoreDAOFactory.getInstance().getDAOGradeFormulaProduto().findGradeFormulaAtivos(gc);
    }

    public Object calcularMaterialNecessarioSubOsAbertas(CoreRequestContext c) throws ExceptionDatabase, ExceptionService {
        Short filtraEspecie = (Short)c.getAttribute("FILTRAR_ESPECIE");
        Long especieInicial = (Long)c.getAttribute("ID_ESPECIE_INICIAL");
        Long especieFinal = (Long)c.getAttribute("ID_ESPECIE_FINAL");
        Short filtraProduto = (Short)c.getAttribute("FILTRAR_PRODUTO");
        Long prodInicial = (Long)c.getAttribute("ID_PRODUTO_INICIAL");
        Long prodFinal = (Long)c.getAttribute("ID_PRODUTO_FINAL");
        Short filtraSubespecie = (Short)c.getAttribute("FILTRAR_SUBESPECIE");
        Long subespecieInicial = (Long)c.getAttribute("ID_SUBESPECIE_INICIAL");
        Long subespecieFinal = (Long)c.getAttribute("ID_SUBESPECIE_FINAL");
        Short filtraFabricante = (Short)c.getAttribute("FILTRAR_FABRICANTE");
        Long fabricanteInicial = (Long)c.getAttribute("ID_FABRICANTE_INICIAL");
        Long fabricanteFinal = (Long)c.getAttribute("ID_FABRICANTE_FINAL");
        Short filtrarLocalizacao = (Short)c.getAttribute("FILTRAR_LOCALIZACAO");
        Long localizacaoInicial = (Long)c.getAttribute("LOCALIZACAO_INICIAL");
        Long localizacaoFinal = (Long)c.getAttribute("LOCALIZACAO_FINAL");
        Short filtraData = (Short)c.getAttribute("FILTRAR_DATA");
        Date dataInicial = (Date)c.getAttribute("DATA_INICIAL");
        Date dataFinal = (Date)c.getAttribute("DATA_FINAL");
        Date dataPosicao = (Date)c.getAttribute("DATA_CONSULTA");
        Long periodoProducao = (Long)c.getAttribute("ID_PERIODO_PRODUCAO");
        Short tipoRelatorio = (Short)c.getAttribute("TIPO_RELATORIO");
        Short exibirUltCompra = (Short)c.getAttribute("EXIBIR_ULT_COMPRA");
        Short simulacao = (Short)c.getAttribute("SIMULACAO");
        Short calcularApenasPlanej = (Short)c.getAttribute("CALCULAR_APENAS_PLANEJ");
        Short tipoAnaliseCompra = (Short)c.getAttribute("TIPO_ANALISE_COMPRA");
        Empresa empresa = (Empresa)c.getAttribute("EMPRESA");
        PlanejamentoProdLinhaProd pl = (PlanejamentoProdLinhaProd)c.getAttribute("PLANEJAMENTO");
        OpcoesPCP opcoesPcp = (OpcoesPCP)c.getAttribute("OPCOES_PCP");
        List osTemp = (List)c.getAttribute("OS_TEMP");
        return new AuxCalculaFormulacaoProdutos().calcularMaterialNecessarioSubOsAbertas(filtraProduto, prodInicial, prodFinal, filtraData, dataInicial, dataFinal, tipoRelatorio, dataPosicao, empresa, filtraEspecie, especieInicial, especieFinal, filtraSubespecie, subespecieInicial, subespecieFinal, filtraFabricante, fabricanteInicial, fabricanteFinal, filtrarLocalizacao, localizacaoInicial, localizacaoFinal, exibirUltCompra, periodoProducao, osTemp, tipoAnaliseCompra, opcoesPcp, calcularApenasPlanej, pl);
    }

    public Object pesquisarFormContemProduto(CoreRequestContext cr) {
        GradeCor gc = (GradeCor)cr.getAttribute("gradeCor");
        return CoreDAOFactory.getInstance().getDAOGradeFormulaProduto().pesquisarFormContemGradeCor(gc);
    }

    public Object existeFormulacaoProdutoGrade(CoreRequestContext cr) {
        GradeCor gc = (GradeCor)cr.getAttribute("gradeCor");
        return CoreDAOFactory.getInstance().getDAOGradeFormulaProduto().pesquisarFormContemGradeCor(gc);
    }

    public void salvarAlteracaoGradeFormulaProduto(CoreRequestContext cr) throws ExceptionDatabase {
        List formulacoes = (List)cr.getAttribute("formulacoes");
        ArrayList<GradeFormulaProduto> grades = new ArrayList<GradeFormulaProduto>();
        for (AlteracaoFormulacaoProduto al : formulacoes) {
            if (al.getStatusAnterior().equals(al.getGradeFormulaProduto().getAtivo())) continue;
            al.getGradeFormulaProduto().getAlteracoesFormulacao().add(al);
            al.setDataModificacao(new Timestamp(new Date().getTime()));
            grades.add(al.getGradeFormulaProduto());
        }
        CoreDAOFactory.getInstance().getDAOGradeFormulaProduto().saveOrUpdateCollection(grades);
    }
}

