/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.grupocaractformulacao;

import com.touchcomp.basementor.model.vo.CaracteristicaProduto;
import com.touchcomp.basementor.model.vo.Cor;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeFormProdTpSpedProd;
import com.touchcomp.basementor.model.vo.GradeFormulaProduto;
import com.touchcomp.basementor.model.vo.GrupoCaractFormCarac;
import com.touchcomp.basementor.model.vo.GrupoCaractFormCaracItem;
import com.touchcomp.basementor.model.vo.GrupoCaractFormulacao;
import com.touchcomp.basementor.model.vo.GrupoProdutos;
import com.touchcomp.basementor.model.vo.ItemGradeFormulaProduto;
import com.touchcomp.basementor.model.vo.ItemGradeGrupoFormProduto;
import com.touchcomp.basementor.model.vo.ItemGrupoProdGupoFormProduto;
import com.touchcomp.basementor.model.vo.NaturezaRequisicao;
import com.touchcomp.basementor.model.vo.OpcoesPCP;
import com.touchcomp.basementor.model.vo.Produto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.DateUtil;

public class UtilGrupoCaractFormulacao {
    public GrupoCaractFormulacao gerarFormulacoesSobreGrupoFormulacao(GrupoCaractFormulacao grupo, Cor cor, OpcoesPCP opcoes) throws ExceptionService, ExceptionDatabase {
        GrupoProdutos gr = grupo.getGrupoProdutos();
        for (Produto p : gr.getProdutos()) {
            GradeFormulaProduto found = this.getGradeFormulaProdGer(grupo.getGradesFormulaGeradas(), p);
            if (found == null) {
                grupo.getGradesFormulaGeradas().add(this.newGradeFormula(grupo, p, cor, opcoes));
                continue;
            }
            found.getItemGradeFormulaProduto().clear();
            this.setarItensFormulacao(p, grupo, found);
        }
        return (GrupoCaractFormulacao)CoreDAOFactory.getInstance().getDAOGrupoCaractFormulacao().saveOrUpdate(grupo);
    }

    private GradeFormulaProduto getGradeFormulaProdGer(List<GradeFormulaProduto> gradesFormulaGeradas, Produto p) {
        for (GradeFormulaProduto gf : gradesFormulaGeradas) {
            if (!gf.getGradeCor().getProdutoGrade().getProduto().equals((Object)p)) continue;
            return gf;
        }
        return null;
    }

    private GradeFormulaProduto newGradeFormula(GrupoCaractFormulacao grupo, Produto p, Cor cor, OpcoesPCP opcoes) throws ExceptionService {
        GradeCor gc = this.findGradeCor(p);
        if (gc == null) {
            throw new ExceptionService("Produto " + p.getNome() + " n\u00e3o possui grade cadastrada.");
        }
        GradeFormulaProduto form = new GradeFormulaProduto(gc);
        form.setAtivo(Short.valueOf((short)1));
        form.setFormulacaoPrincipal(Short.valueOf((short)1));
        form.setDataCadastro(DateUtil.getCurrentDate());
        form.setDescricao(p.getNome());
        form.setEmpresa(grupo.getGrupoProdutos().getEmpresa());
        form.setGradeCor(gc);
        form.setGrupoCaractFormulacao(grupo);
        form.setQuantidadeReferenciaProd(Double.valueOf(1.0));
        this.setarItensFormulacao(p, grupo, form);
        GradeFormProdTpSpedProd g = new GradeFormProdTpSpedProd();
        g.setTipoProducaoSped(opcoes.getTipoProducaoSpedPadrao());
        g.setGradeFormulaProduto(form);
        form.getGradeFormProdTpSpedProd().add(g);
        return form;
    }

    private GradeCor findGradeCor(Produto p) throws ExceptionService {
        CoreRequestContext cq = new CoreRequestContext();
        cq.setAttribute("produto", p);
        GradeCor gc = (GradeCor)CoreServiceFactory.getServiceGradeCor().execute(cq, "findPrimeiraGradeCor");
        return gc;
    }

    private void setarItensFormulacao(Produto p, GrupoCaractFormulacao grupo, GradeFormulaProduto nova) throws ExceptionService {
        ArrayList<ItemGradeFormulaProduto> itensformulacao = new ArrayList<ItemGradeFormulaProduto>();
        for (ItemGrupoProdGupoFormProduto item : grupo.getItensGrupoProdutos()) {
            GradeCor found = this.getItemCaracteristicas(item, p);
            if (found == null) continue;
            ItemGradeFormulaProduto newItem = new ItemGradeFormulaProduto();
            newItem.setGradeCor(found);
            newItem.setNaoRequisitarAutomatico(item.getNaoRequisitarAutomatico());
            newItem.setNaturezaRequisicao(item.getNaturezaRequisicao());
            newItem.setPercAdicional(item.getPercQuebra());
            newItem.setQuantidade(item.getQuantidade());
            newItem.setGradeFormulaProduto(nova);
            itensformulacao.add(newItem);
        }
        for (CaracteristicaProduto c : p.getCaracteristicasProdutos()) {
            itensformulacao.addAll(this.getItensFormulacaoCaract(c, grupo.getCaracteristicasForm(), nova, grupo.getNaturezaRequisicao()));
        }
        itensformulacao.addAll(this.getItensBaseFormulacao(grupo, nova));
        nova.setItemGradeFormulaProduto(itensformulacao);
    }

    private Collection getItensFormulacaoCaract(CaracteristicaProduto c, List<GrupoCaractFormCarac> caracteristicasForm, GradeFormulaProduto gradeFormula, NaturezaRequisicao nat) {
        ArrayList<ItemGradeFormulaProduto> itens = new ArrayList<ItemGradeFormulaProduto>();
        for (GrupoCaractFormCarac gr : caracteristicasForm) {
            if (!gr.getCaractertisticaProduto().equals((Object)c)) continue;
            for (GrupoCaractFormCaracItem item : gr.getItens()) {
                ItemGradeFormulaProduto newItem = new ItemGradeFormulaProduto();
                newItem.setGradeCor(item.getGradeCor());
                newItem.setNaoRequisitarAutomatico(Short.valueOf((short)0));
                newItem.setNaturezaRequisicao(nat);
                newItem.setPercAdicional(Double.valueOf(0.0));
                newItem.setQuantidade(item.getQuantidade());
                newItem.setGradeFormulaProduto(gradeFormula);
                itens.add(newItem);
            }
        }
        return itens;
    }

    private GradeCor getItemCaracteristicas(ItemGrupoProdGupoFormProduto item, Produto produtoGrupo) throws ExceptionService {
        GradeCor found = null;
        for (Produto aux : item.getGrupoProdutos().getProdutos()) {
            if (!this.caracacteristicasIguais(aux.getCaracteristicasProdutos(), produtoGrupo.getCaracteristicasProdutos())) continue;
            found = this.getFirstGradeCor(aux);
            System.out.println(found.getProdutoGrade().getProduto().getNome());
            break;
        }
        return found;
    }

    private boolean caracacteristicasIguais(List<CaracteristicaProduto> caractProdBase, List<CaracteristicaProduto> caractProdGrupo) {
        Boolean aux = null;
        for (CaracteristicaProduto c : caractProdBase) {
            if ((aux = aux == null ? Boolean.valueOf(caractProdGrupo.contains(c)) : Boolean.valueOf(aux != false && caractProdGrupo.contains(c))).booleanValue()) continue;
            break;
        }
        if (aux == null) {
            return false;
        }
        return aux;
    }

    private GradeCor getFirstGradeCor(Produto produto) throws ExceptionService {
        CoreRequestContext cq = new CoreRequestContext();
        cq.setAttribute("produto", produto);
        return (GradeCor)CoreServiceFactory.getServiceGradeCor().execute(cq, "findPrimeiraGradeCor");
    }

    private Collection getItensBaseFormulacao(GrupoCaractFormulacao grupo, GradeFormulaProduto gradeFormula) {
        ArrayList<ItemGradeFormulaProduto> itens = new ArrayList<ItemGradeFormulaProduto>();
        for (ItemGradeGrupoFormProduto item : grupo.getItensGrupoFormulaBase()) {
            ItemGradeFormulaProduto newItem = new ItemGradeFormulaProduto();
            newItem.setGradeCor(item.getGradeCor());
            newItem.setNaoRequisitarAutomatico(Short.valueOf((short)0));
            newItem.setNaturezaRequisicao(item.getNaturezaRequisicao());
            newItem.setPercAdicional(Double.valueOf(0.0));
            newItem.setQuantidade(item.getQuantidade());
            newItem.setGradeFormulaProduto(gradeFormula);
            itens.add(newItem);
        }
        return itens;
    }
}

