/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.integracaocontabil.requisicao;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeralBasico;
import com.touchcomp.basementor.model.vo.Empresa;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;

public class AuxCachePrecoMedioRequisicaoProd {
    private List<SaldoEstoqueGeralBasico> listSaldos = new ArrayList<SaldoEstoqueGeralBasico>();

    public double getPrecoMedioProd(Long idProduto, Date data, Empresa emp) {
        SaldoEstoqueGeralBasico sal = this.getSaldo(idProduto, data, emp);
        if (sal == null) {
            sal = CoreDAOFactory.getInstance().getDAOSaldoEstProprio().findSaldoProdutoUnicoBasico(idProduto, data, emp.getIdentificador(), 1, 1, 1, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS.getValue(), EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue(), null);
            this.listSaldos.add(sal);
        }
        if (sal == null) {
            return 0.0;
        }
        return sal.getValorMedio();
    }

    private SaldoEstoqueGeralBasico getSaldo(Long idProduto, Date data, Empresa emp) {
        for (SaldoEstoqueGeralBasico sal : this.listSaldos) {
            if (sal == null || sal.getIdProduto() == null || !sal.getIdProduto().equals(idProduto) || sal.getDataSaldo() == null || !sal.getDataSaldo().equals(data) || sal.getIdEmpresa() == null || !sal.getIdEmpresa().equals(emp.getIdentificador())) continue;
            return sal;
        }
        return null;
    }
}

