/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.lancamento;

import com.touchcomp.basementor.model.vo.AjusteApuracaoIcms;
import com.touchcomp.basementor.model.vo.Bem;
import com.touchcomp.basementor.model.vo.BorderoChequesTerceiros;
import com.touchcomp.basementor.model.vo.CentroResultadoContFin;
import com.touchcomp.basementor.model.vo.DepreciacaoBem;
import com.touchcomp.basementor.model.vo.DepreciacaoCiap;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.FaturaCte;
import com.touchcomp.basementor.model.vo.IntegAdiantViagemAdiantViagem;
import com.touchcomp.basementor.model.vo.IntegCustoProdVendidoData;
import com.touchcomp.basementor.model.vo.ItemCiapDepreciacaoBaixaBem;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.MovimentoBancario;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.NotaContratoLocacao;
import com.touchcomp.basementor.model.vo.OpcoesContTransp;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesLocacao;
import com.touchcomp.basementor.model.vo.OpcoesPatrimonio;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import java.util.Date;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionPlanoContaEventoNotFound;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.lancamento.UtilLancamentoAdiantamentoViagem;
import mentorcore.service.impl.lancamento.UtilLancamentoAjusteApuracaoIcms;
import mentorcore.service.impl.lancamento.UtilLancamentoBaixaBem;
import mentorcore.service.impl.lancamento.UtilLancamentoBorderoChequeTerceiros;
import mentorcore.service.impl.lancamento.UtilLancamentoContabilMovimentoFolha;
import mentorcore.service.impl.lancamento.UtilLancamentoCustoProdVendido;
import mentorcore.service.impl.lancamento.UtilLancamentoDepreciacaoBem;
import mentorcore.service.impl.lancamento.UtilLancamentoFaturaCte;
import mentorcore.service.impl.lancamento.UtilLancamentoMovBancario;
import mentorcore.service.impl.lancamento.UtilLancamentoNotaContratoLocacao;
import mentorcore.service.impl.lancamento.UtilLancamentoTituloAdicional;

public class ServiceLancamento
extends CoreService {
    public static final String INTEGRAR_DEPRECIACAO = "integrarDepreciacao";

    public DepreciacaoCiap integrarDepreciacao(CoreRequestContext request) throws Exception {
        DepreciacaoCiap depreciacao = (DepreciacaoCiap)request.getAttribute("depreciacao");
        OpcoesPatrimonio opcoesPatrimonio = (OpcoesPatrimonio)request.getAttribute("opcoesPatrimonio");
        for (ItemCiapDepreciacaoBaixaBem itemCiap : depreciacao.getItemCiapDepreciacaoBaixaBem()) {
            for (DepreciacaoBem depreciacaoBem : itemCiap.getDepreciacaoBem()) {
                new UtilLancamentoDepreciacaoBem().gerarLancamentos(depreciacaoBem, depreciacao.getPeriodo(), opcoesPatrimonio);
            }
        }
        return depreciacao;
    }

    public LoteContabil integrarDepreciacaoBem(DepreciacaoBem depreciacaoBem, Date periodo, OpcoesPatrimonio opcoesPatrimonio) throws Exception {
        return new UtilLancamentoDepreciacaoBem().gerarLancamentos(depreciacaoBem, periodo, opcoesPatrimonio);
    }

    public LoteContabil integrarBaixaBem(Bem bem, PlanoConta planoContaLucro, PlanoConta planoContaPrejuizo, Double valorLucroPrejuizo, Date dataBaixa) throws ExceptionService {
        return new UtilLancamentoBaixaBem().gerarLancamentos(bem, planoContaLucro, planoContaPrejuizo, valorLucroPrejuizo, dataBaixa);
    }

    public LoteContabil integrarAdiantamentoViagem(IntegAdiantViagemAdiantViagem adiantamentoViagem) throws ExceptionService {
        return new UtilLancamentoAdiantamentoViagem().gerarLancamentosAdiantamentoViagem(adiantamentoViagem);
    }

    public void integrarCustoProdVendidoLancamentoContabil(IntegCustoProdVendidoData vo, Empresa emp, Short gerarLancAnaliticos) throws ExceptionService {
        new UtilLancamentoCustoProdVendido().contabilizarCustoProdVendido(vo, emp, gerarLancAnaliticos);
    }

    public LoteContabil integrarMovimentoBancario(MovimentoBancario vo, CentroResultadoContFin centroResultadoContFin) throws ExceptionService {
        return new UtilLancamentoMovBancario().gerarLancamentos(vo, centroResultadoContFin);
    }

    public LoteContabil integrarAjusteApuracaoIcms(AjusteApuracaoIcms ajusteApuracaoIcms, Empresa empresa, Date dataApuracao) throws ExceptionService {
        return new UtilLancamentoAjusteApuracaoIcms().gerarLancamentos(ajusteApuracaoIcms, empresa, dataApuracao);
    }

    public LoteContabil integrarContratoLocacao(NotaContratoLocacao nota, OpcoesLocacao opcoesLocacao, OpcoesContabeis opCont) throws ExceptionService, ExceptionDatabase, ExceptionInvalidData {
        return new UtilLancamentoNotaContratoLocacao().gerarLancamentos(nota, opcoesLocacao, opCont);
    }

    public LoteContabil integrarGeracaoFaturamento(FaturaCte vo, OpcoesContTransp opcoesContabeisTransp, OpcoesContabeis opCont) throws ExceptionService, ExceptionInvalidData {
        LoteContabil lote = new UtilLancamentoFaturaCte().gerarLancamentos(vo, opcoesContabeisTransp, opCont);
        return lote;
    }

    public LoteContabil integrarMovimentoFolha(MovimentoFolha movimentoFolha, EmpresaRh empresaRH, EmpresaContabilidade empresaContabil, Short integrarLancamentoCtb) throws ExceptionService, ExceptionPlanoContaEventoNotFound {
        new UtilLancamentoContabilMovimentoFolha();
        return UtilLancamentoContabilMovimentoFolha.gerarLancamentosFinanceiros(movimentoFolha, empresaRH, empresaContabil, integrarLancamentoCtb);
    }

    public LoteContabil integrarBorderoChequeTerceiros(BorderoChequesTerceiros vo) throws ExceptionService {
        LoteContabil lote = new UtilLancamentoBorderoChequeTerceiros().gerarLancamentos(vo);
        return lote;
    }

    public LoteContabil integrarTituloAdicional(Titulo vo, String historicoFinal) throws ExceptionService {
        LoteContabil lote = new UtilLancamentoTituloAdicional().gerarLancamentos(vo, historicoFinal);
        return lote;
    }
}

