/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.lancamento;

import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.model.vo.AdiantamentoViagem;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FechamAdiantamentoViagem;
import com.touchcomp.basementor.model.vo.IntegAdiantViagemAdiantViagem;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.helpers.impl.lotecontabil.HelperLoteContabil;
import com.touchcomp.basementorspringcontext.Context;
import java.util.ArrayList;
import java.util.List;
import mentorcore.exceptions.ExceptionService;

class UtilLancamentoAdiantamentoViagem {
    private final HelperLoteContabil helperLote = (HelperLoteContabil)Context.get(HelperLoteContabil.class);

    UtilLancamentoAdiantamentoViagem() {
    }

    public LoteContabil gerarLancamentosAdiantamentoViagem(IntegAdiantViagemAdiantViagem integAdiantViagemAdiantViagem) throws ExceptionService {
        LoteContabil lote = integAdiantViagemAdiantViagem.getLoteContabil();
        AdiantamentoViagem vo = integAdiantViagemAdiantViagem.getAdiantamentoViagem().getAdiantamentoViagem();
        lote = this.helperLote.criaRecriaLoteContabil(lote, vo.getDataFechamento(), vo.getEmpresa().getEmpresaDados().getGrupoEmpresa(), ConstEnumOrigemLoteContabil.ADIANTAMENTO_VIAGEM);
        lote.getLancamentos().addAll(this.getLancamentosFechamento(vo, lote));
        return lote;
    }

    private List<Lancamento> getLancamentosFechamento(AdiantamentoViagem vo, LoteContabil lote) {
        ArrayList<Lancamento> lancamentos = new ArrayList<Lancamento>();
        if (vo.getFechamento() != null) {
            for (FechamAdiantamentoViagem f : vo.getFechamento().getDespesas()) {
                Lancamento lancamento = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)vo.getEmpresa());
                lancamento.setPlanoContaCred(vo.getPlanoConta());
                lancamento.setPlanoContaDeb(f.getDespesaViagem().getPlanoConta());
                lancamento.setHistorico("Valor Fechamento da despesa: " + f.getDespesaViagem().getDescricao() + " referente ao Adiantamento Viagem nr: " + vo.getIdentificador());
                lancamento.setValor(f.getVrDespesa());
                lancamentos.add(lancamento);
            }
        }
        return lancamentos;
    }
}

