/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.lancamento;

import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.model.vo.AjusteApuracaoIcms;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.helpers.impl.lotecontabil.HelperLoteContabil;
import com.touchcomp.basementorspringcontext.Context;
import java.util.Date;
import mentorcore.exceptions.ExceptionService;

class UtilLancamentoAjusteApuracaoIcms {
    private final HelperLoteContabil helperLote = (HelperLoteContabil)Context.get(HelperLoteContabil.class);

    UtilLancamentoAjusteApuracaoIcms() {
    }

    public LoteContabil gerarLancamentos(AjusteApuracaoIcms ajusteApuracaoIcms, Empresa empresa, Date dataLancamento) throws ExceptionService {
        LoteContabil lote = this.criarLoteContabil(ajusteApuracaoIcms, empresa, dataLancamento);
        if (lote.getLancamentos() != null && !lote.getLancamentos().isEmpty()) {
            return lote;
        }
        return null;
    }

    private LoteContabil criarLoteContabil(AjusteApuracaoIcms ajusteApuracaoIcms, Empresa empresa, Date dataLancamento) throws ExceptionService {
        if (dataLancamento == null) {
            throw new ExceptionService("Informe o Per\u00edodo de Apura\u00e7\u00e3o primeiro antes de salvar o Ajuste de Apura\u00e7\u00e3o!");
        }
        LoteContabil lote = this.helperLote.criaRecriaLoteContabil(ajusteApuracaoIcms.getLoteContabil(), dataLancamento, empresa, ConstEnumOrigemLoteContabil.AJUSTE_APURACAO_ICMS);
        lote.getLancamentos().add(this.criarLancamento(lote, ajusteApuracaoIcms, empresa));
        return lote;
    }

    private Lancamento criarLancamento(LoteContabil lote, AjusteApuracaoIcms ajusteApuracaoIcms, Empresa empresa) throws ExceptionService {
        if (ajusteApuracaoIcms.getTipoAjusteApIcms().getPlanoContaDebito() != null && ajusteApuracaoIcms.getTipoAjusteApIcms().getPlanoContaCredito() != null) {
            Lancamento lanc = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)empresa);
            lanc.setPlanoContaDeb(ajusteApuracaoIcms.getTipoAjusteApIcms().getPlanoContaDebito());
            lanc.setPlanoContaCred(ajusteApuracaoIcms.getTipoAjusteApIcms().getPlanoContaCredito());
            lanc.setHistoricoPadrao(null);
            lanc.setValor(ajusteApuracaoIcms.getValorAjuste());
            lanc.setHistorico("Valor de Ajuste Apura\u00e7\u00e3o de ICMS. " + ajusteApuracaoIcms.getDescricaoCompl());
            return lanc;
        }
        throw new ExceptionService("Nenhum Plano de Conta de D\u00e9bito e Cr\u00e9dito encontrado para contabiliza\u00e7\u00e3o do Ajuste Apura\u00e7\u00e3o de ICMS. \nVerifique o Tipo Ajuste Apura\u00e7\u00e3o ICMS!");
    }
}

