/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.lancamento;

import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.model.vo.Bem;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.helpers.impl.lotecontabil.HelperLoteContabil;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.exceptions.ExceptionService;

class UtilLancamentoBaixaBem {
    private final HelperLoteContabil helperLote = (HelperLoteContabil)Context.get(HelperLoteContabil.class);

    UtilLancamentoBaixaBem() {
    }

    public LoteContabil gerarLancamentos(Bem bem, PlanoConta planoContaLucro, PlanoConta planoContaPrejuizo, Double valorLucroPrejuizo, Date dataBaixa) throws ExceptionService {
        List<Lancamento> lancamentos = UtilLancamentoBaixaBem.getLancamentos(bem, planoContaLucro, planoContaPrejuizo, valorLucroPrejuizo);
        if (TMethods.isWithData(lancamentos)) {
            LoteContabil loteContabil = this.helperLote.criaRecriaLoteContabil(dataBaixa, bem.getEmpresa(), ConstEnumOrigemLoteContabil.BAIXA_BEM);
            loteContabil.setLancamentos(lancamentos);
            for (Lancamento lancamento : lancamentos) {
                lancamento.setLoteContabil(loteContabil);
                lancamento.setDataLancamento(lancamento.getLoteContabil().getDataLote());
            }
            return loteContabil;
        }
        return null;
    }

    private static List<Lancamento> getLancamentos(Bem bem, PlanoConta planoContaLucro, PlanoConta planoContaPrejuizo, Double valorLucroPrejuizo) throws ExceptionService {
        ArrayList<Lancamento> lancamentos = new ArrayList<Lancamento>();
        if (valorLucroPrejuizo != 0.0) {
            Lancamento lancamentoLucroPrejuizo = CompLancamentoBase.newLancamento((Empresa)bem.getEmpresa());
            lancamentoLucroPrejuizo.setHistorico("Valor " + (planoContaLucro != null ? "lucro " : "prejuizo ") + "referente a baixa do Bem: " + bem.getIdentificador() + " - " + bem.getDescricao());
            lancamentoLucroPrejuizo.setPlanoContaCred(planoContaPrejuizo);
            lancamentoLucroPrejuizo.setPlanoContaDeb(planoContaLucro);
            lancamentoLucroPrejuizo.setValor(valorLucroPrejuizo);
            lancamentos.add(lancamentoLucroPrejuizo);
        }
        if (lancamentos != null && lancamentos.size() > 0) {
            return lancamentos;
        }
        return null;
    }
}

