/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.lancamento;

import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.model.vo.BorderoChequeTerceirosMovBancario;
import com.touchcomp.basementor.model.vo.BorderoChequesTerceiros;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.helpers.impl.lotecontabil.HelperLoteContabil;
import com.touchcomp.basementorspringcontext.Context;
import java.util.List;
import mentorcore.tools.DateUtil;

public class UtilLancamentoBorderoChequeTerceiros {
    private final HelperLoteContabil helperLote = (HelperLoteContabil)Context.get(HelperLoteContabil.class);

    public LoteContabil gerarLancamentos(BorderoChequesTerceiros vo) {
        LoteContabil lote = this.contabilizarBordero(vo);
        if (lote.getLancamentos() != null && !lote.getLancamentos().isEmpty()) {
            return lote;
        }
        return null;
    }

    private LoteContabil contabilizarBordero(BorderoChequesTerceiros vo) {
        LoteContabil lote = this.helperLote.criaRecriaLoteContabil(vo.getLoteContabil(), vo.getDataBordero(), vo.getEmpresa(), ConstEnumOrigemLoteContabil.BORDERO_FINANCEIRO);
        lote.setLancamentos(this.getLancamentosBordero(vo, lote));
        return lote;
    }

    private List<Lancamento> getLancamentosBordero(BorderoChequesTerceiros vo, LoteContabil lote) {
        List lancamentos = lote.getLancamentos();
        Double valor = 0.0;
        for (BorderoChequeTerceirosMovBancario b : vo.getChequesTerceirosMovBancarios()) {
            valor = valor + b.getMovimentoBancarioCredito().getValor();
        }
        String historico = this.getHistorico(vo);
        if (valor > 0.0) {
            Lancamento lancamento = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)vo.getEmpresa());
            lancamento.setPlanoContaCred(vo.getCarteiraOrigem().getContaValor().getPlanoConta());
            lancamento.setPlanoContaDeb(vo.getCarteiraCobranca().getContaValor().getPlanoConta());
            lancamento.setValor(valor);
            lancamento.setHistorico(historico);
            lancamentos.add(lancamento);
        }
        return lancamentos;
    }

    private String getHistorico(BorderoChequesTerceiros vo) {
        StringBuilder sb = new StringBuilder();
        sb.append("Bordero Cheque Terceiros do dia: ");
        sb.append(DateUtil.dateToStr(vo.getDataBordero()));
        sb.append(". Cheques: ");
        int tamanho = vo.getChequesTerceirosMovBancarios().size();
        int count = 1;
        for (BorderoChequeTerceirosMovBancario b : vo.getChequesTerceirosMovBancarios()) {
            sb.append(b.getChequeTerceiros().getNumero());
            if (count < tamanho) {
                sb.append(",");
            } else {
                sb.append(".");
            }
            ++count;
        }
        return sb.toString();
    }
}

