/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.lancamento;

import com.touchcomp.basementor.constants.enums.EnumConstSinteticoAnalitico;
import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.model.vo.AberturaPeriodo;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.HistoricoPadrao;
import com.touchcomp.basementor.model.vo.ItemMovCentroCustoColaborador;
import com.touchcomp.basementor.model.vo.ItemMovimentoFolha;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LancamentoCTBCentroCustos;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.MovimentoCentroCustoColaborador;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.ParametrizacaoContabilizacaoFolha;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaImpostoFolha;
import com.touchcomp.basementor.model.vo.TipoCalculo;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementor.model.vo.TipoColaborador;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.helpers.impl.lotecontabil.HelperLoteContabil;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import contatocore.util.ContatoFormatUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionPlanoContaEventoNotFound;
import mentorcore.exceptions.ExceptionService;
import mentorcore.tools.DateUtil;

public class UtilLancamentoContabilMovimentoFolha {
    private static final HelperLoteContabil helperLote = (HelperLoteContabil)Context.get(HelperLoteContabil.class);

    public static LoteContabil gerarLancamentosFinanceiros(MovimentoFolha vo, EmpresaRh empresaRH, EmpresaContabilidade empresaContabil, Short integrarLancamentoCtb) throws ExceptionService, ExceptionPlanoContaEventoNotFound {
        LoteContabil lote = UtilLancamentoContabilMovimentoFolha.contabilizarMovimentoFolha(vo, empresaRH, empresaContabil, integrarLancamentoCtb);
        return lote;
    }

    private static LoteContabil contabilizarMovimentoFolha(MovimentoFolha movFolha, EmpresaRh empresaRH, EmpresaContabilidade empresaContabil, Short integrarLancamentoCtb) throws ExceptionService, ExceptionPlanoContaEventoNotFound {
        if (movFolha.getColaborador().getNumeroRegistro().equals("6925")) {
            System.out.println("");
        }
        LoteContabil lote = helperLote.criaRecriaLoteContabil(movFolha.getLote(), movFolha.getAberturaPeriodo().getDataFinal(), movFolha.getEmpresa(), ConstEnumOrigemLoteContabil.MOVIMENTO_FOLHA);
        Short historicoPadrao = empresaRH.getGerarHistoricoPadrao();
        Object historicoLancamento = "";
        ArrayList<Lancamento> lancs = new ArrayList<Lancamento>();
        Lancamento l = null;
        List ret = new ArrayList();
        TipoCalculo tipoFolha = movFolha.getAberturaPeriodo().getTipoCalculo();
        TipoColaborador tipoColaborador = movFolha.getColaborador().getTipoColaborador();
        CentroCusto centroCusto = movFolha.getColaborador().getCentroCusto();
        Double diasFolha = movFolha.getDiasTrabalhados() + movFolha.getDiasFeriados() + movFolha.getDiasFolgas();
        List itens = UtilLancamentoContabilMovimentoFolha.getItensAlocacaoFolha(movFolha);
        Double diasMes = 0.0;
        Double diasAlocadoAcumulado = 0.0;
        Double totalValorIrrf = 0.0;
        Double totalValorInss = 0.0;
        Double totalValorFgts = 0.0;
        Double totalPis = 0.0;
        if (movFolha.getColaborador().getNumeroRegistro().equals("63")) {
            System.out.println("");
        }
        HashMap hashTotalPagamento = new HashMap();
        diasMes = movFolha.getDiasTrabalhados() + movFolha.getDiasFolgas() + movFolha.getDiasFeriados();
        for (Object object : itens) {
            ItemMovCentroCustoColaborador itemCentroCusto = (ItemMovCentroCustoColaborador)object;
            if (!((diasAlocadoAcumulado = Double.valueOf(diasAlocadoAcumulado + itemCentroCusto.getNrDiasAlocado())) > diasMes)) continue;
            throw new ExceptionService("Dias de aloca\u00e7\u00e3o est\u00e1 maior para o Colaborador: " + movFolha.getColaborador().toString() + "\nDias Alocado: " + diasAlocadoAcumulado.toString() + " Dias Mes: " + diasMes.toString());
        }
        if (diasMes <= 0.0) {
            diasMes = 30.0;
        }
        if (diasAlocadoAcumulado < diasMes) {
            MovimentoCentroCustoColaborador movCentroCusto = new MovimentoCentroCustoColaborador(centroCusto, movFolha.getAberturaPeriodo().getDataInicio());
            ItemMovCentroCustoColaborador item = new ItemMovCentroCustoColaborador(Double.valueOf(diasMes - diasAlocadoAcumulado), movCentroCusto, movFolha.getColaborador());
            itens.add(item);
        }
        Integer tamTotalLista = itens.size();
        Integer contLista = 0;
        for (Object object : itens) {
            ItemMovCentroCustoColaborador itemCentroCusto = (ItemMovCentroCustoColaborador)object;
            Double diasAlocado = itemCentroCusto.getNrDiasAlocado();
            centroCusto = itemCentroCusto.getMovimentoCentroCusto().getCentroCusto();
            contLista = contLista + 1;
            PlanoConta planoContaDebito = null;
            PlanoConta planoContaCredito = null;
            for (ItemMovimentoFolha itemFolha : movFolha.getItensMovimentoFolha()) {
                if (itemFolha.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo().equals("3") || itemFolha.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo().equals("4") || !empresaContabil.getDescartarLiquidoRescisao().equals((short)0) && movFolha.getStatusFolha().getCodigo().equals((short)3) && !itemFolha.getItemMovRescisao().getDescartarContabilizacao().equals((short)0)) continue;
                planoContaCredito = null;
                planoContaDebito = null;
                TipoCalculoEvento tipoCalculo = itemFolha.getEventoColaborador().getTipoCalculoEvento();
                ret = CoreDAOFactory.getInstance().getDAOParamContabilizacaoFolha().findParamFolha(centroCusto, tipoColaborador, tipoFolha, tipoCalculo);
                if (ret.size() > 1) {
                    String retorno = "EXISTE MAIS DE UMA PARAMETRIZA\u00c7\u00c3O PARA: \nCentro de custo: " + centroCusto.getNome() + "\nEvento : " + tipoCalculo.getEvento().getDescricao() + "\nTipo de colaborador: " + tipoColaborador.getDescricao() + "\nTipo de Folha: " + tipoFolha.getDescricao() + "\nIdentificadores: ";
                    for (Object obj : ret) {
                        ParametrizacaoContabilizacaoFolha p = (ParametrizacaoContabilizacaoFolha)obj;
                        retorno = retorno + " " + p.getIdentificador().toString() + ";";
                    }
                    throw new ExceptionPlanoContaEventoNotFound(retorno);
                }
                if (ret.isEmpty() || ret.size() == 0) {
                    throw new ExceptionPlanoContaEventoNotFound("N\u00c3O EXISTE PARAMETRIZA\u00c7\u00c3O PARA: \nCentro de custo: " + centroCusto.getNome() + "\nEvento : " + tipoCalculo.getEvento().getDescricao() + "\nTipo de colaborador: " + tipoColaborador.getDescricao() + "\nTipo de Folha: " + tipoFolha.getDescricao());
                }
                ParametrizacaoContabilizacaoFolha p = (ParametrizacaoContabilizacaoFolha)ret.get(0);
                if (!(itemFolha.getValor() > 0.0)) continue;
                if (p.getBuscarContaDebitoColaborador().equals((short)1)) {
                    if (movFolha.getColaborador().getPlanoContaDebito() == null) {
                        throw new ExceptionPlanoContaEventoNotFound("Conta de Debito n\u00e3o informada no colaborador: " + movFolha.getColaborador().toString());
                    }
                    planoContaDebito = movFolha.getColaborador().getPlanoContaDebito();
                } else {
                    planoContaDebito = p.getPlanoContaDebito();
                    if (ToolMethods.isEquals((Object)planoContaDebito.getMarca(), (Object)EnumConstSinteticoAnalitico.SINTETICO.getValueInt())) {
                        throw new ExceptionPlanoContaEventoNotFound("Plano Conta D\u00e9bito na Parametriza\u00e7\u00e3o " + p.getIdentificador().toString() + " informado conta sint\u00e9tico");
                    }
                }
                if (p.getBuscarContaCreditoColaborador().equals((short)1)) {
                    if (movFolha.getColaborador().getPlanoContaCredito() == null) {
                        throw new ExceptionPlanoContaEventoNotFound("Conta de credito n\u00e3o informada no colaborador: " + movFolha.getColaborador().toString());
                    }
                    planoContaCredito = movFolha.getColaborador().getPlanoContaCredito();
                } else {
                    planoContaCredito = p.getPlanoContaCredito();
                    if (ToolMethods.isEquals((Object)planoContaCredito.getMarca(), (Object)EnumConstSinteticoAnalitico.SINTETICO.getValueInt())) {
                        throw new ExceptionPlanoContaEventoNotFound("Plano Conta Cr\u00e9dito na Parametriza\u00e7\u00e3o " + p.getIdentificador().toString() + " informado conta sint\u00e9tico");
                    }
                }
                historicoLancamento = historicoPadrao.equals((short)1) ? movFolha.getColaborador().getPessoa().getNome() + " " + DateUtil.dateToStr(movFolha.getAberturaPeriodo().getDataFinal(), "MM/yyyy") : p.getHistorico().getDescricao();
                Double valorLancamento = ContatoFormatUtil.arrredondarNumero((Double)(itemFolha.getValor() / diasFolha * diasAlocado), (int)2);
                if (tamTotalLista == contLista) {
                    valorLancamento = itemFolha.getValor() - UtilLancamentoContabilMovimentoFolha.getValorAcumulado(hashTotalPagamento, itemFolha.getEventoColaborador().getTipoCalculoEvento().getEvento().getChave());
                } else {
                    UtilLancamentoContabilMovimentoFolha.getAcumulaValorLancamento(itemFolha.getEventoColaborador().getTipoCalculoEvento().getEvento().getChave(), hashTotalPagamento, valorLancamento);
                }
                l = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)empresaRH.getEmpresa());
                l.setPlanoContaCred(planoContaCredito);
                l.setPlanoContaDeb(planoContaDebito);
                l.setValor(valorLancamento);
                l.setHistorico((String)historicoLancamento);
                if (ToolMethods.isEquals((Object)integrarLancamentoCtb, (Object)1)) {
                    l.getLancamentosCtbCentroCustos().add(new LancamentoCTBCentroCustos(centroCusto, valorLancamento, l));
                }
                l.setDataLancamento(lote.getDataLote());
                lancs.add(l);
            }
            Double valorFgts = ContatoFormatUtil.arrredondarNumero((Double)(movFolha.getVrFgts13Sal() + movFolha.getVrFgtsFerias() + movFolha.getVrFgtsSalario()), (int)2);
            Double valorInss = ContatoFormatUtil.arrredondarNumero((Double)(movFolha.getVrInss13Sal() + movFolha.getVrInssFerias() + movFolha.getVrInssSalario()), (int)2);
            Double valorIrrf = ContatoFormatUtil.arrredondarNumero((Double)(movFolha.getVrIrrf13Sal() + movFolha.getVrIrrfFerias() + movFolha.getVrIrrfSalario()), (int)2);
            Double valorPis = movFolha.getValorPis();
            planoContaCredito = null;
            planoContaDebito = null;
            TipoCalculo tipoCalculo = movFolha.getAberturaPeriodo().getTipoCalculo();
            if (!(valorFgts > 0.0 || valorInss > 0.0 || valorIrrf > 0.0) && !(valorPis > 0.0)) continue;
            List aux = UtilLancamentoContabilMovimentoFolha.getPlanoContaImpostoIrrf(centroCusto, tipoCalculo);
            if (aux.isEmpty() || aux.size() == 0) {
                throw new ExceptionPlanoContaEventoNotFound("N\u00e3o existe Parametriza\u00e7\u00e3o de FGTS/IRRF/INSS para o Centro de custo: " + centroCusto.getNome() + " Tipo de Folha: " + tipoCalculo.getDescricao());
            }
            if (aux.size() > 1) {
                String retorno = "EXISTE MAIS DE UMA PARAMETRIZA\u00c7\u00c3O DE IMPOSTO PARA O Centro de custo: " + centroCusto.getNome() + " Tipo de Folha: " + tipoCalculo.getDescricao() + "\n  IDENTIFICADORES ";
                for (Object obj : aux) {
                    PlanoContaImpostoFolha p = (PlanoContaImpostoFolha)obj;
                    retorno = retorno + " " + p.getIdentificador().toString() + ";";
                }
                throw new ExceptionPlanoContaEventoNotFound(retorno);
            }
            PlanoContaImpostoFolha planoImposto = (PlanoContaImpostoFolha)aux.get(0);
            if (valorFgts > 0.0 && UtilLancamentoContabilMovimentoFolha.validarPlanoContaImposto(planoImposto.getPlanoCCDebitoFgtsFolha(), planoImposto.getPlanoCCCreditoFgtsFolha(), planoImposto.getHistoricoFgtsFolha(), movFolha.getCentroCusto(), "FGTS", planoImposto.getIdentificador())) {
                historicoLancamento = historicoPadrao.equals((short)1) ? " FGTS " + movFolha.getColaborador().getPessoa().getNome() + " " + DateUtil.dateToStr(movFolha.getAberturaPeriodo().getDataFinal(), "MM/yyyy") : planoImposto.getHistoricoFgtsFolha().getDescricao();
                Double valorFgtsLancamento = ContatoFormatUtil.arrredondarNumero((Double)(valorFgts / diasFolha * diasAlocado), (int)2);
                if (tamTotalLista == contLista) {
                    valorFgtsLancamento = valorFgts - totalValorFgts;
                } else {
                    totalValorFgts = totalValorFgts + valorFgtsLancamento;
                }
                l = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)empresaContabil.getEmpresa());
                l.setPlanoContaCred(planoImposto.getPlanoCCCreditoFgtsFolha());
                l.setPlanoContaDeb(planoImposto.getPlanoCCDebitoFgtsFolha());
                l.setValor(valorFgtsLancamento);
                l.setHistorico((String)historicoLancamento);
                if (ToolMethods.isEquals((Object)integrarLancamentoCtb, (Object)1)) {
                    l.getLancamentosCtbCentroCustos().add(new LancamentoCTBCentroCustos(centroCusto, valorFgtsLancamento, l));
                }
                l.setDataLancamento(lote.getDataLote());
                lancs.add(l);
            }
            if (valorInss > 0.0 && UtilLancamentoContabilMovimentoFolha.validarPlanoContaImposto(planoImposto.getPlanoCCDebitoInssFolha(), planoImposto.getPlanoCCCreditoInssFolha(), planoImposto.getHistoricoInssFolha(), movFolha.getCentroCusto(), "INSS", planoImposto.getIdentificador())) {
                if (planoImposto.getBuscarContaCreditoInss().equals((short)1)) {
                    if (movFolha.getColaborador().getPlanoContaCredito() == null) {
                        throw new ExceptionPlanoContaEventoNotFound(" Plano Conta Credito no Colaborador " + movFolha.getColaborador().toString() + " n\u00e3o informada para INSS");
                    }
                    planoContaCredito = movFolha.getColaborador().getPlanoContaCredito();
                } else {
                    planoContaCredito = planoImposto.getPlanoCCCreditoInssFolha();
                }
                if (planoImposto.getBuscarContaDebitoInss().equals((short)1)) {
                    if (movFolha.getColaborador().getPlanoContaDebito() == null) {
                        throw new ExceptionPlanoContaEventoNotFound(" Plano Conta de Debito no colaborador " + movFolha.getColaborador().toString() + " n\u00e3o informada para INSS");
                    }
                    planoContaDebito = movFolha.getColaborador().getPlanoContaDebito();
                } else {
                    planoContaDebito = planoImposto.getPlanoCCDebitoInssFolha();
                }
                historicoLancamento = historicoPadrao.equals((short)1) ? " INSS " + movFolha.getColaborador().getPessoa().getNome() + " " + DateUtil.dateToStr(movFolha.getAberturaPeriodo().getDataFinal(), "MM/yyyy") : planoImposto.getHistoricoInssFolha().getDescricao();
                Double valorInssLancamento = ContatoFormatUtil.arrredondarNumero((Double)(valorInss / diasFolha * diasAlocado), (int)2);
                if (tamTotalLista == contLista) {
                    valorInssLancamento = valorInss - totalValorInss;
                } else {
                    totalValorInss = totalValorInss + valorInssLancamento;
                }
                l = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)empresaContabil.getEmpresa());
                l.setPlanoContaCred(planoContaCredito);
                l.setPlanoContaDeb(planoContaDebito);
                l.setValor(valorInssLancamento);
                l.setHistorico((String)historicoLancamento);
                if (ToolMethods.isEquals((Object)integrarLancamentoCtb, (Object)1)) {
                    l.getLancamentosCtbCentroCustos().add(new LancamentoCTBCentroCustos(centroCusto, valorInssLancamento, l));
                }
                l.setDataLancamento(lote.getDataLote());
                lancs.add(l);
            }
            if (valorPis > 0.0 && UtilLancamentoContabilMovimentoFolha.validarPlanoContaImposto(planoImposto.getPlanoCCDebitoPisFolha(), planoImposto.getPlanoCCCreditoPisFolha(), planoImposto.getHistoricoPisFolha(), movFolha.getCentroCusto(), "PIS", planoImposto.getIdentificador())) {
                planoContaCredito = planoImposto.getPlanoCCCreditoPisFolha();
                planoContaDebito = planoImposto.getPlanoCCDebitoPisFolha();
                historicoLancamento = "PIS SOBRE A FOLHA DE PAGAMENTO";
                Double valorPisLancado = ContatoFormatUtil.arrredondarNumero((Double)(valorPis / diasFolha * diasAlocado), (int)2);
                if (tamTotalLista == contLista) {
                    valorPisLancado = valorPisLancado - totalPis;
                } else {
                    totalPis = totalPis + valorPisLancado;
                }
                if (valorPis > 0.0) {
                    l = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)empresaContabil.getEmpresa());
                    l.setPlanoContaCred(planoContaCredito);
                    l.setPlanoContaDeb(planoContaDebito);
                    l.setValor(valorPis);
                    l.setHistorico((String)historicoLancamento);
                    if (ToolMethods.isEquals((Object)integrarLancamentoCtb, (Object)1)) {
                        l.getLancamentosCtbCentroCustos().add(new LancamentoCTBCentroCustos(centroCusto, valorPis, l));
                    }
                    l.setDataLancamento(lote.getDataLote());
                    lancs.add(l);
                }
            }
            if (!(valorIrrf > 0.0) || !UtilLancamentoContabilMovimentoFolha.validarPlanoContaImposto(planoImposto.getPlanoCCDebitoIrrfFolha(), planoImposto.getPlanoCCCreditoIrrfFolha(), planoImposto.getHistoricoIrrfFolha(), movFolha.getCentroCusto(), "IRRF", planoImposto.getIdentificador())) continue;
            if (planoImposto.getBuscarContaCreditoIrrf().equals((short)1)) {
                if (movFolha.getColaborador().getPlanoContaCredito() == null) {
                    throw new ExceptionPlanoContaEventoNotFound(" Plano de Conta de credito para o colaborador " + movFolha.getColaborador().toString() + " n\u00e3o informada para IRRF.");
                }
                planoContaCredito = movFolha.getColaborador().getPlanoContaCredito();
            } else {
                planoContaCredito = planoImposto.getPlanoCCCreditoIrrfFolha();
            }
            if (planoImposto.getBuscarContaDebitoIrrf().equals((short)1) && movFolha.getColaborador().getPlanoContaDebito() == null) {
                throw new ExceptionPlanoContaEventoNotFound(" Plano de Conta de debito para o colaborador " + movFolha.getColaborador().toString() + " n\u00e3o informada para IRRF. ");
            }
            historicoLancamento = historicoPadrao.equals((short)1) ? " IRRF " + movFolha.getColaborador().getPessoa().getNome() + " " + DateUtil.dateToStr(movFolha.getAberturaPeriodo().getDataFinal(), "MM/yyyy") : planoImposto.getHistoricoIrrfFolha().getDescricao();
            Double valorIrrfLancamento = ContatoFormatUtil.arrredondarNumero((Double)(valorIrrf / diasFolha * diasAlocado), (int)2);
            if (tamTotalLista == contLista) {
                valorIrrfLancamento = valorIrrf - totalValorIrrf;
            } else {
                totalValorIrrf = totalValorIrrf + valorIrrfLancamento;
            }
            l = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)empresaContabil.getEmpresa());
            l.setPlanoContaCred(planoContaCredito);
            l.setPlanoContaDeb(planoImposto.getPlanoCCDebitoIrrfFolha());
            l.setValor(valorIrrfLancamento);
            l.setHistorico((String)historicoLancamento);
            if (ToolMethods.isEquals((Object)integrarLancamentoCtb, (Object)1)) {
                l.getLancamentosCtbCentroCustos().add(new LancamentoCTBCentroCustos(centroCusto, valorIrrfLancamento, l));
            }
            l.setDataLancamento(lote.getDataLote());
            lancs.add(l);
        }
        lote.setLancamentos(lancs);
        return lote;
    }

    private static boolean validarPlanoContaImposto(PlanoConta planoDebito, PlanoConta planoCredito, HistoricoPadrao h, CentroCusto centroCusto, String imposto, Long idParametrizacao) throws ExceptionPlanoContaEventoNotFound {
        if (planoDebito == null || planoCredito == null || h == null) {
            throw new ExceptionPlanoContaEventoNotFound("Primeiro, informe as contas de debito,credito e historico do " + imposto + " para o centro: " + centroCusto.getNome() + ": Identificador da parametriza\u00e7\u00e3o: " + idParametrizacao.toString());
        }
        if (ToolMethods.isEquals((Object)planoDebito.getMarca(), (Object)EnumConstSinteticoAnalitico.SINTETICO.getValueInt())) {
            throw new ExceptionPlanoContaEventoNotFound("Plano Conta D\u00e9bito na Parametriza\u00e7\u00e3o " + idParametrizacao.toString() + " informado conta sint\u00e9tico " + imposto);
        }
        if (ToolMethods.isEquals((Object)planoCredito.getMarca(), (Object)EnumConstSinteticoAnalitico.SINTETICO.getValueInt())) {
            throw new ExceptionPlanoContaEventoNotFound("Plano Conta Cr\u00e9dito na Parametriza\u00e7\u00e3o " + idParametrizacao.toString() + " informado conta sint\u00e9tico " + imposto);
        }
        return true;
    }

    private static Lancamento getLancamento(LoteContabil lote, PlanoConta planoDeb, PlanoConta planoCred, Double valor, HistoricoPadrao historicoPadrao, String descricaoHistorico, Empresa empresa) {
        if (valor != null && valor > 0.0) {
            Lancamento l = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)empresa);
            l.setPlanoContaCred(planoCred);
            l.setPlanoContaDeb(planoDeb);
            l.setValor(valor);
            l.setHistoricoPadrao(historicoPadrao);
            l.setHistorico(descricaoHistorico);
            return l;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void gerarLancamentosContabeisInssEmpresaSemDesoneracao(MovimentoFolha mov, LoteContabil l, EmpresaRh empresaRH, EmpresaContabilidade empresaContabil) throws ExceptionService, ExceptionPlanoContaEventoNotFound {
        ArrayList<Lancamento> lancs = new ArrayList<Lancamento>();
        List aux = new ArrayList();
        CentroCusto centroCusto = mov.getColaborador().getCentroCusto();
        Short historicoPadrao = empresaRH.getGerarHistoricoPadrao();
        Object historicoLancamento = "";
        Double valorBase = 0.0;
        TipoCalculo tipoCaculo = mov.getAberturaPeriodo().getTipoCalculo();
        if (mov.getColaborador().getNumeroRegistro().equals("63")) {
            System.out.println("");
        }
        List itens = UtilLancamentoContabilMovimentoFolha.getItensAlocacaoFolha(mov);
        Double diasMes = 0.0;
        Double diasAlocadoAcumulado = 0.0;
        Double totalRat = 0.0;
        Double totalTerceiro = 0.0;
        Double totalAposentadoria = 0.0;
        HashMap hashTotalPagamento = new HashMap();
        diasMes = mov.getDiasTrabalhados() + mov.getDiasFolgas() + mov.getDiasFeriados();
        for (Object object : itens) {
            ItemMovCentroCustoColaborador itemCentroCusto = (ItemMovCentroCustoColaborador)object;
            if (!((diasAlocadoAcumulado = Double.valueOf(diasAlocadoAcumulado + itemCentroCusto.getNrDiasAlocado())) > diasMes)) continue;
            throw new ExceptionService("Dias de aloca\u00e7\u00e3o est\u00e1 maior para o Colaborador: " + mov.getColaborador().toString() + "\nDias Alocado: " + diasAlocadoAcumulado.toString() + " Dias Mes: " + diasMes.toString());
        }
        if (diasMes <= 0.0) {
            diasMes = 30.0;
        }
        if (diasAlocadoAcumulado < diasMes) {
            MovimentoCentroCustoColaborador movCentroCusto = new MovimentoCentroCustoColaborador(centroCusto, mov.getAberturaPeriodo().getDataInicio());
            ItemMovCentroCustoColaborador item = new ItemMovCentroCustoColaborador(Double.valueOf(diasMes - diasAlocadoAcumulado), movCentroCusto, mov.getColaborador());
            itens.add(item);
        }
        Integer tamLista = itens.size();
        Integer contLista = 0;
        for (Object obj : itens) {
            ItemMovCentroCustoColaborador item = (ItemMovCentroCustoColaborador)obj;
            Double diasAlocado = item.getNrDiasAlocado();
            contLista = contLista + 1;
            Lancamento lancamento = null;
            centroCusto = item.getMovimentoCentroCusto().getCentroCusto();
            valorBase = mov.getBcInssSalario() + mov.getBcInssFerias() + mov.getBcInss13Sal();
            if (mov.getColaborador().getTipoColaborador().getCompoe2200().equals((short)1)) {
                valorBase = mov.getBaseEmpresaColaborador();
            }
            if (!((valorBase = ContatoFormatUtil.arrredondarNumero((Double)(valorBase / diasMes * diasAlocado), (int)2)) > 0.0)) continue;
            aux = CoreDAOFactory.getInstance().getDAOIntegrandoMovFolhas().getPlanoContaContabilInssEmpresa(centroCusto, tipoCaculo);
            if (aux.size() > 1) {
                String retorno = "Existe mais de uma parametriza\u00e7\u00e3o de imposto para o Centro de custo: " + centroCusto.getNome() + " e Tipo de Folha: " + tipoCaculo.getDescricao();
                for (Object objj : aux) {
                    PlanoContaImpostoFolha p = (PlanoContaImpostoFolha)objj;
                    retorno = retorno + " " + p.getIdentificador().toString() + ";";
                }
                throw new ExceptionPlanoContaEventoNotFound(retorno);
            }
            if (aux.isEmpty() || aux.size() == 0) {
                throw new ExceptionPlanoContaEventoNotFound("N\u00e3o existe parametriza\u00e7\u00e3o de imposto para o Centro de custo: " + centroCusto.getNome() + " e Tipo de Folha: " + tipoCaculo.getDescricao());
            }
            PlanoContaImpostoFolha planoImposto = (PlanoContaImpostoFolha)aux.get(0);
            Double valor = 0.0;
            if (empresaRH.getPossuiDesoneracao() != null && empresaRH.getPossuiDesoneracao().equals((short)0)) {
                valor = !mov.getAberturaPeriodo().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue()) ? ContatoFormatUtil.arrredondarNumero((Double)(valorBase * (empresaRH.getPercEmpresa() / 100.0)), (int)2) : this.calcularInssEmpresaComAvosDesonerado(mov, empresaRH);
                if (valor > 0.0) {
                    if (!UtilLancamentoContabilMovimentoFolha.validarPlanoContaImposto(planoImposto.getPlanoCCDebitoInssEmpresa(), planoImposto.getPlanoCCCreditoInssEmpresa(), planoImposto.getHistoricoInssEmpresa(), centroCusto, "INSS EMPRESA", planoImposto.getIdentificador())) throw new ExceptionPlanoContaEventoNotFound(centroCusto.getNome().toUpperCase() + ": Parametriza\u00e7\u00e3o de INSS Empresa incorreto. ");
                    historicoLancamento = historicoPadrao.equals((short)1) ? "INSS EMPRESA-" + mov.getColaborador().getPessoa().getNome() + " " + DateUtil.dateToStr(mov.getAberturaPeriodo().getDataFinal(), "MM/yyyy") : planoImposto.getHistoricoInssEmpresa().getDescricao();
                    lancamento = UtilLancamentoContabilMovimentoFolha.getLancamento(l, planoImposto.getPlanoCCDebitoInssEmpresa(), planoImposto.getPlanoCCCreditoInssEmpresa(), valor, planoImposto.getHistoricoInssEmpresa(), (String)historicoLancamento, empresaContabil.getEmpresa());
                    lancs.add(lancamento);
                }
            } else {
                Double valorDesoneracao;
                Double valorTotal = 0.0;
                Double valorInss = 0.0;
                if (!UtilLancamentoContabilMovimentoFolha.validarPlanoContaImposto(planoImposto.getPlanoCCDebitoInssEmpresa(), planoImposto.getPlanoCCCreditoInssEmpresa(), planoImposto.getHistoricoInssEmpresa(), centroCusto, "INSS EMPRESA", planoImposto.getIdentificador())) throw new ExceptionPlanoContaEventoNotFound(centroCusto.getNome().toUpperCase() + ": Parametriza\u00e7\u00e3o de INSS Empresa incorreto. ");
                Double percDesoneracao = this.getPercDesoneracao(mov.getAberturaPeriodo());
                valorTotal = ContatoFormatUtil.arrredondarNumero((Double)(valorBase * (empresaRH.getPercEmpresa() / 100.0)), (int)2);
                valorInss = ContatoFormatUtil.arrredondarNumero((Double)(valorTotal - ContatoFormatUtil.arrredondarNumero((Double)(valorTotal / 100.0 * percDesoneracao), (int)2)), (int)2);
                historicoLancamento = historicoPadrao.equals((short)1) ? "INSS EMPRESA-" + mov.getColaborador().getPessoa().getNome() + " " + DateUtil.dateToStr(mov.getAberturaPeriodo().getDataFinal(), "MM/yyyy") : planoImposto.getHistoricoInssEmpresa().getDescricao();
                lancamento = UtilLancamentoContabilMovimentoFolha.getLancamento(l, planoImposto.getPlanoCCDebitoInssEmpresa(), planoImposto.getPlanoCCCreditoInssEmpresa(), valorInss, planoImposto.getHistoricoInssEmpresa(), (String)historicoLancamento, empresaContabil.getEmpresa());
                if (lancamento != null) {
                    lancs.add(lancamento);
                }
                if (empresaRH.getGerarLancamentosDesoneracao() != null && empresaRH.getGerarLancamentosDesoneracao().equals((short)1) && (valorDesoneracao = Double.valueOf(valorTotal - valorInss)) > 0.0 && UtilLancamentoContabilMovimentoFolha.validarPlanoContaImposto(planoImposto.getPlanoCCDebitoDesoneracao(), planoImposto.getPlanoCCCreditoDesoneracao(), planoImposto.getHistoricoInssEmpresa(), centroCusto, "DESONERA\u00c7\u00c3O FOLHA DE PAGAMENTO", planoImposto.getIdentificador())) {
                    historicoLancamento = historicoPadrao.equals((short)1) ? "DESONERACAO FOLHA -" + mov.getColaborador().getPessoa().getNome() + " " + DateUtil.dateToStr(mov.getAberturaPeriodo().getDataFinal(), "MM/yyyy") : planoImposto.getHistoricoDesoneracao().getDescricao();
                    lancamento = UtilLancamentoContabilMovimentoFolha.getLancamento(l, planoImposto.getPlanoCCDebitoDesoneracao(), planoImposto.getPlanoCCCreditoDesoneracao(), valorDesoneracao, planoImposto.getHistoricoInssEmpresa(), (String)historicoLancamento, empresaContabil.getEmpresa());
                    if (lancamento != null) {
                        lancs.add(lancamento);
                    }
                }
            }
            if ((mov.getColaborador().getTipoColaborador().getIdentificador().equals(EnumConstTipoColaborador.EMPREGADO.getValue()) || mov.getColaborador().getTipoColaborador().getIdentificador().equals(EnumConstTipoColaborador.MENOR_APRENDIZ.getValue())) && (valor = ContatoFormatUtil.arrredondarNumero((Double)(valorBase * empresaRH.getIndiceFAP() * (empresaRH.getPercRat() / 100.0)), (int)2)) > 0.0) {
                if (!UtilLancamentoContabilMovimentoFolha.validarPlanoContaImposto(planoImposto.getPlanoCCDebitoInssRat(), planoImposto.getPlanoCCCreditoInssRat(), planoImposto.getHistoricoInssRat(), centroCusto, "RAT", planoImposto.getIdentificador())) throw new ExceptionPlanoContaEventoNotFound(centroCusto.getNome().toUpperCase() + ": Parametriza\u00e7\u00e3o de RAT incorreto. ");
                valor = ContatoFormatUtil.arrredondarNumero((Double)(valorBase * empresaRH.getIndiceFAP() * (empresaRH.getPercRat() / 100.0)), (int)2);
                if (contLista == tamLista) {
                    valor = ContatoFormatUtil.arrredondarNumero((Double)(valorBase * empresaRH.getIndiceFAP() * (empresaRH.getPercRat() / 100.0)), (int)2);
                    valor = valor - UtilLancamentoContabilMovimentoFolha.getValorAcumulado(hashTotalPagamento, "RAT");
                } else {
                    UtilLancamentoContabilMovimentoFolha.getAcumulaValorLancamento("RAT", hashTotalPagamento, valor);
                }
                historicoLancamento = historicoPadrao.equals((short)1) ? "RAT-" + mov.getColaborador().getPessoa().getNome() + " " + DateUtil.dateToStr(mov.getAberturaPeriodo().getDataFinal(), "MM/yyyy") : planoImposto.getHistoricoInssRat().getDescricao();
                if (valor > 0.0) {
                    lancamento = UtilLancamentoContabilMovimentoFolha.getLancamento(l, planoImposto.getPlanoCCDebitoInssRat(), planoImposto.getPlanoCCCreditoInssRat(), valor, planoImposto.getHistoricoInssRat(), (String)historicoLancamento, empresaContabil.getEmpresa());
                    lancs.add(lancamento);
                }
            }
            if ((mov.getColaborador().getTipoColaborador().getIdentificador().equals(EnumConstTipoColaborador.EMPREGADO.getValue()) || mov.getColaborador().getTipoColaborador().getIdentificador().equals(EnumConstTipoColaborador.MENOR_APRENDIZ.getValue())) && (valor = ContatoFormatUtil.arrredondarNumero((Double)(valorBase * (empresaRH.getPercTerceiros() / 100.0)), (int)2)) > 0.0) {
                if (!UtilLancamentoContabilMovimentoFolha.validarPlanoContaImposto(planoImposto.getPlanoCCDebitoInssTerceiros(), planoImposto.getPlanoCCCreditoInssTerceiros(), planoImposto.getHistoricoInssTerceiros(), centroCusto, "INSS DE TERCEIROS", planoImposto.getIdentificador())) throw new ExceptionPlanoContaEventoNotFound(centroCusto.getNome().toUpperCase() + ": Parametriza\u00e7\u00e3o de TERCEIROS incorreto. ");
                valor = ContatoFormatUtil.arrredondarNumero((Double)(valorBase * (empresaRH.getPercTerceiros() / 100.0)), (int)2);
                if (contLista == tamLista) {
                    valor = ContatoFormatUtil.arrredondarNumero((Double)(valorBase * (empresaRH.getPercTerceiros() / 100.0)), (int)2);
                    valor = valor - UtilLancamentoContabilMovimentoFolha.getValorAcumulado(hashTotalPagamento, "TERCEIROS");
                } else {
                    UtilLancamentoContabilMovimentoFolha.getAcumulaValorLancamento("TERCEIROS", hashTotalPagamento, valor);
                }
                historicoLancamento = historicoPadrao.equals((short)1) ? "OUTROS TERCEIROS-" + mov.getColaborador().getPessoa().getNome() + " " + DateUtil.dateToStr(mov.getAberturaPeriodo().getDataFinal(), "MM/yyyy") : planoImposto.getHistoricoInssTerceiros().getDescricao();
                lancamento = UtilLancamentoContabilMovimentoFolha.getLancamento(l, planoImposto.getPlanoCCDebitoInssTerceiros(), planoImposto.getPlanoCCCreditoInssTerceiros(), valor, planoImposto.getHistoricoInssTerceiros(), (String)historicoLancamento, empresaContabil.getEmpresa());
                lancs.add(lancamento);
            }
            if (!mov.getColaborador().getCategoriaSefip().getCodigo().equals("04")) continue;
            centroCusto = item.getMovimentoCentroCusto().getCentroCusto();
            aux = CoreDAOFactory.getInstance().getDAOIntegrandoMovFolhas().getPlanoContaImpostoPorCentroCusto(centroCusto, tipoCaculo);
            if (aux.size() > 1) {
                String retorno = "Existe mais de uma parametriza\u00e7\u00e3o de imposto para o Centro de custo: " + centroCusto.getNome();
                for (Object objj : aux) {
                    PlanoContaImpostoFolha p = (PlanoContaImpostoFolha)objj;
                    retorno = retorno + " " + p.getIdentificador().toString() + ";";
                }
                throw new ExceptionPlanoContaEventoNotFound(retorno);
            }
            if (aux.isEmpty() || aux.size() == 0) {
                throw new ExceptionPlanoContaEventoNotFound("N\u00e3o existe parametriza\u00e7\u00e3o de imposto para o Centro de custo: " + centroCusto.getNome());
            }
            planoImposto = (PlanoContaImpostoFolha)aux.get(0);
            if (!UtilLancamentoContabilMovimentoFolha.validarPlanoContaImposto(planoImposto.getPlanoCCDebitoAposentEspecial(), planoImposto.getPlanoCCCreditoAposentEspecial(), planoImposto.getHistoricoAposentEspecial())) throw new ExceptionPlanoContaEventoNotFound("Aposentadoria Especial  sem plano de conta ou historico padr\u00e3o para o centro de custo " + centroCusto.getNome());
            valor = 0.0;
            valor = ContatoFormatUtil.arrredondarNumero((Double)(valorBase * (empresaRH.getPercAposentadoriaEspecial25Anos() / 100.0)), (int)2);
            if (contLista == tamLista) {
                valor = ContatoFormatUtil.arrredondarNumero((Double)(valorBase * (empresaRH.getPercAposentadoriaEspecial25Anos() / 100.0)), (int)2);
                valor = valor - UtilLancamentoContabilMovimentoFolha.getValorAcumulado(hashTotalPagamento, "APOSENTADORIA");
            } else {
                UtilLancamentoContabilMovimentoFolha.getAcumulaValorLancamento("APOSENTADORIA", hashTotalPagamento, valor);
            }
            historicoLancamento = historicoPadrao.equals((short)1) ? "APOSENTADORIA ESPECIAL-" + mov.getColaborador().getPessoa().getNome() + " " + DateUtil.dateToStr(mov.getAberturaPeriodo().getDataFinal(), "MM/yyyy") : planoImposto.getHistoricoAposentEspecial().getDescricao();
            lancamento = UtilLancamentoContabilMovimentoFolha.getLancamento(l, planoImposto.getPlanoCCDebitoAposentEspecial(), planoImposto.getPlanoCCCreditoAposentEspecial(), valor, planoImposto.getHistoricoAposentEspecial(), (String)historicoLancamento, empresaContabil.getEmpresa());
            lancs.add(lancamento);
        }
        l.getLancamentos().addAll(lancs);
    }

    private static boolean validarPlanoContaImposto(PlanoConta planoCCDebito, PlanoConta planoCCCredito, HistoricoPadrao historico) {
        if (planoCCDebito == null) {
            return false;
        }
        if (planoCCCredito == null) {
            return false;
        }
        return historico != null;
    }

    private static List getItensAlocacaoFolha(MovimentoFolha mov) {
        if (ToolMethods.isEquals((Object)mov.getAberturaPeriodo().getTipoCalculo().getTipoFolha(), (Object)EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue())) {
            String hql = " from ItemMovCentroCustoColaborador item  where  item.colaborador = :colaborador  and  item.movimentoCentroCusto.periodoAlocacao = :periodoApuracao";
            return CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)mov.getColaborador()).setDate("periodoApuracao", mov.getAberturaPeriodo().getDataInicio()).list();
        }
        return new ArrayList();
    }

    private static void getAcumulaValorLancamento(String chave, HashMap hash, Double valorLancamento) {
        if (hash.containsKey(chave)) {
            Double valor = (Double)hash.get(chave);
            valor = valor + valorLancamento;
            hash.put(chave, valor);
        } else {
            hash.put(chave, valorLancamento);
        }
    }

    private static Double getValorAcumulado(HashMap hashTotalPagamento, String chave) {
        if (hashTotalPagamento.containsKey(chave)) {
            return (Double)hashTotalPagamento.get(chave);
        }
        return 0.0;
    }

    private Double getPercDesoneracao(AberturaPeriodo aberturaPeriodo) {
        String hql = " select coalesce(c.percDesoneracao,0)  from CalculoInssEmpresa c  inner join c.aberturasPeriodo abr  where  abr.aberturaPeriodo = :aberturaPeriodo ";
        Double percDesoneracao = (Double)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("aberturaPeriodo", (Object)aberturaPeriodo).uniqueResult();
        if (percDesoneracao == null || percDesoneracao <= 0.0) {
            return 0.0;
        }
        return percDesoneracao;
    }

    private Double calcularInssEmpresaComAvosDesonerado(MovimentoFolha mov, EmpresaRh empresaRH) {
        Double avosDec = this.getBuscarAvosDec(mov.getAberturaPeriodo());
        if (avosDec > 0.0) {
            Double aux = mov.getBcInss13Sal() - mov.getBcInss13Sal() / 12.0 * avosDec;
            return ContatoFormatUtil.arrredondarNumero((Double)aux, (int)2);
        }
        return ContatoFormatUtil.arrredondarNumero((Double)(mov.getBcInss13Sal() * (empresaRH.getPercEmpresa() / 100.0)), (int)2);
    }

    private Double getBuscarAvosDec(AberturaPeriodo aberturaPeriodo) {
        String hql = " select c.avosDesonerado  from CalculoInssEmpresa c  inner join c.aberturasPeriodo abr  where  abr.aberturaPeriodo = :abertura ";
        Double avos = (Double)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("abertura", (Object)aberturaPeriodo).uniqueResult();
        if (avos == null) {
            return 0.0;
        }
        return avos;
    }

    public void verificarExistenciaIntegracaoAbertura(AberturaPeriodo abertura) throws ExceptionService {
        String hql = " from IntegracaoMovimentoFolha integracao  where  integracao.abertura = :abertura ";
        List ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("abertura", (Object)abertura).list();
        if (ret != null && !ret.isEmpty()) {
            throw new ExceptionService("J\u00e1 existe uma integra\u00e7\u00e3o para esta Abertura de Periodo. ");
        }
    }

    private static List getPlanoContaImpostoIrrf(CentroCusto centroCusto, TipoCalculo tipoCalculo) {
        String hql = " select planoImposto  from PlanoContaImpostoFolha planoImposto  inner join planoImposto.itensCentroCusto item  inner join planoImposto.itensTipoFolha itemFolha  where  item.centroCusto = :centroCusto  and  itemFolha.tipoFolha = :tipoCalculo ";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("centroCusto", (Object)centroCusto).setEntity("tipoCalculo", (Object)tipoCalculo).list();
    }
}

