/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.lancamento;

import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.helpers.impl.lotecontabil.HelperLoteContabil;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementorspringcontext.Context;
import java.util.List;

public class UtilLancamentoCte {
    private final SCompPlanoConta scPlanoConta = (SCompPlanoConta)Context.get(SCompPlanoConta.class);
    private final HelperLoteContabil helperLote = (HelperLoteContabil)Context.get(HelperLoteContabil.class);

    public LoteContabil gerarLancamentos(Cte vo, OpcoesContabeis opcoes) throws ExceptionInvalidData {
        LoteContabil lote = this.contabilizarCte(vo, opcoes);
        if (lote.getLancamentos() != null && !lote.getLancamentos().isEmpty()) {
            return lote;
        }
        return null;
    }

    private LoteContabil contabilizarCte(Cte vo, OpcoesContabeis opcoes) throws ExceptionInvalidData {
        LoteContabil lote = this.helperLote.criaRecriaLoteContabil(vo.getLoteContabilFat(), vo.getDataEmissao(), vo.getEmpresa(), ConstEnumOrigemLoteContabil.CTE);
        lote.setLancamentos(this.getLancamentosCte(vo, lote, opcoes));
        return lote;
    }

    private List<Lancamento> getLancamentosCte(Cte vo, LoteContabil lote, OpcoesContabeis opcoes) throws ExceptionInvalidData {
        Lancamento lancamento;
        List lancamentos = lote.getLancamentos();
        if (vo.getModeloFiscalCte() == null || vo.getModeloFiscalCte().getOpcaoContabilizacao() != 1) {
            return lancamentos;
        }
        double vlrPis = vo.getCteVlrImpostos().getVrPis();
        double vlrCofins = vo.getCteVlrImpostos().getVrCofins();
        double vlrIcms = vo.getCteVlrImpostos().getVrIcms();
        double vlrPrestacao = vo.getCteVlrImpostos().getVrPrestacao();
        if (vlrPrestacao > 0.0 && vo.getTipoOperacaoFrete() != null) {
            lancamento = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)vo.getEmpresa());
            lancamento.setPlanoContaCred(vo.getTipoOperacaoFrete().getPlanoConta());
            if (vo.getTitulos() != null && !vo.getTitulos().isEmpty()) {
                PlanoConta pc = this.scPlanoConta.getPlanoConta(vo.getClienteTomador().getCliente(), opcoes);
                lancamento.setPlanoContaDeb(pc);
            } else {
                lancamento.setPlanoContaDeb(vo.getModeloFiscalCte().getPlanoContaDevedora());
            }
            lancamento.setValor(vo.getCteVlrImpostos().getVrPrestacao());
            lancamento.setHistorico("Vr. referente ao Cte nr. " + vo.getNumero() + ".");
            lancamentos.add(lancamento);
        }
        if (vlrIcms > 0.0) {
            lancamento = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)vo.getEmpresa());
            lancamento.setPlanoContaCred(vo.getModeloFiscalCte().getPlanoContaIcmsCredor());
            lancamento.setPlanoContaDeb(vo.getModeloFiscalCte().getPlanoContaIcmsDevedor());
            lancamento.setValor(Double.valueOf(vlrIcms));
            lancamento.setHistorico("Vr Icms referente ao Cte nr. " + vo.getNumero() + ".");
            lancamentos.add(lancamento);
        }
        if (vlrPis > 0.0) {
            lancamento = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)vo.getEmpresa());
            lancamento.setPlanoContaCred(vo.getModeloFiscalCte().getPlanoContaPisCredor());
            lancamento.setPlanoContaDeb(vo.getModeloFiscalCte().getPlanoContaPisDevedor());
            lancamento.setValor(Double.valueOf(vlrPis));
            lancamento.setHistorico("Vr Pis referente ao Cte nr. " + vo.getNumero() + ".");
            lancamentos.add(lancamento);
        }
        if (vlrCofins > 0.0) {
            lancamento = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)vo.getEmpresa());
            lancamento.setPlanoContaCred(vo.getModeloFiscalCte().getPlanoContaCofinsCredor());
            lancamento.setPlanoContaDeb(vo.getModeloFiscalCte().getPlanoContaCofinsDevedor());
            lancamento.setValor(Double.valueOf(vlrCofins));
            lancamento.setHistorico("Vr Cofins referente ao Cte nr. " + vo.getNumero() + ".");
            lancamentos.add(lancamento);
        }
        return lancamentos;
    }
}

