/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.lancamento;

import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IntegCustoProdVendidoData;
import com.touchcomp.basementor.model.vo.IntegCustoProdVendidoItem;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.helpers.impl.lotecontabil.HelperLoteContabil;
import com.touchcomp.basementorspringcontext.Context;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mentorcore.exceptions.ExceptionService;
import mentorcore.tools.DateUtil;

class UtilLancamentoCustoProdVendido {
    HashMap hash = new HashMap();
    private final HelperLoteContabil helperLote = (HelperLoteContabil)Context.get(HelperLoteContabil.class);

    UtilLancamentoCustoProdVendido() {
    }

    public void contabilizarCustoProdVendido(List<IntegCustoProdVendidoData> lista, Empresa empresa, Short gerarLancAnaliticos) throws ExceptionService {
        for (IntegCustoProdVendidoData i : lista) {
            LoteContabil lote = this.criarLoteContabil(i, i.getDataIntegracao(), empresa);
            List lancamentos = this.getLancamentos(i, lote, gerarLancAnaliticos, empresa);
            lote.setLancamentos(lancamentos);
            i.setLoteContabil(lote);
        }
    }

    public void contabilizarCustoProdVendido(IntegCustoProdVendidoData i, Empresa empresa, Short gerarLancAnaliticos) throws ExceptionService {
        LoteContabil lote = this.criarLoteContabil(i, i.getDataIntegracao(), empresa);
        List lancamentos = this.getLancamentos(i, lote, gerarLancAnaliticos, empresa);
        lote.setLancamentos(lancamentos);
        i.setLoteContabil(lote);
    }

    private LoteContabil criarLoteContabil(IntegCustoProdVendidoData vo, Date dataLancamento, Empresa empresa) {
        return this.helperLote.criaRecriaLoteContabil(vo.getLoteContabil(), dataLancamento, empresa, ConstEnumOrigemLoteContabil.INTEG_CUSTO_PROD_VEND_DATA);
    }

    private List getLancamentos(IntegCustoProdVendidoData i, LoteContabil lote, Short gerarLancAnaliticos, Empresa e) {
        ArrayList<Lancamento> lanc = new ArrayList<Lancamento>();
        for (IntegCustoProdVendidoItem ig : i.getIntegCustoProdVendItem()) {
            Lancamento found = null;
            Optional<Lancamento> aux = lanc.stream().filter(j -> Objects.equals(j.getPlanoContaDeb(), ig.getPcDebito()) && Objects.equals(j.getPlanoContaCred(), ig.getPcCredito())).findFirst();
            if (aux.isPresent() && gerarLancAnaliticos != 1) {
                aux.get().setValor(Double.valueOf(aux.get().getValor() + ig.getValorTotal()));
                continue;
            }
            found = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)e);
            if (gerarLancAnaliticos == 1) {
                found.setHistorico("Lancamento gerado pelo custo do produto vendido pelo " + ig.getProduto().getIdentificador() + " - " + ig.getProduto().getNome() + " em " + DateUtil.dateToStr(i.getDataIntegracao()));
            } else {
                found.setHistorico("Lancamento gerado pelo custo do produto vendido em " + DateUtil.dateToStr(i.getDataIntegracao()));
            }
            found.setPlanoContaCred(ig.getPcCredito());
            found.setPlanoContaDeb(ig.getPcDebito());
            found.setValor(ig.getValorTotal());
            lanc.add(found);
        }
        return lanc;
    }
}

