/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.lancamento;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.model.vo.DepreciacaoBem;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.OpcoesPatrimonio;
import com.touchcomp.basementor.model.vo.PlanoContaBemDepreciacao;
import com.touchcomp.basementor.model.vo.TipoBem;
import com.touchcomp.basementor.model.vo.TipoDepreciacao;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.helpers.impl.lotecontabil.HelperLoteContabil;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import mentorcore.exceptions.ExceptionService;

class UtilLancamentoDepreciacaoBem {
    private final HelperLoteContabil helperLote = (HelperLoteContabil)Context.get(HelperLoteContabil.class);

    UtilLancamentoDepreciacaoBem() {
    }

    public LoteContabil gerarLancamentos(DepreciacaoBem c, Date periodo, OpcoesPatrimonio opcoesPatrimonio) throws ExceptionService, ExceptionInvalidData {
        ArrayList<Lancamento> lancamentos = new ArrayList<Lancamento>();
        LoteContabil l = this.helperLote.criaRecriaLoteContabil(c.getLoteContabil(), periodo, c.getBemTipoDepreciacao().getBem().getEmpresa(), ConstEnumOrigemLoteContabil.DEPRECIACAO_BEM);
        Lancamento lanc = null;
        PlanoContaBemDepreciacao pl = null;
        if (c.getValorDepreciacao() > 0.0) {
            lanc = CompLancamentoBase.newLancamento((LoteContabil)l, (Empresa)c.getBemTipoDepreciacao().getBem().getEmpresa());
            lanc.setHistorico("Vr. deprecia\u00e7\u00e3o neste m\u00eas ref. Bem nr. " + c.getBemTipoDepreciacao().getBem().getIdentificador());
            pl = this.getPlanoContaBemDepr(c.getBemTipoDepreciacao().getTipoDepreciacao(), c.getBemTipoDepreciacao().getBem().getTipoBem());
            if (pl == null) {
                throw new ExceptionInvalidData("E.ERP.0412.004", new Object[]{c.getBemTipoDepreciacao().getTipoDepreciacao(), c.getBemTipoDepreciacao().getBem().getTipoBem().getDescricao()});
            }
            lanc.setPlanoContaCred(pl.getPlanoContaDepreciacao());
            lanc.setPlanoContaDeb(pl.getPlanoContaDespesa());
            lanc.setValor(c.getValorDepreciacao());
            lancamentos.add(lanc);
        }
        if (c.getValorDeprecAcelerada() > 0.0) {
            lanc = CompLancamentoBase.newLancamento((LoteContabil)l, (Empresa)c.getBemTipoDepreciacao().getBem().getEmpresa());
            lanc.setHistorico("Vr. deprecia\u00e7\u00e3o acelerada neste m\u00eas ref. Bem nr. " + c.getBemTipoDepreciacao().getBem().getIdentificador());
            pl = this.getPlanoContaBemDepr(c.getBemTipoDepreciacao().getTipoDepreciacao(), c.getBemTipoDepreciacao().getBem().getTipoBem());
            if (pl == null) {
                throw new ExceptionInvalidData("E.ERP.0412.004", new Object[]{c.getBemTipoDepreciacao().getTipoDepreciacao(), c.getBemTipoDepreciacao().getBem().getTipoBem().getDescricao()});
            }
            lanc.setPlanoContaCred(pl.getPlanoContaDespesa());
            lanc.setPlanoContaDeb(pl.getPlanoContaDeprAcelerada());
            lanc.setValor(c.getValorDeprecAcelerada());
            lancamentos.add(lanc);
        }
        if (ToolMethods.isEquals((Object)c.getBemTipoDepreciacao().getBem().getBemUsadoPisCofins(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) && c.getValorDepreciacao() > 0.0) {
            if (ToolMethods.isEquals((Object)opcoesPatrimonio.getPlanoContaPisCred(), null)) {
                throw new ExceptionInvalidData("E.ERP.0412.001", new Object[0]);
            }
            if (ToolMethods.isEquals((Object)opcoesPatrimonio.getPlanoContaPisDeb(), null)) {
                throw new ExceptionInvalidData("E.ERP.0412.002", new Object[0]);
            }
            if (!ToolMethods.isWithData((Number)c.getBemTipoDepreciacao().getBem().getBemSpedPisCofins().getAliquotaPis()) || !ToolMethods.isWithData((Number)c.getBemTipoDepreciacao().getBem().getBemSpedPisCofins().getAliquotaCofins())) {
                throw new ExceptionInvalidData("E.ERP.0412.003", new Object[0]);
            }
            lanc = CompLancamentoBase.newLancamento((LoteContabil)l, (Empresa)c.getBemTipoDepreciacao().getBem().getEmpresa());
            lanc.setHistoricoPadrao(opcoesPatrimonio.getHistoricoPis());
            lanc.setHistorico(opcoesPatrimonio.getHistoricoPis().getDescricao());
            lanc.setPlanoContaCred(opcoesPatrimonio.getPlanoContaPisCred());
            lanc.setPlanoContaDeb(opcoesPatrimonio.getPlanoContaPisDeb());
            lanc.setValor(Double.valueOf(c.getValorDepreciacao() * (c.getBemTipoDepreciacao().getBem().getBemSpedPisCofins().getAliquotaPis() / 100.0)));
            lancamentos.add(lanc);
            lanc = CompLancamentoBase.newLancamento((LoteContabil)l, (Empresa)c.getBemTipoDepreciacao().getBem().getEmpresa());
            lanc.setHistoricoPadrao(opcoesPatrimonio.getHistoricoCofins());
            lanc.setHistorico(opcoesPatrimonio.getHistoricoCofins().getDescricao());
            lanc.setPlanoContaCred(opcoesPatrimonio.getPlanoContaCofinsCred());
            lanc.setPlanoContaDeb(opcoesPatrimonio.getPlanoContaCofinsDeb());
            lanc.setValor(Double.valueOf(c.getValorDepreciacao() * (c.getBemTipoDepreciacao().getBem().getBemSpedPisCofins().getAliquotaCofins() / 100.0)));
            lancamentos.add(lanc);
        }
        if (lancamentos != null && !lancamentos.isEmpty()) {
            l.setLancamentos(lancamentos);
            return l;
        }
        return null;
    }

    private PlanoContaBemDepreciacao getPlanoContaBemDepr(TipoDepreciacao tipoDepreciacao, TipoBem tipoBem) {
        for (Object o : tipoDepreciacao.getPlanoContaBemDepr()) {
            PlanoContaBemDepreciacao pc = (PlanoContaBemDepreciacao)o;
            if (!pc.getTipoBem().equals((Object)tipoBem)) continue;
            return pc;
        }
        return null;
    }
}

