/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.lancamento;

import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FaturaCte;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.OpcoesContTransp;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.helpers.impl.lotecontabil.HelperLoteContabil;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class UtilLancamentoFaturaCte {
    private final SCompPlanoConta scPlanoConta = (SCompPlanoConta)ConfApplicationContext.getBean(SCompPlanoConta.class);
    private final HelperLoteContabil helperLote = (HelperLoteContabil)Context.get(HelperLoteContabil.class);

    public LoteContabil gerarLancamentos(FaturaCte vo, OpcoesContTransp opcoesContabeisTransp, OpcoesContabeis opcoes) throws ExceptionInvalidData {
        LoteContabil lote = this.contabilizarCte(vo, opcoesContabeisTransp, opcoes);
        if (lote != null && lote.getLancamentos() != null && !lote.getLancamentos().isEmpty()) {
            return lote;
        }
        return null;
    }

    private LoteContabil contabilizarCte(FaturaCte vo, OpcoesContTransp opcoesContabeisTransp, OpcoesContabeis opcoes) throws ExceptionInvalidData {
        LoteContabil lote = vo.getLoteContabil();
        if (opcoesContabeisTransp.getOpcoesContTranspFatura().getContabilizarFatura() == 1) {
            lote = this.helperLote.criaRecriaLoteContabil(lote, vo.getTipoOperacaoGeracaoFatur().getGeracaoFaturamento().getDataEmissao(), vo.getTipoOperacaoGeracaoFatur().getGeracaoFaturamento().getEmpresa(), ConstEnumOrigemLoteContabil.FATURA_CTE);
            lote.setLancamentos(this.getLancamentosCte(vo, lote, opcoesContabeisTransp, opcoes));
        }
        return lote;
    }

    private List<Lancamento> getLancamentosCte(FaturaCte vo, LoteContabil lote, OpcoesContTransp opcoesContabeisTransp, OpcoesContabeis opcoes) throws ExceptionInvalidData {
        Lancamento acres;
        ParamLancamento p;
        HashMap<ParamLancamento, Double> v = new HashMap<ParamLancamento, Double>();
        List lancamentos = lote.getLancamentos();
        PlanoConta cred = null;
        for (Object c : vo.getCte()) {
            p = new ParamLancamento(this);
            cred = this.scPlanoConta.getPlanoConta(c.getClienteTomador().getCliente(), opcoes);
            p.setContaDebito(cred);
            p.setContaCredito(opcoesContabeisTransp.getOpcoesContTranspFatura().getPlanoContaFatura());
            if (v.get(p) == null) {
                v.put(p, 0.0);
            }
            v.put(p, (Double)v.get(p) + c.getCteVlrImpostos().getVrReceber());
        }
        for (Object c : vo.getRps()) {
            p = new ParamLancamento(this);
            cred = c.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getPlanoContaCliente();
            p.setContaDebito(cred);
            p.setContaCredito(opcoesContabeisTransp.getOpcoesContTranspFatura().getPlanoContaFatura());
            if (v.get(p) == null) {
                v.put(p, 0.0);
            }
            v.put(p, (Double)v.get(p) + c.getValorServico());
        }
        Set keys = v.keySet();
        for (Object o : keys) {
            ParamLancamento pc = (ParamLancamento)o;
            Double vlr = (Double)v.get(o);
            if (!(vlr > 0.0)) continue;
            Lancamento lancamento = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)vo.getTipoOperacaoGeracaoFatur().getGeracaoFaturamento().getEmpresa());
            lancamento.setPlanoContaCred(pc.contaCredito);
            lancamento.setPlanoContaDeb(pc.contaDebito);
            lancamento.setHistorico(null);
            lancamento.setValor(vlr);
            lancamento.setHistorico("Vr. referente a geracao do faturamento nr. " + vo.getIdentificador() + ".");
            lancamentos.add(lancamento);
        }
        Lancamento desc = this.getLancamentoDesconto(vo, lote, cred, opcoesContabeisTransp);
        if (desc != null && desc.getValor() > 0.0) {
            lancamentos.add(desc);
        }
        if ((acres = this.getLancamentoAcrescimo(vo, lote, cred, opcoesContabeisTransp)) != null && acres.getValor() > 0.0) {
            lancamentos.add(acres);
        }
        return lancamentos;
    }

    private Lancamento getLancamentoDesconto(FaturaCte vo, LoteContabil lote, PlanoConta cred, OpcoesContTransp opcoesContabeisTransp) {
        if (vo.getVlrDesconto() > 0.0) {
            Lancamento lancamento = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)vo.getTipoOperacaoGeracaoFatur().getGeracaoFaturamento().getEmpresa());
            lancamento.setPlanoContaCred(cred);
            lancamento.setPlanoContaDeb(opcoesContabeisTransp.getOpcoesContTranspFatura().getPlanoContaDesconto());
            lancamento.setHistorico(null);
            lancamento.setValor(vo.getVlrDesconto());
            lancamento.setHistorico("Vr. de desconto referente a geracao do faturamento nr. " + vo.getIdentificador() + ".");
            return lancamento;
        }
        return null;
    }

    private Lancamento getLancamentoAcrescimo(FaturaCte vo, LoteContabil lote, PlanoConta cred, OpcoesContTransp opcoesContabeisTransp) {
        if (vo.getVlrDesconto() > 0.0) {
            Lancamento lancamento = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)vo.getTipoOperacaoGeracaoFatur().getGeracaoFaturamento().getEmpresa());
            lancamento.setPlanoContaDeb(cred);
            lancamento.setPlanoContaCred(opcoesContabeisTransp.getOpcoesContTranspFatura().getPlanoContaAcrescimo());
            lancamento.setHistorico(null);
            lancamento.setValor(vo.getVlrAcrescimo());
            lancamento.setHistorico("Vr. de acrescimo referente a geracao do faturamento nr. " + vo.getIdentificador() + ".");
            return lancamento;
        }
        return null;
    }

    private class ParamLancamento {
        private PlanoConta contaDebito;
        private PlanoConta contaCredito;

        private ParamLancamento(UtilLancamentoFaturaCte utilLancamentoFaturaCte) {
        }

        public PlanoConta getContaDebito() {
            return this.contaDebito;
        }

        public void setContaDebito(PlanoConta contaDebito) {
            this.contaDebito = contaDebito;
        }

        public PlanoConta getContaCredito() {
            return this.contaCredito;
        }

        public void setContaCredito(PlanoConta contaCredito) {
            this.contaCredito = contaCredito;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ParamLancamento)) {
                return false;
            }
            ParamLancamento p = (ParamLancamento)obj;
            return p.getContaCredito().equals((Object)this.getContaCredito()) && p.getContaDebito().equals((Object)this.getContaDebito());
        }

        public int hashCode() {
            return this.contaCredito.hashCode() + this.contaDebito.hashCode();
        }
    }
}

