/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.lancamento;

import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.model.vo.CentroResultadoContFin;
import com.touchcomp.basementor.model.vo.ContraPartMovimentoBancario;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.MovimentoBancario;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.helpers.impl.lotecontabil.HelperLoteContabil;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import mentorcore.database.mentor.CoreBdUtil;

class UtilLancamentoMovBancario {
    private final HelperLoteContabil helperLote = (HelperLoteContabil)Context.get(HelperLoteContabil.class);

    UtilLancamentoMovBancario() {
    }

    public LoteContabil gerarLancamentos(MovimentoBancario vo, CentroResultadoContFin centroResultadoContFin) {
        LoteContabil lote = this.getLancamentosMovimentos(vo, centroResultadoContFin);
        if (lote != null && lote.getLancamentos() != null && !lote.getLancamentos().isEmpty()) {
            return lote;
        }
        return null;
    }

    private LoteContabil getLancamentosMovimentos(MovimentoBancario vo, CentroResultadoContFin centroResultadoContFin) {
        if (vo.getGrupoDeBaixaFormas() != null) {
            return null;
        }
        if (ToolMethods.isAffirmative((Number)vo.getNaoContabilizarMov())) {
            return null;
        }
        ArrayList<Lancamento> lancamentos = new ArrayList<Lancamento>();
        LoteContabil lote = null;
        if (vo.getIntegracaoMovBancarioMovimento() != null) {
            lote = vo.getIntegracaoMovBancarioMovimento().getLoteContabil();
        }
        lote = this.helperLote.criaRecriaLoteContabil(lote, vo.getDataLancamento(), vo.getEmpresa(), ConstEnumOrigemLoteContabil.MOVIMENTO_BANCARIO);
        CoreBdUtil.getInstance().getSession().evict((Object)lote);
        if (vo.getContaValor().getGerarLancamentoContabil() == 1) {
            Lancamento lancamento = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)vo.getEmpresa());
            lancamento.setHistoricoPadrao(vo.getHistoricoPadrao());
            lancamento.setValor(vo.getValor());
            lancamento.setHistorico(vo.getHistorico());
            if (vo.getDebCred() == 0) {
                lancamento.setPlanoContaCred(vo.getContaValor().getPlanoConta());
                for (Object objContta : vo.getContraPartMovimentoBancario()) {
                    ContraPartMovimentoBancario contra = (ContraPartMovimentoBancario)objContta;
                    if (contra.getPlanoConta() == null) continue;
                    Lancamento lancamentoContra = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)vo.getEmpresa());
                    if (contra.getDebCred().equals((short)1)) {
                        lancamentoContra.setPlanoContaCred(contra.getPlanoConta());
                    } else {
                        lancamentoContra.setPlanoContaDeb(contra.getPlanoConta());
                    }
                    lancamentoContra.setHistoricoPadrao(contra.getHistoricoPadrao());
                    lancamentoContra.setValor(contra.getValor());
                    lancamentoContra.setHistorico(contra.getHistorico());
                    lancamentos.add(lancamentoContra);
                }
            } else {
                lancamento.setPlanoContaDeb(vo.getContaValor().getPlanoConta());
                for (Object objContta : vo.getContraPartMovimentoBancario()) {
                    ContraPartMovimentoBancario contra = (ContraPartMovimentoBancario)objContta;
                    if (contra.getPlanoConta() == null) continue;
                    Lancamento lancamentoContra = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)vo.getEmpresa());
                    if (contra.getDebCred().equals((short)1)) {
                        lancamentoContra.setPlanoContaCred(contra.getPlanoConta());
                    } else {
                        lancamentoContra.setPlanoContaDeb(contra.getPlanoConta());
                    }
                    lancamentoContra.setHistoricoPadrao(contra.getHistoricoPadrao());
                    lancamentoContra.setValor(contra.getValor());
                    lancamentoContra.setHistorico(contra.getHistorico());
                    lancamentos.add(lancamentoContra);
                }
            }
            if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
                lancamentos.add(lancamento);
            }
        }
        lote.getLancamentos().addAll(lancamentos);
        if (lote.getLancamentos() != null && !lote.getLancamentos().isEmpty()) {
            return lote;
        }
        return null;
    }
}

