/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.lancamento;

import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.NotaContratoLocacao;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesLocacao;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.helpers.impl.lotecontabil.HelperLoteContabil;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Collection;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;

public class UtilLancamentoNotaContratoLocacao {
    private final SCompPlanoConta scPlanoConta = (SCompPlanoConta)ConfApplicationContext.getBean(SCompPlanoConta.class);
    private final HelperLoteContabil helperLote = (HelperLoteContabil)Context.get(HelperLoteContabil.class);

    public LoteContabil gerarLancamentos(NotaContratoLocacao apuracaoLocacaoContrato, OpcoesLocacao opcoesLocacao, OpcoesContabeis opcoes) throws ExceptionService, ExceptionDatabase, ExceptionInvalidData {
        LoteContabil lote = this.getLancamentosMovimentos(apuracaoLocacaoContrato, opcoesLocacao, opcoes);
        if (lote != null && lote.getLancamentos() != null && !lote.getLancamentos().isEmpty()) {
            return lote;
        }
        return null;
    }

    private LoteContabil getLancamentosMovimentos(NotaContratoLocacao vo, OpcoesLocacao opcoesLocacao, OpcoesContabeis opcoes) throws ExceptionService, ExceptionDatabase, ExceptionInvalidData {
        LoteContabil lote = this.helperLote.criaRecriaLoteContabil(vo.getLoteContabil(), vo.getDataEmissao(), vo.getEmpresa(), ConstEnumOrigemLoteContabil.NOTA_CONTRATO_LOCACAO);
        CoreBdUtil.getInstance().getSession().evict((Object)lote);
        Lancamento lancamento = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)vo.getEmpresa());
        lancamento.setValor(vo.getValorTotal());
        lancamento.setHistorico("Lancamento gerado pela Nota de Loca\u00e7\u00e3o nr. " + vo.getNumero() + " para o cliente " + vo.getUnidadeFatCliente().getCliente().getPessoa().getNome());
        lancamento.setPlanoContaCred(opcoesLocacao.getPlanoContaCred());
        PlanoConta pc = this.scPlanoConta.getPlanoConta(vo.getUnidadeFatCliente().getCliente(), opcoes);
        lancamento.setPlanoContaDeb(pc);
        lote.getLancamentos().add(lancamento);
        if (ToolMethods.isWithData((Collection)lote.getLancamentos())) {
            return lote;
        }
        return null;
    }
}

