/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.lancamentoctbgerencial;

import com.touchcomp.basementor.model.vo.AberturaPeriodo;
import com.touchcomp.basementor.model.vo.AdiantamentoViagem;
import com.touchcomp.basementor.model.vo.BaixaBem;
import com.touchcomp.basementor.model.vo.DepreciacaoCiap;
import com.touchcomp.basementor.model.vo.GrupoDeBaixa;
import com.touchcomp.basementor.model.vo.IntegracaoComunicadoProducao;
import com.touchcomp.basementor.model.vo.IntegracaoRequisicao;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.MovimentoBancario;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.ProvisaoDec;
import com.touchcomp.basementor.model.vo.ProvisaoFerias;
import com.touchcomp.basementor.model.vo.Titulo;
import java.util.HashMap;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.tools.DateUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;

class AuxCompletaInfoLancGer {
    AuxCompletaInfoLancGer() {
    }

    public Object findDadosLancGerencial(LancamentoCtbGerencial l) {
        HashMap result = null;
        result = this.findOrigemTitulo(l);
        if (result == null) {
            result = this.findOrigemMovBancario(l);
        }
        if (result == null) {
            result = this.findOrigemDepBem(l);
        }
        if (result == null) {
            result = this.findOrigemRequisicao(l);
        }
        if (result == null) {
            result = this.findOrigemLanSaidaItem(l);
        }
        if (result == null) {
            result = this.findOrigemBaixaTitulosLiquidacao(l);
        }
        if (result == null) {
            result = this.findOrigemBaixaTitulos(l);
        }
        if (result == null) {
            result = this.findOrigemMovimentoFolha(l);
        }
        if (result == null) {
            result = this.findOrigemComProducao(l);
        }
        if (result == null) {
            result = this.findOrigemProvisao13(l);
        }
        if (result == null) {
            result = this.findOrigemBaixaBem(l);
        }
        if (result == null) {
            result = this.findOrigemProvisaoFerias(l);
        }
        if (result == null) {
            result = this.findOrigemFechamAdiantamentoViagem(l);
        }
        if (result == null) {
            result = new HashMap();
        }
        return result;
    }

    private HashMap findOrigemTitulo(LancamentoCtbGerencial l) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct t from Titulo t inner join t.lancCtbGerencial l where l = :lanc");
        q.setEntity("lanc", (Object)l);
        q.setMaxResults(1);
        Titulo t = (Titulo)q.uniqueResult();
        if (t != null) {
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("descOrigem", "T\u00edtulo nr: " + t.getIdentificador() + " emitido em " + DateUtil.dateToStr(t.getDataEmissao()));
            h.put("idOrigem", t.getIdentificador());
            h.put("object", t);
            return h;
        }
        return null;
    }

    private HashMap findOrigemMovBancario(LancamentoCtbGerencial l) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct t from MovimentoBancario t inner join t.contraPartMovimentoBancario c where exists(select cp from ContraPartMovimentoBancario cp where cp.lancamentoCtbGerencial=:lanc and cp = c)");
        q.setEntity("lanc", (Object)l);
        q.setMaxResults(1);
        MovimentoBancario t = (MovimentoBancario)q.uniqueResult();
        if (t != null) {
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("descOrigem", "Movimento Financeiro nr: " + t.getIdentificador() + " emitido em " + DateUtil.dateToStr(t.getDataLancamento()));
            h.put("idOrigem", t.getIdentificador());
            h.put("object", t);
            return h;
        }
        return null;
    }

    private HashMap findOrigemDepBem(LancamentoCtbGerencial l) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct t.itemCiapDepreciacaoBaixaBem.depreciacaoCiap from DepreciacaoBem t where t.lancamentoCtbGerencial=:lanc");
        q.setEntity("lanc", (Object)l);
        q.setMaxResults(1);
        DepreciacaoCiap t = (DepreciacaoCiap)q.uniqueResult();
        if (t != null) {
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("descOrigem", "Deprecia\u00e7\u00e3o Bem nr: " + t.getIdentificador() + " emitido em " + DateUtil.dateToStr(t.getPeriodo()));
            h.put("idOrigem", t.getIdentificador());
            h.put("object", t);
            return h;
        }
        return null;
    }

    private HashMap findOrigemRequisicao(LancamentoCtbGerencial l) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct t.integracaoRequisicao from IntegracaoRequisicaoItem t inner join t.lancamentosCtbGerencial l where l=:lanc");
        q.setEntity("lanc", (Object)l);
        q.setMaxResults(1);
        IntegracaoRequisicao t = (IntegracaoRequisicao)q.uniqueResult();
        if (t != null) {
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("descOrigem", "Integra\u00e7\u00e3o Requisi\u00e7\u00e3o nr: " + t.getIdentificador());
            h.put("idOrigem", t.getIdentificador());
            h.put("object", t);
            return h;
        }
        return null;
    }

    private HashMap findOrigemLanSaidaItem(LancamentoCtbGerencial l) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct i.itemNotaTerceiros.notaFiscalTerceiros from LancCtoSaidaItemNota i where i.lancCtbGerencial=:lanc");
        q.setEntity("lanc", (Object)l);
        q.setMaxResults(1);
        NotaFiscalTerceiros t = (NotaFiscalTerceiros)q.uniqueResult();
        if (t != null) {
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("descOrigem", "NF identificador nr: " + t.getIdentificador() + " com entrada em " + DateUtil.dateToStr(t.getDataEntrada()));
            h.put("idOrigem", t.getIdentificador());
            h.put("object", t);
            return h;
        }
        return null;
    }

    private HashMap findOrigemBaixaTitulosLiquidacao(LancamentoCtbGerencial l) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct b.grupoDeBaixaFormas.grupoDeBaixa from BaixaTitulo b inner join b.lancCTbGerencialLiquidacao l where l=:lanc");
        q.setEntity("lanc", (Object)l);
        q.setMaxResults(1);
        GrupoDeBaixa b = (GrupoDeBaixa)q.uniqueResult();
        if (b != null) {
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("descOrigem", "Baixa titulo identificador nr: " + b.getIdentificador() + " com entrada em " + DateUtil.dateToStr(b.getDataLiquidacao()));
            h.put("idOrigem", b.getIdentificador());
            h.put("object", b);
            return h;
        }
        return null;
    }

    private HashMap findOrigemBaixaTitulos(LancamentoCtbGerencial l) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct b.grupoDeBaixaFormas.grupoDeBaixa from BaixaTitulo b inner join b.lancamentoCtbGerencial l where l=:lanc");
        q.setEntity("lanc", (Object)l);
        q.setMaxResults(1);
        GrupoDeBaixa b = (GrupoDeBaixa)q.uniqueResult();
        if (b != null) {
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("descOrigem", "Baixa titulo identificador nr: " + b.getIdentificador() + " com entrada em " + DateUtil.dateToStr(b.getDataLiquidacao()));
            h.put("idOrigem", b.getIdentificador());
            h.put("object", b);
            return h;
        }
        return null;
    }

    private HashMap findOrigemMovimentoFolha(LancamentoCtbGerencial l) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct m.aberturaPeriodo from MovimentoFolha m inner join m.lancsGerenciais l where l.lancamentoGerencial=:lanc");
        q.setEntity("lanc", (Object)l);
        q.setMaxResults(1);
        AberturaPeriodo b = (AberturaPeriodo)q.uniqueResult();
        if (b != null) {
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("descOrigem", "Movimento Folha identificador nr: " + b.getIdentificador() + " com entrada em " + DateUtil.dateToStr(b.getDataFinal()));
            h.put("idOrigem", b.getIdentificador());
            h.put("object", b);
            return h;
        }
        return null;
    }

    private HashMap findOrigemBaixaBem(LancamentoCtbGerencial l) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct m from BaixaBem m where m.lancamentoGerencial=:lanc");
        q.setEntity("lanc", (Object)l);
        q.setMaxResults(1);
        BaixaBem b = (BaixaBem)q.uniqueResult();
        if (b != null) {
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("descOrigem", "Baixa Bem identificador nr: " + b.getIdentificador() + " com entrada em " + DateUtil.dateToStr(b.getDataBaixa()));
            h.put("idOrigem", b.getIdentificador());
            h.put("object", b);
            return h;
        }
        return null;
    }

    private HashMap findOrigemComProducao(LancamentoCtbGerencial lancamentoCtbGerencial) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT DISTINCT c FROM IntegracaoComProducaoItem m INNER JOIN m.integracaoComunicadoProd c INNER JOIN m.lancamentosCtbGerencial l WHERE l = :lanc");
        q.setEntity("lanc", (Object)lancamentoCtbGerencial);
        q.setMaxResults(1);
        IntegracaoComunicadoProducao b = (IntegracaoComunicadoProducao)q.uniqueResult();
        if (b != null) {
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("descOrigem", "Integra\u00e7\u00e3o Comunicado Producao identificador nr: " + b.getIdentificador());
            h.put("idOrigem", b.getIdentificador());
            h.put("object", b);
            return h;
        }
        return null;
    }

    private HashMap findOrigemProvisao13(LancamentoCtbGerencial l) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct m from ProvisaoDec m inner join m.lancsGerencial l where l=:lanc");
        q.setEntity("lanc", (Object)l);
        q.setMaxResults(1);
        ProvisaoDec b = (ProvisaoDec)q.uniqueResult();
        if (b != null) {
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("descOrigem", "Provisao 13 identificador nr: " + b.getIdentificador() + " com entrada em " + DateUtil.dateToStr(b.getDataCadastro()));
            h.put("idOrigem", b.getIdentificador());
            h.put("object", b);
            return h;
        }
        return null;
    }

    private HashMap findOrigemProvisaoFerias(LancamentoCtbGerencial l) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct m from ProvisaoFerias m inner join m.lancsGerencial l where l=:lanc");
        q.setEntity("lanc", (Object)l);
        q.setMaxResults(1);
        ProvisaoFerias b = (ProvisaoFerias)q.uniqueResult();
        if (b != null) {
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("descOrigem", "Provisao Ferias identificador nr: " + b.getIdentificador() + " com entrada em " + DateUtil.dateToStr(b.getDataCadastro()));
            h.put("idOrigem", b.getIdentificador());
            h.put("object", b);
            return h;
        }
        return null;
    }

    private HashMap findOrigemFechamAdiantamentoViagem(LancamentoCtbGerencial l) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct m.adiantamentoViagem from FechamAdiantamentoViagem m inner join m.lancamentoCtbGerencial l where l=:lanc");
        q.setEntity("lanc", (Object)l);
        q.setMaxResults(1);
        AdiantamentoViagem b = (AdiantamentoViagem)q.uniqueResult();
        if (b != null) {
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("descOrigem", "Fechamento diantamento Viagem Ferias identificador nr: " + b.getIdentificador() + " com entrada em " + DateUtil.dateToStr(b.getDataFechamento()));
            h.put("idOrigem", b.getIdentificador());
            h.put("object", b);
            return h;
        }
        return null;
    }
}

