/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.leadtimefornecedor;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.LeadTimeFornecedor;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.leadtimefornecedor.UtilLeadTimeFornecedor;
import mentorcore.service.impl.leadtimefornecedor.UtilProcessarLeadTimeFornecedores;

public class ServiceLeadTimeFornecedor
extends CoreService {
    public static final String FIND_LEAD_TIME_FORNECEDOR_PRODUTO = "findLeadTimeFornecedorProduto";
    public static final String PROCESSAR_LEAD_TIME_FORNECEDOR_PRODUTO = "processarLeadTimeFornecedorProduto";
    public static final String FIND_LEAD_TIME_GRADE_COR = "findLeadTimeGradeCor";
    public static final String FIND_LEAD_TIME_GRADE_COR_HASH = "findLeadTimeGradeCorHash";
    public static final String FIND_LEAD_TIME_GRADE_COR_HOMOLOGADO = "findLeadTimeGradeCorHomologado";

    public LeadTimeFornecedor findLeadTimeFornecedorProduto(CoreRequestContext request) throws ExceptionService {
        GradeCor gradeCor = (GradeCor)request.getAttribute("gradeCor");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        List<LeadTimeFornecedor> ret = CoreDAOFactory.getInstance().getDAOLeadTimeFornecedor().findLeadTimeFornecedorProduto(gradeCor, empresa);
        return UtilLeadTimeFornecedor.verifyDuplicatedLeadTime(ret, gradeCor);
    }

    public void processarLeadTimeFornecedorProduto(CoreRequestContext request) throws ExceptionService, ExceptionDatabase {
        Date dataBase = (Date)request.getAttribute("dataBase");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        new UtilProcessarLeadTimeFornecedores().processaLeadTimeFornecedores(dataBase, empresa);
    }

    public List findLeadTimeGradeCor(CoreRequestContext request) throws ExceptionService, ExceptionDatabase {
        GradeCor gradeCor = (GradeCor)request.getAttribute("gradeCor");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        return CoreDAOFactory.getInstance().getDAOLeadTimeFornProduto().findLeadTimeProduto(gradeCor, empresa);
    }

    public List findLeadTimeGradeCorHash(CoreRequestContext request) throws ExceptionService, ExceptionDatabase {
        Long idGradeCor = (Long)request.getAttribute("idGradeCor");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        return CoreDAOFactory.getInstance().getDAOLeadTimeFornProduto().findLeadTimeProdutoHash(idGradeCor, empresa);
    }

    public List findLeadTimeGradeCorHomologado(CoreRequestContext request) throws ExceptionService, ExceptionDatabase {
        GradeCor gradeCor = (GradeCor)request.getAttribute("gradeCor");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        return CoreDAOFactory.getInstance().getDAOLeadTimeFornProduto().findLeadTimeProdutoHomologado(gradeCor, empresa);
    }
}

