/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.leadtimefornecedor;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.LeadTimeFornProduto;
import com.touchcomp.basementor.model.vo.LeadTimeFornecedor;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.tools.DateUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilProcessarLeadTimeFornecedores {
    UtilProcessarLeadTimeFornecedores() {
    }

    public void processaLeadTimeFornecedores(Date dataBase, Empresa emp) throws ExceptionDatabase {
        List ultimasRecep = this.getListaRecepcoes(dataBase);
        this.processarLeadTime(ultimasRecep, emp);
    }

    private List getListaRecepcoes(Date dataBase) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select  oc.dataEmissao as DATA_EMISSAO, n.dataEntrada as DATA_ENTRADA, p.nome as NOME_PRODUTO, g.gradeCor AS GRADE, n.unidadeFatFornecedor as UNIDADE_FAT_FORN from RecepcaoMercadorias r inner join r.notaFiscalTerceiros n inner join n.itemNotaTerceiros i inner join i.grade g inner join i.produto p inner join r.itemRecepcao ir inner join ir.itemOrdemCompra io inner join io.ordemCompra oc where n.dataEntrada = (select max(n1.dataEntrada)  from  RecepcaoMercadorias r1 inner join r1.notaFiscalTerceiros n1 inner join n1.itemNotaTerceiros i1 inner join i1.grade g1 where g1.gradeCor=g.gradeCor and   n1.dataEntrada>=:dataBase) order by n.unidadeFatFornecedor");
        q.setDate("dataBase", dataBase);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private void processarLeadTime(List ultimasRecep, Empresa emp) throws ExceptionDatabase {
        UnidadeFatFornecedor currentUnidadeFat = null;
        LeadTimeFornecedor currentLeadTime = null;
        for (Object o : ultimasRecep) {
            LeadTimeFornProduto leadGrade;
            HashMap h = (HashMap)o;
            UnidadeFatFornecedor u = (UnidadeFatFornecedor)h.get("UNIDADE_FAT_FORN");
            GradeCor gradeCor = (GradeCor)h.get("GRADE");
            Date dataEmissao = (Date)h.get("DATA_EMISSAO");
            Date dataEntrada = (Date)h.get("DATA_ENTRADA");
            if (currentUnidadeFat == null || !u.equals((Object)currentUnidadeFat)) {
                currentUnidadeFat = u;
                if (currentLeadTime != null) {
                    CoreDAOFactory.getInstance().getDAOLeadTimeFornecedor().saveOrUpdate(currentLeadTime);
                }
                currentLeadTime = null;
            }
            if (currentLeadTime == null) {
                currentLeadTime = this.getLeadTimeFornecedor(currentUnidadeFat, emp);
            }
            if (currentLeadTime == null) {
                currentLeadTime = this.getNewLeadTimeFornecedor(currentUnidadeFat, emp);
            }
            if ((leadGrade = this.getLeadGrade(gradeCor, currentLeadTime)) == null) {
                leadGrade = new LeadTimeFornProduto();
                leadGrade.setGradeCor(gradeCor);
                leadGrade.setLeadTimeFornecedor(currentLeadTime);
                currentLeadTime.getLeadTimeFornProduto().add(leadGrade);
            }
            leadGrade.setLeadTime(DateUtil.diferenceDayBetweenDates(dataEmissao, dataEntrada));
            if (leadGrade.getLeadTime() < 0) {
                leadGrade.setLeadTime(Integer.valueOf(0));
            }
            leadGrade.setUltimaEntrada(dataEntrada);
        }
    }

    private LeadTimeFornecedor getLeadTimeFornecedor(UnidadeFatFornecedor currentUnidadeFat, Empresa emp) throws ExceptionDatabase {
        return CoreDAOFactory.getInstance().getDAOLeadTimeFornecedor().getLeadTime(currentUnidadeFat, emp);
    }

    private LeadTimeFornecedor getNewLeadTimeFornecedor(UnidadeFatFornecedor currentUnidadeFat, Empresa emp) {
        LeadTimeFornecedor l = new LeadTimeFornecedor();
        l.setUnidadeFatFornecedor(currentUnidadeFat);
        l.setEmpresa(emp);
        return l;
    }

    private LeadTimeFornProduto getLeadGrade(GradeCor gradeCor, LeadTimeFornecedor lead) {
        for (LeadTimeFornProduto l : lead.getLeadTimeFornProduto()) {
            if (!l.getGradeCor().equals((Object)gradeCor)) continue;
            return l;
        }
        return null;
    }
}

