/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagemapuracaocomisrecibo;

import com.touchcomp.basementor.model.vo.ApuracaoComissaoRepresentante;
import com.touchcomp.basementor.model.vo.ApuracaoComissaoRepresentanteBaixasPag;
import com.touchcomp.basementor.model.vo.ApuracaoComissaoRepresentanteTitulosFat;
import com.touchcomp.basementor.model.vo.ApuracaoComissaoRepresentanteTitulosVenc;
import com.touchcomp.basementor.model.vo.Nodo;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilListagemApuracaoComisRecibo {
    UtilListagemApuracaoComisRecibo() {
    }

    JasperPrint gerarListagemApuracaoComisRecibo(Short filtrarData, Date dataInicial, Date dataFinal, Short filtrarRepresentante, Long representanteInicial, Long representanteFinal, Short filtrarApuracao, Long apuracaoInicial, Long apuracaoFinal, String fecho, Nodo nodo, HashMap parametros) throws ExceptionService {
        List<HashMap> dados = this.pesquisarApuracaoComisRecibo(filtrarData, dataInicial, dataFinal, filtrarRepresentante, representanteInicial, representanteFinal, filtrarApuracao, apuracaoInicial, apuracaoFinal);
        this.pesquisarLancamentos(dados);
        return this.gerarJasperPrintListagemApuracaoComisRecibo(filtrarData, dataInicial, dataFinal, filtrarRepresentante, representanteInicial, representanteFinal, fecho, nodo, parametros, dados);
    }

    private List<HashMap> pesquisarApuracaoComisRecibo(Short filtrarData, Date dataInicial, Date dataFinal, Short filtrarRepresentante, Long representanteInicial, Long representanteFinal, Short filtrarApuracao, Long apuracaoInicial, Long apuracaoFinal) throws ExceptionService {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = " SELECT a.identificador  AS ID_APUR_COMIS_REPRESENTANTE, r.identificador            AS ID_REPRESENTANTE, r.pessoa.nome              AS NOME_REPRESENTANTE, t.dataVencimento           AS DATA_VENCIMENTO, coalesce(t.valor,0d)       AS VALOR, coalesce(t.descontoFinanceiro, 0d) AS DESCONTO, a.vrComissaoFaturamento    AS COMISSAO_FATURAMENTO, a.vrComissaoVencimento     AS COMISSAO_VENCIMENTO, a.vrComissaoPagamento      AS COMISSAO_PAGAMENTO, a.dataInicial              AS DATA_INICIAL, a.dataFinal                AS DATA_FINAL, a.dataCadastro             AS DATA_APURACAO, a.valorDebito              AS VALOR_DEBITO, a.valorCredito             AS VALOR_CREDITO FROM ApuracaoComissaoRepresentante a LEFT JOIN a.tituloGerado t INNER JOIN a.representante r WHERE (:filtrarData <> 1 OR ((a.dataInicial BETWEEN :dataInicial AND :dataFinal) AND (a.dataFinal BETWEEN :dataInicial AND :dataFinal))) AND (:filtrarRepresentante <> 1 OR r.identificador BETWEEN :representanteInicial and :representanteFinal) AND (:filtrarApuracao <> 1 OR a.identificador BETWEEN :apuracaoInicial and :apuracaoFinal) GROUP BY   a.identificador, r.identificador, r.pessoa.nome, t.dataVencimento, t.valor, t.descontoFinanceiro, a.vrComissaoFaturamento, a.vrComissaoVencimento, a.vrComissaoPagamento, a.dataInicial, a.dataFinal, a.valorDebito, a.valorCredito, a.dataCadastro";
        Query q = s.createQuery(hql);
        q.setShort("filtrarData", filtrarData.shortValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setShort("filtrarRepresentante", filtrarRepresentante.shortValue());
        q.setLong("representanteInicial", representanteInicial.longValue());
        q.setLong("representanteFinal", representanteFinal.longValue());
        q.setShort("filtrarApuracao", filtrarApuracao.shortValue());
        q.setLong("apuracaoInicial", apuracaoInicial.longValue());
        q.setLong("apuracaoFinal", apuracaoFinal.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        if (lista != null) {
            for (Object o : lista) {
                HashMap h = (HashMap)o;
                ApuracaoComissaoRepresentante a = (ApuracaoComissaoRepresentante)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOApuracaoComissaoRep(), (Long)h.get("ID_APUR_COMIS_REPRESENTANTE"));
                Double valorVendido = 0.0;
                for (ApuracaoComissaoRepresentanteTitulosFat tFat : a.getTitulosFaturamento()) {
                    valorVendido = valorVendido + tFat.getTituloRepresentante().getVrBCComissao();
                }
                for (ApuracaoComissaoRepresentanteTitulosVenc tVenc : a.getTitulosVencimento()) {
                    valorVendido = valorVendido + tVenc.getTituloRepresentante().getVrBCComissao();
                }
                for (ApuracaoComissaoRepresentanteBaixasPag b : a.getBaixasPagamento()) {
                    valorVendido = valorVendido + b.getBaixaTitulo().getValor();
                }
                h.put("VALOR", valorVendido);
                h.put("MEDIA_COMISSAO", (a.getVrComissaoPagamento() + a.getVrComissaoFaturamento() + a.getVrComissaoVencimento()) * 100.0 / valorVendido);
            }
        }
        return lista;
    }

    private JasperPrint gerarJasperPrintListagemApuracaoComisRecibo(Short filtrarData, Date dataIncial, Date dataFinal, Short filtrarRepresentante, Long representanteInicial, Long representanteFinal, String fecho, Nodo nodo, HashMap parametros, List<HashMap> dados) throws ExceptionService {
        parametros.put("FILTRAR_DATA", filtrarData);
        parametros.put("DATA_INICIAL", dataIncial);
        parametros.put("DATA_FINAL", dataFinal);
        parametros.put("FILTRAR_REPRESENTANTE", filtrarRepresentante);
        parametros.put("REPRESENTANTE_INICIAL", representanteInicial);
        parametros.put("REPRESENTANTE_FINAL", representanteFinal);
        parametros.put("FECHO", fecho);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", parametros).setAttribute("isPaisagem", false).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "financeiro" + File.separator + "apuracaocomissaorepresentante" + File.separator + "LISTAGEM_APURACAO_COMISSAO_RECIBO.jasper";
        CoreRequestContext r = new CoreRequestContext();
        r.setAttribute("path", path);
        r.setAttribute("parametros", parametros);
        r.setAttribute("dados", dados);
        return (JasperPrint)CoreServiceFactory.getCoreReportService().execute(r, "getJasperPrintDataSource");
    }

    private void pesquisarLancamentos(List<HashMap> dados) {
        for (HashMap h : dados) {
            Long idApuracao = (Long)h.get("ID_APUR_COMIS_REPRESENTANTE");
            h.put("LIST_LANCAMENTOS_MANUAIS", this.gerarLancamentos(idApuracao));
        }
    }

    private List<HashMap> gerarLancamentos(Long idApuracao) {
        ArrayList<HashMap> list = new ArrayList();
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" SELECT l.debCred     AS TIPO_LANCAMENTO, l.valor              AS VALOR_LANC_MANUAIS, l.observacao         AS OBSERVACAO FROM LancamentoComissaoRepresentante l WHERE l.apuracaoComissaoRepresentante = :idApuracao");
        q.setLong("idApuracao", idApuracao.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        list = q.list();
        return list;
    }
}

