/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagemautorizacaoretirada;

import com.touchcomp.basementor.model.vo.AutorizacaoRetirada;
import com.touchcomp.basementor.model.vo.BaixaAutorizacaoRetirada;
import com.touchcomp.basementor.model.vo.Nodo;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilListagemAutorizacaoRetirada {
    private static final Short BAIXADAS = 0;

    UtilListagemAutorizacaoRetirada() {
    }

    JasperPrint gerarListagemAutorizacaoRetirada(Short tipo, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, String fecho, Nodo nodo, HashMap parametros) throws ExceptionService {
        List<HashMap> dados = this.pesquisarAutorizacaoRetiradaBaixadaNaoBaixadas(tipo, filtrarEmpresa, empresaInicial, empresaFinal);
        return this.gerarJasperPrintAutorizacaoRetirada(tipo, filtrarEmpresa, empresaInicial, empresaFinal, fecho, nodo, parametros, dados);
    }

    private List<HashMap> pesquisarAutorizacaoRetiradaBaixadaNaoBaixadas(Short tipo, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal) {
        Criteria criteria = CoreBdUtil.getInstance().getSession().createCriteria(AutorizacaoRetirada.class);
        criteria = criteria.createAlias("empresa", "empresa");
        criteria = criteria.createAlias("tipoOperacaoAR", "tipoOperacaoAR");
        criteria = criteria.createAlias("conjuntoTransportador", "conjuntoTransportador");
        criteria = criteria.createAlias("conjuntoTransportador.motorista", "motorista");
        criteria = criteria.createAlias("motorista.pessoa", "pessoaMotorista");
        criteria = criteria.createAlias("conjuntoTransportador.transportadorAgregado", "transportadorAgregado");
        criteria = criteria.createAlias("transportadorAgregado.pessoa", "pessoaTransportadorAgregado");
        criteria = criteria.createAlias("conjuntoTransportador.conjuntoTranspVeiculo", "conjuntoTranspVeiculo");
        criteria = criteria.createAlias("conjuntoTranspVeiculo.veiculo", "veiculo");
        if (filtrarEmpresa == 1) {
            criteria.add(Restrictions.between((String)"empresa.identificador", (Object)empresaInicial, (Object)empresaFinal));
        }
        if (tipo == BAIXADAS) {
            criteria.add(Restrictions.isNotEmpty((String)"baixaAutorizacaoRetirada"));
        } else {
            criteria.add(Restrictions.isEmpty((String)"baixaAutorizacaoRetirada"));
        }
        criteria.add((Criterion)Restrictions.eq((String)"conjuntoTranspVeiculo.placaPrincipal", (Object)1));
        ProjectionList projections = Projections.projectionList();
        projections.add(Projections.alias((Projection)Projections.property((String)"identificador"), (String)"ID_AUTORIZACAO_RETIRADA"));
        projections.add(Projections.alias((Projection)Projections.property((String)"numeroAR"), (String)"NUMERO_AR"));
        projections.add(Projections.alias((Projection)Projections.property((String)"dataAR"), (String)"DATA_AR"));
        projections.add(Projections.alias((Projection)Projections.property((String)"tipoOperacaoAR.identificador"), (String)"ID_TIPO_OPERACAO_AR"));
        projections.add(Projections.alias((Projection)Projections.property((String)"tipoOperacaoAR.descricao"), (String)"TIPO_OPERACAO_AR"));
        projections.add(Projections.alias((Projection)Projections.property((String)"motorista.identificador"), (String)"ID_MOTORISTA"));
        projections.add(Projections.alias((Projection)Projections.property((String)"pessoaMotorista.nome"), (String)"MOTORISTA"));
        projections.add(Projections.alias((Projection)Projections.property((String)"transportadorAgregado.identificador"), (String)"ID_TRANSPORTADOR_AGREGADO"));
        projections.add(Projections.alias((Projection)Projections.property((String)"pessoaTransportadorAgregado.nome"), (String)"TRANSPORTADOR_AGREGADO"));
        projections.add(Projections.alias((Projection)Projections.property((String)"veiculo.placa"), (String)"PLACA"));
        criteria.setProjection((Projection)projections);
        criteria.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        if (tipo == BAIXADAS) {
            return this.pesquisarNotas(criteria.list());
        }
        return criteria.list();
    }

    private List<HashMap> pesquisarNotas(List<HashMap> dados) {
        for (HashMap h : dados) {
            Long idAutorizacaoRetirada = (Long)h.get("ID_AUTORIZACAO_RETIRADA");
            Criteria criteria = CoreBdUtil.getInstance().getSession().createCriteria(BaixaAutorizacaoRetirada.class);
            criteria = criteria.createAlias("autorizacaoRetirada", "autorizacaoRetirada");
            criteria.add((Criterion)Restrictions.eq((String)"autorizacaoRetirada.identificador", (Object)idAutorizacaoRetirada));
            ProjectionList projections = Projections.projectionList();
            projections.add(Projections.alias((Projection)Projections.property((String)"numeroNota"), (String)"NUMERO_NOTA"));
            projections.add(Projections.alias((Projection)Projections.property((String)"dataNota"), (String)"DATA_NOTA"));
            projections.add(Projections.alias((Projection)Projections.property((String)"valorNota"), (String)"VALOR_NOTA"));
            criteria.setProjection((Projection)projections);
            criteria.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            h.put("LIST_NOTAS", criteria.list());
        }
        return dados;
    }

    private JasperPrint gerarJasperPrintAutorizacaoRetirada(Short tipo, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, String fecho, Nodo nodo, HashMap parametros, List<HashMap> dados) throws ExceptionService {
        parametros.put("TIPO", tipo);
        parametros.put("FILTRAR_EMPRESA", filtrarEmpresa);
        parametros.put("EMPRESA_INICIAL", empresaInicial);
        parametros.put("EMPRESA_FINAL", empresaFinal);
        parametros.put("FECHO", fecho);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", parametros).setAttribute("isPaisagem", true).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "transportador" + File.separator + "controleretirada" + File.separator + "relatorios" + File.separator + "LISTAGEM_AUTORIZACAO_RETIRADA.jasper";
        CoreRequestContext r = new CoreRequestContext();
        r.setAttribute("path", path);
        r.setAttribute("parametros", parametros);
        r.setAttribute("dados", dados);
        return (JasperPrint)CoreServiceFactory.getCoreReportService().execute(r, "getJasperPrintDataSource");
    }
}

