/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagembasecalculo;

import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.TipoCalculo;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilListagemBaseCalculo {
    JasperPrint gerarListagemBasePorEvento(Integer filtrarCC, Integer filtrarData, Date dataInicial, Date dataFinal, Long tipoCalculo, Integer empresaInicial, Integer empresaFinal, Short fgts, Short inss, String titulo, String nomeCentroCusto, String fecho, Nodo nodo, HashMap parametros) throws ExceptionService {
        List<HashMap> dados = this.pesquisarBCPorEvento(filtrarCC, filtrarData, dataInicial, dataFinal, tipoCalculo, empresaInicial, empresaFinal, fgts, inss, titulo, nomeCentroCusto);
        return this.gerarJasperPrintListagemBaseCalculoPorEvento(filtrarCC, filtrarData, dataInicial, dataFinal, tipoCalculo, empresaInicial, empresaFinal, fgts, inss, titulo, nomeCentroCusto, fecho, nodo, parametros, dados);
    }

    private List<HashMap> pesquisarBCPorEvento(Integer filtrarCC, Integer filtrarData, Date dataInicial, Date dataFinal, Long tipoCalculo, Integer empresaInicial, Integer empresaFinal, Short fgts, Short inss, String titulo, String nomeCentroCusto) throws ExceptionService {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = " SELECT  e.codigo          AS CODIGO, e.descricao       AS DESCRICAO, SUM(i.referencia) AS REFERENCIA, SUM(i.valor)      AS VALOR, e.tipoEvento      AS TIPO_EVENTO FROM MovimentoFolha mov INNER JOIN    mov.colaborador co INNER JOIN    co.centroCusto c INNER JOIN    co.pessoa p INNER JOIN    co.funcao f INNER JOIN    f.cbo cb INNER JOIN    mov.itensMovimentoFolha i INNER JOIN    i.eventoColaborador item INNER JOIN    item.tipoCalculoEvento tipo  INNER JOIN    tipo.evento e INNER JOIN    mov.aberturaPeriodo a WHERE mov.empresa BETWEEN :empresaInicial AND :empresaFinal AND  (:filtrarData <> 1 OR (a.dataInicio >= :dataInicial AND a.dataFinal <= :dataFinal)) AND  (:fgts <> 1 OR (tipo.incidenciaFgts = :fgts)) AND  (:inss <> 1 OR (tipo.incidenciaInss = :inss))";
        if (tipoCalculo != null && tipoCalculo != 0L) {
            hql = (String)hql + " AND  (a.tipoCalculo = :tipoCalculo)";
        }
        hql = (String)hql + " GROUP BY  e.codigo, e.descricao, e.tipoEvento ORDER BY e.tipoEvento,e.codigo";
        Query q = s.createQuery((String)hql);
        q.setInteger("filtrarData", filtrarData.intValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        if (tipoCalculo != null && tipoCalculo != 0L) {
            q.setLong("tipoCalculo", tipoCalculo.longValue());
        }
        q.setShort("fgts", fgts.shortValue());
        q.setShort("inss", inss.shortValue());
        q.setLong("empresaInicial", (long)empresaInicial.intValue());
        q.setLong("empresaFinal", (long)empresaFinal.intValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private JasperPrint gerarJasperPrintListagemBaseCalculoPorEvento(Integer filtrarCC, Integer filtrarData, Date dataInicial, Date dataFinal, Long tipoCalculo, Integer empresaInicial, Integer empresaFinal, Short fgts, Short inss, String titulo, String nomeCentroCusto, String fecho, Nodo nodo, HashMap parametros, List<HashMap> dados) throws ExceptionService {
        parametros.put("FILTRAR_DATA", filtrarData);
        parametros.put("DATA_INICIAL", dataInicial);
        parametros.put("DATA_FINAL", dataFinal);
        parametros.put("TIPO_FOLHA", tipoCalculo);
        parametros.put("FILTRAR_CENTRO_CUSTO", filtrarCC);
        parametros.put("EMPRESA_INICIAL", empresaInicial);
        parametros.put("EMPRESA_FINAL", empresaFinal);
        parametros.put("FGTS", fgts);
        parametros.put("INSS", inss);
        parametros.put("FECHO", fecho);
        parametros.put("TITULO", titulo);
        parametros.put("NOME_CENTRO_CUSTO", nomeCentroCusto);
        parametros.put("HIBERNATE_SESSION", CoreBdUtil.getInstance().getSession());
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", parametros).setAttribute("isPaisagem", false).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "rh" + File.separator + "relatorios" + File.separator + "listagembasecalculo" + File.separator + "LISTAGEM_BASE_IMPOSTO_POR_EVENTO_TESTE.jasper";
        CoreRequestContext r = new CoreRequestContext();
        r.setAttribute("path", path);
        r.setAttribute("parametros", parametros);
        r.setAttribute("dados", dados);
        JasperPrint jasper = (JasperPrint)CoreServiceFactory.getCoreReportService().execute(r, "getJasperPrintDataSource");
        return jasper;
    }

    JasperPrint gerarListagemBasePorColaborador(Integer exibirCC, Date periodo, Date dataInicial, Date dataFinal, String titulo, String tipoFolha, Integer filtrarCategoria, Integer imposto, Integer categoria, String descriCategoria, TipoCalculo tipoCalculo, String ccInicio, String ccFinal, Integer empresaInicial, Integer empresaFinal, String fecho, Nodo nodo, HashMap parametros, Short filtrarGrupo, GrupoEmpresa grupo, Long idSindicato) throws ExceptionService {
        List<HashMap> dados = this.pesquisarBCPorColaborador(exibirCC, dataInicial, dataFinal, filtrarCategoria, imposto, categoria, tipoCalculo, ccInicio, ccFinal, empresaInicial, empresaFinal, filtrarGrupo, grupo, idSindicato);
        return this.gerarJasperPrintListagemBaseCalculoPorColaborador(exibirCC, periodo, dataInicial, dataFinal, titulo, tipoFolha, filtrarCategoria, imposto, categoria, descriCategoria, tipoCalculo, ccInicio, ccFinal, empresaInicial, empresaFinal, fecho, nodo, parametros, dados);
    }

    private List<HashMap> pesquisarBCPorColaborador(Integer exibirCC, Date dataInicial, Date dataFinal, Integer filtrarCategoria, Integer imposto, Integer categoria, TipoCalculo tipoCalculo, String ccInicio, String ccFinal, Integer empresaInicial, Integer empresaFinal, Short filtrarGrupo, GrupoEmpresa grupo, Long idSindicato) throws ExceptionService {
        Session s = CoreBdUtil.getInstance().getSession();
        if (categoria == null) {
            categoria = 1;
        }
        Query query = s.createQuery(this.getQuery(imposto, tipoCalculo, exibirCC, filtrarGrupo));
        query.setInteger("filtrarCentroCusto", exibirCC.intValue());
        query.setInteger("filtrarCentroCusto", exibirCC.intValue());
        query.setLong("idSindicato", idSindicato.longValue());
        query.setDate("dataInicio", dataInicial);
        query.setDate("dataFinal", dataFinal);
        query.setShort("filtrarGrupo", filtrarGrupo.shortValue());
        query.setLong("idGrupo", grupo.getIdentificador().longValue());
        if (tipoCalculo != null) {
            query.setEntity("tipoCalculo", (Object)tipoCalculo);
        }
        query.setString("ccInicio", ccInicio);
        query.setString("ccFinal", ccFinal);
        query.setInteger("idEmpresaInicial", empresaInicial.intValue());
        query.setInteger("idEmpresaFinal", empresaFinal.intValue());
        query.setInteger("filtrarCategoria", filtrarCategoria.intValue());
        query.setInteger("categoria", categoria == null ? 1 : categoria);
        query.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List l = query.list();
        if (imposto == 2) {
            HashMap m = new HashMap();
            ArrayList aux = new ArrayList();
            aux.addAll(l);
            l.clear();
            for (Object o : aux) {
                m = (HashMap)o;
                Long idColaborador = (Long)m.get("idColaborador");
                Query q = CoreBdUtil.getInstance().getSession().createQuery(this.getQueryRecisao());
                q.setLong("colaborador", idColaborador.longValue());
                q.setDate("data", dataFinal);
                q.setShort("nao", (short)0);
                q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
                if (q.uniqueResult() != null) {
                    m.put("DATA", ((HashMap)q.uniqueResult()).get("DATA"));
                    m.put("CODIGO2", ((HashMap)q.uniqueResult()).get("CODIGO"));
                }
                l.add(m);
            }
        }
        return l;
    }

    private String getQuery(Integer imposto, TipoCalculo tipoCalculo, Integer filtarCC, Short filtrarGrupo) {
        if (imposto == 0) {
            Object query = " SELECT  mov.colaborador.centroCusto.codigo AS CODIGO,mov.colaborador.centroCusto.nome AS CENTRO_C, mov.colaborador.nomeSocialTravesti as NOME_SOCIAL_TRAVESTI, cast(mov.colaborador.numeroRegistro as integer )AS NUMERO_REGISTRO, mov.colaborador.pessoa.nome AS NOME, mov.bcInssSalario AS BC_SALARIO, mov.vrInssSalario AS VR_SALARIO, mov.bcInssFerias AS BC_FERIAS, mov.vrInssFerias AS VR_FERIAS, mov.bcInss13Sal AS BC_13, mov.vrInss13Sal AS VR_13,mov.aliqInssSalario AS ALIQ_SALARIO,mov.aliqInssFerias AS ALIQ_FERIAS,mov.aliqInss13Sal AS ALIQ_13 FROM MovimentoFolha mov WHERE  ((:filtrarGrupo = 0 and mov.empresa.identificador BETWEEN :idEmpresaInicial AND :idEmpresaFinal )  or (:filtrarGrupo = 1 and mov.empresa.empresaDados.grupoEmpresa.identificador BETWEEN :idGrupo AND :idGrupo ) )AND (:filtrarCentroCusto <> 1 OR mov.centroCusto.codigo  between  :ccInicio AND :ccFinal) AND (mov.aberturaPeriodo.dataInicio >= :dataInicio AND mov.aberturaPeriodo.dataFinal <= :dataFinal ) AND ( :filtrarCategoria <> 1 OR  mov.colaborador.categoriaTrabalhador.identificador = :categoria) AND (:idSindicato = 0 or mov.colaborador.sindicato.identificador = :idSindicato )";
            if (tipoCalculo != null) {
                query = (String)query + "AND mov.aberturaPeriodo.tipoCalculo.identificador = :tipoCalculo ";
            }
            query = filtarCC == 0 ? (String)query + "ORDER BY mov.colaborador.pessoa.nome " : (String)query + "ORDER BY mov.colaborador.centroCusto.codigo,mov.colaborador.pessoa.nome ";
            return query;
        }
        if (imposto == 1) {
            Object query = " SELECT  mov.colaborador.centroCusto.codigo AS CODIGO,mov.colaborador.centroCusto.nome AS CENTRO_C, mov.colaborador.nomeSocialTravesti as NOME_SOCIAL_TRAVESTI, CAST(mov.colaborador.numeroRegistro AS integer)AS NUMERO_REGISTRO, mov.colaborador.pessoa.nome AS NOME, mov.bcIrrfSalario AS BC_SALARIO, mov.vrIrrfSalario AS VR_SALARIO, mov.bcIrrfFerias AS BC_FERIAS, mov.vrIrrfFerias AS VR_FERIAS, mov.bcIrrf13Sal AS BC_13, mov.vrIrrf13Sal AS VR_13,mov.aliqIrrfSalario AS ALIQ_SALARIO,mov.aliqIrrfFerias AS ALIQ_FERIAS,mov.aliqIrrf13Sal AS ALIQ_13 FROM MovimentoFolha mov WHERE  ((:filtrarGrupo = 0 and mov.empresa.identificador BETWEEN :idEmpresaInicial AND :idEmpresaFinal )  or (:filtrarGrupo = 1 and mov.empresa.empresaDados.grupoEmpresa.identificador BETWEEN :idGrupo AND :idGrupo ) )AND (:filtrarCentroCusto <> 1 OR mov.colaborador.centroCusto.codigo  BETWEEN  :ccInicio AND :ccFinal) AND (mov.aberturaPeriodo.dataInicio >= :dataInicio AND mov.aberturaPeriodo.dataFinal <= :dataFinal )AND (:filtrarCategoria <> 1 OR  mov.colaborador.categoriaTrabalhador.identificador = :categoria) AND (:idSindicato = 0 or mov.colaborador.sindicato.identificador = :idSindicato )";
            if (tipoCalculo != null) {
                query = (String)query + " AND (mov.aberturaPeriodo.tipoCalculo.identificador = :tipoCalculo) ";
            }
            query = filtarCC == 0 ? (String)query + "ORDER BY mov.colaborador.pessoa.nome " : (String)query + "ORDER BY mov.colaborador.centroCusto.codigo,mov.colaborador.pessoa.nome ";
            return query;
        }
        Object query = " SELECT  mov.colaborador.centroCusto.codigo AS CODIGO,mov.colaborador.centroCusto.nome AS CENTRO_C, mov.colaborador.nomeSocialTravesti as NOME_SOCIAL_TRAVESTI, cast(mov.colaborador.numeroRegistro as integer )AS NUMERO_REGISTRO, mov.colaborador.pessoa.nome AS NOME, mov.bcFgtsSalario AS BC_SALARIO, mov.vrFgtsSalario AS VR_SALARIO, mov.bcFgtsFerias AS BC_FERIAS, mov.vrFgtsFerias AS VR_FERIAS, mov.bcFgts13Sal AS BC_13, mov.vrFgts13Sal AS VR_13,mov.aliqFgtsSalario AS ALIQ_SALARIO,mov.aliqFgtsFerias AS ALIQ_FERIAS,mov.aliqFgts13Sal AS ALIQ_13,mov.colaborador.identificador AS idColaborador FROM MovimentoFolha mov WHERE  ((:filtrarGrupo = 0 and mov.empresa.identificador BETWEEN :idEmpresaInicial AND :idEmpresaFinal )  or (:filtrarGrupo = 1 and mov.empresa.empresaDados.grupoEmpresa.identificador BETWEEN :idGrupo AND :idGrupo ) )AND (:filtrarCentroCusto <> 1 OR mov.colaborador.centroCusto.codigo  BETWEEN  :ccInicio AND :ccFinal) AND (mov.aberturaPeriodo.dataInicio >= :dataInicio AND mov.aberturaPeriodo.dataFinal <= :dataFinal ) AND ( :filtrarCategoria <> 1 OR  mov.colaborador.categoriaTrabalhador.identificador = :categoria) AND (:idSindicato = 0 or mov.colaborador.sindicato.identificador = :idSindicato )";
        if (tipoCalculo != null) {
            query = (String)query + "AND (mov.aberturaPeriodo.tipoCalculo.identificador = :tipoCalculo) ";
        }
        query = filtarCC == 0 ? (String)query + "ORDER BY mov.colaborador.pessoa.nome " : (String)query + "ORDER BY mov.colaborador.centroCusto.codigo,mov.colaborador.pessoa.nome ";
        return query;
    }

    private String getQueryRecisao() {
        return "SELECT r.dataAfastamento AS DATA, r.cadastroRecisao.recisao.codigo AS CODIGO FROM Recisao r WHERE r.colaborador.identificador = :colaborador AND r.recisaoComplementar = :nao AND r.dataAfastamento <= :data";
    }

    private JasperPrint gerarJasperPrintListagemBaseCalculoPorColaborador(Integer exibirCC, Date periodo, Date dataInicial, Date dataFinal, String titulo, String tipoFolha, Integer filtrarCategoria, Integer imposto, Integer categoria, String descriCategoria, TipoCalculo tipoCalculo, String ccInicio, String ccFinal, Integer empresaInicial, Integer empresaFinal, String fecho, Nodo nodo, HashMap parametros, List<HashMap> dados) throws ExceptionService {
        parametros.put("DATA_INICIAL", dataInicial);
        parametros.put("DATA_FINAL", dataFinal);
        parametros.put("TIPO_FOLHA", tipoCalculo);
        parametros.put("PERIODO", periodo);
        parametros.put("EXIBIR_CC", exibirCC);
        parametros.put("CENTRO_CUSTO_INICIAL", ccInicio);
        parametros.put("CENTRO_CUSTO_FINAL", ccFinal);
        parametros.put("EMPRESA_INICIAL", empresaInicial);
        parametros.put("EMPRESA_FINAL", empresaFinal);
        parametros.put("TITULO", titulo);
        parametros.put("TIPO_FOLHA", tipoFolha);
        parametros.put("FILTRAR_CATEGORIA", filtrarCategoria);
        parametros.put("CATEGORIA", categoria);
        parametros.put("DESCRICAO_CATEGORIA", descriCategoria);
        parametros.put("IMPOSTO", imposto);
        parametros.put("FECHO", fecho);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", parametros).setAttribute("isPaisagem", false).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "rh" + File.separator + "relatorios" + File.separator + "listagembasecalculo" + File.separator + "LISTAGEM_BC_IMPOSTOS.jasper";
        CoreRequestContext r = new CoreRequestContext();
        r.setAttribute("path", path);
        r.setAttribute("parametros", parametros);
        r.setAttribute("dados", dados);
        return (JasperPrint)CoreServiceFactory.getCoreReportService().execute(r, "getJasperPrintDataSource");
    }
}

