/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagemcivcipp;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Nodo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilListagemCivCipp {
    private static final Short CIV = 0;
    private static final Short CIPP = 1;
    private static Long quantidadeCancelada;
    private static Long quantidadeEmitida;

    public UtilListagemCivCipp() {
        quantidadeCancelada = 0L;
        quantidadeEmitida = 0L;
    }

    JasperPrint gerarListagemCivCipp(Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Short tipoInspecao, Empresa empresa, String fecho, Nodo nodo, HashMap parametros) throws ExceptionService {
        List<HashMap> dados = this.pesquisarCivCipp(filtrarDataEmissao, dataEmissaoInicial, dataEmissaoFinal, tipoInspecao, empresa);
        return this.gerarJasperPrintCivCipp(filtrarDataEmissao, dataEmissaoInicial, dataEmissaoFinal, tipoInspecao, fecho, nodo, parametros, dados);
    }

    private List<HashMap> pesquisarCivCipp(Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Short tipoInspecao, Empresa empresa) {
        List<Object> dados = new ArrayList();
        if (tipoInspecao == CIV) {
            dados = this.pesquisarCiv(filtrarDataEmissao, dataEmissaoInicial, dataEmissaoFinal, empresa);
            Long totalCiv = dados.size();
            this.pesquisarInutCiv(filtrarDataEmissao, dataEmissaoInicial, dataEmissaoFinal, empresa, dados);
            quantidadeCancelada = this.totalCivCancelado(filtrarDataEmissao, dataEmissaoInicial, dataEmissaoFinal, empresa);
            quantidadeEmitida = totalCiv - this.totalCivCancelado(filtrarDataEmissao, dataEmissaoInicial, dataEmissaoFinal, empresa);
        } else {
            dados = this.pesquisarCipp(filtrarDataEmissao, dataEmissaoInicial, dataEmissaoFinal, empresa);
            Long totalCipp = dados.size();
            this.pesquisarInutCipp(filtrarDataEmissao, dataEmissaoInicial, dataEmissaoFinal, empresa, dados);
            quantidadeCancelada = this.totalCippCancelado(filtrarDataEmissao, dataEmissaoInicial, dataEmissaoFinal, empresa);
            quantidadeEmitida = totalCipp - this.totalCippCancelado(filtrarDataEmissao, dataEmissaoInicial, dataEmissaoFinal, empresa);
        }
        if (dados != null && !dados.isEmpty()) {
            this.getListaOrdenada(dados);
        }
        return dados;
    }

    private List<HashMap> pesquisarCiv(Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT DISTINCT c.numeroCiv                     AS NUMERO, c.dataEmissao                   AS DATA_EMISSAO, c.dataCancelamento              AS DATA_CANCELAMENTO, c.motivoCancelamento            AS MOTIVO FROM Civ c WHERE (:filtrarDataEmissao <> 1 OR CAST(c.dataEmissao AS date) BETWEEN :dataEmissaoInicial AND :dataEmissaoFinal) AND c.empresa = :empresa");
        q.setShort("filtrarDataEmissao", filtrarDataEmissao.shortValue());
        q.setDate("dataEmissaoInicial", dataEmissaoInicial);
        q.setDate("dataEmissaoFinal", dataEmissaoFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private void pesquisarInutCiv(Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Empresa empresa, List<HashMap> dados) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT DISTINCT i.numeroInicial                     AS NUMERO_INICIAL, i.numeroFinal                       AS NUMERO_FINAL, i.dataCadastro                      AS DATA_EMISSAO, i.dataCancelamento                  AS DATA_CANCELAMENTO, i.motivo                            AS MOTIVO FROM InutilizacaoCiv i WHERE (:filtrarDataEmissao <> 1 OR CAST(i.dataCancelamento AS date) BETWEEN :dataEmissaoInicial AND :dataEmissaoFinal) AND i.empresa = :empresa");
        q.setShort("filtrarDataEmissao", filtrarDataEmissao.shortValue());
        q.setDate("dataEmissaoInicial", dataEmissaoInicial);
        q.setDate("dataEmissaoFinal", dataEmissaoFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        this.verificarDadosCivCipp(dados, q.list());
    }

    private List<HashMap> pesquisarCipp(Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT DISTINCT c.nrCpp                 AS NUMERO, c.dataEmissao           AS DATA_EMISSAO, c.dataCancelamento      AS DATA_CANCELAMENTO, c.motivoCancelamento    AS MOTIVO FROM Cipp c WHERE (:filtrarDataEmissao <> 1 OR CAST(c.dataEmissao AS date) BETWEEN :dataEmissaoInicial AND :dataEmissaoFinal) AND c.empresa = :empresa");
        q.setShort("filtrarDataEmissao", filtrarDataEmissao.shortValue());
        q.setDate("dataEmissaoInicial", dataEmissaoInicial);
        q.setDate("dataEmissaoFinal", dataEmissaoFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private void pesquisarInutCipp(Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Empresa empresa, List<HashMap> dados) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT DISTINCT i.numeroInicial                     AS NUMERO_INICIAL, i.numeroFinal                       AS NUMERO_FINAL, i.dataCancelamento                  AS DATA_CANCELAMENTO, i.motivo                            AS MOTIVO FROM InutilizacaoCipp i WHERE (:filtrarDataEmissao <> 1 OR CAST(i.dataCancelamento AS date) BETWEEN :dataEmissaoInicial AND :dataEmissaoFinal) AND i.empresa = :empresa");
        q.setShort("filtrarDataEmissao", filtrarDataEmissao.shortValue());
        q.setDate("dataEmissaoInicial", dataEmissaoInicial);
        q.setDate("dataEmissaoFinal", dataEmissaoFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        this.verificarDadosCivCipp(dados, q.list());
    }

    private void verificarDadosCivCipp(List<HashMap> dados, List<HashMap> listdadosInutCiv) {
        for (HashMap h : listdadosInutCiv) {
            Long numeroInicial = (Long)h.get("NUMERO_INICIAL");
            Long numeroFinal = (Long)h.get("NUMERO_FINAL");
            Date dataCancelamento = (Date)h.get("DATA_CANCELAMENTO");
            String motivo = (String)h.get("MOTIVO");
            Long nrInicial = numeroInicial;
            while (nrInicial <= numeroFinal) {
                HashMap<String, Object> hash = new HashMap<String, Object>();
                hash.put("NUMERO", nrInicial);
                hash.put("DATA_EMISSAO", null);
                hash.put("DATA_CANCELAMENTO", dataCancelamento);
                hash.put("MOTIVO", motivo);
                dados.add(hash);
                Long l = nrInicial;
                nrInicial = nrInicial + 1L;
            }
        }
    }

    private void getListaOrdenada(List<HashMap> dados) {
        Collections.sort(dados, new Comparator(this){

            public int compare(Object o1, Object o2) {
                Long numero1 = (Long)((HashMap)o1).get("NUMERO");
                Long numero2 = (Long)((HashMap)o2).get("NUMERO");
                return numero1.compareTo(numero2);
            }
        });
    }

    private JasperPrint gerarJasperPrintCivCipp(Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Short tipoInspecao, String fecho, Nodo nodo, HashMap parametros, List<HashMap> dados) throws ExceptionService {
        parametros.put("FILTRAR_DATA_EMISSAO", filtrarDataEmissao);
        parametros.put("DATA_EMISSAO_INICIAL", dataEmissaoInicial);
        parametros.put("DATA_EMISSAO_FINAL", dataEmissaoFinal);
        parametros.put("TOTAL_CANCELADO", quantidadeCancelada);
        parametros.put("TOTAL_EMITIDO", quantidadeEmitida);
        parametros.put("TIPO_INSPECAO", tipoInspecao);
        parametros.put("FECHO", fecho);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", parametros).setAttribute("isPaisagem", false).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "inspecaoveicular" + File.separator + "listagemcivcipp" + File.separator + "LISTAGEM_CIV_CIPP.jasper";
        CoreRequestContext r = new CoreRequestContext();
        r.setAttribute("path", path);
        r.setAttribute("parametros", parametros);
        r.setAttribute("dados", dados);
        return (JasperPrint)CoreServiceFactory.getCoreReportService().execute(r, "getJasperPrintDataSource");
    }

    private Long totalCippCancelado(Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT DISTINCT count(c.identificador) AS TOTAL_CANCELADO FROM Cipp c INNER JOIN c.ordem os WHERE (:filtrarDataEmissao <> 1 OR CAST(c.dataEmissao AS date) BETWEEN :dataEmissaoInicial AND :dataEmissaoFinal) AND c.empresa = :empresa AND c.cancelado = :sim");
        q.setShort("filtrarDataEmissao", filtrarDataEmissao.shortValue());
        q.setShort("sim", (short)1);
        q.setDate("dataEmissaoInicial", dataEmissaoInicial);
        q.setDate("dataEmissaoFinal", dataEmissaoFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        HashMap h = (HashMap)q.uniqueResult();
        Long totalCancelado = (Long)h.get("TOTAL_CANCELADO");
        return totalCancelado;
    }

    private Long totalCivCancelado(Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT DISTINCT count(c.identificador) AS TOTAL_CANCELADO FROM Civ c WHERE (:filtrarDataEmissao <> 1 OR CAST(c.dataEmissao AS date) BETWEEN :dataEmissaoInicial AND :dataEmissaoFinal) AND c.empresa = :empresa AND c.cancelado = :sim");
        q.setShort("filtrarDataEmissao", filtrarDataEmissao.shortValue());
        q.setShort("sim", (short)1);
        q.setDate("dataEmissaoInicial", dataEmissaoInicial);
        q.setDate("dataEmissaoFinal", dataEmissaoFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        HashMap h = (HashMap)q.uniqueResult();
        Long totalCancelado = (Long)h.get("TOTAL_CANCELADO");
        return totalCancelado;
    }
}

