/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagemclientessemgiro;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilListagemClientesSemGiro {
    private static final Short PESQUISA_POR_NOTA = 0;
    private static final Short PESQUISA_COM_GIRO = 1;

    UtilListagemClientesSemGiro() {
    }

    JasperPrint gerarListagemClientesSemGiro(Date dataPeriodoSemGiroInicial, Date dataPeriodoSemGiroFinal, Short filtrarDataPeriodoCompras, Date dataPeriodoComprasInicial, Date dataPeriodoComprasFinal, Short filtrarCliente, Long clienteInicial, Long clienteFinal, Short filtrarRepresentante, Long representanteInicial, Long representanteFinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short filtrarUnidadeFederativa, UnidadeFederativa unidadeFederativa, Short filtrarCidade, Cidade cidade, Short exibirEndereco, String fecho, Nodo nodo, HashMap parametros, Short apenasReceitaVenda, Short apenasClienteAtivo) throws ExceptionService {
        List<HashMap> dados = this.pesquisarClientesSemGiro(dataPeriodoSemGiroInicial, dataPeriodoSemGiroFinal, filtrarDataPeriodoCompras, dataPeriodoComprasInicial, dataPeriodoComprasFinal, filtrarCliente, clienteInicial, clienteFinal, filtrarRepresentante, representanteInicial, representanteFinal, filtrarEmpresa, empresaInicial, empresaFinal, filtrarUnidadeFederativa, unidadeFederativa, filtrarCidade, cidade, apenasReceitaVenda, apenasClienteAtivo);
        return this.gerarJasperPrintClientesSemGiro(dataPeriodoSemGiroInicial, dataPeriodoSemGiroFinal, filtrarDataPeriodoCompras, dataPeriodoComprasInicial, dataPeriodoComprasFinal, filtrarCliente, clienteInicial, clienteFinal, filtrarRepresentante, representanteInicial, representanteFinal, filtrarEmpresa, empresaInicial, empresaFinal, filtrarUnidadeFederativa, unidadeFederativa, filtrarCidade, cidade, exibirEndereco, fecho, nodo, parametros, dados);
    }

    private List<HashMap> pesquisarClientesSemGiro(Date dataPeriodoSemGiroInicial, Date dataPeriodoSemGiroFinal, Short filtrarDataPeriodoCompras, Date dataPeriodoComprasInicial, Date dataPeriodoComprasFinal, Short filtrarCliente, Long clienteInicial, Long clienteFinal, Short filtrarRepresentante, Long representanteInicial, Long representanteFinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short filtrarUnidadeFederativa, UnidadeFederativa unidadeFederativa, Short filtrarCidade, Cidade cidade, Short apenasReceitaVenda, Short apenasClienteAtivo) {
        List clientesComGiro = this.buildData(this.getQueryCliente(filtrarUnidadeFederativa, filtrarCidade), dataPeriodoSemGiroInicial, dataPeriodoSemGiroFinal, filtrarCliente, clienteInicial, clienteFinal, filtrarRepresentante, representanteInicial, representanteFinal, filtrarEmpresa, empresaInicial, empresaFinal, filtrarUnidadeFederativa, unidadeFederativa, filtrarCidade, cidade, PESQUISA_COM_GIRO, apenasReceitaVenda, apenasClienteAtivo);
        List idsClientesComGiro = clientesComGiro.stream().map(x -> (Long)x.get("ID_CLIENTE")).collect(Collectors.toList());
        List notas = this.buildData(this.getQueryNotaPropria(filtrarUnidadeFederativa, filtrarCidade), dataPeriodoSemGiroInicial, dataPeriodoSemGiroFinal, filtrarCliente, clienteInicial, clienteFinal, filtrarRepresentante, representanteInicial, representanteFinal, filtrarEmpresa, empresaInicial, empresaFinal, filtrarUnidadeFederativa, unidadeFederativa, filtrarCidade, cidade, PESQUISA_POR_NOTA, apenasReceitaVenda, apenasClienteAtivo);
        notas.removeIf(x -> idsClientesComGiro.contains((Long)x.get("ID_CLIENTE")));
        return this.pesquisarNota(notas, filtrarDataPeriodoCompras, dataPeriodoComprasInicial, dataPeriodoComprasFinal);
    }

    private List buildData(String query, Date dataPeriodoSemGiroInicial, Date dataPeriodoSemGiroFinal, Short filtrarCliente, Long clienteInicial, Long clienteFinal, Short filtrarRepresentante, Long representanteInicial, Long representanteFinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short filtrarUnidadeFederativa, UnidadeFederativa unidadeFederativa, Short filtrarCidade, Cidade cidade, Short tipoPesquisa, Short apenasReceitaVenda, Short apenasClienteAtivo) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(query);
        if (ToolMethods.isEquals((Object)tipoPesquisa, (Object)PESQUISA_COM_GIRO)) {
            q.setDate("dataPeriodoSemGiroInicial", dataPeriodoSemGiroInicial);
            q.setDate("dataPeriodoSemGiroFinal", dataPeriodoSemGiroFinal);
        }
        q.setShort("filtrarCliente", filtrarCliente.shortValue());
        q.setLong("clienteInicial", clienteInicial.longValue());
        q.setLong("clienteFinal", clienteFinal.longValue());
        q.setShort("filtrarRepresentante", filtrarRepresentante.shortValue());
        q.setLong("representanteInicial", representanteInicial.longValue());
        q.setLong("representanteFinal", representanteFinal.longValue());
        q.setShort("filtrarEmpresa", filtrarEmpresa.shortValue());
        q.setLong("empresaInicial", empresaInicial.longValue());
        q.setLong("empresaFinal", empresaFinal.longValue());
        if (filtrarUnidadeFederativa == 1) {
            q.setEntity("unidadeFederativa", (Object)unidadeFederativa);
        }
        if (filtrarCidade == 1) {
            q.setEntity("cidade", (Object)cidade);
        }
        q.setParameter("status", (Object)EnumConstNFeStatus.getStatusAutorizadaShort());
        q.setShort("apenasReceitaVenda", apenasReceitaVenda.shortValue());
        q.setShort("apenasClienteAtivo", apenasClienteAtivo.shortValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private String getQueryCliente(Short filtrarUnidadeFederativa, Short filtrarCidade) {
        Object query = "SELECT DISTINCT   uc.identificador as ID_CLIENTE FROM NotaFiscalPropria p     INNER JOIN p.itensNotaPropria i\n         INNER JOIN i.itemNotaLivroFiscal il\n             INNER JOIN il.cfop cfop\n  Inner Join p.empresa e   Inner Join p.unidadeFatCliente u     Inner Join u.cliente uc       Inner Join uc.faturamento f         Inner Join f.representante r WHERE  p.dataEmissaoNota BETWEEN :dataPeriodoSemGiroInicial AND :dataPeriodoSemGiroFinal   AND (:filtrarEmpresa <> 1 OR e.identificador BETWEEN :empresaInicial AND :empresaFinal)  AND (:filtrarCliente <> 1 OR uc.identificador BETWEEN :clienteInicial AND :clienteFinal)  AND (:filtrarRepresentante <> 1 OR r.identificador BETWEEN :representanteInicial AND :representanteFinal)    AND (p.status IN(:status))\n and (:apenasReceitaVenda = 0 or cfop.cfopReceitaVenda = 1) and (:apenasClienteAtivo = 0 or uc.ativo = 1)";
        if (filtrarUnidadeFederativa == 1) {
            query = (String)query + " AND u.pessoa.endereco.cidade.uf = :unidadeFederativa";
        }
        if (filtrarCidade == 1) {
            query = (String)query + " AND u.pessoa.endereco.cidade = :cidade";
        }
        return query;
    }

    private String getQueryNotaPropria(Short filtrarUnidadeFederativa, Short filtrarCidade) {
        Object query = "SELECT DISTINCT   n.unidadeFatCliente.cliente.identificador             AS ID_CLIENTE,   n.unidadeFatCliente.cliente.pessoa.nome               AS CLIENTE,   n.unidadeFatCliente.cliente.pessoa.complemento.fone1  AS FONE_CLIENTE,   n.unidadeFatCliente.cliente.faturamento.representante.identificador AS ID_REPRESENTANTE,   n.unidadeFatCliente.cliente.faturamento.representante.pessoa.nome   AS REPRESENTANTE,   n.unidadeFatCliente.pessoa.endereco.logradouro        AS LOGRADOURO,   n.unidadeFatCliente.pessoa.endereco.numero            AS NUMERO_ENDERECO,   n.unidadeFatCliente.pessoa.endereco.bairro            AS BAIRRO,   n.unidadeFatCliente.pessoa.endereco.cep               AS CEP,   n.unidadeFatCliente.pessoa.endereco.cidade.descricao  AS CIDADE,   n.unidadeFatCliente.pessoa.endereco.cidade.uf.sigla   AS UF,   COUNT(*)                  AS CONT_NOTA,   SUM(il.valorTotal)      AS VALOR_TOTAL_COMPRAS   FROM  NotaFiscalPropria n     INNER JOIN n.itensNotaPropria i\n         INNER JOIN i.itemNotaLivroFiscal il\n             INNER JOIN il.cfop cfop\n  WHERE    (:filtrarCliente <> 1 OR n.unidadeFatCliente.cliente.identificador             BETWEEN :clienteInicial            AND :clienteFinal)  and (:apenasReceitaVenda = 0 or cfop.cfopReceitaVenda = 1) and (:apenasClienteAtivo = 0 or n.unidadeFatCliente.cliente.ativo = 1)  AND   (:filtrarRepresentante <> 1 OR n.unidadeFatCliente.cliente.faturamento.representante.identificador BETWEEN :representanteInicial      AND :representanteFinal)   AND   (:filtrarEmpresa <> 1 OR n.empresa.identificador                 BETWEEN :empresaInicial            AND :empresaFinal)   AND   n.status IN(:status)";
        if (filtrarUnidadeFederativa == 1) {
            query = (String)query + " AND n.unidadeFatCliente.pessoa.endereco.cidade.uf = :unidadeFederativa";
        }
        if (filtrarCidade == 1) {
            query = (String)query + " AND n.unidadeFatCliente.pessoa.endereco.cidade = :cidade";
        }
        query = (String)query + " GROUP BY n.unidadeFatCliente.cliente.identificador,      n.unidadeFatCliente.cliente.pessoa.nome,      n.unidadeFatCliente.cliente.pessoa.complemento.fone1,      n.unidadeFatCliente.cliente.faturamento.representante.identificador,      n.unidadeFatCliente.cliente.faturamento.representante.pessoa.nome,      n.unidadeFatCliente.pessoa.endereco.logradouro,      n.unidadeFatCliente.pessoa.endereco.numero,      n.unidadeFatCliente.pessoa.endereco.bairro,      n.unidadeFatCliente.pessoa.endereco.cep,      n.unidadeFatCliente.pessoa.endereco.cidade.descricao,      n.unidadeFatCliente.pessoa.endereco.cidade.uf.sigla ";
        return query;
    }

    private List<HashMap> pesquisarNota(List<HashMap> list, Short filtrarDataPeriodoCompras, Date dataPeriodoComprasInicial, Date dataPeriodoComprasFinal) {
        ArrayList<HashMap> aux = new ArrayList<HashMap>();
        for (HashMap h : list) {
            this.pesquisarUltimaNota(h, filtrarDataPeriodoCompras, dataPeriodoComprasInicial, dataPeriodoComprasFinal);
            if (h.get("NUMERO_NOTA") != null) continue;
            aux.add(h);
        }
        if (!aux.isEmpty()) {
            list.removeAll(aux);
        }
        return list;
    }

    private void pesquisarUltimaNota(HashMap h, Short filtrarDataPeriodoCompras, Date dataPeriodoComprasInicial, Date dataPeriodoComprasFinal) {
        HashMap m;
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT n.numeroNota    AS NUMERO_NOTA, n.serie         AS SERIE, n.dataEmissaoNota             AS DATA_EMISSAO, n.valoresNfPropria.valorTotal AS VALOR_TOTAL FROM     NotaFiscalPropria n WHERE    (:filtrarDataPeriodoCompras <> 1 OR CAST(n.dataEmissaoNota AS date) BETWEEN :dataPeriodoComprasInicial AND :dataPeriodoComprasFinal) AND      n.unidadeFatCliente.cliente.identificador = :cliente AND      n.status IN(:status) ORDER BY n.dataEmissaoNota DESCENDING,          n.numeroNota      DESCENDING");
        q.setShort("filtrarDataPeriodoCompras", filtrarDataPeriodoCompras.shortValue());
        q.setDate("dataPeriodoComprasInicial", dataPeriodoComprasInicial);
        q.setDate("dataPeriodoComprasFinal", dataPeriodoComprasFinal);
        q.setLong("cliente", ((Long)h.get("ID_CLIENTE")).longValue());
        q.setParameter("status", (Object)EnumConstNFeStatus.getStatusAutorizadaShort());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        HashMap hashMap = m = q.list() != null && !q.list().isEmpty() ? (HashMap)q.list().get(0) : null;
        if (m != null) {
            h.put("NUMERO_NOTA", m.get("NUMERO_NOTA"));
            h.put("SERIE", m.get("SERIE"));
            h.put("DATA_EMISSAO", m.get("DATA_EMISSAO"));
            h.put("VALOR_TOTAL", m.get("VALOR_TOTAL"));
        }
    }

    private JasperPrint gerarJasperPrintClientesSemGiro(Date dataPeriodoSemGiroInicial, Date dataPeriodoSemGiroFinal, Short filtrarDataPeriodoCompras, Date dataPeriodoComprasInicial, Date dataPeriodoComprasFinal, Short filtrarCliente, Long clienteInicial, Long clienteFinal, Short filtrarRepresentante, Long representanteInicial, Long representanteFinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short filtrarUnidadeFederativa, UnidadeFederativa unidadeFederativa, Short filtrarCidade, Cidade cidade, Short exibirEndereco, String fecho, Nodo nodo, HashMap parametros, List<HashMap> dados) throws ExceptionService {
        parametros.put("DATA_PERIODO_SEM_GIRO_INICIAL", dataPeriodoSemGiroInicial);
        parametros.put("DATA_PERIODO_SEM_GIRO_FINAL", dataPeriodoSemGiroFinal);
        parametros.put("FILTRAR_DATA_PERIODO_COMPRAS", filtrarDataPeriodoCompras);
        parametros.put("DATA_PERIODO_COMPRAS_INICIAL", dataPeriodoComprasInicial);
        parametros.put("DATA_PERIODO_COMPRAS_FINAL", dataPeriodoComprasFinal);
        parametros.put("FILTRAR_CLIENTE", filtrarCliente);
        parametros.put("CLIENTE_INICIAL", clienteInicial);
        parametros.put("CLIENTE_FINAL", clienteFinal);
        parametros.put("FILTRAR_REPRESENTANTE", filtrarRepresentante);
        parametros.put("REPRESENTANTE_INICIAL", representanteInicial);
        parametros.put("REPRESENTANTE_FINAL", representanteFinal);
        parametros.put("FILTRAR_EMPRESA", filtrarEmpresa);
        parametros.put("EMPRESA_INICIAL", empresaInicial);
        parametros.put("EMPRESA_FINAL", empresaFinal);
        parametros.put("EXIBIR_ENDERECO", exibirEndereco);
        parametros.put("FILTRAR_UNIDADE_FEDERATIVA", filtrarUnidadeFederativa);
        if (filtrarUnidadeFederativa == 1) {
            parametros.put("UNIDADE_FEDERATIVA", unidadeFederativa.getSigla());
        }
        parametros.put("FILTRAR_CIDADE", filtrarCidade);
        if (filtrarCidade == 1) {
            parametros.put("CIDADE", cidade.getDescricao());
        }
        parametros.put("FECHO", fecho);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", parametros).setAttribute("isPaisagem", true).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "vendas" + File.separator + "relatorios" + File.separator + "listagemclientessemgiro" + File.separator + "LISTAGEM_CLIENTES_SEM_GIRO.jasper";
        CoreRequestContext r = new CoreRequestContext();
        r.setAttribute("path", path);
        r.setAttribute("parametros", parametros);
        r.setAttribute("dados", dados);
        return (JasperPrint)CoreServiceFactory.getCoreReportService().execute(r, "getJasperPrintDataSource");
    }
}

