/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagemcteporcidade;

import com.touchcomp.basementor.model.vo.Nodo;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilListagemCtePorCidade {
    private static final Short QUEBRA_CIDADE_TOMADOR_SERVICO = 0;
    private static final Short QUEBRA_CIDADE_REMETENTE = 1;
    private static final Short QUEBRA_CIDADE_DESTINATARIO = 2;
    private static final Short NUMERO_CTE = 0;
    private static final Short DATA_EMISSAO = 1;

    UtilListagemCtePorCidade() {
    }

    JasperPrint gerarListagemCtePorCidade(Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short filtrarCidadeTomadorServico, Long cidadeTomadorServicoInicial, Long cidadeTomadorServicoFinal, Short filtrarCidadeRemetente, Long cidadeRemetenteInicial, Long cidadeRemetenteFinal, Short filtrarCidadeDestinatario, Long cidadeDestinatarioInicial, Long cidadeDestinatarioFinal, Short quebraCidade, Short ordenacao, String fecho, Nodo nodo, HashMap parametros) throws ExceptionService {
        List<HashMap> dados = this.pesquisarCte(filtrarDataEmissao, dataEmissaoInicial, dataEmissaoFinal, filtrarEmpresa, empresaInicial, empresaFinal, filtrarCidadeTomadorServico, cidadeTomadorServicoInicial, cidadeTomadorServicoFinal, filtrarCidadeRemetente, cidadeRemetenteInicial, cidadeRemetenteFinal, filtrarCidadeDestinatario, cidadeDestinatarioInicial, cidadeDestinatarioFinal, quebraCidade, ordenacao);
        return this.gerarJasperPrintCtePorCidade(filtrarDataEmissao, dataEmissaoInicial, dataEmissaoFinal, filtrarEmpresa, empresaInicial, empresaFinal, filtrarCidadeTomadorServico, cidadeTomadorServicoInicial, cidadeTomadorServicoFinal, filtrarCidadeRemetente, cidadeRemetenteInicial, cidadeRemetenteFinal, filtrarCidadeDestinatario, cidadeDestinatarioInicial, cidadeDestinatarioFinal, quebraCidade, fecho, nodo, parametros, dados);
    }

    private List<HashMap> pesquisarCte(Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short filtrarCidadeTomadorServico, Long cidadeTomadorServicoInicial, Long cidadeTomadorServicoFinal, Short filtrarCidadeRemetente, Long cidadeRemetenteInicial, Long cidadeRemetenteFinal, Short filtrarCidadeDestinatario, Long cidadeDestinatarioInicial, Long cidadeDestinatarioFinal, Short quebraCidade, Short ordenacao) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "SELECT c.empresa.identificador AS ID_EMPRESA, c.empresa.pessoa.nome AS EMPRESA, c.numero AS NUMERO, c.dataEmissao AS DATA_EMISSAO, c.remetenteDestinatario.pessoaRemetente.pessoaTransporte.pessoa.nome AS REMETENTE, c.remetenteDestinatario.pessoaDestinatario.pessoaTransporte.pessoa.nome AS DESTINATARIO, c.cteVlrImpostos.vrPrestacao AS VALOR_PRESTACAO, c.cteVlrImpostos.vrIcms AS VALOR_ICMS";
        if (quebraCidade == QUEBRA_CIDADE_TOMADOR_SERVICO) {
            hql = (String)hql + ", c.clienteTomador.endereco.cidade.descricao AS CIDADE";
        } else if (quebraCidade == QUEBRA_CIDADE_REMETENTE) {
            hql = (String)hql + ", c.remetenteDestinatario.pessoaRemetente.endereco.cidade.descricao AS CIDADE";
        } else if (quebraCidade == QUEBRA_CIDADE_DESTINATARIO) {
            hql = (String)hql + ", c.remetenteDestinatario.pessoaDestinatario.endereco.cidade.descricao AS CIDADE";
        }
        hql = (String)hql + " FROM Cte c WHERE c.cteInfo.status = 100 AND (:filtrarDataEmissao <> 1 OR CAST(c.dataEmissao AS date) BETWEEN :dataEmissaoInicial AND :dataEmissaoFinal) AND (:filtrarEmpresa <> 1 OR c.empresa.identificador BETWEEN :empresaInicial and :empresaFinal) AND (:filtrarCidadeTomadorServico <> 1 OR c.clienteTomador.endereco.cidade.identificador BETWEEN :cidadeTomadorServicoInicial AND :cidadeTomadorServicoFinal) AND (:filtrarCidadeRemetente <> 1 OR c.remetenteDestinatario.pessoaRemetente.endereco.cidade.identificador BETWEEN :cidadeRemetenteInicial AND :cidadeRemetenteFinal) AND (:filtrarCidadeDestinatario <> 1 OR c.remetenteDestinatario.pessoaDestinatario.endereco.cidade.identificador BETWEEN :cidadeDestinatarioInicial AND :cidadeDestinatarioFinal) ORDER BY c.empresa.identificador,";
        if (quebraCidade == QUEBRA_CIDADE_TOMADOR_SERVICO) {
            hql = (String)hql + " c.clienteTomador.endereco.cidade.descricao,";
        } else if (quebraCidade == QUEBRA_CIDADE_REMETENTE) {
            hql = (String)hql + " c.remetenteDestinatario.pessoaRemetente.endereco.cidade.descricao,";
        } else if (quebraCidade == QUEBRA_CIDADE_DESTINATARIO) {
            hql = (String)hql + " c.remetenteDestinatario.pessoaDestinatario.endereco.cidade.descricao,";
        }
        if (ordenacao == NUMERO_CTE) {
            hql = (String)hql + " c.numero";
        } else if (ordenacao == DATA_EMISSAO) {
            hql = (String)hql + " c.dataEmissao";
        }
        Query q = s.createQuery((String)hql);
        q.setShort("filtrarDataEmissao", filtrarDataEmissao.shortValue());
        q.setDate("dataEmissaoInicial", dataEmissaoInicial);
        q.setDate("dataEmissaoFinal", dataEmissaoFinal);
        q.setShort("filtrarEmpresa", filtrarEmpresa.shortValue());
        q.setLong("empresaInicial", empresaInicial.longValue());
        q.setLong("empresaFinal", empresaFinal.longValue());
        q.setShort("filtrarCidadeTomadorServico", filtrarCidadeTomadorServico.shortValue());
        q.setLong("cidadeTomadorServicoInicial", cidadeTomadorServicoInicial.longValue());
        q.setLong("cidadeTomadorServicoFinal", cidadeTomadorServicoFinal.longValue());
        q.setShort("filtrarCidadeRemetente", filtrarCidadeRemetente.shortValue());
        q.setLong("cidadeRemetenteInicial", cidadeRemetenteInicial.longValue());
        q.setLong("cidadeRemetenteFinal", cidadeRemetenteFinal.longValue());
        q.setShort("filtrarCidadeDestinatario", filtrarCidadeDestinatario.shortValue());
        q.setLong("cidadeDestinatarioInicial", cidadeDestinatarioInicial.longValue());
        q.setLong("cidadeDestinatarioFinal", cidadeDestinatarioFinal.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private JasperPrint gerarJasperPrintCtePorCidade(Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short filtrarCidadeTomadorServico, Long cidadeTomadorServicoInicial, Long cidadeTomadorServicoFinal, Short filtrarCidadeRemetente, Long cidadeRemetenteInicial, Long cidadeRemetenteFinal, Short filtrarCidadeDestinatario, Long cidadeDestinatarioInicial, Long cidadeDestinatarioFinal, Short quebraCidade, String fecho, Nodo nodo, HashMap parametros, List<HashMap> dados) throws ExceptionService {
        parametros.put("FILTRAR_DATA_EMISSAO", filtrarDataEmissao);
        parametros.put("DATA_EMISSAO_INICIAL", dataEmissaoInicial);
        parametros.put("DATA_EMISSAO_FINAL", dataEmissaoFinal);
        parametros.put("FILTRAR_EMPRESA", filtrarEmpresa);
        parametros.put("EMPRESA_INICIAL", empresaInicial);
        parametros.put("EMPRESA_FINAL", empresaFinal);
        parametros.put("FILTRAR_CIDADE_TOMADOR_SERVICO", filtrarCidadeTomadorServico);
        parametros.put("CIDADE_TOMADOR_SERVICO_INICIAL", cidadeTomadorServicoInicial);
        parametros.put("CIDADE_TOMADOR_SERVICO_FINAL", cidadeTomadorServicoFinal);
        parametros.put("FILTRAR_CIDADE_REMETENTE", filtrarCidadeRemetente);
        parametros.put("CIDADE_REMETENTE_INICIAL", cidadeRemetenteInicial);
        parametros.put("CIDADE_REMETENTE_FINAL", cidadeRemetenteFinal);
        parametros.put("FILTRAR_CIDADE_DESTINATARIO", filtrarCidadeDestinatario);
        parametros.put("CIDADE_DESTINATARIO_INICIAL", cidadeDestinatarioInicial);
        parametros.put("CIDADE_DESTINATARIO_FINAL", cidadeDestinatarioFinal);
        parametros.put("QUEBRA_CIDADE", quebraCidade);
        parametros.put("FECHO", fecho);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", parametros).setAttribute("isPaisagem", false).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "transportador" + File.separator + "relatorios" + File.separator + "listagemcteporcidade" + File.separator + "LISTAGEM_CTE_POR_CIDADE.jasper";
        CoreRequestContext r = new CoreRequestContext();
        r.setAttribute("path", path);
        r.setAttribute("parametros", parametros);
        r.setAttribute("dados", dados);
        return (JasperPrint)CoreServiceFactory.getCoreReportService().execute(r, "getJasperPrintDataSource");
    }
}

