/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagemcteporfatura;

import com.touchcomp.basementor.model.vo.Nodo;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilListagemCtePorFatura {
    UtilListagemCtePorFatura() {
    }

    JasperPrint gerarListagemCtePorFatura(Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Short filtrarDataVencimento, Date dataVencimentoInicial, Date dataVencimentoFinal, Short filtrarFaturaCte, Long faturaCteInicial, Long faturaCteFinal, Short filtrarTitulo, Long tituloInicial, Long tituloFinal, Short filtrarTomadorServico, Long tomadorServicoInicial, Long tomadorServicoFinal, Short filtrarCidadeTomadorServico, Long cidadeTomadorServicoInicial, Long cidadeTomadorServicoFinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short quebrarEmpresa, String fecho, Nodo nodo, HashMap parametros) throws ExceptionService {
        List<HashMap> dados = this.pesquisarCtePorFatura(filtrarDataEmissao, dataEmissaoInicial, dataEmissaoFinal, filtrarDataVencimento, dataVencimentoInicial, dataVencimentoFinal, filtrarFaturaCte, faturaCteInicial, faturaCteFinal, filtrarTitulo, tituloInicial, tituloFinal, filtrarTomadorServico, tomadorServicoInicial, tomadorServicoFinal, filtrarCidadeTomadorServico, cidadeTomadorServicoInicial, cidadeTomadorServicoFinal, filtrarEmpresa, empresaInicial, empresaFinal, quebrarEmpresa);
        this.pesquisarNotasCte(dados);
        return this.gerarJasperPrintCtePorFatura(filtrarDataEmissao, dataEmissaoInicial, dataEmissaoFinal, filtrarDataVencimento, dataVencimentoInicial, dataVencimentoFinal, filtrarFaturaCte, faturaCteInicial, faturaCteFinal, filtrarTitulo, tituloInicial, tituloFinal, filtrarTomadorServico, tomadorServicoInicial, tomadorServicoFinal, filtrarCidadeTomadorServico, cidadeTomadorServicoInicial, cidadeTomadorServicoFinal, filtrarEmpresa, empresaInicial, empresaFinal, quebrarEmpresa, fecho, nodo, parametros, dados);
    }

    private List<HashMap> pesquisarCtePorFatura(Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Short filtrarDataVencimento, Date dataVencimentoInicial, Date dataVencimentoFinal, Short filtrarFaturaCte, Long faturaCteInicial, Long faturaCteFinal, Short filtrarTitulo, Long tituloInicial, Long tituloFinal, Short filtrarTomadorServico, Long tomadorServicoInicial, Long tomadorServicoFinal, Short filtrarCidadeTomadorServico, Long cidadeTomadorServicoInicial, Long cidadeTomadorServicoFinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short quebrarEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "select c.identificador as cte, t.identificador as titulo, c.faturaCte.identificador as faturaCte, c.faturaCte.dataVencimento as dataVencimento, c.numero as numero, c.serie as serie, c.clienteTomador.cliente.identificador as idTomador, c.clienteTomador.cliente.pessoa.nome as nomeTomador, c.remetenteDestinatario.pessoaRemetente.pessoaTransporte.identificador as idRemetente, c.remetenteDestinatario.pessoaRemetente.pessoaTransporte.pessoa.nome as remetente, c.remetenteDestinatario.pessoaDestinatario.pessoaTransporte.identificador as idDestinatario, c.remetenteDestinatario.pessoaDestinatario.pessoaTransporte.pessoa.nome as destinatario, c.cteVlrImpostos.vrPrestacao as valorPrestacao, c.empresa.identificador as idEmpresa, c.empresa.pessoa.nome as nomeEmpresa from Cte c inner join c.faturaCte.titulos t where (:filtrarDataEmissao <> 1 or c.faturaCte.tipoOperacaoGeracaoFatur.geracaoFaturamento.dataEmissao between :dataEmissaoInicial and :dataEmissaoFinal) AND (:filtrarDataVencimento <> 1 or c.faturaCte.dataVencimento between :dataVencimentoInicial and :dataVencimentoFinal) AND (:filtrarFaturaCte <> 1 or c.faturaCte.identificador between :faturaCteInicial and :faturaCteFinal) AND (:filtrarTitulo <> 1 or t.identificador between :tituloInicial and :tituloFinal) AND (:filtrarTomadorServico <> 1 or c.clienteTomador.cliente.identificador between :tomadorServicoInicial and :tomadorServicoFinal) AND (:filtrarCidadeTomadorServico <> 1 or c.clienteTomador.endereco.cidade.identificador between :cidadeTomadorServicoInicial and :cidadeTomadorServicoFinal) AND (:filtrarEmpresa <> 1 or c.empresa.identificador between :empresaInicial and :empresaFinal) ORDER BY ";
        if (quebrarEmpresa == 1) {
            hql = (String)hql + "c.empresa.identificador, ";
        }
        hql = (String)hql + "c.faturaCte.identificador, c.clienteTomador.cliente.identificador, c.numero";
        Query q = s.createQuery((String)hql);
        q.setShort("filtrarDataEmissao", filtrarDataEmissao.shortValue());
        q.setDate("dataEmissaoInicial", dataEmissaoInicial);
        q.setDate("dataEmissaoFinal", dataEmissaoFinal);
        q.setShort("filtrarDataVencimento", filtrarDataVencimento.shortValue());
        q.setDate("dataVencimentoInicial", dataVencimentoInicial);
        q.setDate("dataVencimentoFinal", dataVencimentoFinal);
        q.setShort("filtrarFaturaCte", filtrarFaturaCte.shortValue());
        q.setLong("faturaCteInicial", faturaCteInicial.longValue());
        q.setLong("faturaCteFinal", faturaCteFinal.longValue());
        q.setShort("filtrarTitulo", filtrarTitulo.shortValue());
        q.setLong("tituloInicial", tituloInicial.longValue());
        q.setLong("tituloFinal", tituloFinal.longValue());
        q.setShort("filtrarTomadorServico", filtrarTomadorServico.shortValue());
        q.setLong("tomadorServicoInicial", tomadorServicoInicial.longValue());
        q.setLong("tomadorServicoFinal", tomadorServicoFinal.longValue());
        q.setShort("filtrarCidadeTomadorServico", filtrarCidadeTomadorServico.shortValue());
        q.setLong("cidadeTomadorServicoInicial", cidadeTomadorServicoInicial.longValue());
        q.setLong("cidadeTomadorServicoFinal", cidadeTomadorServicoFinal.longValue());
        q.setShort("filtrarEmpresa", filtrarEmpresa.shortValue());
        q.setLong("empresaInicial", empresaInicial.longValue());
        q.setLong("empresaFinal", empresaFinal.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private void pesquisarNotasCte(List<HashMap> dados) {
        Iterator<HashMap> iterator = dados.iterator();
        while (iterator.hasNext()) {
            HashMap o;
            HashMap h = o = iterator.next();
            List<HashMap> notas = this.pesquisarNotas((Long)h.get("cte"));
            h.put("notas", notas);
        }
    }

    public List<HashMap> pesquisarNotas(Long cte) {
        List<HashMap> list = new ArrayList();
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT c.nrNota as notaNfe, 'Nfe' as descricao FROM CTeNFe c WHERE c.cte.identificador = :cte");
        q.setLong("cte", cte.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        list = q.list();
        if (list != null && !list.isEmpty()) {
            return list;
        }
        Query qu = s.createQuery("SELECT c.numero as notaNf, 'Nf' as descricao FROM CteNf c WHERE c.cte.identificador = :cte");
        qu.setLong("cte", cte.longValue());
        qu.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        list = qu.list();
        if (list != null && !list.isEmpty()) {
            return list;
        }
        Query que = s.createQuery("SELECT c.numeroDocumento as notaOutros, 'Outros' as descricao FROM CTeOutros c WHERE c.cte.identificador = :cte");
        que.setLong("cte", cte.longValue());
        que.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return que.list();
    }

    private JasperPrint gerarJasperPrintCtePorFatura(Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Short filtrarDataVencimento, Date dataVencimentoInicial, Date dataVencimentoFinal, Short filtrarFaturaCte, Long faturaCteInicial, Long faturaCteFinal, Short filtrarTitulo, Long tituloInicial, Long tituloFinal, Short filtrarTomadorServico, Long tomadorServicoInicial, Long tomadorServicoFinal, Short filtrarCidadeTomadorServico, Long cidadeTomadorServicoInicial, Long cidadeTomadorServicoFinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short quebrarEmpresa, String fecho, Nodo nodo, HashMap parametros, List<HashMap> dados) throws ExceptionService {
        parametros.put("FILTRAR_DATA_EMISSAO", filtrarDataEmissao);
        parametros.put("DATA_EMISSAO_INICIAL", dataEmissaoInicial);
        parametros.put("DATA_EMISSAO_FINAL", dataEmissaoFinal);
        parametros.put("FILTRAR_DATA_VENCIMENTO", filtrarDataVencimento);
        parametros.put("DATA_VENCIMENTO_INICIAL", dataVencimentoInicial);
        parametros.put("DATA_VENCIMENTO_FINAL", dataVencimentoFinal);
        parametros.put("FILTRAR_FATURA_CTE", filtrarFaturaCte);
        parametros.put("FATURA_CTE_INICIAL", faturaCteInicial);
        parametros.put("FATURA_CTE_FINAL", faturaCteFinal);
        parametros.put("FILTRAR_TITULO", filtrarTitulo);
        parametros.put("TITULO_INICIAL", tituloInicial);
        parametros.put("TITULO_FINAL", tituloFinal);
        parametros.put("FILTRAR_TOMADOR_SERVICO", filtrarTomadorServico);
        parametros.put("TOMADOR_SERVICO_INICIAL", tomadorServicoInicial);
        parametros.put("TOMADOR_SERVICO_FINAL", tomadorServicoFinal);
        parametros.put("FILTRAR_CIDADE_TOMADOR_SERVICO", filtrarCidadeTomadorServico);
        parametros.put("CIDADE_TOMADOR_SERVICO_INICIAL", cidadeTomadorServicoInicial);
        parametros.put("CIDADE_TOMADOR_SERVICO_FINAL", cidadeTomadorServicoFinal);
        parametros.put("FILTRAR_EMPRESA", filtrarEmpresa);
        parametros.put("EMPRESA_INICIAL", empresaInicial);
        parametros.put("EMPRESA_FINAL", empresaFinal);
        parametros.put("QUEBRAR_EMPRESA", quebrarEmpresa);
        parametros.put("FECHO", fecho);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", parametros).setAttribute("isPaisagem", true).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "transportes" + File.separator + "listagens" + File.separator + "cteporfatura" + File.separator + "LISTAGEM_CTE_FATURA.jasper";
        CoreRequestContext r = new CoreRequestContext();
        r.setAttribute("path", path);
        r.setAttribute("parametros", parametros);
        r.setAttribute("dados", dados);
        return (JasperPrint)CoreServiceFactory.getCoreReportService().execute(r, "getJasperPrintDataSource");
    }
}

