/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagemfaturamentocidade;

import com.touchcomp.basementor.model.vo.Nodo;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilListagemFaturamentoCidade {
    UtilListagemFaturamentoCidade() {
    }

    JasperPrint gerarListagemFaturamentoCidade(Short filtrarDataPrevisao, Date dataPrevisaoInicial, Date dataPrevisaoFinal, Short filtrarCentroEstocagem, Long centroEstocagemInicial, Long centroEstocagemFinal, Short filtrarProduto, Long produtoInicial, Long produtoFinal, Short filtrarEspecie, Long especieInicial, Long especieFinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short quebrarEspecie, String fecho, Nodo nodo, HashMap parametros) throws ExceptionService {
        List<HashMap> dados = this.pesquisarFaturamentoCidade(filtrarDataPrevisao, dataPrevisaoInicial, dataPrevisaoFinal, filtrarCentroEstocagem, centroEstocagemInicial, centroEstocagemFinal, filtrarProduto, produtoInicial, produtoFinal, filtrarEspecie, especieInicial, especieFinal, filtrarEmpresa, empresaInicial, empresaFinal);
        return this.gerarJasperPrintFaturamentoCidade(filtrarDataPrevisao, dataPrevisaoInicial, dataPrevisaoFinal, filtrarCentroEstocagem, centroEstocagemInicial, centroEstocagemFinal, filtrarProduto, produtoInicial, produtoFinal, filtrarEspecie, especieInicial, especieFinal, quebrarEspecie, fecho, nodo, parametros, dados);
    }

    private List<HashMap> pesquisarFaturamentoCidade(Short filtrarDataPrevisao, Date dataPrevisaoInicial, Date dataPrevisaoFinal, Short filtrarCentroEstocagem, Long centroEstocagemInicial, Long centroEstocagemFinal, Short filtrarProduto, Long produtoInicial, Long produtoFinal, Short filtrarEspecie, Long especieInicial, Long especieFinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT n.unidadeFatCliente.cliente.pessoa.endereco.cidade.identificador AS ID_CIDADE, n.unidadeFatCliente.cliente.pessoa.endereco.cidade.descricao     AS CIDADE, n.unidadeFatCliente.cliente.pessoa.endereco.cidade.uf.sigla      AS UF, i.produto.especie.identificador                                  AS ID_ESPECIE, i.produto.especie.nome                                           AS ESPECIE, i.produto.identificador                                          AS ID_PRODUTO, i.produto.nome                                                   AS PRODUTO, n.numeroNota                                                     AS NUMERO_NOTA, n.dataEmissaoNota                                                AS DATA_EMISSAO, n.unidadeFatCliente.cliente.identificador                        AS ID_CLIENTE, n.unidadeFatCliente.cliente.pessoa.nome                          AS CLIENTE, i.quantidadeTotal                                                AS QUANTIDADE_TOTAL, i.quantidadeTotal * i.valorUnitario                              AS VALOR, n.status                                                         AS STATUS FROM       NotaFiscalPropria n INNER JOIN n.itensNotaPropria i WHERE      (:filtrarDataPrevisao    <> 1 OR CAST(n.dataEmissaoNota AS date) BETWEEN :dataPrevisaoInicial    AND :dataPrevisaoFinal) AND        (:filtrarCentroEstocagem <> 1 OR i.centroEstoque.identificador   BETWEEN :centroEstocagemInicial AND :centroEstocagemFinal) AND        (:filtrarProduto         <> 1 OR i.produto.identificador         BETWEEN :produtoInicial         AND :produtoFinal) AND        (:filtrarEspecie         <> 1 OR i.produto.especie.identificador BETWEEN :especieInicial         AND :especieFinal) AND        (:filtrarEmpresa         <> 1 OR n.empresa.identificador BETWEEN :empresaInicial         AND :empresaFinal) ORDER BY   n.unidadeFatCliente.cliente.pessoa.endereco.cidade.identificador,            i.produto.especie.identificador,            i.produto.identificador");
        q.setShort("filtrarDataPrevisao", filtrarDataPrevisao.shortValue());
        q.setDate("dataPrevisaoInicial", dataPrevisaoInicial);
        q.setDate("dataPrevisaoFinal", dataPrevisaoFinal);
        q.setShort("filtrarCentroEstocagem", filtrarCentroEstocagem.shortValue());
        q.setLong("centroEstocagemInicial", centroEstocagemInicial.longValue());
        q.setLong("centroEstocagemFinal", centroEstocagemFinal.longValue());
        q.setShort("filtrarProduto", filtrarProduto.shortValue());
        q.setLong("produtoInicial", produtoInicial.longValue());
        q.setLong("produtoFinal", produtoFinal.longValue());
        q.setShort("filtrarEspecie", filtrarEspecie.shortValue());
        q.setLong("especieInicial", especieInicial.longValue());
        q.setLong("especieFinal", especieFinal.longValue());
        q.setShort("filtrarEmpresa", filtrarEmpresa.shortValue());
        q.setLong("empresaInicial", empresaInicial.longValue());
        q.setLong("empresaFinal", empresaFinal.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private JasperPrint gerarJasperPrintFaturamentoCidade(Short filtrarDataPrevisao, Date dataPrevisaoInicial, Date dataPrevisaoFinal, Short filtrarCentroEstocagem, Long centroEstocagemInicial, Long centroEstocagemFinal, Short filtrarProduto, Long produtoInicial, Long produtoFinal, Short filtrarEspecie, Long especieInicial, Long especieFinal, Short quebrarEspecie, String fecho, Nodo nodo, HashMap parametros, List<HashMap> dados) throws ExceptionService {
        parametros.put("FILTRAR_DATA_PREVISAO", filtrarDataPrevisao);
        parametros.put("DATA_PREVISAO_INICIAL", dataPrevisaoInicial);
        parametros.put("DATA_PREVISAO_FINAL", dataPrevisaoFinal);
        parametros.put("FILTRAR_CENTRO_ESTOCAGEM", filtrarCentroEstocagem);
        parametros.put("CENTRO_ESTOCAGEM_INICIAL", centroEstocagemInicial);
        parametros.put("CENTRO_ESTOCAGEM_FINAL", centroEstocagemFinal);
        parametros.put("FILTRAR_PRODUTO", filtrarProduto);
        parametros.put("PRODUTO_INICIAL", produtoInicial);
        parametros.put("PRODUTO_FINAL", produtoFinal);
        parametros.put("FILTRAR_ESPECIE", filtrarEspecie);
        parametros.put("ESPECIE_INICIAL", especieInicial);
        parametros.put("ESPECIE_FINAL", especieFinal);
        parametros.put("QUEBRAR_ESPECIE", quebrarEspecie);
        parametros.put("FECHO", fecho);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", parametros).setAttribute("isPaisagem", true).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "vendas" + File.separator + "relatorios" + File.separator + "listagemfaturamentocidade" + File.separator + "LISTAGEM_FATURAMENTO_CIDADE.jasper";
        CoreRequestContext r = new CoreRequestContext();
        r.setAttribute("path", path);
        r.setAttribute("parametros", parametros);
        r.setAttribute("dados", dados);
        return (JasperPrint)CoreServiceFactory.getCoreReportService().execute(r, "getJasperPrintDataSource");
    }
}

