/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagemfuncoesequipamentos;

import com.touchcomp.basementor.model.vo.Funcao;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilListagemFuncoesEquipamentos {
    UtilListagemFuncoesEquipamentos() {
    }

    JasperPrint gerarListagemFuncoesEquipamentos(Short filtrarFuncao, Funcao funcao, Short filtrarEquipamento, Produto equipamento, String fecho, Nodo nodo, HashMap parametros, Short quebra) throws ExceptionService {
        List<HashMap> dados = this.pesquisarFuncoesEquipamentos(filtrarFuncao, funcao, filtrarEquipamento, equipamento, quebra);
        return this.gerarJasperPrintFuncoesEquipamentos(filtrarFuncao, funcao, filtrarEquipamento, equipamento, fecho, nodo, parametros, dados, quebra);
    }

    List<HashMap> pesquisarFuncoesEquipamentos(Short filtrarFuncao, Funcao funcao, Short filtrarEquipamento, Produto equipamento, Short quebra) {
        Short quebraEquipamento = 0;
        Long idEquipamento = 0L;
        Long idFuncao = 0L;
        if (ToolMethods.isEquals((Object)filtrarEquipamento, (Object)1)) {
            idEquipamento = equipamento.getIdentificador();
        }
        if (ToolMethods.isEquals((Object)filtrarFuncao, (Object)1)) {
            idFuncao = funcao.getIdentificador();
        }
        Object query = "SELECT  \n  f.identificador AS idFuncao,\n  f.descricao     AS nomeFuncao,\n  cbo.codigo      AS codigoCbo,\n  p.identificador AS idProduto,\n  p.nome          AS nomeProduto,\n  i.vidaUtil      AS vidaUtil\nFROM ParametrizacaoEquipamentoSeguranca pes\n  INNER JOIN pes.funcao pf\n  INNER JOIN pf.funcao f\n    INNER JOIN f.cbo cbo\n  INNER JOIN pes.itemEquipamento i\n    INNER JOIN i.gradeCor gc\n      INNER JOIN gc.produtoGrade pg\n        INNER JOIN pg.produto p\nWHERE  (:filtrarEquipamento <> 1 OR p.identificador = :equipamento) \n  AND  (:filtrarFuncao      <> 1 OR f.identificador = :funcao) \n";
        query = ToolMethods.isEquals((Object)quebra, (Object)quebraEquipamento) ? (String)query + "ORDER BY p.identificador, f.identificador" : (String)query + "ORDER BY f.identificador, p.identificador";
        List data = CoreBdUtil.getInstance().getSession().createQuery((String)query).setShort("filtrarEquipamento", filtrarEquipamento.shortValue()).setLong("equipamento", idEquipamento.longValue()).setShort("filtrarFuncao", filtrarFuncao.shortValue()).setLong("funcao", idFuncao.longValue()).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        return data;
    }

    private JasperPrint gerarJasperPrintFuncoesEquipamentos(Short filtrarFuncao, Funcao funcao, Short filtrarEquipamento, Produto equipamento, String fecho, Nodo nodo, HashMap parametros, List<HashMap> dados, Short quebra) throws ExceptionService {
        parametros.put("FILTRAR_FUNCAO", filtrarFuncao);
        parametros.put("FUNCAO", funcao != null ? funcao.getIdentificador() : null);
        parametros.put("FILTRAR_EQUIPAMENTO", filtrarEquipamento);
        parametros.put("EQUIPAMENTO", equipamento != null ? equipamento.getIdentificador() : null);
        parametros.put("QUEBRA", quebra);
        parametros.put("FECHO", fecho);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", parametros).setAttribute("isPaisagem", false).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "rh" + File.separator + "relatorios" + File.separator + "listagemfuncoesequipamentos" + File.separator + "LISTAGEM_FUNCOES_EQUIPAMENTOS.jasper";
        CoreRequestContext r = new CoreRequestContext();
        r.setAttribute("path", path);
        r.setAttribute("parametros", parametros);
        r.setAttribute("dados", dados);
        return (JasperPrint)CoreServiceFactory.getCoreReportService().execute(r, "getJasperPrintDataSource");
    }
}

