/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagemlotesproduto;

import com.touchcomp.basementor.model.vo.Nodo;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilListagemLotesProduto {
    UtilListagemLotesProduto() {
    }

    JasperPrint gerarListagemLotesProduto(Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Short filtrarProduto, Long produtoInicial, Long produtoFinal, String fecho, Nodo nodo, HashMap parametros) throws ExceptionService {
        List<HashMap> dados = this.pesquisarLotesProduto(filtrarDataEmissao, dataEmissaoInicial, dataEmissaoFinal, filtrarProduto, produtoInicial, produtoFinal);
        return this.gerarJasperPrintLotesProduto(filtrarDataEmissao, dataEmissaoInicial, dataEmissaoFinal, filtrarProduto, produtoInicial, produtoFinal, fecho, nodo, parametros, dados);
    }

    private List<HashMap> pesquisarLotesProduto(Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Short filtrarProduto, Long produtoInicial, Long produtoFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT i.produto.identificador     AS ID_PRODUTO, i.produto.nome                                  AS NOME, n.numeroNota                                    AS NUMERO_NOTA, n.serie                                         AS SERIE, g.loteFabricacao.loteFabricacao                 AS LOTE_FABRICACAO, n.dataEmissaoNota                               AS DATA_EMISSAO, n.unidadeFatCliente.cliente.identificador       AS ID_CLIENTE, n.unidadeFatCliente.cliente.pessoa.nome         AS CLIENTE, sum(g.quantidade)                               AS QUANTIDADE, g.loteFabricacao.dataFabricacao                 AS DATA_FABRICACAO, g.loteFabricacao.dataValidade                   AS DATA_VALIDADE FROM        NotaFiscalPropria n INNER JOIN  n.itensNotaPropria i INNER JOIN  i.gradesNotaFiscalPropria g WHERE       (:filtrarDataEmissao <> 1 OR n.dataEmissaoNota BETWEEN :dataEmissaoInicial AND :dataEmissaoFinal) AND         (:filtrarProduto <> 1 OR i.produto.identificador BETWEEN :produtoInicial AND :produtoFinal) GROUP BY    i.produto.identificador,             i.produto.nome,             n.numeroNota,             n.serie,             g.loteFabricacao.loteFabricacao,             n.dataEmissaoNota,             n.unidadeFatCliente.cliente.identificador,             n.unidadeFatCliente.cliente.pessoa.nome,             g.loteFabricacao.dataFabricacao,             g.loteFabricacao.dataValidade ORDER BY    i.produto.identificador");
        q.setShort("filtrarDataEmissao", filtrarDataEmissao.shortValue());
        q.setDate("dataEmissaoInicial", dataEmissaoInicial);
        q.setDate("dataEmissaoFinal", dataEmissaoFinal);
        q.setShort("filtrarProduto", filtrarProduto.shortValue());
        q.setLong("produtoInicial", produtoInicial.longValue());
        q.setLong("produtoFinal", produtoFinal.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private JasperPrint gerarJasperPrintLotesProduto(Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Short filtrarProduto, Long produtoInicial, Long produtoFinal, String fecho, Nodo nodo, HashMap parametros, List<HashMap> dados) throws ExceptionService {
        parametros.put("FILTRAR_DATA_EMISSAO", filtrarDataEmissao);
        parametros.put("DATA_EMISSAO_INICIAL", dataEmissaoInicial);
        parametros.put("DATA_EMISSAO_FINAL", dataEmissaoFinal);
        parametros.put("FILTRAR_PRODUTO", filtrarProduto);
        parametros.put("PRODUTO_INICIAL", produtoInicial);
        parametros.put("PRODUTO_FINAL", produtoFinal);
        parametros.put("FECHO", fecho);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", parametros).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "manufatura" + File.separator + "listagens" + File.separator + "listagemlotesproduto" + File.separator + "LISTAGEM_LOTES_POR_PRODUTO.jasper";
        CoreRequestContext r = new CoreRequestContext();
        r.setAttribute("path", path);
        r.setAttribute("parametros", parametros);
        r.setAttribute("dados", dados);
        return (JasperPrint)CoreServiceFactory.getCoreReportService().execute(r, "getJasperPrintDataSource");
    }
}

