/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagemmanifestocteeletronico;

import com.touchcomp.basementor.model.vo.Nodo;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilListagemManifestoCteEletronico {
    private Short NAO_ENCERRADOS = 1;

    UtilListagemManifestoCteEletronico() {
    }

    JasperPrint gerarListagemManifestoCteEletronico(Short tipo, Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Short filtrarMotorista, Long motoristaInicial, Long motoristaFinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short filtrarManifestoCteEletronico, Long manifestoCteEletronicoNumero, Short filtrarNotaFiscalPropria, Long notaFiscalPropriaNumero, Short filtrarCte, Long cteNumero, Short imprimirDadosNotaFiscalPropriaCte, String fecho, Nodo nodo, HashMap parametros) throws ExceptionService {
        List<HashMap> dados = this.pesquisarManifestoCteEletronico(tipo, filtrarDataEmissao, dataEmissaoInicial, dataEmissaoFinal, filtrarMotorista, motoristaInicial, motoristaFinal, filtrarEmpresa, empresaInicial, empresaFinal, filtrarManifestoCteEletronico, manifestoCteEletronicoNumero, filtrarNotaFiscalPropria, notaFiscalPropriaNumero, filtrarCte, cteNumero);
        return this.gerarJasperPrintManifestoCteEletronico(filtrarDataEmissao, dataEmissaoInicial, dataEmissaoFinal, filtrarMotorista, motoristaInicial, motoristaFinal, filtrarEmpresa, empresaInicial, empresaFinal, filtrarManifestoCteEletronico, manifestoCteEletronicoNumero, filtrarNotaFiscalPropria, notaFiscalPropriaNumero, filtrarCte, cteNumero, imprimirDadosNotaFiscalPropriaCte, fecho, nodo, parametros, dados);
    }

    private List<HashMap> pesquisarManifestoCteEletronico(Short tipo, Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Short filtrarMotorista, Long motoristaInicial, Long motoristaFinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short filtrarManifestoCteEletronico, Long manifestoCteEletronicoNumero, Short filtrarNotaFiscalPropria, Long notaFiscalPropriaNumero, Short filtrarCte, Long cteNumero) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "SELECT DISTINCT e.identificador                                          AS ID_EMPRESA,\ns.nome                                                    AS EMPRESA,\nm.serie                                                   AS SERIE,\nm.numero                                                  AS NUMERO,\nm.dataEmissao                                             AS DATA_EMISSAO,\nm.status                                                  AS STATUS,\nr.identificador                                           AS ID_AGREGADO,\na.nome                                                    AS AGREGADO,\no.identificador                                           AS ID_MOTORISTA,\np.nome                                                    AS MOTORISTA,\nm.pesoBrutoTotalCarga                                     AS PESO_TOTAL_CARGA,\nm.valorTotalCarga                                         AS VALOR_TOTAL_MERCADORIA,\nv.placa                                                   AS PLACA_PRINCIPAL,\nCOALESCE(n.serie, c.serie)                                AS SERIE_CTE_NFE,\nCOALESCE(CAST(n.numeroNota as long), c.numero)            AS NUMERO_CTE_NFE,\nCOALESCE(n.dataEmissaoNota, CAST(c.dataEmissao as date))  AS DATA_EMISSAO_CTE_NFE,\nCOALESCE(cl.identificador, l.identificador)               AS ID_CLIENTE,\nCOALESCE(po.nome, pe.nome)                                AS CLIENTE,\nCOALESCE(vn.valorTotal, cv.vrPrestacao)                   AS VALOR_CTE_NFE\n FROM ManifestoCteEletronico m INNER JOIN m.empresa e INNER JOIN e.pessoa s INNER JOIN m.conjuntoTransportador t INNER JOIN t.conjuntoTranspVeiculo j INNER JOIN j.veiculo v LEFT JOIN  m.cte cc LEFT JOIN cc.cte c LEFT JOIN  c.clienteTomador ct LEFT JOIN  ct.cliente l LEFT JOIN  l.pessoa pe LEFT JOIN  c.cteVlrImpostos cv LEFT JOIN  m.nfe nn LEFT JOIN nn.nfe n LEFT JOIN  n.unidadeFatCliente u LEFT JOIN  u.cliente cl LEFT JOIN  cl.pessoa po LEFT JOIN n.valoresNfPropria vn INNER JOIN t.motorista o INNER JOIN o.pessoa p INNER JOIN t.transportadorAgregado r INNER JOIN r.pessoa a WHERE j.placaPrincipal = :placaPrincipal AND   (:filtrarDataEmissao <> 1 OR CAST(m.dataEmissao AS date) BETWEEN :dataEmissaoInicial AND :dataEmissaoFinal) AND   (:filtrarMotorista   <> 1 OR o.identificador             BETWEEN :motoristaInicial   AND :motoristaFinal) AND   (:filtrarEmpresa     <> 1 OR e.identificador             BETWEEN :empresaInicial     AND :empresaFinal) AND   (:filtrarManifestoCteEletronico <> 1 OR m.numero     = :manifestoCteEletronicoNumero) AND   (:filtrarNotaFiscalPropria      <> 1 OR n.numeroNota = :notaFiscalPropriaNumero) AND   (:filtrarCte                    <> 1 OR c.numero     = :cteNumero)";
        if (tipo.equals(this.NAO_ENCERRADOS)) {
            hql = (String)hql + " AND m.status = 100";
        }
        hql = (String)hql + " ORDER BY e.identificador, m.numero, n.numeroNota, c.numero";
        Query q = s.createQuery((String)hql);
        q.setShort("placaPrincipal", (short)1);
        q.setShort("filtrarDataEmissao", filtrarDataEmissao.shortValue());
        q.setDate("dataEmissaoInicial", dataEmissaoInicial);
        q.setDate("dataEmissaoFinal", dataEmissaoFinal);
        q.setShort("filtrarMotorista", filtrarMotorista.shortValue());
        q.setLong("motoristaInicial", motoristaInicial.longValue());
        q.setLong("motoristaFinal", motoristaFinal.longValue());
        q.setShort("filtrarEmpresa", filtrarEmpresa.shortValue());
        q.setLong("empresaInicial", empresaInicial.longValue());
        q.setLong("empresaFinal", empresaFinal.longValue());
        q.setShort("filtrarManifestoCteEletronico", filtrarManifestoCteEletronico.shortValue());
        q.setLong("manifestoCteEletronicoNumero", manifestoCteEletronicoNumero.longValue());
        q.setShort("filtrarNotaFiscalPropria", filtrarNotaFiscalPropria.shortValue());
        q.setInteger("notaFiscalPropriaNumero", Integer.valueOf(notaFiscalPropriaNumero.toString()).intValue());
        q.setShort("filtrarCte", filtrarCte.shortValue());
        q.setLong("cteNumero", cteNumero.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private JasperPrint gerarJasperPrintManifestoCteEletronico(Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Short filtrarMotorista, Long motoristaInicial, Long motoristaFinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short filtrarManifestoCteEletronico, Long manifestoCteEletronicoNumero, Short filtrarNotaFiscalPropria, Long notaFiscalPropriaNumero, Short filtrarCte, Long cteNumero, Short imprimirDadosNotaFiscalPropriaCte, String fecho, Nodo nodo, HashMap parametros, List<HashMap> dados) throws ExceptionService {
        parametros.put("FILTRAR_DATA_EMISSAO", filtrarDataEmissao);
        parametros.put("DATA_EMISSAO_INICIAL", dataEmissaoInicial);
        parametros.put("DATA_EMISSAO_FINAL", dataEmissaoFinal);
        parametros.put("FILTRAR_MOTORISTA", filtrarMotorista);
        parametros.put("MOTORISTA_INICIAL", motoristaInicial);
        parametros.put("MOTORISTA_FINAL", motoristaFinal);
        parametros.put("FILTRAR_EMPRESA", filtrarEmpresa);
        parametros.put("EMPRESA_INICIAL", empresaInicial);
        parametros.put("EMPRESA_FINAL", empresaFinal);
        parametros.put("FILTRAR_MANIFESTO_CTE_ELETRONICO", filtrarManifestoCteEletronico);
        parametros.put("MANIFESTO_CTE_ELETRONICO_NUMERO", manifestoCteEletronicoNumero);
        parametros.put("FILTRAR_NOTA_FISCAL_PROPRIA", filtrarNotaFiscalPropria);
        parametros.put("NOTA_FISCAL_PROPRIA_NUMERO", notaFiscalPropriaNumero);
        parametros.put("FILTRAR_CTE", filtrarCte);
        parametros.put("CTE_NUMERO", cteNumero);
        parametros.put("IMPRIMIR_DADOS_NOTA_FISCAL_PROPRIA_CTE", imprimirDadosNotaFiscalPropriaCte);
        parametros.put("FECHO", fecho);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", parametros).setAttribute("isPaisagem", true).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "transportador" + File.separator + "manifestocte" + File.separator + "listagem" + File.separator + "listagemmanifestocteeletronico" + File.separator + "LISTAGEM_MANIFESTO_CTE_ELETRONICO.jasper";
        CoreRequestContext r = new CoreRequestContext();
        r.setAttribute("path", path);
        r.setAttribute("parametros", parametros);
        r.setAttribute("dados", dados);
        return (JasperPrint)CoreServiceFactory.getCoreReportService().execute(r, "getJasperPrintDataSource");
    }
}

