/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagemnotaterceirossemxml;

import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorxml.model.XMLNfeTerceiros;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLNFeTerceiros;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilNotaFiscalTerceirosSemXML {
    UtilNotaFiscalTerceirosSemXML() {
    }

    public JasperPrint gerarNotaFiscalTerceirosSemXML(CoreRequestContext r) throws ExceptionService {
        try {
            Short filtrarData = (Short)r.getAttribute("filtrarData");
            Date dataInicial = (Date)r.getAttribute("dataInicial");
            Date dataFinal = (Date)r.getAttribute("dataFinal");
            Short filtrarFornecedor = (Short)r.getAttribute("filtrarFornecedor");
            Long fornecedorInicial = (Long)r.getAttribute("fornecedorInicial");
            Long fornecedorFinal = (Long)r.getAttribute("fornecedorFinal");
            String fecho = (String)r.getAttribute("fecho");
            HashMap defaultParameters = (HashMap)r.getAttribute("defaultParameters");
            List notaTerceiros = this.findNotaTerceiros(filtrarData, dataInicial, dataFinal, filtrarFornecedor, fornecedorInicial, fornecedorFinal);
            List notaTerceirosSemXML = this.findNotasSemXML(notaTerceiros);
            List ordenada = this.getListaOrdenada(notaTerceirosSemXML);
            HashMap<String, Object> parametros = new HashMap<String, Object>();
            parametros.put("FILTRAR_DATA", filtrarData);
            parametros.put("DATA_INICIAL", dataInicial);
            parametros.put("DATA_FINAL", dataFinal);
            parametros.put("FILTRAR_FORNECEDOR", filtrarFornecedor);
            parametros.put("FORNECEDOR_INICIAL", fornecedorInicial);
            parametros.put("FORNECEDOR_FINAL", fornecedorFinal);
            parametros.put("FECHO", fecho);
            parametros.putAll(defaultParameters);
            Object path = System.getProperty("user.dir");
            path = (String)path + File.separator + "reports" + File.separator + "suprimentos" + File.separator + "gestaorecebimentos" + File.separator + "listagens" + File.separator + "notafiscalsemxml" + File.separator + "BEANS_LISTAGEM_NOTA_TERCEIROS_SEM_XML.jasper";
            CoreRequestContext relatorio = new CoreRequestContext();
            relatorio.setAttribute("path", path);
            relatorio.setAttribute("parametros", parametros);
            relatorio.setAttribute("dados", ordenada);
            Object jasperPrint = CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
            return (JasperPrint)jasperPrint;
        }
        catch (Exception ex) {
            throw new ExceptionService("Erro ao pesquisar XML das Notas!");
        }
    }

    private List findNotaTerceiros(Short filtrarData, Date dataInicial, Date dataFinal, Short filtrarFornecedor, Long fornecedorInicial, Long fornecedorFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = "SELECT n.identificador as ID, n.dataEntrada as DATA_ENTRADA_SAIDA, n.serie as SERIE, n.numeroNota as NUMERO, n.unidadeFatFornecedor.fornecedor.pessoa.nome as FORNECEDOR FROM NotaFiscalTerceiros n";
        if (filtrarData == 1) {
            query = (String)query + " WHERE n.dataEntrada BETWEEN :dataInicial AND :dataFinal";
        }
        if (filtrarFornecedor == 1) {
            query = filtrarData == 0 ? (String)query + " WHERE" : (String)query + " AND";
            query = (String)query + " n.unidadeFatFornecedor.fornecedor.identificador BETWEEN :fornecedorInicial AND :fornecedorFinal";
        }
        Query q = s.createQuery((String)query);
        if (filtrarData == 1) {
            q.setDate("dataInicial", dataInicial);
            q.setDate("dataFinal", dataFinal);
        }
        if (filtrarFornecedor == 1) {
            q.setLong("fornecedorInicial", fornecedorInicial.longValue());
            q.setLong("fornecedorFinal", fornecedorFinal.longValue());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List findNotasSemXML(List<HashMap> notaTerceiros) {
        ServiceXMLNFeTerceiros service = (ServiceXMLNFeTerceiros)ConfApplicationContext.getBean(ServiceXMLNFeTerceiros.class);
        ArrayList<HashMap> result = new ArrayList<HashMap>();
        ArrayList idsNotas = new ArrayList();
        ArrayList<XMLNfeTerceiros> xmls = new ArrayList();
        for (HashMap m : notaTerceiros) {
            idsNotas.add(m.get("ID"));
        }
        if (!idsNotas.isEmpty()) {
            xmls = service.getListXmlNfeTerceiros(idsNotas);
        }
        if (notaTerceiros.size() != xmls.size()) {
            for (HashMap nota : notaTerceiros) {
                if (this.temId(xmls, (Long)nota.get("ID"))) continue;
                result.add(nota);
            }
            return result;
        }
        return new ArrayList();
    }

    private boolean temId(List<XMLNfeTerceiros> xmls, Long id) {
        for (XMLNfeTerceiros xml : xmls) {
            if (!id.equals(xml.getIdNotaTerceiros())) continue;
            return true;
        }
        return false;
    }

    private List getListaOrdenada(List movimentos) {
        if (movimentos != null) {
            Collections.sort(movimentos, new Comparator(this){

                public int compare(Object o1, Object o2) {
                    HashMap i = (HashMap)o1;
                    HashMap i2 = (HashMap)o2;
                    return ((Long)i.get("ID")).compareTo((Long)i2.get("ID"));
                }
            });
            return movimentos;
        }
        return null;
    }
}

